# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeploymentArgs', 'Deployment']

@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[str],
                 application_version: pulumi.Input[int],
                 environment_id: pulumi.Input[str],
                 start: pulumi.Input[bool],
                 force_stop: Optional[pulumi.Input[bool]] = None,
                 timeouts: Optional[pulumi.Input['DeploymentTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a Deployment resource.
        :param pulumi.Input[str] application_id: Application to deploy.
        :param pulumi.Input[int] application_version: Version to application to deploy
        :param pulumi.Input[str] environment_id: Environment to deploy application to.
        :param pulumi.Input[bool] start: Start the application once deployed.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "application_version", application_version)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "start", start)
        if force_stop is not None:
            pulumi.set(__self__, "force_stop", force_stop)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[str]:
        """
        Application to deploy.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="applicationVersion")
    def application_version(self) -> pulumi.Input[int]:
        """
        Version to application to deploy
        """
        return pulumi.get(self, "application_version")

    @application_version.setter
    def application_version(self, value: pulumi.Input[int]):
        pulumi.set(self, "application_version", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[str]:
        """
        Environment to deploy application to.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[bool]:
        """
        Start the application once deployed.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[bool]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter(name="forceStop")
    def force_stop(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "force_stop")

    @force_stop.setter
    def force_stop(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_stop", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DeploymentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DeploymentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _DeploymentState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 application_version: Optional[pulumi.Input[int]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 force_stop: Optional[pulumi.Input[bool]] = None,
                 start: Optional[pulumi.Input[bool]] = None,
                 timeouts: Optional[pulumi.Input['DeploymentTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering Deployment resources.
        :param pulumi.Input[str] application_id: Application to deploy.
        :param pulumi.Input[int] application_version: Version to application to deploy
        :param pulumi.Input[str] environment_id: Environment to deploy application to.
        :param pulumi.Input[bool] start: Start the application once deployed.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_version is not None:
            pulumi.set(__self__, "application_version", application_version)
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if force_stop is not None:
            pulumi.set(__self__, "force_stop", force_stop)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        Application to deploy.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="applicationVersion")
    def application_version(self) -> Optional[pulumi.Input[int]]:
        """
        Version to application to deploy
        """
        return pulumi.get(self, "application_version")

    @application_version.setter
    def application_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "application_version", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Environment to deploy application to.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="forceStop")
    def force_stop(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "force_stop")

    @force_stop.setter
    def force_stop(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_stop", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[bool]]:
        """
        Start the application once deployed.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DeploymentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DeploymentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


class Deployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 application_version: Optional[pulumi.Input[int]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 force_stop: Optional[pulumi.Input[bool]] = None,
                 start: Optional[pulumi.Input[bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['DeploymentTimeoutsArgs', 'DeploymentTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an [AWS Mainframe Modernization Deployment.](https://docs.aws.amazon.com/m2/latest/userguide/applications-m2-deploy.html)

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.m2.Deployment("test",
            environment_id="01234567890abcdef012345678",
            application_id="34567890abcdef012345678012",
            application_version=1,
            start=True)
        ```

        ## Import

        Using `pulumi import`, import Mainframe Modernization Deployment using the `APPLICATION-ID,DEPLOYMENT-ID`. For example:

        ```sh
        $ pulumi import aws:m2/deployment:Deployment example APPLICATION-ID,DEPLOYMENT-ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: Application to deploy.
        :param pulumi.Input[int] application_version: Version to application to deploy
        :param pulumi.Input[str] environment_id: Environment to deploy application to.
        :param pulumi.Input[bool] start: Start the application once deployed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an [AWS Mainframe Modernization Deployment.](https://docs.aws.amazon.com/m2/latest/userguide/applications-m2-deploy.html)

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.m2.Deployment("test",
            environment_id="01234567890abcdef012345678",
            application_id="34567890abcdef012345678012",
            application_version=1,
            start=True)
        ```

        ## Import

        Using `pulumi import`, import Mainframe Modernization Deployment using the `APPLICATION-ID,DEPLOYMENT-ID`. For example:

        ```sh
        $ pulumi import aws:m2/deployment:Deployment example APPLICATION-ID,DEPLOYMENT-ID
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 application_version: Optional[pulumi.Input[int]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 force_stop: Optional[pulumi.Input[bool]] = None,
                 start: Optional[pulumi.Input[bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['DeploymentTimeoutsArgs', 'DeploymentTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentArgs.__new__(DeploymentArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            if application_version is None and not opts.urn:
                raise TypeError("Missing required property 'application_version'")
            __props__.__dict__["application_version"] = application_version
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["force_stop"] = force_stop
            if start is None and not opts.urn:
                raise TypeError("Missing required property 'start'")
            __props__.__dict__["start"] = start
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["deployment_id"] = None
        super(Deployment, __self__).__init__(
            'aws:m2/deployment:Deployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[str]] = None,
            application_version: Optional[pulumi.Input[int]] = None,
            deployment_id: Optional[pulumi.Input[str]] = None,
            environment_id: Optional[pulumi.Input[str]] = None,
            force_stop: Optional[pulumi.Input[bool]] = None,
            start: Optional[pulumi.Input[bool]] = None,
            timeouts: Optional[pulumi.Input[Union['DeploymentTimeoutsArgs', 'DeploymentTimeoutsArgsDict']]] = None) -> 'Deployment':
        """
        Get an existing Deployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: Application to deploy.
        :param pulumi.Input[int] application_version: Version to application to deploy
        :param pulumi.Input[str] environment_id: Environment to deploy application to.
        :param pulumi.Input[bool] start: Start the application once deployed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentState.__new__(_DeploymentState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["application_version"] = application_version
        __props__.__dict__["deployment_id"] = deployment_id
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["force_stop"] = force_stop
        __props__.__dict__["start"] = start
        __props__.__dict__["timeouts"] = timeouts
        return Deployment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[str]:
        """
        Application to deploy.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="applicationVersion")
    def application_version(self) -> pulumi.Output[int]:
        """
        Version to application to deploy
        """
        return pulumi.get(self, "application_version")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[str]:
        """
        Environment to deploy application to.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="forceStop")
    def force_stop(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "force_stop")

    @property
    @pulumi.getter
    def start(self) -> pulumi.Output[bool]:
        """
        Start the application once deployed.
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.DeploymentTimeouts']]:
        return pulumi.get(self, "timeouts")

