# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AuthorizeVpcEndpointAccessAuthorizedPrincipalArgs',
    'AuthorizeVpcEndpointAccessAuthorizedPrincipalArgsDict',
    'DomainAdvancedSecurityOptionsArgs',
    'DomainAdvancedSecurityOptionsArgsDict',
    'DomainAdvancedSecurityOptionsMasterUserOptionsArgs',
    'DomainAdvancedSecurityOptionsMasterUserOptionsArgsDict',
    'DomainAutoTuneOptionsArgs',
    'DomainAutoTuneOptionsArgsDict',
    'DomainAutoTuneOptionsMaintenanceScheduleArgs',
    'DomainAutoTuneOptionsMaintenanceScheduleArgsDict',
    'DomainAutoTuneOptionsMaintenanceScheduleDurationArgs',
    'DomainAutoTuneOptionsMaintenanceScheduleDurationArgsDict',
    'DomainClusterConfigArgs',
    'DomainClusterConfigArgsDict',
    'DomainClusterConfigColdStorageOptionsArgs',
    'DomainClusterConfigColdStorageOptionsArgsDict',
    'DomainClusterConfigZoneAwarenessConfigArgs',
    'DomainClusterConfigZoneAwarenessConfigArgsDict',
    'DomainCognitoOptionsArgs',
    'DomainCognitoOptionsArgsDict',
    'DomainDomainEndpointOptionsArgs',
    'DomainDomainEndpointOptionsArgsDict',
    'DomainEbsOptionsArgs',
    'DomainEbsOptionsArgsDict',
    'DomainEncryptAtRestArgs',
    'DomainEncryptAtRestArgsDict',
    'DomainLogPublishingOptionArgs',
    'DomainLogPublishingOptionArgsDict',
    'DomainNodeToNodeEncryptionArgs',
    'DomainNodeToNodeEncryptionArgsDict',
    'DomainOffPeakWindowOptionsArgs',
    'DomainOffPeakWindowOptionsArgsDict',
    'DomainOffPeakWindowOptionsOffPeakWindowArgs',
    'DomainOffPeakWindowOptionsOffPeakWindowArgsDict',
    'DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs',
    'DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgsDict',
    'DomainSamlOptionsSamlOptionsArgs',
    'DomainSamlOptionsSamlOptionsArgsDict',
    'DomainSamlOptionsSamlOptionsIdpArgs',
    'DomainSamlOptionsSamlOptionsIdpArgsDict',
    'DomainSnapshotOptionsArgs',
    'DomainSnapshotOptionsArgsDict',
    'DomainSoftwareUpdateOptionsArgs',
    'DomainSoftwareUpdateOptionsArgsDict',
    'DomainVpcOptionsArgs',
    'DomainVpcOptionsArgsDict',
    'OutboundConnectionConnectionPropertiesArgs',
    'OutboundConnectionConnectionPropertiesArgsDict',
    'OutboundConnectionConnectionPropertiesCrossClusterSearchArgs',
    'OutboundConnectionConnectionPropertiesCrossClusterSearchArgsDict',
    'OutboundConnectionLocalDomainInfoArgs',
    'OutboundConnectionLocalDomainInfoArgsDict',
    'OutboundConnectionRemoteDomainInfoArgs',
    'OutboundConnectionRemoteDomainInfoArgsDict',
    'PackagePackageSourceArgs',
    'PackagePackageSourceArgsDict',
    'ServerlessCollectionTimeoutsArgs',
    'ServerlessCollectionTimeoutsArgsDict',
    'ServerlessSecurityConfigSamlOptionsArgs',
    'ServerlessSecurityConfigSamlOptionsArgsDict',
    'ServerlessVpcEndpointTimeoutsArgs',
    'ServerlessVpcEndpointTimeoutsArgsDict',
    'VpcEndpointVpcOptionsArgs',
    'VpcEndpointVpcOptionsArgsDict',
    'GetDomainOffPeakWindowOptionsArgs',
    'GetDomainOffPeakWindowOptionsArgsDict',
    'GetDomainOffPeakWindowOptionsOffPeakWindowArgs',
    'GetDomainOffPeakWindowOptionsOffPeakWindowArgsDict',
    'GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs',
    'GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgsDict',
    'GetServerlessSecurityConfigSamlOptionsArgs',
    'GetServerlessSecurityConfigSamlOptionsArgsDict',
]

MYPY = False

if not MYPY:
    class AuthorizeVpcEndpointAccessAuthorizedPrincipalArgsDict(TypedDict):
        principal: pulumi.Input[str]
        """
        IAM principal that is allowed to access to the domain.
        """
        principal_type: pulumi.Input[str]
        """
        Type of principal.
        """
elif False:
    AuthorizeVpcEndpointAccessAuthorizedPrincipalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthorizeVpcEndpointAccessAuthorizedPrincipalArgs:
    def __init__(__self__, *,
                 principal: pulumi.Input[str],
                 principal_type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] principal: IAM principal that is allowed to access to the domain.
        :param pulumi.Input[str] principal_type: Type of principal.
        """
        pulumi.set(__self__, "principal", principal)
        pulumi.set(__self__, "principal_type", principal_type)

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Input[str]:
        """
        IAM principal that is allowed to access to the domain.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal", value)

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Input[str]:
        """
        Type of principal.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_type", value)


if not MYPY:
    class DomainAdvancedSecurityOptionsArgsDict(TypedDict):
        enabled: pulumi.Input[bool]
        """
        Whether advanced security is enabled.
        """
        anonymous_auth_enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether Anonymous auth is enabled. Enables fine-grained access control on an existing domain. Ignored unless `advanced_security_options` are enabled. _Can only be enabled on an existing domain._
        """
        internal_user_database_enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether the internal user database is enabled. Default is `false`.
        """
        master_user_options: NotRequired[pulumi.Input['DomainAdvancedSecurityOptionsMasterUserOptionsArgsDict']]
        """
        Configuration block for the main user. Detailed below.
        """
elif False:
    DomainAdvancedSecurityOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainAdvancedSecurityOptionsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 anonymous_auth_enabled: Optional[pulumi.Input[bool]] = None,
                 internal_user_database_enabled: Optional[pulumi.Input[bool]] = None,
                 master_user_options: Optional[pulumi.Input['DomainAdvancedSecurityOptionsMasterUserOptionsArgs']] = None):
        """
        :param pulumi.Input[bool] enabled: Whether advanced security is enabled.
        :param pulumi.Input[bool] anonymous_auth_enabled: Whether Anonymous auth is enabled. Enables fine-grained access control on an existing domain. Ignored unless `advanced_security_options` are enabled. _Can only be enabled on an existing domain._
        :param pulumi.Input[bool] internal_user_database_enabled: Whether the internal user database is enabled. Default is `false`.
        :param pulumi.Input['DomainAdvancedSecurityOptionsMasterUserOptionsArgs'] master_user_options: Configuration block for the main user. Detailed below.
        """
        pulumi.set(__self__, "enabled", enabled)
        if anonymous_auth_enabled is not None:
            pulumi.set(__self__, "anonymous_auth_enabled", anonymous_auth_enabled)
        if internal_user_database_enabled is not None:
            pulumi.set(__self__, "internal_user_database_enabled", internal_user_database_enabled)
        if master_user_options is not None:
            pulumi.set(__self__, "master_user_options", master_user_options)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether advanced security is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="anonymousAuthEnabled")
    def anonymous_auth_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Anonymous auth is enabled. Enables fine-grained access control on an existing domain. Ignored unless `advanced_security_options` are enabled. _Can only be enabled on an existing domain._
        """
        return pulumi.get(self, "anonymous_auth_enabled")

    @anonymous_auth_enabled.setter
    def anonymous_auth_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "anonymous_auth_enabled", value)

    @property
    @pulumi.getter(name="internalUserDatabaseEnabled")
    def internal_user_database_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the internal user database is enabled. Default is `false`.
        """
        return pulumi.get(self, "internal_user_database_enabled")

    @internal_user_database_enabled.setter
    def internal_user_database_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "internal_user_database_enabled", value)

    @property
    @pulumi.getter(name="masterUserOptions")
    def master_user_options(self) -> Optional[pulumi.Input['DomainAdvancedSecurityOptionsMasterUserOptionsArgs']]:
        """
        Configuration block for the main user. Detailed below.
        """
        return pulumi.get(self, "master_user_options")

    @master_user_options.setter
    def master_user_options(self, value: Optional[pulumi.Input['DomainAdvancedSecurityOptionsMasterUserOptionsArgs']]):
        pulumi.set(self, "master_user_options", value)


if not MYPY:
    class DomainAdvancedSecurityOptionsMasterUserOptionsArgsDict(TypedDict):
        master_user_arn: NotRequired[pulumi.Input[str]]
        """
        ARN for the main user. Only specify if `internal_user_database_enabled` is not set or set to `false`.
        """
        master_user_name: NotRequired[pulumi.Input[str]]
        """
        Main user's username, which is stored in the Amazon OpenSearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
        master_user_password: NotRequired[pulumi.Input[str]]
        """
        Main user's password, which is stored in the Amazon OpenSearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
elif False:
    DomainAdvancedSecurityOptionsMasterUserOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainAdvancedSecurityOptionsMasterUserOptionsArgs:
    def __init__(__self__, *,
                 master_user_arn: Optional[pulumi.Input[str]] = None,
                 master_user_name: Optional[pulumi.Input[str]] = None,
                 master_user_password: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] master_user_arn: ARN for the main user. Only specify if `internal_user_database_enabled` is not set or set to `false`.
        :param pulumi.Input[str] master_user_name: Main user's username, which is stored in the Amazon OpenSearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        :param pulumi.Input[str] master_user_password: Main user's password, which is stored in the Amazon OpenSearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
        if master_user_arn is not None:
            pulumi.set(__self__, "master_user_arn", master_user_arn)
        if master_user_name is not None:
            pulumi.set(__self__, "master_user_name", master_user_name)
        if master_user_password is not None:
            pulumi.set(__self__, "master_user_password", master_user_password)

    @property
    @pulumi.getter(name="masterUserArn")
    def master_user_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the main user. Only specify if `internal_user_database_enabled` is not set or set to `false`.
        """
        return pulumi.get(self, "master_user_arn")

    @master_user_arn.setter
    def master_user_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_user_arn", value)

    @property
    @pulumi.getter(name="masterUserName")
    def master_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Main user's username, which is stored in the Amazon OpenSearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
        return pulumi.get(self, "master_user_name")

    @master_user_name.setter
    def master_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_user_name", value)

    @property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> Optional[pulumi.Input[str]]:
        """
        Main user's password, which is stored in the Amazon OpenSearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
        return pulumi.get(self, "master_user_password")

    @master_user_password.setter
    def master_user_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_user_password", value)


if not MYPY:
    class DomainAutoTuneOptionsArgsDict(TypedDict):
        desired_state: pulumi.Input[str]
        """
        Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
        """
        maintenance_schedules: NotRequired[pulumi.Input[Sequence[pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleArgsDict']]]]
        """
        Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.

        **NOTE:** Maintenance windows are deprecated and have been replaced with [off-peak windows](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html). Consequently, `maintenance_schedule` configuration blocks cannot be specified when `use_off_peak_window` is set to `true`.
        """
        rollback_on_disable: NotRequired[pulumi.Input[str]]
        """
        Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
        """
        use_off_peak_window: NotRequired[pulumi.Input[bool]]
        """
        Whether to schedule Auto-Tune optimizations that require blue/green deployments during the domain's configured daily off-peak window. Defaults to `false`.
        """
elif False:
    DomainAutoTuneOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainAutoTuneOptionsArgs:
    def __init__(__self__, *,
                 desired_state: pulumi.Input[str],
                 maintenance_schedules: Optional[pulumi.Input[Sequence[pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleArgs']]]] = None,
                 rollback_on_disable: Optional[pulumi.Input[str]] = None,
                 use_off_peak_window: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] desired_state: Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
        :param pulumi.Input[Sequence[pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleArgs']]] maintenance_schedules: Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
               
               **NOTE:** Maintenance windows are deprecated and have been replaced with [off-peak windows](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html). Consequently, `maintenance_schedule` configuration blocks cannot be specified when `use_off_peak_window` is set to `true`.
        :param pulumi.Input[str] rollback_on_disable: Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
        :param pulumi.Input[bool] use_off_peak_window: Whether to schedule Auto-Tune optimizations that require blue/green deployments during the domain's configured daily off-peak window. Defaults to `false`.
        """
        pulumi.set(__self__, "desired_state", desired_state)
        if maintenance_schedules is not None:
            pulumi.set(__self__, "maintenance_schedules", maintenance_schedules)
        if rollback_on_disable is not None:
            pulumi.set(__self__, "rollback_on_disable", rollback_on_disable)
        if use_off_peak_window is not None:
            pulumi.set(__self__, "use_off_peak_window", use_off_peak_window)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Input[str]:
        """
        Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: pulumi.Input[str]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleArgs']]]]:
        """
        Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.

        **NOTE:** Maintenance windows are deprecated and have been replaced with [off-peak windows](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html). Consequently, `maintenance_schedule` configuration blocks cannot be specified when `use_off_peak_window` is set to `true`.
        """
        return pulumi.get(self, "maintenance_schedules")

    @maintenance_schedules.setter
    def maintenance_schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleArgs']]]]):
        pulumi.set(self, "maintenance_schedules", value)

    @property
    @pulumi.getter(name="rollbackOnDisable")
    def rollback_on_disable(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
        """
        return pulumi.get(self, "rollback_on_disable")

    @rollback_on_disable.setter
    def rollback_on_disable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rollback_on_disable", value)

    @property
    @pulumi.getter(name="useOffPeakWindow")
    def use_off_peak_window(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to schedule Auto-Tune optimizations that require blue/green deployments during the domain's configured daily off-peak window. Defaults to `false`.
        """
        return pulumi.get(self, "use_off_peak_window")

    @use_off_peak_window.setter
    def use_off_peak_window(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_off_peak_window", value)


if not MYPY:
    class DomainAutoTuneOptionsMaintenanceScheduleArgsDict(TypedDict):
        cron_expression_for_recurrence: pulumi.Input[str]
        """
        A cron expression specifying the recurrence pattern for an Auto-Tune maintenance schedule.
        """
        duration: pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleDurationArgsDict']
        """
        Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
        """
        start_at: pulumi.Input[str]
        """
        Date and time at which to start the Auto-Tune maintenance schedule in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
elif False:
    DomainAutoTuneOptionsMaintenanceScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainAutoTuneOptionsMaintenanceScheduleArgs:
    def __init__(__self__, *,
                 cron_expression_for_recurrence: pulumi.Input[str],
                 duration: pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleDurationArgs'],
                 start_at: pulumi.Input[str]):
        """
        :param pulumi.Input[str] cron_expression_for_recurrence: A cron expression specifying the recurrence pattern for an Auto-Tune maintenance schedule.
        :param pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleDurationArgs'] duration: Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
        :param pulumi.Input[str] start_at: Date and time at which to start the Auto-Tune maintenance schedule in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        pulumi.set(__self__, "cron_expression_for_recurrence", cron_expression_for_recurrence)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_at", start_at)

    @property
    @pulumi.getter(name="cronExpressionForRecurrence")
    def cron_expression_for_recurrence(self) -> pulumi.Input[str]:
        """
        A cron expression specifying the recurrence pattern for an Auto-Tune maintenance schedule.
        """
        return pulumi.get(self, "cron_expression_for_recurrence")

    @cron_expression_for_recurrence.setter
    def cron_expression_for_recurrence(self, value: pulumi.Input[str]):
        pulumi.set(self, "cron_expression_for_recurrence", value)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleDurationArgs']:
        """
        Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input['DomainAutoTuneOptionsMaintenanceScheduleDurationArgs']):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="startAt")
    def start_at(self) -> pulumi.Input[str]:
        """
        Date and time at which to start the Auto-Tune maintenance schedule in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "start_at")

    @start_at.setter
    def start_at(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_at", value)


if not MYPY:
    class DomainAutoTuneOptionsMaintenanceScheduleDurationArgsDict(TypedDict):
        unit: pulumi.Input[str]
        """
        Unit of time specifying the duration of an Auto-Tune maintenance window. Valid values: `HOURS`.
        """
        value: pulumi.Input[int]
        """
        An integer specifying the value of the duration of an Auto-Tune maintenance window.
        """
elif False:
    DomainAutoTuneOptionsMaintenanceScheduleDurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainAutoTuneOptionsMaintenanceScheduleDurationArgs:
    def __init__(__self__, *,
                 unit: pulumi.Input[str],
                 value: pulumi.Input[int]):
        """
        :param pulumi.Input[str] unit: Unit of time specifying the duration of an Auto-Tune maintenance window. Valid values: `HOURS`.
        :param pulumi.Input[int] value: An integer specifying the value of the duration of an Auto-Tune maintenance window.
        """
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> pulumi.Input[str]:
        """
        Unit of time specifying the duration of an Auto-Tune maintenance window. Valid values: `HOURS`.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: pulumi.Input[str]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[int]:
        """
        An integer specifying the value of the duration of an Auto-Tune maintenance window.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[int]):
        pulumi.set(self, "value", value)


if not MYPY:
    class DomainClusterConfigArgsDict(TypedDict):
        cold_storage_options: NotRequired[pulumi.Input['DomainClusterConfigColdStorageOptionsArgsDict']]
        """
        Configuration block containing cold storage configuration. Detailed below.
        """
        dedicated_master_count: NotRequired[pulumi.Input[int]]
        """
        Number of dedicated main nodes in the cluster.
        """
        dedicated_master_enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether dedicated main nodes are enabled for the cluster.
        """
        dedicated_master_type: NotRequired[pulumi.Input[str]]
        """
        Instance type of the dedicated main nodes in the cluster.
        """
        instance_count: NotRequired[pulumi.Input[int]]
        """
        Number of instances in the cluster.
        """
        instance_type: NotRequired[pulumi.Input[str]]
        """
        Instance type of data nodes in the cluster.
        """
        multi_az_with_standby_enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether a multi-AZ domain is turned on with a standby AZ. For more information, see [Configuring a multi-AZ domain in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html).
        """
        warm_count: NotRequired[pulumi.Input[int]]
        """
        Number of warm nodes in the cluster. Valid values are between `2` and `150`. `warm_count` can be only and must be set when `warm_enabled` is set to `true`.
        """
        warm_enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether to enable warm storage.
        """
        warm_type: NotRequired[pulumi.Input[str]]
        """
        Instance type for the OpenSearch cluster's warm nodes. Valid values are `ultrawarm1.medium.search`, `ultrawarm1.large.search` and `ultrawarm1.xlarge.search`. `warm_type` can be only and must be set when `warm_enabled` is set to `true`.
        """
        zone_awareness_config: NotRequired[pulumi.Input['DomainClusterConfigZoneAwarenessConfigArgsDict']]
        """
        Configuration block containing zone awareness settings. Detailed below.
        """
        zone_awareness_enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether zone awareness is enabled, set to `true` for multi-az deployment. To enable awareness with three Availability Zones, the `availability_zone_count` within the `zone_awareness_config` must be set to `3`.
        """
elif False:
    DomainClusterConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainClusterConfigArgs:
    def __init__(__self__, *,
                 cold_storage_options: Optional[pulumi.Input['DomainClusterConfigColdStorageOptionsArgs']] = None,
                 dedicated_master_count: Optional[pulumi.Input[int]] = None,
                 dedicated_master_enabled: Optional[pulumi.Input[bool]] = None,
                 dedicated_master_type: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 multi_az_with_standby_enabled: Optional[pulumi.Input[bool]] = None,
                 warm_count: Optional[pulumi.Input[int]] = None,
                 warm_enabled: Optional[pulumi.Input[bool]] = None,
                 warm_type: Optional[pulumi.Input[str]] = None,
                 zone_awareness_config: Optional[pulumi.Input['DomainClusterConfigZoneAwarenessConfigArgs']] = None,
                 zone_awareness_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['DomainClusterConfigColdStorageOptionsArgs'] cold_storage_options: Configuration block containing cold storage configuration. Detailed below.
        :param pulumi.Input[int] dedicated_master_count: Number of dedicated main nodes in the cluster.
        :param pulumi.Input[bool] dedicated_master_enabled: Whether dedicated main nodes are enabled for the cluster.
        :param pulumi.Input[str] dedicated_master_type: Instance type of the dedicated main nodes in the cluster.
        :param pulumi.Input[int] instance_count: Number of instances in the cluster.
        :param pulumi.Input[str] instance_type: Instance type of data nodes in the cluster.
        :param pulumi.Input[bool] multi_az_with_standby_enabled: Whether a multi-AZ domain is turned on with a standby AZ. For more information, see [Configuring a multi-AZ domain in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html).
        :param pulumi.Input[int] warm_count: Number of warm nodes in the cluster. Valid values are between `2` and `150`. `warm_count` can be only and must be set when `warm_enabled` is set to `true`.
        :param pulumi.Input[bool] warm_enabled: Whether to enable warm storage.
        :param pulumi.Input[str] warm_type: Instance type for the OpenSearch cluster's warm nodes. Valid values are `ultrawarm1.medium.search`, `ultrawarm1.large.search` and `ultrawarm1.xlarge.search`. `warm_type` can be only and must be set when `warm_enabled` is set to `true`.
        :param pulumi.Input['DomainClusterConfigZoneAwarenessConfigArgs'] zone_awareness_config: Configuration block containing zone awareness settings. Detailed below.
        :param pulumi.Input[bool] zone_awareness_enabled: Whether zone awareness is enabled, set to `true` for multi-az deployment. To enable awareness with three Availability Zones, the `availability_zone_count` within the `zone_awareness_config` must be set to `3`.
        """
        if cold_storage_options is not None:
            pulumi.set(__self__, "cold_storage_options", cold_storage_options)
        if dedicated_master_count is not None:
            pulumi.set(__self__, "dedicated_master_count", dedicated_master_count)
        if dedicated_master_enabled is not None:
            pulumi.set(__self__, "dedicated_master_enabled", dedicated_master_enabled)
        if dedicated_master_type is not None:
            pulumi.set(__self__, "dedicated_master_type", dedicated_master_type)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if multi_az_with_standby_enabled is not None:
            pulumi.set(__self__, "multi_az_with_standby_enabled", multi_az_with_standby_enabled)
        if warm_count is not None:
            pulumi.set(__self__, "warm_count", warm_count)
        if warm_enabled is not None:
            pulumi.set(__self__, "warm_enabled", warm_enabled)
        if warm_type is not None:
            pulumi.set(__self__, "warm_type", warm_type)
        if zone_awareness_config is not None:
            pulumi.set(__self__, "zone_awareness_config", zone_awareness_config)
        if zone_awareness_enabled is not None:
            pulumi.set(__self__, "zone_awareness_enabled", zone_awareness_enabled)

    @property
    @pulumi.getter(name="coldStorageOptions")
    def cold_storage_options(self) -> Optional[pulumi.Input['DomainClusterConfigColdStorageOptionsArgs']]:
        """
        Configuration block containing cold storage configuration. Detailed below.
        """
        return pulumi.get(self, "cold_storage_options")

    @cold_storage_options.setter
    def cold_storage_options(self, value: Optional[pulumi.Input['DomainClusterConfigColdStorageOptionsArgs']]):
        pulumi.set(self, "cold_storage_options", value)

    @property
    @pulumi.getter(name="dedicatedMasterCount")
    def dedicated_master_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of dedicated main nodes in the cluster.
        """
        return pulumi.get(self, "dedicated_master_count")

    @dedicated_master_count.setter
    def dedicated_master_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dedicated_master_count", value)

    @property
    @pulumi.getter(name="dedicatedMasterEnabled")
    def dedicated_master_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether dedicated main nodes are enabled for the cluster.
        """
        return pulumi.get(self, "dedicated_master_enabled")

    @dedicated_master_enabled.setter
    def dedicated_master_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dedicated_master_enabled", value)

    @property
    @pulumi.getter(name="dedicatedMasterType")
    def dedicated_master_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance type of the dedicated main nodes in the cluster.
        """
        return pulumi.get(self, "dedicated_master_type")

    @dedicated_master_type.setter
    def dedicated_master_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_master_type", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of instances in the cluster.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance type of data nodes in the cluster.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="multiAzWithStandbyEnabled")
    def multi_az_with_standby_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether a multi-AZ domain is turned on with a standby AZ. For more information, see [Configuring a multi-AZ domain in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html).
        """
        return pulumi.get(self, "multi_az_with_standby_enabled")

    @multi_az_with_standby_enabled.setter
    def multi_az_with_standby_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_az_with_standby_enabled", value)

    @property
    @pulumi.getter(name="warmCount")
    def warm_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of warm nodes in the cluster. Valid values are between `2` and `150`. `warm_count` can be only and must be set when `warm_enabled` is set to `true`.
        """
        return pulumi.get(self, "warm_count")

    @warm_count.setter
    def warm_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warm_count", value)

    @property
    @pulumi.getter(name="warmEnabled")
    def warm_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable warm storage.
        """
        return pulumi.get(self, "warm_enabled")

    @warm_enabled.setter
    def warm_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "warm_enabled", value)

    @property
    @pulumi.getter(name="warmType")
    def warm_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance type for the OpenSearch cluster's warm nodes. Valid values are `ultrawarm1.medium.search`, `ultrawarm1.large.search` and `ultrawarm1.xlarge.search`. `warm_type` can be only and must be set when `warm_enabled` is set to `true`.
        """
        return pulumi.get(self, "warm_type")

    @warm_type.setter
    def warm_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warm_type", value)

    @property
    @pulumi.getter(name="zoneAwarenessConfig")
    def zone_awareness_config(self) -> Optional[pulumi.Input['DomainClusterConfigZoneAwarenessConfigArgs']]:
        """
        Configuration block containing zone awareness settings. Detailed below.
        """
        return pulumi.get(self, "zone_awareness_config")

    @zone_awareness_config.setter
    def zone_awareness_config(self, value: Optional[pulumi.Input['DomainClusterConfigZoneAwarenessConfigArgs']]):
        pulumi.set(self, "zone_awareness_config", value)

    @property
    @pulumi.getter(name="zoneAwarenessEnabled")
    def zone_awareness_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether zone awareness is enabled, set to `true` for multi-az deployment. To enable awareness with three Availability Zones, the `availability_zone_count` within the `zone_awareness_config` must be set to `3`.
        """
        return pulumi.get(self, "zone_awareness_enabled")

    @zone_awareness_enabled.setter
    def zone_awareness_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "zone_awareness_enabled", value)


if not MYPY:
    class DomainClusterConfigColdStorageOptionsArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Boolean to enable cold storage for an OpenSearch domain. Defaults to `false`. Master and ultrawarm nodes must be enabled for cold storage.
        """
elif False:
    DomainClusterConfigColdStorageOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainClusterConfigColdStorageOptionsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] enabled: Boolean to enable cold storage for an OpenSearch domain. Defaults to `false`. Master and ultrawarm nodes must be enabled for cold storage.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to enable cold storage for an OpenSearch domain. Defaults to `false`. Master and ultrawarm nodes must be enabled for cold storage.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class DomainClusterConfigZoneAwarenessConfigArgsDict(TypedDict):
        availability_zone_count: NotRequired[pulumi.Input[int]]
        """
        Number of Availability Zones for the domain to use with `zone_awareness_enabled`. Defaults to `2`. Valid values: `2` or `3`.
        """
elif False:
    DomainClusterConfigZoneAwarenessConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainClusterConfigZoneAwarenessConfigArgs:
    def __init__(__self__, *,
                 availability_zone_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] availability_zone_count: Number of Availability Zones for the domain to use with `zone_awareness_enabled`. Defaults to `2`. Valid values: `2` or `3`.
        """
        if availability_zone_count is not None:
            pulumi.set(__self__, "availability_zone_count", availability_zone_count)

    @property
    @pulumi.getter(name="availabilityZoneCount")
    def availability_zone_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of Availability Zones for the domain to use with `zone_awareness_enabled`. Defaults to `2`. Valid values: `2` or `3`.
        """
        return pulumi.get(self, "availability_zone_count")

    @availability_zone_count.setter
    def availability_zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "availability_zone_count", value)


if not MYPY:
    class DomainCognitoOptionsArgsDict(TypedDict):
        identity_pool_id: pulumi.Input[str]
        """
        ID of the Cognito Identity Pool to use.
        """
        role_arn: pulumi.Input[str]
        """
        ARN of the IAM role that has the AmazonOpenSearchServiceCognitoAccess policy attached.
        """
        user_pool_id: pulumi.Input[str]
        """
        ID of the Cognito User Pool to use.
        """
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether Amazon Cognito authentication with Dashboard is enabled or not. Default is `false`.
        """
elif False:
    DomainCognitoOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainCognitoOptionsArgs:
    def __init__(__self__, *,
                 identity_pool_id: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 user_pool_id: pulumi.Input[str],
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] identity_pool_id: ID of the Cognito Identity Pool to use.
        :param pulumi.Input[str] role_arn: ARN of the IAM role that has the AmazonOpenSearchServiceCognitoAccess policy attached.
        :param pulumi.Input[str] user_pool_id: ID of the Cognito User Pool to use.
        :param pulumi.Input[bool] enabled: Whether Amazon Cognito authentication with Dashboard is enabled or not. Default is `false`.
        """
        pulumi.set(__self__, "identity_pool_id", identity_pool_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> pulumi.Input[str]:
        """
        ID of the Cognito Identity Pool to use.
        """
        return pulumi.get(self, "identity_pool_id")

    @identity_pool_id.setter
    def identity_pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "identity_pool_id", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        ARN of the IAM role that has the AmazonOpenSearchServiceCognitoAccess policy attached.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[str]:
        """
        ID of the Cognito User Pool to use.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Amazon Cognito authentication with Dashboard is enabled or not. Default is `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class DomainDomainEndpointOptionsArgsDict(TypedDict):
        custom_endpoint: NotRequired[pulumi.Input[str]]
        """
        Fully qualified domain for your custom endpoint.
        """
        custom_endpoint_certificate_arn: NotRequired[pulumi.Input[str]]
        """
        ACM certificate ARN for your custom endpoint.
        """
        custom_endpoint_enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether to enable custom endpoint for the OpenSearch domain.
        """
        enforce_https: NotRequired[pulumi.Input[bool]]
        """
        Whether or not to require HTTPS. Defaults to `true`.
        """
        tls_security_policy: NotRequired[pulumi.Input[str]]
        """
        Name of the TLS security policy that needs to be applied to the HTTPS endpoint. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DomainEndpointOptions.html#opensearchservice-Type-DomainEndpointOptions-TLSSecurityPolicy). Pulumi will only perform drift detection if a configuration value is provided.
        """
elif False:
    DomainDomainEndpointOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainDomainEndpointOptionsArgs:
    def __init__(__self__, *,
                 custom_endpoint: Optional[pulumi.Input[str]] = None,
                 custom_endpoint_certificate_arn: Optional[pulumi.Input[str]] = None,
                 custom_endpoint_enabled: Optional[pulumi.Input[bool]] = None,
                 enforce_https: Optional[pulumi.Input[bool]] = None,
                 tls_security_policy: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] custom_endpoint: Fully qualified domain for your custom endpoint.
        :param pulumi.Input[str] custom_endpoint_certificate_arn: ACM certificate ARN for your custom endpoint.
        :param pulumi.Input[bool] custom_endpoint_enabled: Whether to enable custom endpoint for the OpenSearch domain.
        :param pulumi.Input[bool] enforce_https: Whether or not to require HTTPS. Defaults to `true`.
        :param pulumi.Input[str] tls_security_policy: Name of the TLS security policy that needs to be applied to the HTTPS endpoint. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DomainEndpointOptions.html#opensearchservice-Type-DomainEndpointOptions-TLSSecurityPolicy). Pulumi will only perform drift detection if a configuration value is provided.
        """
        if custom_endpoint is not None:
            pulumi.set(__self__, "custom_endpoint", custom_endpoint)
        if custom_endpoint_certificate_arn is not None:
            pulumi.set(__self__, "custom_endpoint_certificate_arn", custom_endpoint_certificate_arn)
        if custom_endpoint_enabled is not None:
            pulumi.set(__self__, "custom_endpoint_enabled", custom_endpoint_enabled)
        if enforce_https is not None:
            pulumi.set(__self__, "enforce_https", enforce_https)
        if tls_security_policy is not None:
            pulumi.set(__self__, "tls_security_policy", tls_security_policy)

    @property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified domain for your custom endpoint.
        """
        return pulumi.get(self, "custom_endpoint")

    @custom_endpoint.setter
    def custom_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_endpoint", value)

    @property
    @pulumi.getter(name="customEndpointCertificateArn")
    def custom_endpoint_certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ACM certificate ARN for your custom endpoint.
        """
        return pulumi.get(self, "custom_endpoint_certificate_arn")

    @custom_endpoint_certificate_arn.setter
    def custom_endpoint_certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_endpoint_certificate_arn", value)

    @property
    @pulumi.getter(name="customEndpointEnabled")
    def custom_endpoint_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable custom endpoint for the OpenSearch domain.
        """
        return pulumi.get(self, "custom_endpoint_enabled")

    @custom_endpoint_enabled.setter
    def custom_endpoint_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_endpoint_enabled", value)

    @property
    @pulumi.getter(name="enforceHttps")
    def enforce_https(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to require HTTPS. Defaults to `true`.
        """
        return pulumi.get(self, "enforce_https")

    @enforce_https.setter
    def enforce_https(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enforce_https", value)

    @property
    @pulumi.getter(name="tlsSecurityPolicy")
    def tls_security_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the TLS security policy that needs to be applied to the HTTPS endpoint. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DomainEndpointOptions.html#opensearchservice-Type-DomainEndpointOptions-TLSSecurityPolicy). Pulumi will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "tls_security_policy")

    @tls_security_policy.setter
    def tls_security_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_security_policy", value)


if not MYPY:
    class DomainEbsOptionsArgsDict(TypedDict):
        ebs_enabled: pulumi.Input[bool]
        """
        Whether EBS volumes are attached to data nodes in the domain.
        """
        iops: NotRequired[pulumi.Input[int]]
        """
        Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
        """
        throughput: NotRequired[pulumi.Input[int]]
        """
        Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
        """
        volume_size: NotRequired[pulumi.Input[int]]
        """
        Size of EBS volumes attached to data nodes (in GiB).
        """
        volume_type: NotRequired[pulumi.Input[str]]
        """
        Type of EBS volumes attached to data nodes.
        """
elif False:
    DomainEbsOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainEbsOptionsArgs:
    def __init__(__self__, *,
                 ebs_enabled: pulumi.Input[bool],
                 iops: Optional[pulumi.Input[int]] = None,
                 throughput: Optional[pulumi.Input[int]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] ebs_enabled: Whether EBS volumes are attached to data nodes in the domain.
        :param pulumi.Input[int] iops: Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
        :param pulumi.Input[int] throughput: Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
        :param pulumi.Input[int] volume_size: Size of EBS volumes attached to data nodes (in GiB).
        :param pulumi.Input[str] volume_type: Type of EBS volumes attached to data nodes.
        """
        pulumi.set(__self__, "ebs_enabled", ebs_enabled)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="ebsEnabled")
    def ebs_enabled(self) -> pulumi.Input[bool]:
        """
        Whether EBS volumes are attached to data nodes in the domain.
        """
        return pulumi.get(self, "ebs_enabled")

    @ebs_enabled.setter
    def ebs_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "ebs_enabled", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of EBS volumes attached to data nodes (in GiB).
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of EBS volumes attached to data nodes.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


if not MYPY:
    class DomainEncryptAtRestArgsDict(TypedDict):
        enabled: pulumi.Input[bool]
        """
        Whether to enable encryption at rest. If the `encrypt_at_rest` block is not provided then this defaults to `false`. Enabling encryption on new domains requires an `engine_version` of `OpenSearch_X.Y` or `Elasticsearch_5.1` or greater.
        """
        kms_key_id: NotRequired[pulumi.Input[str]]
        """
        KMS key ARN to encrypt the Elasticsearch domain with. If not specified then it defaults to using the `aws/es` service KMS key. Note that KMS will accept a KMS key ID but will return the key ARN. To prevent the provider detecting unwanted changes, use the key ARN instead.
        """
elif False:
    DomainEncryptAtRestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainEncryptAtRestArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 kms_key_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Whether to enable encryption at rest. If the `encrypt_at_rest` block is not provided then this defaults to `false`. Enabling encryption on new domains requires an `engine_version` of `OpenSearch_X.Y` or `Elasticsearch_5.1` or greater.
        :param pulumi.Input[str] kms_key_id: KMS key ARN to encrypt the Elasticsearch domain with. If not specified then it defaults to using the `aws/es` service KMS key. Note that KMS will accept a KMS key ID but will return the key ARN. To prevent the provider detecting unwanted changes, use the key ARN instead.
        """
        pulumi.set(__self__, "enabled", enabled)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether to enable encryption at rest. If the `encrypt_at_rest` block is not provided then this defaults to `false`. Enabling encryption on new domains requires an `engine_version` of `OpenSearch_X.Y` or `Elasticsearch_5.1` or greater.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        KMS key ARN to encrypt the Elasticsearch domain with. If not specified then it defaults to using the `aws/es` service KMS key. Note that KMS will accept a KMS key ID but will return the key ARN. To prevent the provider detecting unwanted changes, use the key ARN instead.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)


if not MYPY:
    class DomainLogPublishingOptionArgsDict(TypedDict):
        cloudwatch_log_group_arn: pulumi.Input[str]
        """
        ARN of the Cloudwatch log group to which log needs to be published.
        """
        log_type: pulumi.Input[str]
        """
        Type of OpenSearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
        """
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether given log publishing option is enabled or not.
        """
elif False:
    DomainLogPublishingOptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainLogPublishingOptionArgs:
    def __init__(__self__, *,
                 cloudwatch_log_group_arn: pulumi.Input[str],
                 log_type: pulumi.Input[str],
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] cloudwatch_log_group_arn: ARN of the Cloudwatch log group to which log needs to be published.
        :param pulumi.Input[str] log_type: Type of OpenSearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
        :param pulumi.Input[bool] enabled: Whether given log publishing option is enabled or not.
        """
        pulumi.set(__self__, "cloudwatch_log_group_arn", cloudwatch_log_group_arn)
        pulumi.set(__self__, "log_type", log_type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="cloudwatchLogGroupArn")
    def cloudwatch_log_group_arn(self) -> pulumi.Input[str]:
        """
        ARN of the Cloudwatch log group to which log needs to be published.
        """
        return pulumi.get(self, "cloudwatch_log_group_arn")

    @cloudwatch_log_group_arn.setter
    def cloudwatch_log_group_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloudwatch_log_group_arn", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> pulumi.Input[str]:
        """
        Type of OpenSearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_type", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether given log publishing option is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class DomainNodeToNodeEncryptionArgsDict(TypedDict):
        enabled: pulumi.Input[bool]
        """
        Whether to enable node-to-node encryption. If the `node_to_node_encryption` block is not provided then this defaults to `false`. Enabling node-to-node encryption of a new domain requires an `engine_version` of `OpenSearch_X.Y` or `Elasticsearch_6.0` or greater.
        """
elif False:
    DomainNodeToNodeEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainNodeToNodeEncryptionArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] enabled: Whether to enable node-to-node encryption. If the `node_to_node_encryption` block is not provided then this defaults to `false`. Enabling node-to-node encryption of a new domain requires an `engine_version` of `OpenSearch_X.Y` or `Elasticsearch_6.0` or greater.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether to enable node-to-node encryption. If the `node_to_node_encryption` block is not provided then this defaults to `false`. Enabling node-to-node encryption of a new domain requires an `engine_version` of `OpenSearch_X.Y` or `Elasticsearch_6.0` or greater.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class DomainOffPeakWindowOptionsArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Enabled disabled toggle for off-peak update window.
        """
        off_peak_window: NotRequired[pulumi.Input['DomainOffPeakWindowOptionsOffPeakWindowArgsDict']]
elif False:
    DomainOffPeakWindowOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainOffPeakWindowOptionsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 off_peak_window: Optional[pulumi.Input['DomainOffPeakWindowOptionsOffPeakWindowArgs']] = None):
        """
        :param pulumi.Input[bool] enabled: Enabled disabled toggle for off-peak update window.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if off_peak_window is not None:
            pulumi.set(__self__, "off_peak_window", off_peak_window)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabled disabled toggle for off-peak update window.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="offPeakWindow")
    def off_peak_window(self) -> Optional[pulumi.Input['DomainOffPeakWindowOptionsOffPeakWindowArgs']]:
        return pulumi.get(self, "off_peak_window")

    @off_peak_window.setter
    def off_peak_window(self, value: Optional[pulumi.Input['DomainOffPeakWindowOptionsOffPeakWindowArgs']]):
        pulumi.set(self, "off_peak_window", value)


if not MYPY:
    class DomainOffPeakWindowOptionsOffPeakWindowArgsDict(TypedDict):
        window_start_time: NotRequired[pulumi.Input['DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgsDict']]
        """
        10h window for updates
        """
elif False:
    DomainOffPeakWindowOptionsOffPeakWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainOffPeakWindowOptionsOffPeakWindowArgs:
    def __init__(__self__, *,
                 window_start_time: Optional[pulumi.Input['DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs']] = None):
        """
        :param pulumi.Input['DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs'] window_start_time: 10h window for updates
        """
        if window_start_time is not None:
            pulumi.set(__self__, "window_start_time", window_start_time)

    @property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> Optional[pulumi.Input['DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs']]:
        """
        10h window for updates
        """
        return pulumi.get(self, "window_start_time")

    @window_start_time.setter
    def window_start_time(self, value: Optional[pulumi.Input['DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs']]):
        pulumi.set(self, "window_start_time", value)


if not MYPY:
    class DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgsDict(TypedDict):
        hours: NotRequired[pulumi.Input[int]]
        """
        Starting hour of the 10-hour window for updates
        """
        minutes: NotRequired[pulumi.Input[int]]
        """
        Starting minute of the 10-hour window for updates
        """
elif False:
    DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs:
    def __init__(__self__, *,
                 hours: Optional[pulumi.Input[int]] = None,
                 minutes: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] hours: Starting hour of the 10-hour window for updates
        :param pulumi.Input[int] minutes: Starting minute of the 10-hour window for updates
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def hours(self) -> Optional[pulumi.Input[int]]:
        """
        Starting hour of the 10-hour window for updates
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Starting minute of the 10-hour window for updates
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minutes", value)


if not MYPY:
    class DomainSamlOptionsSamlOptionsArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether SAML authentication is enabled.
        """
        idp: NotRequired[pulumi.Input['DomainSamlOptionsSamlOptionsIdpArgsDict']]
        """
        Information from your identity provider.
        """
        master_backend_role: NotRequired[pulumi.Input[str]]
        """
        This backend role from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        """
        master_user_name: NotRequired[pulumi.Input[str]]
        """
        This username from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        """
        roles_key: NotRequired[pulumi.Input[str]]
        """
        Element of the SAML assertion to use for backend roles. Default is roles.
        """
        session_timeout_minutes: NotRequired[pulumi.Input[int]]
        """
        Duration of a session in minutes after a user logs in. Default is 60. Maximum value is 1,440.
        """
        subject_key: NotRequired[pulumi.Input[str]]
        """
        Element of the SAML assertion to use for username. Default is NameID.
        """
elif False:
    DomainSamlOptionsSamlOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainSamlOptionsSamlOptionsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp: Optional[pulumi.Input['DomainSamlOptionsSamlOptionsIdpArgs']] = None,
                 master_backend_role: Optional[pulumi.Input[str]] = None,
                 master_user_name: Optional[pulumi.Input[str]] = None,
                 roles_key: Optional[pulumi.Input[str]] = None,
                 session_timeout_minutes: Optional[pulumi.Input[int]] = None,
                 subject_key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Whether SAML authentication is enabled.
        :param pulumi.Input['DomainSamlOptionsSamlOptionsIdpArgs'] idp: Information from your identity provider.
        :param pulumi.Input[str] master_backend_role: This backend role from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        :param pulumi.Input[str] master_user_name: This username from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        :param pulumi.Input[str] roles_key: Element of the SAML assertion to use for backend roles. Default is roles.
        :param pulumi.Input[int] session_timeout_minutes: Duration of a session in minutes after a user logs in. Default is 60. Maximum value is 1,440.
        :param pulumi.Input[str] subject_key: Element of the SAML assertion to use for username. Default is NameID.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp is not None:
            pulumi.set(__self__, "idp", idp)
        if master_backend_role is not None:
            pulumi.set(__self__, "master_backend_role", master_backend_role)
        if master_user_name is not None:
            pulumi.set(__self__, "master_user_name", master_user_name)
        if roles_key is not None:
            pulumi.set(__self__, "roles_key", roles_key)
        if session_timeout_minutes is not None:
            pulumi.set(__self__, "session_timeout_minutes", session_timeout_minutes)
        if subject_key is not None:
            pulumi.set(__self__, "subject_key", subject_key)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether SAML authentication is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def idp(self) -> Optional[pulumi.Input['DomainSamlOptionsSamlOptionsIdpArgs']]:
        """
        Information from your identity provider.
        """
        return pulumi.get(self, "idp")

    @idp.setter
    def idp(self, value: Optional[pulumi.Input['DomainSamlOptionsSamlOptionsIdpArgs']]):
        pulumi.set(self, "idp", value)

    @property
    @pulumi.getter(name="masterBackendRole")
    def master_backend_role(self) -> Optional[pulumi.Input[str]]:
        """
        This backend role from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        """
        return pulumi.get(self, "master_backend_role")

    @master_backend_role.setter
    def master_backend_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_backend_role", value)

    @property
    @pulumi.getter(name="masterUserName")
    def master_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        This username from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        """
        return pulumi.get(self, "master_user_name")

    @master_user_name.setter
    def master_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_user_name", value)

    @property
    @pulumi.getter(name="rolesKey")
    def roles_key(self) -> Optional[pulumi.Input[str]]:
        """
        Element of the SAML assertion to use for backend roles. Default is roles.
        """
        return pulumi.get(self, "roles_key")

    @roles_key.setter
    def roles_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "roles_key", value)

    @property
    @pulumi.getter(name="sessionTimeoutMinutes")
    def session_timeout_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Duration of a session in minutes after a user logs in. Default is 60. Maximum value is 1,440.
        """
        return pulumi.get(self, "session_timeout_minutes")

    @session_timeout_minutes.setter
    def session_timeout_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_timeout_minutes", value)

    @property
    @pulumi.getter(name="subjectKey")
    def subject_key(self) -> Optional[pulumi.Input[str]]:
        """
        Element of the SAML assertion to use for username. Default is NameID.
        """
        return pulumi.get(self, "subject_key")

    @subject_key.setter
    def subject_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_key", value)


if not MYPY:
    class DomainSamlOptionsSamlOptionsIdpArgsDict(TypedDict):
        entity_id: pulumi.Input[str]
        """
        Unique Entity ID of the application in SAML Identity Provider.
        """
        metadata_content: pulumi.Input[str]
        """
        Metadata of the SAML application in xml format.
        """
elif False:
    DomainSamlOptionsSamlOptionsIdpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainSamlOptionsSamlOptionsIdpArgs:
    def __init__(__self__, *,
                 entity_id: pulumi.Input[str],
                 metadata_content: pulumi.Input[str]):
        """
        :param pulumi.Input[str] entity_id: Unique Entity ID of the application in SAML Identity Provider.
        :param pulumi.Input[str] metadata_content: Metadata of the SAML application in xml format.
        """
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "metadata_content", metadata_content)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> pulumi.Input[str]:
        """
        Unique Entity ID of the application in SAML Identity Provider.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter(name="metadataContent")
    def metadata_content(self) -> pulumi.Input[str]:
        """
        Metadata of the SAML application in xml format.
        """
        return pulumi.get(self, "metadata_content")

    @metadata_content.setter
    def metadata_content(self, value: pulumi.Input[str]):
        pulumi.set(self, "metadata_content", value)


if not MYPY:
    class DomainSnapshotOptionsArgsDict(TypedDict):
        automated_snapshot_start_hour: pulumi.Input[int]
        """
        Hour during which the service takes an automated daily snapshot of the indices in the domain.
        """
elif False:
    DomainSnapshotOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainSnapshotOptionsArgs:
    def __init__(__self__, *,
                 automated_snapshot_start_hour: pulumi.Input[int]):
        """
        :param pulumi.Input[int] automated_snapshot_start_hour: Hour during which the service takes an automated daily snapshot of the indices in the domain.
        """
        pulumi.set(__self__, "automated_snapshot_start_hour", automated_snapshot_start_hour)

    @property
    @pulumi.getter(name="automatedSnapshotStartHour")
    def automated_snapshot_start_hour(self) -> pulumi.Input[int]:
        """
        Hour during which the service takes an automated daily snapshot of the indices in the domain.
        """
        return pulumi.get(self, "automated_snapshot_start_hour")

    @automated_snapshot_start_hour.setter
    def automated_snapshot_start_hour(self, value: pulumi.Input[int]):
        pulumi.set(self, "automated_snapshot_start_hour", value)


if not MYPY:
    class DomainSoftwareUpdateOptionsArgsDict(TypedDict):
        auto_software_update_enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether automatic service software updates are enabled for the domain. Defaults to `false`.
        """
elif False:
    DomainSoftwareUpdateOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainSoftwareUpdateOptionsArgs:
    def __init__(__self__, *,
                 auto_software_update_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] auto_software_update_enabled: Whether automatic service software updates are enabled for the domain. Defaults to `false`.
        """
        if auto_software_update_enabled is not None:
            pulumi.set(__self__, "auto_software_update_enabled", auto_software_update_enabled)

    @property
    @pulumi.getter(name="autoSoftwareUpdateEnabled")
    def auto_software_update_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether automatic service software updates are enabled for the domain. Defaults to `false`.
        """
        return pulumi.get(self, "auto_software_update_enabled")

    @auto_software_update_enabled.setter
    def auto_software_update_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_software_update_enabled", value)


if not MYPY:
    class DomainVpcOptionsArgsDict(TypedDict):
        availability_zones: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        List of VPC Security Group IDs to be applied to the OpenSearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
        """
        subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        List of VPC Subnet IDs for the OpenSearch domain endpoints to be created in.
        """
        vpc_id: NotRequired[pulumi.Input[str]]
        """
        If the domain was created inside a VPC, the ID of the VPC.
        """
elif False:
    DomainVpcOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainVpcOptionsArgs:
    def __init__(__self__, *,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of VPC Security Group IDs to be applied to the OpenSearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of VPC Subnet IDs for the OpenSearch domain endpoints to be created in.
        :param pulumi.Input[str] vpc_id: If the domain was created inside a VPC, the ID of the VPC.
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VPC Security Group IDs to be applied to the OpenSearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VPC Subnet IDs for the OpenSearch domain endpoints to be created in.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        If the domain was created inside a VPC, the ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


if not MYPY:
    class OutboundConnectionConnectionPropertiesArgsDict(TypedDict):
        cross_cluster_search: NotRequired[pulumi.Input['OutboundConnectionConnectionPropertiesCrossClusterSearchArgsDict']]
        """
        Configuration block for cross cluster search.
        """
        endpoint: NotRequired[pulumi.Input[str]]
        """
        The endpoint of the remote domain, is only set when `connection_mode` is `VPC_ENDPOINT` and `accept_connection` is `TRUE`.
        """
elif False:
    OutboundConnectionConnectionPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OutboundConnectionConnectionPropertiesArgs:
    def __init__(__self__, *,
                 cross_cluster_search: Optional[pulumi.Input['OutboundConnectionConnectionPropertiesCrossClusterSearchArgs']] = None,
                 endpoint: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['OutboundConnectionConnectionPropertiesCrossClusterSearchArgs'] cross_cluster_search: Configuration block for cross cluster search.
        :param pulumi.Input[str] endpoint: The endpoint of the remote domain, is only set when `connection_mode` is `VPC_ENDPOINT` and `accept_connection` is `TRUE`.
        """
        if cross_cluster_search is not None:
            pulumi.set(__self__, "cross_cluster_search", cross_cluster_search)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="crossClusterSearch")
    def cross_cluster_search(self) -> Optional[pulumi.Input['OutboundConnectionConnectionPropertiesCrossClusterSearchArgs']]:
        """
        Configuration block for cross cluster search.
        """
        return pulumi.get(self, "cross_cluster_search")

    @cross_cluster_search.setter
    def cross_cluster_search(self, value: Optional[pulumi.Input['OutboundConnectionConnectionPropertiesCrossClusterSearchArgs']]):
        pulumi.set(self, "cross_cluster_search", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint of the remote domain, is only set when `connection_mode` is `VPC_ENDPOINT` and `accept_connection` is `TRUE`.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)


if not MYPY:
    class OutboundConnectionConnectionPropertiesCrossClusterSearchArgsDict(TypedDict):
        skip_unavailable: NotRequired[pulumi.Input[str]]
        """
        Skips unavailable clusters and can only be used for cross-cluster searches. Accepted values are `ENABLED` or `DISABLED`.
        """
elif False:
    OutboundConnectionConnectionPropertiesCrossClusterSearchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OutboundConnectionConnectionPropertiesCrossClusterSearchArgs:
    def __init__(__self__, *,
                 skip_unavailable: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] skip_unavailable: Skips unavailable clusters and can only be used for cross-cluster searches. Accepted values are `ENABLED` or `DISABLED`.
        """
        if skip_unavailable is not None:
            pulumi.set(__self__, "skip_unavailable", skip_unavailable)

    @property
    @pulumi.getter(name="skipUnavailable")
    def skip_unavailable(self) -> Optional[pulumi.Input[str]]:
        """
        Skips unavailable clusters and can only be used for cross-cluster searches. Accepted values are `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "skip_unavailable")

    @skip_unavailable.setter
    def skip_unavailable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "skip_unavailable", value)


if not MYPY:
    class OutboundConnectionLocalDomainInfoArgsDict(TypedDict):
        domain_name: pulumi.Input[str]
        """
        The name of the local domain.
        """
        owner_id: pulumi.Input[str]
        """
        The Account ID of the owner of the local domain.
        """
        region: pulumi.Input[str]
        """
        The region of the local domain.
        """
elif False:
    OutboundConnectionLocalDomainInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OutboundConnectionLocalDomainInfoArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 owner_id: pulumi.Input[str],
                 region: pulumi.Input[str]):
        """
        :param pulumi.Input[str] domain_name: The name of the local domain.
        :param pulumi.Input[str] owner_id: The Account ID of the owner of the local domain.
        :param pulumi.Input[str] region: The region of the local domain.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The name of the local domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Input[str]:
        """
        The Account ID of the owner of the local domain.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        The region of the local domain.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)


if not MYPY:
    class OutboundConnectionRemoteDomainInfoArgsDict(TypedDict):
        domain_name: pulumi.Input[str]
        """
        The name of the remote domain.
        """
        owner_id: pulumi.Input[str]
        """
        The Account ID of the owner of the remote domain.
        """
        region: pulumi.Input[str]
        """
        The region of the remote domain.
        """
elif False:
    OutboundConnectionRemoteDomainInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OutboundConnectionRemoteDomainInfoArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 owner_id: pulumi.Input[str],
                 region: pulumi.Input[str]):
        """
        :param pulumi.Input[str] domain_name: The name of the remote domain.
        :param pulumi.Input[str] owner_id: The Account ID of the owner of the remote domain.
        :param pulumi.Input[str] region: The region of the remote domain.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The name of the remote domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Input[str]:
        """
        The Account ID of the owner of the remote domain.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        The region of the remote domain.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)


if not MYPY:
    class PackagePackageSourceArgsDict(TypedDict):
        s3_bucket_name: pulumi.Input[str]
        """
        The name of the Amazon S3 bucket containing the package.
        """
        s3_key: pulumi.Input[str]
        """
        Key (file name) of the package.
        """
elif False:
    PackagePackageSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PackagePackageSourceArgs:
    def __init__(__self__, *,
                 s3_bucket_name: pulumi.Input[str],
                 s3_key: pulumi.Input[str]):
        """
        :param pulumi.Input[str] s3_bucket_name: The name of the Amazon S3 bucket containing the package.
        :param pulumi.Input[str] s3_key: Key (file name) of the package.
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        pulumi.set(__self__, "s3_key", s3_key)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> pulumi.Input[str]:
        """
        The name of the Amazon S3 bucket containing the package.
        """
        return pulumi.get(self, "s3_bucket_name")

    @s3_bucket_name.setter
    def s3_bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_bucket_name", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> pulumi.Input[str]:
        """
        Key (file name) of the package.
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_key", value)


if not MYPY:
    class ServerlessCollectionTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        delete: NotRequired[pulumi.Input[str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
elif False:
    ServerlessCollectionTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerlessCollectionTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[str]] = None,
                 delete: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete", value)


if not MYPY:
    class ServerlessSecurityConfigSamlOptionsArgsDict(TypedDict):
        metadata: pulumi.Input[str]
        """
        The XML IdP metadata file generated from your identity provider.
        """
        group_attribute: NotRequired[pulumi.Input[str]]
        """
        Group attribute for this SAML integration.
        """
        session_timeout: NotRequired[pulumi.Input[int]]
        """
        Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
        """
        user_attribute: NotRequired[pulumi.Input[str]]
        """
        User attribute for this SAML integration.
        """
elif False:
    ServerlessSecurityConfigSamlOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerlessSecurityConfigSamlOptionsArgs:
    def __init__(__self__, *,
                 metadata: pulumi.Input[str],
                 group_attribute: Optional[pulumi.Input[str]] = None,
                 session_timeout: Optional[pulumi.Input[int]] = None,
                 user_attribute: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] metadata: The XML IdP metadata file generated from your identity provider.
        :param pulumi.Input[str] group_attribute: Group attribute for this SAML integration.
        :param pulumi.Input[int] session_timeout: Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
        :param pulumi.Input[str] user_attribute: User attribute for this SAML integration.
        """
        pulumi.set(__self__, "metadata", metadata)
        if group_attribute is not None:
            pulumi.set(__self__, "group_attribute", group_attribute)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)
        if user_attribute is not None:
            pulumi.set(__self__, "user_attribute", user_attribute)

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Input[str]:
        """
        The XML IdP metadata file generated from your identity provider.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: pulumi.Input[str]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="groupAttribute")
    def group_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        Group attribute for this SAML integration.
        """
        return pulumi.get(self, "group_attribute")

    @group_attribute.setter
    def group_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_attribute", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_timeout", value)

    @property
    @pulumi.getter(name="userAttribute")
    def user_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        User attribute for this SAML integration.
        """
        return pulumi.get(self, "user_attribute")

    @user_attribute.setter
    def user_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_attribute", value)


if not MYPY:
    class ServerlessVpcEndpointTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        delete: NotRequired[pulumi.Input[str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        update: NotRequired[pulumi.Input[str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
elif False:
    ServerlessVpcEndpointTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerlessVpcEndpointTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[str]] = None,
                 delete: Optional[pulumi.Input[str]] = None,
                 update: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param pulumi.Input[str] update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update", value)


if not MYPY:
    class VpcEndpointVpcOptionsArgsDict(TypedDict):
        subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        A list of subnet IDs associated with the VPC endpoints for the domain. If your domain uses multiple Availability Zones, you need to provide two subnet IDs, one per zone. Otherwise, provide only one.
        """
        availability_zones: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The list of security group IDs associated with the VPC endpoints for the domain. If you do not provide a security group ID, OpenSearch Service uses the default security group for the VPC.
        """
        vpc_id: NotRequired[pulumi.Input[str]]
elif False:
    VpcEndpointVpcOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpcEndpointVpcOptionsArgs:
    def __init__(__self__, *,
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of subnet IDs associated with the VPC endpoints for the domain. If your domain uses multiple Availability Zones, you need to provide two subnet IDs, one per zone. Otherwise, provide only one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The list of security group IDs associated with the VPC endpoints for the domain. If you do not provide a security group ID, OpenSearch Service uses the default security group for the VPC.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of subnet IDs associated with the VPC endpoints for the domain. If your domain uses multiple Availability Zones, you need to provide two subnet IDs, one per zone. Otherwise, provide only one.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of security group IDs associated with the VPC endpoints for the domain. If you do not provide a security group ID, OpenSearch Service uses the default security group for the VPC.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


if not MYPY:
    class GetDomainOffPeakWindowOptionsArgsDict(TypedDict):
        enabled: bool
        """
        Enabled disabled toggle for off-peak update window
        """
        off_peak_windows: Sequence['GetDomainOffPeakWindowOptionsOffPeakWindowArgsDict']
elif False:
    GetDomainOffPeakWindowOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDomainOffPeakWindowOptionsArgs:
    def __init__(__self__, *,
                 enabled: bool,
                 off_peak_windows: Sequence['GetDomainOffPeakWindowOptionsOffPeakWindowArgs']):
        """
        :param bool enabled: Enabled disabled toggle for off-peak update window
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "off_peak_windows", off_peak_windows)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enabled disabled toggle for off-peak update window
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: bool):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="offPeakWindows")
    def off_peak_windows(self) -> Sequence['GetDomainOffPeakWindowOptionsOffPeakWindowArgs']:
        return pulumi.get(self, "off_peak_windows")

    @off_peak_windows.setter
    def off_peak_windows(self, value: Sequence['GetDomainOffPeakWindowOptionsOffPeakWindowArgs']):
        pulumi.set(self, "off_peak_windows", value)


if not MYPY:
    class GetDomainOffPeakWindowOptionsOffPeakWindowArgsDict(TypedDict):
        window_start_times: Sequence['GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgsDict']
        """
        10h window for updates
        """
elif False:
    GetDomainOffPeakWindowOptionsOffPeakWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDomainOffPeakWindowOptionsOffPeakWindowArgs:
    def __init__(__self__, *,
                 window_start_times: Sequence['GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs']):
        """
        :param Sequence['GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs'] window_start_times: 10h window for updates
        """
        pulumi.set(__self__, "window_start_times", window_start_times)

    @property
    @pulumi.getter(name="windowStartTimes")
    def window_start_times(self) -> Sequence['GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs']:
        """
        10h window for updates
        """
        return pulumi.get(self, "window_start_times")

    @window_start_times.setter
    def window_start_times(self, value: Sequence['GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs']):
        pulumi.set(self, "window_start_times", value)


if not MYPY:
    class GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgsDict(TypedDict):
        hours: int
        """
        Starting hour of the 10-hour window for updates
        """
        minutes: int
        """
        Starting minute of the 10-hour window for updates
        """
elif False:
    GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs:
    def __init__(__self__, *,
                 hours: int,
                 minutes: int):
        """
        :param int hours: Starting hour of the 10-hour window for updates
        :param int minutes: Starting minute of the 10-hour window for updates
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Starting hour of the 10-hour window for updates
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: int):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Starting minute of the 10-hour window for updates
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: int):
        pulumi.set(self, "minutes", value)


if not MYPY:
    class GetServerlessSecurityConfigSamlOptionsArgsDict(TypedDict):
        group_attribute: str
        """
        Group attribute for this SAML integration.
        """
        metadata: str
        """
        The XML IdP metadata file generated from your identity provider.
        """
        session_timeout: int
        """
        Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
        """
        user_attribute: str
        """
        User attribute for this SAML integration.
        """
elif False:
    GetServerlessSecurityConfigSamlOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetServerlessSecurityConfigSamlOptionsArgs:
    def __init__(__self__, *,
                 group_attribute: str,
                 metadata: str,
                 session_timeout: int,
                 user_attribute: str):
        """
        :param str group_attribute: Group attribute for this SAML integration.
        :param str metadata: The XML IdP metadata file generated from your identity provider.
        :param int session_timeout: Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
        :param str user_attribute: User attribute for this SAML integration.
        """
        pulumi.set(__self__, "group_attribute", group_attribute)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "session_timeout", session_timeout)
        pulumi.set(__self__, "user_attribute", user_attribute)

    @property
    @pulumi.getter(name="groupAttribute")
    def group_attribute(self) -> str:
        """
        Group attribute for this SAML integration.
        """
        return pulumi.get(self, "group_attribute")

    @group_attribute.setter
    def group_attribute(self, value: str):
        pulumi.set(self, "group_attribute", value)

    @property
    @pulumi.getter
    def metadata(self) -> str:
        """
        The XML IdP metadata file generated from your identity provider.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: str):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> int:
        """
        Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: int):
        pulumi.set(self, "session_timeout", value)

    @property
    @pulumi.getter(name="userAttribute")
    def user_attribute(self) -> str:
        """
        User attribute for this SAML integration.
        """
        return pulumi.get(self, "user_attribute")

    @user_attribute.setter
    def user_attribute(self, value: str):
        pulumi.set(self, "user_attribute", value)


