# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InboundConnectionAccepterArgs', 'InboundConnectionAccepter']

@pulumi.input_type
class InboundConnectionAccepterArgs:
    def __init__(__self__, *,
                 connection_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a InboundConnectionAccepter resource.
        :param pulumi.Input[str] connection_id: Specifies the ID of the connection to accept.
        """
        pulumi.set(__self__, "connection_id", connection_id)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the connection to accept.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_id", value)


@pulumi.input_type
class _InboundConnectionAccepterState:
    def __init__(__self__, *,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 connection_status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering InboundConnectionAccepter resources.
        :param pulumi.Input[str] connection_id: Specifies the ID of the connection to accept.
        :param pulumi.Input[str] connection_status: Status of the connection request.
        """
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if connection_status is not None:
            pulumi.set(__self__, "connection_status", connection_status)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the connection to accept.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the connection request.
        """
        return pulumi.get(self, "connection_status")

    @connection_status.setter
    def connection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_status", value)


class InboundConnectionAccepter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an [AWS Opensearch Inbound Connection Accepter](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_AcceptInboundConnection.html). If connecting domains from different AWS accounts, ensure that the accepter is configured to use the AWS account where the _remote_ opensearch domain exists.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_region = aws.get_region()
        foo = aws.opensearch.OutboundConnection("foo",
            connection_alias="outbound_connection",
            local_domain_info={
                "owner_id": current.account_id,
                "region": current_get_region.name,
                "domain_name": local_domain["domainName"],
            },
            remote_domain_info={
                "owner_id": current.account_id,
                "region": current_get_region.name,
                "domain_name": remote_domain["domainName"],
            })
        foo_inbound_connection_accepter = aws.opensearch.InboundConnectionAccepter("foo", connection_id=foo.id)
        ```

        ## Import

        Using `pulumi import`, import AWS Opensearch Inbound Connection Accepters using the Inbound Connection ID. For example:

        ```sh
        $ pulumi import aws:opensearch/inboundConnectionAccepter:InboundConnectionAccepter foo connection-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_id: Specifies the ID of the connection to accept.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InboundConnectionAccepterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an [AWS Opensearch Inbound Connection Accepter](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_AcceptInboundConnection.html). If connecting domains from different AWS accounts, ensure that the accepter is configured to use the AWS account where the _remote_ opensearch domain exists.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_region = aws.get_region()
        foo = aws.opensearch.OutboundConnection("foo",
            connection_alias="outbound_connection",
            local_domain_info={
                "owner_id": current.account_id,
                "region": current_get_region.name,
                "domain_name": local_domain["domainName"],
            },
            remote_domain_info={
                "owner_id": current.account_id,
                "region": current_get_region.name,
                "domain_name": remote_domain["domainName"],
            })
        foo_inbound_connection_accepter = aws.opensearch.InboundConnectionAccepter("foo", connection_id=foo.id)
        ```

        ## Import

        Using `pulumi import`, import AWS Opensearch Inbound Connection Accepters using the Inbound Connection ID. For example:

        ```sh
        $ pulumi import aws:opensearch/inboundConnectionAccepter:InboundConnectionAccepter foo connection-id
        ```

        :param str resource_name: The name of the resource.
        :param InboundConnectionAccepterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InboundConnectionAccepterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InboundConnectionAccepterArgs.__new__(InboundConnectionAccepterArgs)

            if connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'connection_id'")
            __props__.__dict__["connection_id"] = connection_id
            __props__.__dict__["connection_status"] = None
        super(InboundConnectionAccepter, __self__).__init__(
            'aws:opensearch/inboundConnectionAccepter:InboundConnectionAccepter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_id: Optional[pulumi.Input[str]] = None,
            connection_status: Optional[pulumi.Input[str]] = None) -> 'InboundConnectionAccepter':
        """
        Get an existing InboundConnectionAccepter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_id: Specifies the ID of the connection to accept.
        :param pulumi.Input[str] connection_status: Status of the connection request.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InboundConnectionAccepterState.__new__(_InboundConnectionAccepterState)

        __props__.__dict__["connection_id"] = connection_id
        __props__.__dict__["connection_status"] = connection_status
        return InboundConnectionAccepter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the connection to accept.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> pulumi.Output[str]:
        """
        Status of the connection request.
        """
        return pulumi.get(self, "connection_status")

