# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOrganizationalUnitChildAccountsResult',
    'AwaitableGetOrganizationalUnitChildAccountsResult',
    'get_organizational_unit_child_accounts',
    'get_organizational_unit_child_accounts_output',
]

@pulumi.output_type
class GetOrganizationalUnitChildAccountsResult:
    """
    A collection of values returned by getOrganizationalUnitChildAccounts.
    """
    def __init__(__self__, accounts=None, id=None, parent_id=None):
        if accounts and not isinstance(accounts, list):
            raise TypeError("Expected argument 'accounts' to be a list")
        pulumi.set(__self__, "accounts", accounts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)

    @property
    @pulumi.getter
    def accounts(self) -> Sequence['outputs.GetOrganizationalUnitChildAccountsAccountResult']:
        """
        List of child accounts, which have the following attributes:
        """
        return pulumi.get(self, "accounts")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> str:
        return pulumi.get(self, "parent_id")


class AwaitableGetOrganizationalUnitChildAccountsResult(GetOrganizationalUnitChildAccountsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationalUnitChildAccountsResult(
            accounts=self.accounts,
            id=self.id,
            parent_id=self.parent_id)


def get_organizational_unit_child_accounts(parent_id: Optional[str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationalUnitChildAccountsResult:
    """
    Get all direct child accounts under a parent organizational unit. This only provides immediate children, not all children.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    org = aws.organizations.get_organization()
    accounts = aws.organizations.get_organizational_unit_child_accounts(parent_id=org.roots[0].id)
    ```


    :param str parent_id: The parent ID of the accounts.
    """
    __args__ = dict()
    __args__['parentId'] = parent_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:organizations/getOrganizationalUnitChildAccounts:getOrganizationalUnitChildAccounts', __args__, opts=opts, typ=GetOrganizationalUnitChildAccountsResult).value

    return AwaitableGetOrganizationalUnitChildAccountsResult(
        accounts=pulumi.get(__ret__, 'accounts'),
        id=pulumi.get(__ret__, 'id'),
        parent_id=pulumi.get(__ret__, 'parent_id'))
def get_organizational_unit_child_accounts_output(parent_id: Optional[pulumi.Input[str]] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrganizationalUnitChildAccountsResult]:
    """
    Get all direct child accounts under a parent organizational unit. This only provides immediate children, not all children.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    org = aws.organizations.get_organization()
    accounts = aws.organizations.get_organizational_unit_child_accounts(parent_id=org.roots[0].id)
    ```


    :param str parent_id: The parent ID of the accounts.
    """
    __args__ = dict()
    __args__['parentId'] = parent_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:organizations/getOrganizationalUnitChildAccounts:getOrganizationalUnitChildAccounts', __args__, opts=opts, typ=GetOrganizationalUnitChildAccountsResult)
    return __ret__.apply(lambda __response__: GetOrganizationalUnitChildAccountsResult(
        accounts=pulumi.get(__response__, 'accounts'),
        id=pulumi.get(__response__, 'id'),
        parent_id=pulumi.get(__response__, 'parent_id')))
