# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAssetResult',
    'AwaitableGetAssetResult',
    'get_asset',
    'get_asset_output',
]

@pulumi.output_type
class GetAssetResult:
    """
    A collection of values returned by getAsset.
    """
    def __init__(__self__, arn=None, asset_id=None, asset_type=None, host_id=None, id=None, rack_elevation=None, rack_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if asset_id and not isinstance(asset_id, str):
            raise TypeError("Expected argument 'asset_id' to be a str")
        pulumi.set(__self__, "asset_id", asset_id)
        if asset_type and not isinstance(asset_type, str):
            raise TypeError("Expected argument 'asset_type' to be a str")
        pulumi.set(__self__, "asset_type", asset_type)
        if host_id and not isinstance(host_id, str):
            raise TypeError("Expected argument 'host_id' to be a str")
        pulumi.set(__self__, "host_id", host_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if rack_elevation and not isinstance(rack_elevation, int):
            raise TypeError("Expected argument 'rack_elevation' to be a int")
        pulumi.set(__self__, "rack_elevation", rack_elevation)
        if rack_id and not isinstance(rack_id, str):
            raise TypeError("Expected argument 'rack_id' to be a str")
        pulumi.set(__self__, "rack_id", rack_id)

    @property
    @pulumi.getter
    def arn(self) -> str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> str:
        return pulumi.get(self, "asset_id")

    @property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> str:
        """
        Type of the asset.
        """
        return pulumi.get(self, "asset_type")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> str:
        """
        Host ID of the Dedicated Hosts on the asset, if a Dedicated Host is provisioned.
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="rackElevation")
    def rack_elevation(self) -> int:
        """
        Position of an asset in a rack measured in rack units.
        """
        return pulumi.get(self, "rack_elevation")

    @property
    @pulumi.getter(name="rackId")
    def rack_id(self) -> str:
        """
        Rack ID of the asset.
        """
        return pulumi.get(self, "rack_id")


class AwaitableGetAssetResult(GetAssetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAssetResult(
            arn=self.arn,
            asset_id=self.asset_id,
            asset_type=self.asset_type,
            host_id=self.host_id,
            id=self.id,
            rack_elevation=self.rack_elevation,
            rack_id=self.rack_id)


def get_asset(arn: Optional[str] = None,
              asset_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAssetResult:
    """
    Information about a specific hardware asset in an Outpost.


    :param str arn: Outpost ARN.
    :param str asset_id: ID of the asset.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['assetId'] = asset_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:outposts/getAsset:getAsset', __args__, opts=opts, typ=GetAssetResult).value

    return AwaitableGetAssetResult(
        arn=pulumi.get(__ret__, 'arn'),
        asset_id=pulumi.get(__ret__, 'asset_id'),
        asset_type=pulumi.get(__ret__, 'asset_type'),
        host_id=pulumi.get(__ret__, 'host_id'),
        id=pulumi.get(__ret__, 'id'),
        rack_elevation=pulumi.get(__ret__, 'rack_elevation'),
        rack_id=pulumi.get(__ret__, 'rack_id'))
def get_asset_output(arn: Optional[pulumi.Input[str]] = None,
                     asset_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAssetResult]:
    """
    Information about a specific hardware asset in an Outpost.


    :param str arn: Outpost ARN.
    :param str asset_id: ID of the asset.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['assetId'] = asset_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:outposts/getAsset:getAsset', __args__, opts=opts, typ=GetAssetResult)
    return __ret__.apply(lambda __response__: GetAssetResult(
        arn=pulumi.get(__response__, 'arn'),
        asset_id=pulumi.get(__response__, 'asset_id'),
        asset_type=pulumi.get(__response__, 'asset_type'),
        host_id=pulumi.get(__response__, 'host_id'),
        id=pulumi.get(__response__, 'id'),
        rack_elevation=pulumi.get(__response__, 'rack_elevation'),
        rack_id=pulumi.get(__response__, 'rack_id')))
