# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetThemeResult',
    'AwaitableGetThemeResult',
    'get_theme',
    'get_theme_output',
]

@pulumi.output_type
class GetThemeResult:
    """
    A collection of values returned by getTheme.
    """
    def __init__(__self__, arn=None, aws_account_id=None, base_theme_id=None, configurations=None, created_time=None, id=None, last_updated_time=None, name=None, permissions=None, status=None, tags=None, theme_id=None, version_description=None, version_number=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if aws_account_id and not isinstance(aws_account_id, str):
            raise TypeError("Expected argument 'aws_account_id' to be a str")
        pulumi.set(__self__, "aws_account_id", aws_account_id)
        if base_theme_id and not isinstance(base_theme_id, str):
            raise TypeError("Expected argument 'base_theme_id' to be a str")
        pulumi.set(__self__, "base_theme_id", base_theme_id)
        if configurations and not isinstance(configurations, list):
            raise TypeError("Expected argument 'configurations' to be a list")
        pulumi.set(__self__, "configurations", configurations)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_time and not isinstance(last_updated_time, str):
            raise TypeError("Expected argument 'last_updated_time' to be a str")
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if theme_id and not isinstance(theme_id, str):
            raise TypeError("Expected argument 'theme_id' to be a str")
        pulumi.set(__self__, "theme_id", theme_id)
        if version_description and not isinstance(version_description, str):
            raise TypeError("Expected argument 'version_description' to be a str")
        pulumi.set(__self__, "version_description", version_description)
        if version_number and not isinstance(version_number, int):
            raise TypeError("Expected argument 'version_number' to be a int")
        pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the theme.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> str:
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="baseThemeId")
    def base_theme_id(self) -> str:
        """
        The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight.
        """
        return pulumi.get(self, "base_theme_id")

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetThemeConfigurationResult']:
        """
        The theme configuration, which contains the theme display properties. See configuration.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The time that the theme was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> str:
        """
        The time that the theme was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Display name of the theme.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence['outputs.GetThemePermissionResult']:
        """
        A set of resource permissions on the theme. See permissions.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The theme creation status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> str:
        return pulumi.get(self, "theme_id")

    @property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> str:
        """
        A description of the current theme version being created/updated.
        """
        return pulumi.get(self, "version_description")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> int:
        """
        The version number of the theme version.
        """
        return pulumi.get(self, "version_number")


class AwaitableGetThemeResult(GetThemeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetThemeResult(
            arn=self.arn,
            aws_account_id=self.aws_account_id,
            base_theme_id=self.base_theme_id,
            configurations=self.configurations,
            created_time=self.created_time,
            id=self.id,
            last_updated_time=self.last_updated_time,
            name=self.name,
            permissions=self.permissions,
            status=self.status,
            tags=self.tags,
            theme_id=self.theme_id,
            version_description=self.version_description,
            version_number=self.version_number)


def get_theme(aws_account_id: Optional[str] = None,
              tags: Optional[Mapping[str, str]] = None,
              theme_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetThemeResult:
    """
    Data source for managing an AWS QuickSight Theme.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.quicksight.get_theme(theme_id="example")
    ```


    :param str aws_account_id: AWS account ID.
    :param Mapping[str, str] tags: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
    :param str theme_id: Identifier of the theme.
           
           The following arguments are optional:
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['tags'] = tags
    __args__['themeId'] = theme_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:quicksight/getTheme:getTheme', __args__, opts=opts, typ=GetThemeResult).value

    return AwaitableGetThemeResult(
        arn=pulumi.get(__ret__, 'arn'),
        aws_account_id=pulumi.get(__ret__, 'aws_account_id'),
        base_theme_id=pulumi.get(__ret__, 'base_theme_id'),
        configurations=pulumi.get(__ret__, 'configurations'),
        created_time=pulumi.get(__ret__, 'created_time'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_time=pulumi.get(__ret__, 'last_updated_time'),
        name=pulumi.get(__ret__, 'name'),
        permissions=pulumi.get(__ret__, 'permissions'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        theme_id=pulumi.get(__ret__, 'theme_id'),
        version_description=pulumi.get(__ret__, 'version_description'),
        version_number=pulumi.get(__ret__, 'version_number'))
def get_theme_output(aws_account_id: Optional[pulumi.Input[Optional[str]]] = None,
                     tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                     theme_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetThemeResult]:
    """
    Data source for managing an AWS QuickSight Theme.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.quicksight.get_theme(theme_id="example")
    ```


    :param str aws_account_id: AWS account ID.
    :param Mapping[str, str] tags: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
    :param str theme_id: Identifier of the theme.
           
           The following arguments are optional:
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['tags'] = tags
    __args__['themeId'] = theme_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:quicksight/getTheme:getTheme', __args__, opts=opts, typ=GetThemeResult)
    return __ret__.apply(lambda __response__: GetThemeResult(
        arn=pulumi.get(__response__, 'arn'),
        aws_account_id=pulumi.get(__response__, 'aws_account_id'),
        base_theme_id=pulumi.get(__response__, 'base_theme_id'),
        configurations=pulumi.get(__response__, 'configurations'),
        created_time=pulumi.get(__response__, 'created_time'),
        id=pulumi.get(__response__, 'id'),
        last_updated_time=pulumi.get(__response__, 'last_updated_time'),
        name=pulumi.get(__response__, 'name'),
        permissions=pulumi.get(__response__, 'permissions'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        theme_id=pulumi.get(__response__, 'theme_id'),
        version_description=pulumi.get(__response__, 'version_description'),
        version_number=pulumi.get(__response__, 'version_number')))
