# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 retention_period: pulumi.Input['RuleRetentionPeriodArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 lock_configuration: Optional[pulumi.Input['RuleLockConfigurationArgs']] = None,
                 resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input[str] resource_type: The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
        :param pulumi.Input['RuleRetentionPeriodArgs'] retention_period: Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.
               
               The following arguments are optional:
        :param pulumi.Input[str] description: The retention rule description.
        :param pulumi.Input['RuleLockConfigurationArgs'] lock_configuration: Information about the retention rule lock configuration. See `lock_configuration` below.
        :param pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]] resource_tags: Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
        """
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "retention_period", retention_period)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if lock_configuration is not None:
            pulumi.set(__self__, "lock_configuration", lock_configuration)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> pulumi.Input['RuleRetentionPeriodArgs']:
        """
        Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: pulumi.Input['RuleRetentionPeriodArgs']):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The retention rule description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="lockConfiguration")
    def lock_configuration(self) -> Optional[pulumi.Input['RuleLockConfigurationArgs']]:
        """
        Information about the retention rule lock configuration. See `lock_configuration` below.
        """
        return pulumi.get(self, "lock_configuration")

    @lock_configuration.setter
    def lock_configuration(self, value: Optional[pulumi.Input['RuleLockConfigurationArgs']]):
        pulumi.set(self, "lock_configuration", value)

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]]]:
        """
        Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]]]):
        pulumi.set(self, "resource_tags", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RuleState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 lock_configuration: Optional[pulumi.Input['RuleLockConfigurationArgs']] = None,
                 lock_end_time: Optional[pulumi.Input[str]] = None,
                 lock_state: Optional[pulumi.Input[str]] = None,
                 resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input['RuleRetentionPeriodArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Rule resources.
        :param pulumi.Input[str] description: The retention rule description.
        :param pulumi.Input['RuleLockConfigurationArgs'] lock_configuration: Information about the retention rule lock configuration. See `lock_configuration` below.
        :param pulumi.Input[str] lock_end_time: (Timestamp) The date and time at which the unlock delay is set to expire. Only returned for retention rules that have been unlocked and that are still within the unlock delay period.
        :param pulumi.Input[str] lock_state: (Optional) The lock state of the retention rules to list. Only retention rules with the specified lock state are returned. Valid values are `locked`, `pending_unlock`, `unlocked`.
        :param pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]] resource_tags: Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
        :param pulumi.Input[str] resource_type: The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
        :param pulumi.Input['RuleRetentionPeriodArgs'] retention_period: Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.
               
               The following arguments are optional:
        :param pulumi.Input[str] status: (String) The state of the retention rule. Only retention rules that are in the `available` state retain resources. Valid values include `pending` and `available`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if lock_configuration is not None:
            pulumi.set(__self__, "lock_configuration", lock_configuration)
        if lock_end_time is not None:
            pulumi.set(__self__, "lock_end_time", lock_end_time)
        if lock_state is not None:
            pulumi.set(__self__, "lock_state", lock_state)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The retention rule description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="lockConfiguration")
    def lock_configuration(self) -> Optional[pulumi.Input['RuleLockConfigurationArgs']]:
        """
        Information about the retention rule lock configuration. See `lock_configuration` below.
        """
        return pulumi.get(self, "lock_configuration")

    @lock_configuration.setter
    def lock_configuration(self, value: Optional[pulumi.Input['RuleLockConfigurationArgs']]):
        pulumi.set(self, "lock_configuration", value)

    @property
    @pulumi.getter(name="lockEndTime")
    def lock_end_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Timestamp) The date and time at which the unlock delay is set to expire. Only returned for retention rules that have been unlocked and that are still within the unlock delay period.
        """
        return pulumi.get(self, "lock_end_time")

    @lock_end_time.setter
    def lock_end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lock_end_time", value)

    @property
    @pulumi.getter(name="lockState")
    def lock_state(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) The lock state of the retention rules to list. Only retention rules with the specified lock state are returned. Valid values are `locked`, `pending_unlock`, `unlocked`.
        """
        return pulumi.get(self, "lock_state")

    @lock_state.setter
    def lock_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lock_state", value)

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]]]:
        """
        Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]]]):
        pulumi.set(self, "resource_tags", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input['RuleRetentionPeriodArgs']]:
        """
        Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input['RuleRetentionPeriodArgs']]):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (String) The state of the retention rule. Only retention rules that are in the `available` state retain resources. Valid values include `pending` and `available`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 lock_configuration: Optional[pulumi.Input[Union['RuleLockConfigurationArgs', 'RuleLockConfigurationArgsDict']]] = None,
                 resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleResourceTagArgs', 'RuleResourceTagArgsDict']]]]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input[Union['RuleRetentionPeriodArgs', 'RuleRetentionPeriodArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS RBin Rule.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rbin.Rule("example",
            description="example_rule",
            resource_type="EBS_SNAPSHOT",
            resource_tags=[{
                "resource_tag_key": "tag_key",
                "resource_tag_value": "tag_value",
            }],
            retention_period={
                "retention_period_value": 10,
                "retention_period_unit": "DAYS",
            },
            tags={
                "test_tag_key": "test_tag_value",
            })
        ```

        ## Import

        Using `pulumi import`, import RBin Rule using the `id`. For example:

        ```sh
        $ pulumi import aws:rbin/rule:Rule example examplerule
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The retention rule description.
        :param pulumi.Input[Union['RuleLockConfigurationArgs', 'RuleLockConfigurationArgsDict']] lock_configuration: Information about the retention rule lock configuration. See `lock_configuration` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleResourceTagArgs', 'RuleResourceTagArgsDict']]]] resource_tags: Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
        :param pulumi.Input[str] resource_type: The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
        :param pulumi.Input[Union['RuleRetentionPeriodArgs', 'RuleRetentionPeriodArgsDict']] retention_period: Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS RBin Rule.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rbin.Rule("example",
            description="example_rule",
            resource_type="EBS_SNAPSHOT",
            resource_tags=[{
                "resource_tag_key": "tag_key",
                "resource_tag_value": "tag_value",
            }],
            retention_period={
                "retention_period_value": 10,
                "retention_period_unit": "DAYS",
            },
            tags={
                "test_tag_key": "test_tag_value",
            })
        ```

        ## Import

        Using `pulumi import`, import RBin Rule using the `id`. For example:

        ```sh
        $ pulumi import aws:rbin/rule:Rule example examplerule
        ```

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 lock_configuration: Optional[pulumi.Input[Union['RuleLockConfigurationArgs', 'RuleLockConfigurationArgsDict']]] = None,
                 resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleResourceTagArgs', 'RuleResourceTagArgsDict']]]]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input[Union['RuleRetentionPeriodArgs', 'RuleRetentionPeriodArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["lock_configuration"] = lock_configuration
            __props__.__dict__["resource_tags"] = resource_tags
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            if retention_period is None and not opts.urn:
                raise TypeError("Missing required property 'retention_period'")
            __props__.__dict__["retention_period"] = retention_period
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["lock_end_time"] = None
            __props__.__dict__["lock_state"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(Rule, __self__).__init__(
            'aws:rbin/rule:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            lock_configuration: Optional[pulumi.Input[Union['RuleLockConfigurationArgs', 'RuleLockConfigurationArgsDict']]] = None,
            lock_end_time: Optional[pulumi.Input[str]] = None,
            lock_state: Optional[pulumi.Input[str]] = None,
            resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleResourceTagArgs', 'RuleResourceTagArgsDict']]]]] = None,
            resource_type: Optional[pulumi.Input[str]] = None,
            retention_period: Optional[pulumi.Input[Union['RuleRetentionPeriodArgs', 'RuleRetentionPeriodArgsDict']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The retention rule description.
        :param pulumi.Input[Union['RuleLockConfigurationArgs', 'RuleLockConfigurationArgsDict']] lock_configuration: Information about the retention rule lock configuration. See `lock_configuration` below.
        :param pulumi.Input[str] lock_end_time: (Timestamp) The date and time at which the unlock delay is set to expire. Only returned for retention rules that have been unlocked and that are still within the unlock delay period.
        :param pulumi.Input[str] lock_state: (Optional) The lock state of the retention rules to list. Only retention rules with the specified lock state are returned. Valid values are `locked`, `pending_unlock`, `unlocked`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleResourceTagArgs', 'RuleResourceTagArgsDict']]]] resource_tags: Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
        :param pulumi.Input[str] resource_type: The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
        :param pulumi.Input[Union['RuleRetentionPeriodArgs', 'RuleRetentionPeriodArgsDict']] retention_period: Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.
               
               The following arguments are optional:
        :param pulumi.Input[str] status: (String) The state of the retention rule. Only retention rules that are in the `available` state retain resources. Valid values include `pending` and `available`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleState.__new__(_RuleState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["lock_configuration"] = lock_configuration
        __props__.__dict__["lock_end_time"] = lock_end_time
        __props__.__dict__["lock_state"] = lock_state
        __props__.__dict__["resource_tags"] = resource_tags
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["retention_period"] = retention_period
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Rule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The retention rule description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="lockConfiguration")
    def lock_configuration(self) -> pulumi.Output[Optional['outputs.RuleLockConfiguration']]:
        """
        Information about the retention rule lock configuration. See `lock_configuration` below.
        """
        return pulumi.get(self, "lock_configuration")

    @property
    @pulumi.getter(name="lockEndTime")
    def lock_end_time(self) -> pulumi.Output[str]:
        """
        (Timestamp) The date and time at which the unlock delay is set to expire. Only returned for retention rules that have been unlocked and that are still within the unlock delay period.
        """
        return pulumi.get(self, "lock_end_time")

    @property
    @pulumi.getter(name="lockState")
    def lock_state(self) -> pulumi.Output[str]:
        """
        (Optional) The lock state of the retention rules to list. Only retention rules with the specified lock state are returned. Valid values are `locked`, `pending_unlock`, `unlocked`.
        """
        return pulumi.get(self, "lock_state")

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> pulumi.Output[Sequence['outputs.RuleResourceTag']]:
        """
        Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
        """
        return pulumi.get(self, "resource_tags")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[str]:
        """
        The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> pulumi.Output['outputs.RuleRetentionPeriod']:
        """
        Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.

        The following arguments are optional:
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        (String) The state of the retention rule. Only retention rules that are in the `available` state retain resources. Valid values include `pending` and `available`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags_all")

