# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterClusterNodeArgs',
    'ClusterClusterNodeArgsDict',
    'ClusterLoggingArgs',
    'ClusterLoggingArgsDict',
    'ClusterSnapshotCopyArgs',
    'ClusterSnapshotCopyArgsDict',
    'EndpointAccessVpcEndpointArgs',
    'EndpointAccessVpcEndpointArgsDict',
    'EndpointAccessVpcEndpointNetworkInterfaceArgs',
    'EndpointAccessVpcEndpointNetworkInterfaceArgsDict',
    'ParameterGroupParameterArgs',
    'ParameterGroupParameterArgsDict',
    'ScheduledActionTargetActionArgs',
    'ScheduledActionTargetActionArgsDict',
    'ScheduledActionTargetActionPauseClusterArgs',
    'ScheduledActionTargetActionPauseClusterArgsDict',
    'ScheduledActionTargetActionResizeClusterArgs',
    'ScheduledActionTargetActionResizeClusterArgsDict',
    'ScheduledActionTargetActionResumeClusterArgs',
    'ScheduledActionTargetActionResumeClusterArgsDict',
    'GetDataSharesDataShareArgs',
    'GetDataSharesDataShareArgsDict',
    'GetProducerDataSharesDataShareArgs',
    'GetProducerDataSharesDataShareArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterClusterNodeArgsDict(TypedDict):
        node_role: NotRequired[pulumi.Input[str]]
        """
        Whether the node is a leader node or a compute node
        """
        private_ip_address: NotRequired[pulumi.Input[str]]
        """
        The private IP address of a node within a cluster
        """
        public_ip_address: NotRequired[pulumi.Input[str]]
        """
        The public IP address of a node within a cluster
        """
elif False:
    ClusterClusterNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterClusterNodeArgs:
    def __init__(__self__, *,
                 node_role: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 public_ip_address: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] node_role: Whether the node is a leader node or a compute node
        :param pulumi.Input[str] private_ip_address: The private IP address of a node within a cluster
        :param pulumi.Input[str] public_ip_address: The public IP address of a node within a cluster
        """
        if node_role is not None:
            pulumi.set(__self__, "node_role", node_role)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)

    @property
    @pulumi.getter(name="nodeRole")
    def node_role(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the node is a leader node or a compute node
        """
        return pulumi.get(self, "node_role")

    @node_role.setter
    def node_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_role", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address of a node within a cluster
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The public IP address of a node within a cluster
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address", value)


if not MYPY:
    class ClusterLoggingArgsDict(TypedDict):
        enable: pulumi.Input[bool]
        """
        Enables logging information such as queries and connection attempts, for the specified Amazon Redshift cluster.
        """
        bucket_name: NotRequired[pulumi.Input[str]]
        """
        The name of an existing S3 bucket where the log files are to be stored. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions.
        For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
        """
        log_destination_type: NotRequired[pulumi.Input[str]]
        """
        The log destination type. An enum with possible values of `s3` and `cloudwatch`.
        """
        log_exports: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The collection of exported log types. Log types include the connection log, user log and user activity log. Required when `log_destination_type` is `cloudwatch`. Valid log types are `connectionlog`, `userlog`, and `useractivitylog`.
        """
        s3_key_prefix: NotRequired[pulumi.Input[str]]
        """
        The prefix applied to the log file names.
        """
elif False:
    ClusterLoggingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterLoggingArgs:
    def __init__(__self__, *,
                 enable: pulumi.Input[bool],
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 log_destination_type: Optional[pulumi.Input[str]] = None,
                 log_exports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 s3_key_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enable: Enables logging information such as queries and connection attempts, for the specified Amazon Redshift cluster.
        :param pulumi.Input[str] bucket_name: The name of an existing S3 bucket where the log files are to be stored. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions.
               For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
        :param pulumi.Input[str] log_destination_type: The log destination type. An enum with possible values of `s3` and `cloudwatch`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] log_exports: The collection of exported log types. Log types include the connection log, user log and user activity log. Required when `log_destination_type` is `cloudwatch`. Valid log types are `connectionlog`, `userlog`, and `useractivitylog`.
        :param pulumi.Input[str] s3_key_prefix: The prefix applied to the log file names.
        """
        pulumi.set(__self__, "enable", enable)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if log_destination_type is not None:
            pulumi.set(__self__, "log_destination_type", log_destination_type)
        if log_exports is not None:
            pulumi.set(__self__, "log_exports", log_exports)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Input[bool]:
        """
        Enables logging information such as queries and connection attempts, for the specified Amazon Redshift cluster.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing S3 bucket where the log files are to be stored. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions.
        For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="logDestinationType")
    def log_destination_type(self) -> Optional[pulumi.Input[str]]:
        """
        The log destination type. An enum with possible values of `s3` and `cloudwatch`.
        """
        return pulumi.get(self, "log_destination_type")

    @log_destination_type.setter
    def log_destination_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_destination_type", value)

    @property
    @pulumi.getter(name="logExports")
    def log_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The collection of exported log types. Log types include the connection log, user log and user activity log. Required when `log_destination_type` is `cloudwatch`. Valid log types are `connectionlog`, `userlog`, and `useractivitylog`.
        """
        return pulumi.get(self, "log_exports")

    @log_exports.setter
    def log_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "log_exports", value)

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix applied to the log file names.
        """
        return pulumi.get(self, "s3_key_prefix")

    @s3_key_prefix.setter
    def s3_key_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_key_prefix", value)


if not MYPY:
    class ClusterSnapshotCopyArgsDict(TypedDict):
        destination_region: pulumi.Input[str]
        """
        The destination region that you want to copy snapshots to.
        """
        grant_name: NotRequired[pulumi.Input[str]]
        """
        The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
        """
        retention_period: NotRequired[pulumi.Input[int]]
        """
        The number of days to retain automated snapshots in the destination region after they are copied from the source region. Defaults to `7`.
        """
elif False:
    ClusterSnapshotCopyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterSnapshotCopyArgs:
    def __init__(__self__, *,
                 destination_region: pulumi.Input[str],
                 grant_name: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] destination_region: The destination region that you want to copy snapshots to.
        :param pulumi.Input[str] grant_name: The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
        :param pulumi.Input[int] retention_period: The number of days to retain automated snapshots in the destination region after they are copied from the source region. Defaults to `7`.
        """
        pulumi.set(__self__, "destination_region", destination_region)
        if grant_name is not None:
            pulumi.set(__self__, "grant_name", grant_name)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> pulumi.Input[str]:
        """
        The destination region that you want to copy snapshots to.
        """
        return pulumi.get(self, "destination_region")

    @destination_region.setter
    def destination_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_region", value)

    @property
    @pulumi.getter(name="grantName")
    def grant_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
        """
        return pulumi.get(self, "grant_name")

    @grant_name.setter
    def grant_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grant_name", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days to retain automated snapshots in the destination region after they are copied from the source region. Defaults to `7`.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_period", value)


if not MYPY:
    class EndpointAccessVpcEndpointArgsDict(TypedDict):
        network_interfaces: NotRequired[pulumi.Input[Sequence[pulumi.Input['EndpointAccessVpcEndpointNetworkInterfaceArgsDict']]]]
        """
        One or more network interfaces of the endpoint. Also known as an interface endpoint. See details below.
        """
        vpc_endpoint_id: NotRequired[pulumi.Input[str]]
        """
        The connection endpoint ID for connecting an Amazon Redshift cluster through the proxy.
        """
        vpc_id: NotRequired[pulumi.Input[str]]
        """
        The VPC identifier that the endpoint is associated.
        """
elif False:
    EndpointAccessVpcEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointAccessVpcEndpointArgs:
    def __init__(__self__, *,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointAccessVpcEndpointNetworkInterfaceArgs']]]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['EndpointAccessVpcEndpointNetworkInterfaceArgs']]] network_interfaces: One or more network interfaces of the endpoint. Also known as an interface endpoint. See details below.
        :param pulumi.Input[str] vpc_endpoint_id: The connection endpoint ID for connecting an Amazon Redshift cluster through the proxy.
        :param pulumi.Input[str] vpc_id: The VPC identifier that the endpoint is associated.
        """
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if vpc_endpoint_id is not None:
            pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointAccessVpcEndpointNetworkInterfaceArgs']]]]:
        """
        One or more network interfaces of the endpoint. Also known as an interface endpoint. See details below.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointAccessVpcEndpointNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The connection endpoint ID for connecting an Amazon Redshift cluster through the proxy.
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @vpc_endpoint_id.setter
    def vpc_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_endpoint_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC identifier that the endpoint is associated.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


if not MYPY:
    class EndpointAccessVpcEndpointNetworkInterfaceArgsDict(TypedDict):
        availability_zone: NotRequired[pulumi.Input[str]]
        """
        The Availability Zone.
        """
        network_interface_id: NotRequired[pulumi.Input[str]]
        """
        The network interface identifier.
        """
        private_ip_address: NotRequired[pulumi.Input[str]]
        """
        The IPv4 address of the network interface within the subnet.
        """
        subnet_id: NotRequired[pulumi.Input[str]]
        """
        The subnet identifier.
        """
elif False:
    EndpointAccessVpcEndpointNetworkInterfaceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointAccessVpcEndpointNetworkInterfaceArgs:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 network_interface_id: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] availability_zone: The Availability Zone.
        :param pulumi.Input[str] network_interface_id: The network interface identifier.
        :param pulumi.Input[str] private_ip_address: The IPv4 address of the network interface within the subnet.
        :param pulumi.Input[str] subnet_id: The subnet identifier.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Availability Zone.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[str]]:
        """
        The network interface identifier.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_interface_id", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address of the network interface within the subnet.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet identifier.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


if not MYPY:
    class ParameterGroupParameterArgsDict(TypedDict):
        name: pulumi.Input[str]
        """
        The name of the Redshift parameter.
        """
        value: pulumi.Input[str]
        """
        The value of the Redshift parameter.
        """
elif False:
    ParameterGroupParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ParameterGroupParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The name of the Redshift parameter.
        :param pulumi.Input[str] value: The value of the Redshift parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Redshift parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the Redshift parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ScheduledActionTargetActionArgsDict(TypedDict):
        pause_cluster: NotRequired[pulumi.Input['ScheduledActionTargetActionPauseClusterArgsDict']]
        """
        An action that runs a `PauseCluster` API operation. Documented below.
        """
        resize_cluster: NotRequired[pulumi.Input['ScheduledActionTargetActionResizeClusterArgsDict']]
        """
        An action that runs a `ResizeCluster` API operation. Documented below.
        """
        resume_cluster: NotRequired[pulumi.Input['ScheduledActionTargetActionResumeClusterArgsDict']]
        """
        An action that runs a `ResumeCluster` API operation. Documented below.
        """
elif False:
    ScheduledActionTargetActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledActionTargetActionArgs:
    def __init__(__self__, *,
                 pause_cluster: Optional[pulumi.Input['ScheduledActionTargetActionPauseClusterArgs']] = None,
                 resize_cluster: Optional[pulumi.Input['ScheduledActionTargetActionResizeClusterArgs']] = None,
                 resume_cluster: Optional[pulumi.Input['ScheduledActionTargetActionResumeClusterArgs']] = None):
        """
        :param pulumi.Input['ScheduledActionTargetActionPauseClusterArgs'] pause_cluster: An action that runs a `PauseCluster` API operation. Documented below.
        :param pulumi.Input['ScheduledActionTargetActionResizeClusterArgs'] resize_cluster: An action that runs a `ResizeCluster` API operation. Documented below.
        :param pulumi.Input['ScheduledActionTargetActionResumeClusterArgs'] resume_cluster: An action that runs a `ResumeCluster` API operation. Documented below.
        """
        if pause_cluster is not None:
            pulumi.set(__self__, "pause_cluster", pause_cluster)
        if resize_cluster is not None:
            pulumi.set(__self__, "resize_cluster", resize_cluster)
        if resume_cluster is not None:
            pulumi.set(__self__, "resume_cluster", resume_cluster)

    @property
    @pulumi.getter(name="pauseCluster")
    def pause_cluster(self) -> Optional[pulumi.Input['ScheduledActionTargetActionPauseClusterArgs']]:
        """
        An action that runs a `PauseCluster` API operation. Documented below.
        """
        return pulumi.get(self, "pause_cluster")

    @pause_cluster.setter
    def pause_cluster(self, value: Optional[pulumi.Input['ScheduledActionTargetActionPauseClusterArgs']]):
        pulumi.set(self, "pause_cluster", value)

    @property
    @pulumi.getter(name="resizeCluster")
    def resize_cluster(self) -> Optional[pulumi.Input['ScheduledActionTargetActionResizeClusterArgs']]:
        """
        An action that runs a `ResizeCluster` API operation. Documented below.
        """
        return pulumi.get(self, "resize_cluster")

    @resize_cluster.setter
    def resize_cluster(self, value: Optional[pulumi.Input['ScheduledActionTargetActionResizeClusterArgs']]):
        pulumi.set(self, "resize_cluster", value)

    @property
    @pulumi.getter(name="resumeCluster")
    def resume_cluster(self) -> Optional[pulumi.Input['ScheduledActionTargetActionResumeClusterArgs']]:
        """
        An action that runs a `ResumeCluster` API operation. Documented below.
        """
        return pulumi.get(self, "resume_cluster")

    @resume_cluster.setter
    def resume_cluster(self, value: Optional[pulumi.Input['ScheduledActionTargetActionResumeClusterArgs']]):
        pulumi.set(self, "resume_cluster", value)


if not MYPY:
    class ScheduledActionTargetActionPauseClusterArgsDict(TypedDict):
        cluster_identifier: pulumi.Input[str]
        """
        The identifier of the cluster to be paused.
        """
elif False:
    ScheduledActionTargetActionPauseClusterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledActionTargetActionPauseClusterArgs:
    def __init__(__self__, *,
                 cluster_identifier: pulumi.Input[str]):
        """
        :param pulumi.Input[str] cluster_identifier: The identifier of the cluster to be paused.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Input[str]:
        """
        The identifier of the cluster to be paused.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_identifier", value)


if not MYPY:
    class ScheduledActionTargetActionResizeClusterArgsDict(TypedDict):
        cluster_identifier: pulumi.Input[str]
        """
        The unique identifier for the cluster to resize.
        """
        classic: NotRequired[pulumi.Input[bool]]
        """
        A boolean value indicating whether the resize operation is using the classic resize process. Default: `false`.
        """
        cluster_type: NotRequired[pulumi.Input[str]]
        """
        The new cluster type for the specified cluster.
        """
        node_type: NotRequired[pulumi.Input[str]]
        """
        The new node type for the nodes you are adding.
        """
        number_of_nodes: NotRequired[pulumi.Input[int]]
        """
        The new number of nodes for the cluster.
        """
elif False:
    ScheduledActionTargetActionResizeClusterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledActionTargetActionResizeClusterArgs:
    def __init__(__self__, *,
                 cluster_identifier: pulumi.Input[str],
                 classic: Optional[pulumi.Input[bool]] = None,
                 cluster_type: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 number_of_nodes: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] cluster_identifier: The unique identifier for the cluster to resize.
        :param pulumi.Input[bool] classic: A boolean value indicating whether the resize operation is using the classic resize process. Default: `false`.
        :param pulumi.Input[str] cluster_type: The new cluster type for the specified cluster.
        :param pulumi.Input[str] node_type: The new node type for the nodes you are adding.
        :param pulumi.Input[int] number_of_nodes: The new number of nodes for the cluster.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if classic is not None:
            pulumi.set(__self__, "classic", classic)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if number_of_nodes is not None:
            pulumi.set(__self__, "number_of_nodes", number_of_nodes)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Input[str]:
        """
        The unique identifier for the cluster to resize.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter
    def classic(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value indicating whether the resize operation is using the classic resize process. Default: `false`.
        """
        return pulumi.get(self, "classic")

    @classic.setter
    def classic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "classic", value)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[str]]:
        """
        The new cluster type for the specified cluster.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_type", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[str]]:
        """
        The new node type for the nodes you are adding.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The new number of nodes for the cluster.
        """
        return pulumi.get(self, "number_of_nodes")

    @number_of_nodes.setter
    def number_of_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_nodes", value)


if not MYPY:
    class ScheduledActionTargetActionResumeClusterArgsDict(TypedDict):
        cluster_identifier: pulumi.Input[str]
        """
        The identifier of the cluster to be resumed.
        """
elif False:
    ScheduledActionTargetActionResumeClusterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ScheduledActionTargetActionResumeClusterArgs:
    def __init__(__self__, *,
                 cluster_identifier: pulumi.Input[str]):
        """
        :param pulumi.Input[str] cluster_identifier: The identifier of the cluster to be resumed.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Input[str]:
        """
        The identifier of the cluster to be resumed.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_identifier", value)


if not MYPY:
    class GetDataSharesDataShareArgsDict(TypedDict):
        data_share_arn: str
        """
        ARN (Amazon Resource Name) of the data share.
        """
        managed_by: str
        """
        Identifier of a datashare to show its managing entity.
        """
        producer_arn: str
        """
        ARN (Amazon Resource Name) of the producer.
        """
elif False:
    GetDataSharesDataShareArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDataSharesDataShareArgs:
    def __init__(__self__, *,
                 data_share_arn: str,
                 managed_by: str,
                 producer_arn: str):
        """
        :param str data_share_arn: ARN (Amazon Resource Name) of the data share.
        :param str managed_by: Identifier of a datashare to show its managing entity.
        :param str producer_arn: ARN (Amazon Resource Name) of the producer.
        """
        pulumi.set(__self__, "data_share_arn", data_share_arn)
        pulumi.set(__self__, "managed_by", managed_by)
        pulumi.set(__self__, "producer_arn", producer_arn)

    @property
    @pulumi.getter(name="dataShareArn")
    def data_share_arn(self) -> str:
        """
        ARN (Amazon Resource Name) of the data share.
        """
        return pulumi.get(self, "data_share_arn")

    @data_share_arn.setter
    def data_share_arn(self, value: str):
        pulumi.set(self, "data_share_arn", value)

    @property
    @pulumi.getter(name="managedBy")
    def managed_by(self) -> str:
        """
        Identifier of a datashare to show its managing entity.
        """
        return pulumi.get(self, "managed_by")

    @managed_by.setter
    def managed_by(self, value: str):
        pulumi.set(self, "managed_by", value)

    @property
    @pulumi.getter(name="producerArn")
    def producer_arn(self) -> str:
        """
        ARN (Amazon Resource Name) of the producer.
        """
        return pulumi.get(self, "producer_arn")

    @producer_arn.setter
    def producer_arn(self, value: str):
        pulumi.set(self, "producer_arn", value)


if not MYPY:
    class GetProducerDataSharesDataShareArgsDict(TypedDict):
        data_share_arn: str
        """
        ARN (Amazon Resource Name) of the data share.
        """
        managed_by: str
        """
        Identifier of a datashare to show its managing entity.
        """
        producer_arn: str
        """
        Amazon Resource Name (ARN) of the producer namespace that returns in the list of datashares.

        The following arguments are optional:
        """
elif False:
    GetProducerDataSharesDataShareArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetProducerDataSharesDataShareArgs:
    def __init__(__self__, *,
                 data_share_arn: str,
                 managed_by: str,
                 producer_arn: str):
        """
        :param str data_share_arn: ARN (Amazon Resource Name) of the data share.
        :param str managed_by: Identifier of a datashare to show its managing entity.
        :param str producer_arn: Amazon Resource Name (ARN) of the producer namespace that returns in the list of datashares.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "data_share_arn", data_share_arn)
        pulumi.set(__self__, "managed_by", managed_by)
        pulumi.set(__self__, "producer_arn", producer_arn)

    @property
    @pulumi.getter(name="dataShareArn")
    def data_share_arn(self) -> str:
        """
        ARN (Amazon Resource Name) of the data share.
        """
        return pulumi.get(self, "data_share_arn")

    @data_share_arn.setter
    def data_share_arn(self, value: str):
        pulumi.set(self, "data_share_arn", value)

    @property
    @pulumi.getter(name="managedBy")
    def managed_by(self) -> str:
        """
        Identifier of a datashare to show its managing entity.
        """
        return pulumi.get(self, "managed_by")

    @managed_by.setter
    def managed_by(self, value: str):
        pulumi.set(self, "managed_by", value)

    @property
    @pulumi.getter(name="producerArn")
    def producer_arn(self) -> str:
        """
        Amazon Resource Name (ARN) of the producer namespace that returns in the list of datashares.

        The following arguments are optional:
        """
        return pulumi.get(self, "producer_arn")

    @producer_arn.setter
    def producer_arn(self, value: str):
        pulumi.set(self, "producer_arn", value)


