# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DataShareConsumerAssociationArgs', 'DataShareConsumerAssociation']

@pulumi.input_type
class DataShareConsumerAssociationArgs:
    def __init__(__self__, *,
                 data_share_arn: pulumi.Input[str],
                 allow_writes: Optional[pulumi.Input[bool]] = None,
                 associate_entire_account: Optional[pulumi.Input[bool]] = None,
                 consumer_arn: Optional[pulumi.Input[str]] = None,
                 consumer_region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DataShareConsumerAssociation resource.
        :param pulumi.Input[str] data_share_arn: Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.
               
               The following arguments are optional:
        :param pulumi.Input[bool] allow_writes: Whether to allow write operations for a datashare.
        :param pulumi.Input[bool] associate_entire_account: Whether the datashare is associated with the entire account. Conflicts with `consumer_arn` and `consumer_region`.
        :param pulumi.Input[str] consumer_arn: Amazon Resource Name (ARN) of the consumer that is associated with the datashare. Conflicts with `associate_entire_account` and `consumer_region`.
        :param pulumi.Input[str] consumer_region: From a datashare consumer account, associates a datashare with all existing and future namespaces in the specified AWS Region. Conflicts with `associate_entire_account` and `consumer_arn`.
        """
        pulumi.set(__self__, "data_share_arn", data_share_arn)
        if allow_writes is not None:
            pulumi.set(__self__, "allow_writes", allow_writes)
        if associate_entire_account is not None:
            pulumi.set(__self__, "associate_entire_account", associate_entire_account)
        if consumer_arn is not None:
            pulumi.set(__self__, "consumer_arn", consumer_arn)
        if consumer_region is not None:
            pulumi.set(__self__, "consumer_region", consumer_region)

    @property
    @pulumi.getter(name="dataShareArn")
    def data_share_arn(self) -> pulumi.Input[str]:
        """
        Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.

        The following arguments are optional:
        """
        return pulumi.get(self, "data_share_arn")

    @data_share_arn.setter
    def data_share_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_share_arn", value)

    @property
    @pulumi.getter(name="allowWrites")
    def allow_writes(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow write operations for a datashare.
        """
        return pulumi.get(self, "allow_writes")

    @allow_writes.setter
    def allow_writes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_writes", value)

    @property
    @pulumi.getter(name="associateEntireAccount")
    def associate_entire_account(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the datashare is associated with the entire account. Conflicts with `consumer_arn` and `consumer_region`.
        """
        return pulumi.get(self, "associate_entire_account")

    @associate_entire_account.setter
    def associate_entire_account(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "associate_entire_account", value)

    @property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the consumer that is associated with the datashare. Conflicts with `associate_entire_account` and `consumer_region`.
        """
        return pulumi.get(self, "consumer_arn")

    @consumer_arn.setter
    def consumer_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_arn", value)

    @property
    @pulumi.getter(name="consumerRegion")
    def consumer_region(self) -> Optional[pulumi.Input[str]]:
        """
        From a datashare consumer account, associates a datashare with all existing and future namespaces in the specified AWS Region. Conflicts with `associate_entire_account` and `consumer_arn`.
        """
        return pulumi.get(self, "consumer_region")

    @consumer_region.setter
    def consumer_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_region", value)


@pulumi.input_type
class _DataShareConsumerAssociationState:
    def __init__(__self__, *,
                 allow_writes: Optional[pulumi.Input[bool]] = None,
                 associate_entire_account: Optional[pulumi.Input[bool]] = None,
                 consumer_arn: Optional[pulumi.Input[str]] = None,
                 consumer_region: Optional[pulumi.Input[str]] = None,
                 data_share_arn: Optional[pulumi.Input[str]] = None,
                 managed_by: Optional[pulumi.Input[str]] = None,
                 producer_arn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DataShareConsumerAssociation resources.
        :param pulumi.Input[bool] allow_writes: Whether to allow write operations for a datashare.
        :param pulumi.Input[bool] associate_entire_account: Whether the datashare is associated with the entire account. Conflicts with `consumer_arn` and `consumer_region`.
        :param pulumi.Input[str] consumer_arn: Amazon Resource Name (ARN) of the consumer that is associated with the datashare. Conflicts with `associate_entire_account` and `consumer_region`.
        :param pulumi.Input[str] consumer_region: From a datashare consumer account, associates a datashare with all existing and future namespaces in the specified AWS Region. Conflicts with `associate_entire_account` and `consumer_arn`.
        :param pulumi.Input[str] data_share_arn: Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.
               
               The following arguments are optional:
        :param pulumi.Input[str] managed_by: Identifier of a datashare to show its managing entity.
        :param pulumi.Input[str] producer_arn: Amazon Resource Name (ARN) of the producer.
        """
        if allow_writes is not None:
            pulumi.set(__self__, "allow_writes", allow_writes)
        if associate_entire_account is not None:
            pulumi.set(__self__, "associate_entire_account", associate_entire_account)
        if consumer_arn is not None:
            pulumi.set(__self__, "consumer_arn", consumer_arn)
        if consumer_region is not None:
            pulumi.set(__self__, "consumer_region", consumer_region)
        if data_share_arn is not None:
            pulumi.set(__self__, "data_share_arn", data_share_arn)
        if managed_by is not None:
            pulumi.set(__self__, "managed_by", managed_by)
        if producer_arn is not None:
            pulumi.set(__self__, "producer_arn", producer_arn)

    @property
    @pulumi.getter(name="allowWrites")
    def allow_writes(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow write operations for a datashare.
        """
        return pulumi.get(self, "allow_writes")

    @allow_writes.setter
    def allow_writes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_writes", value)

    @property
    @pulumi.getter(name="associateEntireAccount")
    def associate_entire_account(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the datashare is associated with the entire account. Conflicts with `consumer_arn` and `consumer_region`.
        """
        return pulumi.get(self, "associate_entire_account")

    @associate_entire_account.setter
    def associate_entire_account(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "associate_entire_account", value)

    @property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the consumer that is associated with the datashare. Conflicts with `associate_entire_account` and `consumer_region`.
        """
        return pulumi.get(self, "consumer_arn")

    @consumer_arn.setter
    def consumer_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_arn", value)

    @property
    @pulumi.getter(name="consumerRegion")
    def consumer_region(self) -> Optional[pulumi.Input[str]]:
        """
        From a datashare consumer account, associates a datashare with all existing and future namespaces in the specified AWS Region. Conflicts with `associate_entire_account` and `consumer_arn`.
        """
        return pulumi.get(self, "consumer_region")

    @consumer_region.setter
    def consumer_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_region", value)

    @property
    @pulumi.getter(name="dataShareArn")
    def data_share_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.

        The following arguments are optional:
        """
        return pulumi.get(self, "data_share_arn")

    @data_share_arn.setter
    def data_share_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_share_arn", value)

    @property
    @pulumi.getter(name="managedBy")
    def managed_by(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of a datashare to show its managing entity.
        """
        return pulumi.get(self, "managed_by")

    @managed_by.setter
    def managed_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_by", value)

    @property
    @pulumi.getter(name="producerArn")
    def producer_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the producer.
        """
        return pulumi.get(self, "producer_arn")

    @producer_arn.setter
    def producer_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "producer_arn", value)


class DataShareConsumerAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_writes: Optional[pulumi.Input[bool]] = None,
                 associate_entire_account: Optional[pulumi.Input[bool]] = None,
                 consumer_arn: Optional[pulumi.Input[str]] = None,
                 consumer_region: Optional[pulumi.Input[str]] = None,
                 data_share_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Redshift Data Share Consumer Association.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshift.DataShareConsumerAssociation("example",
            data_share_arn="arn:aws:redshift:us-west-2:123456789012:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example",
            associate_entire_account=True)
        ```

        ### Consumer Region

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshift.DataShareConsumerAssociation("example",
            data_share_arn="arn:aws:redshift:us-west-2:123456789012:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example",
            consumer_region="us-west-2")
        ```

        ## Import

        Using `pulumi import`, import Redshift Data Share Consumer Association using the `id`. For example:

        ```sh
        $ pulumi import aws:redshift/dataShareConsumerAssociation:DataShareConsumerAssociation example arn:aws:redshift:us-west-2:123456789012:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example,,,us-west-2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_writes: Whether to allow write operations for a datashare.
        :param pulumi.Input[bool] associate_entire_account: Whether the datashare is associated with the entire account. Conflicts with `consumer_arn` and `consumer_region`.
        :param pulumi.Input[str] consumer_arn: Amazon Resource Name (ARN) of the consumer that is associated with the datashare. Conflicts with `associate_entire_account` and `consumer_region`.
        :param pulumi.Input[str] consumer_region: From a datashare consumer account, associates a datashare with all existing and future namespaces in the specified AWS Region. Conflicts with `associate_entire_account` and `consumer_arn`.
        :param pulumi.Input[str] data_share_arn: Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataShareConsumerAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Redshift Data Share Consumer Association.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshift.DataShareConsumerAssociation("example",
            data_share_arn="arn:aws:redshift:us-west-2:123456789012:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example",
            associate_entire_account=True)
        ```

        ### Consumer Region

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshift.DataShareConsumerAssociation("example",
            data_share_arn="arn:aws:redshift:us-west-2:123456789012:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example",
            consumer_region="us-west-2")
        ```

        ## Import

        Using `pulumi import`, import Redshift Data Share Consumer Association using the `id`. For example:

        ```sh
        $ pulumi import aws:redshift/dataShareConsumerAssociation:DataShareConsumerAssociation example arn:aws:redshift:us-west-2:123456789012:datashare:b3bfde75-73fd-408b-9086-d6fccfd6d588/example,,,us-west-2
        ```

        :param str resource_name: The name of the resource.
        :param DataShareConsumerAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataShareConsumerAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_writes: Optional[pulumi.Input[bool]] = None,
                 associate_entire_account: Optional[pulumi.Input[bool]] = None,
                 consumer_arn: Optional[pulumi.Input[str]] = None,
                 consumer_region: Optional[pulumi.Input[str]] = None,
                 data_share_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataShareConsumerAssociationArgs.__new__(DataShareConsumerAssociationArgs)

            __props__.__dict__["allow_writes"] = allow_writes
            __props__.__dict__["associate_entire_account"] = associate_entire_account
            __props__.__dict__["consumer_arn"] = consumer_arn
            __props__.__dict__["consumer_region"] = consumer_region
            if data_share_arn is None and not opts.urn:
                raise TypeError("Missing required property 'data_share_arn'")
            __props__.__dict__["data_share_arn"] = data_share_arn
            __props__.__dict__["managed_by"] = None
            __props__.__dict__["producer_arn"] = None
        super(DataShareConsumerAssociation, __self__).__init__(
            'aws:redshift/dataShareConsumerAssociation:DataShareConsumerAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_writes: Optional[pulumi.Input[bool]] = None,
            associate_entire_account: Optional[pulumi.Input[bool]] = None,
            consumer_arn: Optional[pulumi.Input[str]] = None,
            consumer_region: Optional[pulumi.Input[str]] = None,
            data_share_arn: Optional[pulumi.Input[str]] = None,
            managed_by: Optional[pulumi.Input[str]] = None,
            producer_arn: Optional[pulumi.Input[str]] = None) -> 'DataShareConsumerAssociation':
        """
        Get an existing DataShareConsumerAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_writes: Whether to allow write operations for a datashare.
        :param pulumi.Input[bool] associate_entire_account: Whether the datashare is associated with the entire account. Conflicts with `consumer_arn` and `consumer_region`.
        :param pulumi.Input[str] consumer_arn: Amazon Resource Name (ARN) of the consumer that is associated with the datashare. Conflicts with `associate_entire_account` and `consumer_region`.
        :param pulumi.Input[str] consumer_region: From a datashare consumer account, associates a datashare with all existing and future namespaces in the specified AWS Region. Conflicts with `associate_entire_account` and `consumer_arn`.
        :param pulumi.Input[str] data_share_arn: Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.
               
               The following arguments are optional:
        :param pulumi.Input[str] managed_by: Identifier of a datashare to show its managing entity.
        :param pulumi.Input[str] producer_arn: Amazon Resource Name (ARN) of the producer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataShareConsumerAssociationState.__new__(_DataShareConsumerAssociationState)

        __props__.__dict__["allow_writes"] = allow_writes
        __props__.__dict__["associate_entire_account"] = associate_entire_account
        __props__.__dict__["consumer_arn"] = consumer_arn
        __props__.__dict__["consumer_region"] = consumer_region
        __props__.__dict__["data_share_arn"] = data_share_arn
        __props__.__dict__["managed_by"] = managed_by
        __props__.__dict__["producer_arn"] = producer_arn
        return DataShareConsumerAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowWrites")
    def allow_writes(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to allow write operations for a datashare.
        """
        return pulumi.get(self, "allow_writes")

    @property
    @pulumi.getter(name="associateEntireAccount")
    def associate_entire_account(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the datashare is associated with the entire account. Conflicts with `consumer_arn` and `consumer_region`.
        """
        return pulumi.get(self, "associate_entire_account")

    @property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> pulumi.Output[Optional[str]]:
        """
        Amazon Resource Name (ARN) of the consumer that is associated with the datashare. Conflicts with `associate_entire_account` and `consumer_region`.
        """
        return pulumi.get(self, "consumer_arn")

    @property
    @pulumi.getter(name="consumerRegion")
    def consumer_region(self) -> pulumi.Output[Optional[str]]:
        """
        From a datashare consumer account, associates a datashare with all existing and future namespaces in the specified AWS Region. Conflicts with `associate_entire_account` and `consumer_arn`.
        """
        return pulumi.get(self, "consumer_region")

    @property
    @pulumi.getter(name="dataShareArn")
    def data_share_arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.

        The following arguments are optional:
        """
        return pulumi.get(self, "data_share_arn")

    @property
    @pulumi.getter(name="managedBy")
    def managed_by(self) -> pulumi.Output[str]:
        """
        Identifier of a datashare to show its managing entity.
        """
        return pulumi.get(self, "managed_by")

    @property
    @pulumi.getter(name="producerArn")
    def producer_arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the producer.
        """
        return pulumi.get(self, "producer_arn")

