# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCredentialsResult',
    'AwaitableGetCredentialsResult',
    'get_credentials',
    'get_credentials_output',
]

@pulumi.output_type
class GetCredentialsResult:
    """
    A collection of values returned by getCredentials.
    """
    def __init__(__self__, db_name=None, db_password=None, db_user=None, duration_seconds=None, expiration=None, id=None, workgroup_name=None):
        if db_name and not isinstance(db_name, str):
            raise TypeError("Expected argument 'db_name' to be a str")
        pulumi.set(__self__, "db_name", db_name)
        if db_password and not isinstance(db_password, str):
            raise TypeError("Expected argument 'db_password' to be a str")
        pulumi.set(__self__, "db_password", db_password)
        if db_user and not isinstance(db_user, str):
            raise TypeError("Expected argument 'db_user' to be a str")
        pulumi.set(__self__, "db_user", db_user)
        if duration_seconds and not isinstance(duration_seconds, int):
            raise TypeError("Expected argument 'duration_seconds' to be a int")
        pulumi.set(__self__, "duration_seconds", duration_seconds)
        if expiration and not isinstance(expiration, str):
            raise TypeError("Expected argument 'expiration' to be a str")
        pulumi.set(__self__, "expiration", expiration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if workgroup_name and not isinstance(workgroup_name, str):
            raise TypeError("Expected argument 'workgroup_name' to be a str")
        pulumi.set(__self__, "workgroup_name", workgroup_name)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[str]:
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> str:
        """
        Temporary password that authorizes the user name returned by `db_user` to log on to the database `db_name`.
        """
        return pulumi.get(self, "db_password")

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> str:
        """
        A database user name that is authorized to log on to the database `db_name` using the password `db_password` . If the specified `db_user` exists in the database, the new user name has the same database privileges as the user named in `db_user` . By default, the user is added to PUBLIC. the user doesn't exist in the database.
        """
        return pulumi.get(self, "db_user")

    @property
    @pulumi.getter(name="durationSeconds")
    def duration_seconds(self) -> Optional[int]:
        return pulumi.get(self, "duration_seconds")

    @property
    @pulumi.getter
    def expiration(self) -> str:
        """
        Date and time the password in `db_password` expires.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> str:
        return pulumi.get(self, "workgroup_name")


class AwaitableGetCredentialsResult(GetCredentialsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCredentialsResult(
            db_name=self.db_name,
            db_password=self.db_password,
            db_user=self.db_user,
            duration_seconds=self.duration_seconds,
            expiration=self.expiration,
            id=self.id,
            workgroup_name=self.workgroup_name)


def get_credentials(db_name: Optional[str] = None,
                    duration_seconds: Optional[int] = None,
                    workgroup_name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCredentialsResult:
    """
    Provides redshift serverless temporary credentials for a workgroup.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.redshiftserverless.get_credentials(workgroup_name=example_aws_redshiftserverless_workgroup["workgroupName"])
    ```


    :param str db_name: The name of the database to get temporary authorization to log on to.
    :param int duration_seconds: The number of seconds until the returned temporary password expires. The minimum is 900 seconds, and the maximum is 3600 seconds.
    :param str workgroup_name: The name of the workgroup associated with the database.
    """
    __args__ = dict()
    __args__['dbName'] = db_name
    __args__['durationSeconds'] = duration_seconds
    __args__['workgroupName'] = workgroup_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:redshiftserverless/getCredentials:getCredentials', __args__, opts=opts, typ=GetCredentialsResult).value

    return AwaitableGetCredentialsResult(
        db_name=pulumi.get(__ret__, 'db_name'),
        db_password=pulumi.get(__ret__, 'db_password'),
        db_user=pulumi.get(__ret__, 'db_user'),
        duration_seconds=pulumi.get(__ret__, 'duration_seconds'),
        expiration=pulumi.get(__ret__, 'expiration'),
        id=pulumi.get(__ret__, 'id'),
        workgroup_name=pulumi.get(__ret__, 'workgroup_name'))
def get_credentials_output(db_name: Optional[pulumi.Input[Optional[str]]] = None,
                           duration_seconds: Optional[pulumi.Input[Optional[int]]] = None,
                           workgroup_name: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCredentialsResult]:
    """
    Provides redshift serverless temporary credentials for a workgroup.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.redshiftserverless.get_credentials(workgroup_name=example_aws_redshiftserverless_workgroup["workgroupName"])
    ```


    :param str db_name: The name of the database to get temporary authorization to log on to.
    :param int duration_seconds: The number of seconds until the returned temporary password expires. The minimum is 900 seconds, and the maximum is 3600 seconds.
    :param str workgroup_name: The name of the workgroup associated with the database.
    """
    __args__ = dict()
    __args__['dbName'] = db_name
    __args__['durationSeconds'] = duration_seconds
    __args__['workgroupName'] = workgroup_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:redshiftserverless/getCredentials:getCredentials', __args__, opts=opts, typ=GetCredentialsResult)
    return __ret__.apply(lambda __response__: GetCredentialsResult(
        db_name=pulumi.get(__response__, 'db_name'),
        db_password=pulumi.get(__response__, 'db_password'),
        db_user=pulumi.get(__response__, 'db_user'),
        duration_seconds=pulumi.get(__response__, 'duration_seconds'),
        expiration=pulumi.get(__response__, 'expiration'),
        id=pulumi.get(__response__, 'id'),
        workgroup_name=pulumi.get(__response__, 'workgroup_name')))
