# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UsageLimitArgs', 'UsageLimit']

@pulumi.input_type
class UsageLimitArgs:
    def __init__(__self__, *,
                 amount: pulumi.Input[int],
                 resource_arn: pulumi.Input[str],
                 usage_type: pulumi.Input[str],
                 breach_action: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a UsageLimit resource.
        :param pulumi.Input[int] amount: The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
        :param pulumi.Input[str] resource_arn: The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
        :param pulumi.Input[str] usage_type: The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
        :param pulumi.Input[str] breach_action: The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
        :param pulumi.Input[str] period: The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
        """
        pulumi.set(__self__, "amount", amount)
        pulumi.set(__self__, "resource_arn", resource_arn)
        pulumi.set(__self__, "usage_type", usage_type)
        if breach_action is not None:
            pulumi.set(__self__, "breach_action", breach_action)
        if period is not None:
            pulumi.set(__self__, "period", period)

    @property
    @pulumi.getter
    def amount(self) -> pulumi.Input[int]:
        """
        The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: pulumi.Input[int]):
        pulumi.set(self, "amount", value)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_arn", value)

    @property
    @pulumi.getter(name="usageType")
    def usage_type(self) -> pulumi.Input[str]:
        """
        The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
        """
        return pulumi.get(self, "usage_type")

    @usage_type.setter
    def usage_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "usage_type", value)

    @property
    @pulumi.getter(name="breachAction")
    def breach_action(self) -> Optional[pulumi.Input[str]]:
        """
        The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
        """
        return pulumi.get(self, "breach_action")

    @breach_action.setter
    def breach_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "breach_action", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)


@pulumi.input_type
class _UsageLimitState:
    def __init__(__self__, *,
                 amount: Optional[pulumi.Input[int]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 breach_action: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 resource_arn: Optional[pulumi.Input[str]] = None,
                 usage_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering UsageLimit resources.
        :param pulumi.Input[int] amount: The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the Redshift Serverless Usage Limit.
        :param pulumi.Input[str] breach_action: The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
        :param pulumi.Input[str] period: The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
        :param pulumi.Input[str] resource_arn: The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
        :param pulumi.Input[str] usage_type: The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
        """
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if breach_action is not None:
            pulumi.set(__self__, "breach_action", breach_action)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)
        if usage_type is not None:
            pulumi.set(__self__, "usage_type", usage_type)

    @property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[int]]:
        """
        The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "amount", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the Redshift Serverless Usage Limit.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="breachAction")
    def breach_action(self) -> Optional[pulumi.Input[str]]:
        """
        The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
        """
        return pulumi.get(self, "breach_action")

    @breach_action.setter
    def breach_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "breach_action", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_arn", value)

    @property
    @pulumi.getter(name="usageType")
    def usage_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
        """
        return pulumi.get(self, "usage_type")

    @usage_type.setter
    def usage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "usage_type", value)


class UsageLimit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[int]] = None,
                 breach_action: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 resource_arn: Optional[pulumi.Input[str]] = None,
                 usage_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new Amazon Redshift Serverless Usage Limit.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshiftserverless.Workgroup("example",
            namespace_name=example_aws_redshiftserverless_namespace["namespaceName"],
            workgroup_name="example")
        example_usage_limit = aws.redshiftserverless.UsageLimit("example",
            resource_arn=example.arn,
            usage_type="serverless-compute",
            amount=60)
        ```

        ## Import

        Using `pulumi import`, import Redshift Serverless Usage Limits using the `id`. For example:

        ```sh
        $ pulumi import aws:redshiftserverless/usageLimit:UsageLimit example example-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] amount: The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
        :param pulumi.Input[str] breach_action: The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
        :param pulumi.Input[str] period: The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
        :param pulumi.Input[str] resource_arn: The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
        :param pulumi.Input[str] usage_type: The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UsageLimitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Amazon Redshift Serverless Usage Limit.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshiftserverless.Workgroup("example",
            namespace_name=example_aws_redshiftserverless_namespace["namespaceName"],
            workgroup_name="example")
        example_usage_limit = aws.redshiftserverless.UsageLimit("example",
            resource_arn=example.arn,
            usage_type="serverless-compute",
            amount=60)
        ```

        ## Import

        Using `pulumi import`, import Redshift Serverless Usage Limits using the `id`. For example:

        ```sh
        $ pulumi import aws:redshiftserverless/usageLimit:UsageLimit example example-id
        ```

        :param str resource_name: The name of the resource.
        :param UsageLimitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UsageLimitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[int]] = None,
                 breach_action: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 resource_arn: Optional[pulumi.Input[str]] = None,
                 usage_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UsageLimitArgs.__new__(UsageLimitArgs)

            if amount is None and not opts.urn:
                raise TypeError("Missing required property 'amount'")
            __props__.__dict__["amount"] = amount
            __props__.__dict__["breach_action"] = breach_action
            __props__.__dict__["period"] = period
            if resource_arn is None and not opts.urn:
                raise TypeError("Missing required property 'resource_arn'")
            __props__.__dict__["resource_arn"] = resource_arn
            if usage_type is None and not opts.urn:
                raise TypeError("Missing required property 'usage_type'")
            __props__.__dict__["usage_type"] = usage_type
            __props__.__dict__["arn"] = None
        super(UsageLimit, __self__).__init__(
            'aws:redshiftserverless/usageLimit:UsageLimit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            amount: Optional[pulumi.Input[int]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            breach_action: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[str]] = None,
            resource_arn: Optional[pulumi.Input[str]] = None,
            usage_type: Optional[pulumi.Input[str]] = None) -> 'UsageLimit':
        """
        Get an existing UsageLimit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] amount: The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the Redshift Serverless Usage Limit.
        :param pulumi.Input[str] breach_action: The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
        :param pulumi.Input[str] period: The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
        :param pulumi.Input[str] resource_arn: The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
        :param pulumi.Input[str] usage_type: The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UsageLimitState.__new__(_UsageLimitState)

        __props__.__dict__["amount"] = amount
        __props__.__dict__["arn"] = arn
        __props__.__dict__["breach_action"] = breach_action
        __props__.__dict__["period"] = period
        __props__.__dict__["resource_arn"] = resource_arn
        __props__.__dict__["usage_type"] = usage_type
        return UsageLimit(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def amount(self) -> pulumi.Output[int]:
        """
        The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the Redshift Serverless Usage Limit.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="breachAction")
    def breach_action(self) -> pulumi.Output[Optional[str]]:
        """
        The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
        """
        return pulumi.get(self, "breach_action")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[str]]:
        """
        The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter(name="usageType")
    def usage_type(self) -> pulumi.Output[str]:
        """
        The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
        """
        return pulumi.get(self, "usage_type")

