# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ProfilesAssociationTimeouts',
    'ProfilesProfileTimeouts',
    'ProfilesResourceAssociationTimeouts',
    'RecordAlias',
    'RecordCidrRoutingPolicy',
    'RecordFailoverRoutingPolicy',
    'RecordGeolocationRoutingPolicy',
    'RecordGeoproximityRoutingPolicy',
    'RecordGeoproximityRoutingPolicyCoordinate',
    'RecordLatencyRoutingPolicy',
    'RecordWeightedRoutingPolicy',
    'ResolverEndpointIpAddress',
    'ResolverRuleTargetIp',
    'ZoneVpc',
    'GetProfilesProfilesProfileResult',
    'GetQueryLogConfigFilterResult',
    'GetResolverEndpointFilterResult',
    'GetResolverFirewallRulesFirewallRuleResult',
    'GetTrafficPolicyDocumentEndpointResult',
    'GetTrafficPolicyDocumentRuleResult',
    'GetTrafficPolicyDocumentRuleGeoProximityLocationResult',
    'GetTrafficPolicyDocumentRuleItemResult',
    'GetTrafficPolicyDocumentRuleLocationResult',
    'GetTrafficPolicyDocumentRulePrimaryResult',
    'GetTrafficPolicyDocumentRuleRegionResult',
    'GetTrafficPolicyDocumentRuleSecondaryResult',
]

@pulumi.output_type
class ProfilesAssociationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 delete: Optional[str] = None,
                 update: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class ProfilesProfileTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 delete: Optional[str] = None,
                 read: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param str read: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Read operations occur during any refresh or planning operation when refresh is enabled.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if read is not None:
            pulumi.set(__self__, "read", read)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def read(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Read operations occur during any refresh or planning operation when refresh is enabled.
        """
        return pulumi.get(self, "read")


@pulumi.output_type
class ProfilesResourceAssociationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 delete: Optional[str] = None,
                 read: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param str read: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Read operations occur during any refresh or planning operation when refresh is enabled.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if read is not None:
            pulumi.set(__self__, "read", read)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def read(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Read operations occur during any refresh or planning operation when refresh is enabled.
        """
        return pulumi.get(self, "read")


@pulumi.output_type
class RecordAlias(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluateTargetHealth":
            suggest = "evaluate_target_health"
        elif key == "zoneId":
            suggest = "zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordAlias. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordAlias.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordAlias.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluate_target_health: bool,
                 name: str,
                 zone_id: str):
        """
        :param bool evaluate_target_health: Set to `true` if you want Route 53 to determine whether to respond to DNS queries using this resource record set by checking the health of the resource record set. Some resources have special requirements, see [related part of documentation](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resource-record-sets-values.html#rrsets-values-alias-evaluate-target-health).
        :param str name: DNS domain name for a CloudFront distribution, S3 bucket, ELB, or another resource record set in this hosted zone.
        :param str zone_id: Hosted zone ID for a CloudFront distribution, S3 bucket, ELB, or Route 53 hosted zone. See `resource_elb.zone_id` for example.
        """
        pulumi.set(__self__, "evaluate_target_health", evaluate_target_health)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="evaluateTargetHealth")
    def evaluate_target_health(self) -> bool:
        """
        Set to `true` if you want Route 53 to determine whether to respond to DNS queries using this resource record set by checking the health of the resource record set. Some resources have special requirements, see [related part of documentation](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resource-record-sets-values.html#rrsets-values-alias-evaluate-target-health).
        """
        return pulumi.get(self, "evaluate_target_health")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        DNS domain name for a CloudFront distribution, S3 bucket, ELB, or another resource record set in this hosted zone.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        Hosted zone ID for a CloudFront distribution, S3 bucket, ELB, or Route 53 hosted zone. See `resource_elb.zone_id` for example.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class RecordCidrRoutingPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionId":
            suggest = "collection_id"
        elif key == "locationName":
            suggest = "location_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordCidrRoutingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordCidrRoutingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordCidrRoutingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collection_id: str,
                 location_name: str):
        """
        :param str collection_id: The CIDR collection ID. See the `route53.CidrCollection` resource for more details.
        :param str location_name: The CIDR collection location name. See the `route53.CidrLocation` resource for more details. A `location_name` with an asterisk `"*"` can be used to create a default CIDR record. `collection_id` is still required for default record.
        """
        pulumi.set(__self__, "collection_id", collection_id)
        pulumi.set(__self__, "location_name", location_name)

    @property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> str:
        """
        The CIDR collection ID. See the `route53.CidrCollection` resource for more details.
        """
        return pulumi.get(self, "collection_id")

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> str:
        """
        The CIDR collection location name. See the `route53.CidrLocation` resource for more details. A `location_name` with an asterisk `"*"` can be used to create a default CIDR record. `collection_id` is still required for default record.
        """
        return pulumi.get(self, "location_name")


@pulumi.output_type
class RecordFailoverRoutingPolicy(dict):
    def __init__(__self__, *,
                 type: str):
        """
        :param str type: `PRIMARY` or `SECONDARY`. A `PRIMARY` record will be served if its healthcheck is passing, otherwise the `SECONDARY` will be served. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html#dns-failover-failover-rrsets
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        `PRIMARY` or `SECONDARY`. A `PRIMARY` record will be served if its healthcheck is passing, otherwise the `SECONDARY` will be served. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html#dns-failover-failover-rrsets
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RecordGeolocationRoutingPolicy(dict):
    def __init__(__self__, *,
                 continent: Optional[str] = None,
                 country: Optional[str] = None,
                 subdivision: Optional[str] = None):
        """
        :param str continent: A two-letter continent code. See http://docs.aws.amazon.com/Route53/latest/APIReference/API_GetGeoLocation.html for code details. Either `continent` or `country` must be specified.
        :param str country: A two-character country code or `*` to indicate a default resource record set.
        :param str subdivision: A subdivision code for a country.
        """
        if continent is not None:
            pulumi.set(__self__, "continent", continent)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if subdivision is not None:
            pulumi.set(__self__, "subdivision", subdivision)

    @property
    @pulumi.getter
    def continent(self) -> Optional[str]:
        """
        A two-letter continent code. See http://docs.aws.amazon.com/Route53/latest/APIReference/API_GetGeoLocation.html for code details. Either `continent` or `country` must be specified.
        """
        return pulumi.get(self, "continent")

    @property
    @pulumi.getter
    def country(self) -> Optional[str]:
        """
        A two-character country code or `*` to indicate a default resource record set.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def subdivision(self) -> Optional[str]:
        """
        A subdivision code for a country.
        """
        return pulumi.get(self, "subdivision")


@pulumi.output_type
class RecordGeoproximityRoutingPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsRegion":
            suggest = "aws_region"
        elif key == "localZoneGroup":
            suggest = "local_zone_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordGeoproximityRoutingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordGeoproximityRoutingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordGeoproximityRoutingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_region: Optional[str] = None,
                 bias: Optional[int] = None,
                 coordinates: Optional[Sequence['outputs.RecordGeoproximityRoutingPolicyCoordinate']] = None,
                 local_zone_group: Optional[str] = None):
        """
        :param str aws_region: A AWS region where the resource is present.
        :param int bias: Route more traffic or less traffic to the resource by specifying a value ranges between -90 to 90. See https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy-geoproximity.html for bias details.
        :param Sequence['RecordGeoproximityRoutingPolicyCoordinateArgs'] coordinates: Specify `latitude` and `longitude` for routing traffic to non-AWS resources.
        :param str local_zone_group: A AWS local zone group where the resource is present. See https://docs.aws.amazon.com/local-zones/latest/ug/available-local-zones.html for local zone group list.
        """
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if bias is not None:
            pulumi.set(__self__, "bias", bias)
        if coordinates is not None:
            pulumi.set(__self__, "coordinates", coordinates)
        if local_zone_group is not None:
            pulumi.set(__self__, "local_zone_group", local_zone_group)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[str]:
        """
        A AWS region where the resource is present.
        """
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter
    def bias(self) -> Optional[int]:
        """
        Route more traffic or less traffic to the resource by specifying a value ranges between -90 to 90. See https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy-geoproximity.html for bias details.
        """
        return pulumi.get(self, "bias")

    @property
    @pulumi.getter
    def coordinates(self) -> Optional[Sequence['outputs.RecordGeoproximityRoutingPolicyCoordinate']]:
        """
        Specify `latitude` and `longitude` for routing traffic to non-AWS resources.
        """
        return pulumi.get(self, "coordinates")

    @property
    @pulumi.getter(name="localZoneGroup")
    def local_zone_group(self) -> Optional[str]:
        """
        A AWS local zone group where the resource is present. See https://docs.aws.amazon.com/local-zones/latest/ug/available-local-zones.html for local zone group list.
        """
        return pulumi.get(self, "local_zone_group")


@pulumi.output_type
class RecordGeoproximityRoutingPolicyCoordinate(dict):
    def __init__(__self__, *,
                 latitude: str,
                 longitude: str):
        pulumi.set(__self__, "latitude", latitude)
        pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter
    def latitude(self) -> str:
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> str:
        return pulumi.get(self, "longitude")


@pulumi.output_type
class RecordLatencyRoutingPolicy(dict):
    def __init__(__self__, *,
                 region: str):
        """
        :param str region: An AWS region from which to measure latency. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-latency
        """
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        An AWS region from which to measure latency. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-latency
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class RecordWeightedRoutingPolicy(dict):
    def __init__(__self__, *,
                 weight: int):
        """
        :param int weight: A numeric value indicating the relative weight of the record. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted.
        """
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        A numeric value indicating the relative weight of the record. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ResolverEndpointIpAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "ipId":
            suggest = "ip_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverEndpointIpAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverEndpointIpAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverEndpointIpAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: str,
                 ip: Optional[str] = None,
                 ip_id: Optional[str] = None,
                 ipv6: Optional[str] = None):
        """
        :param str subnet_id: ID of the subnet that contains the IP address.
        :param str ip: IPv4 address in the subnet that you want to use for DNS queries.
        :param str ipv6: IPv6 address in the subnet that you want to use for DNS queries.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_id is not None:
            pulumi.set(__self__, "ip_id", ip_id)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        ID of the subnet that contains the IP address.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        IPv4 address in the subnet that you want to use for DNS queries.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> Optional[str]:
        return pulumi.get(self, "ip_id")

    @property
    @pulumi.getter
    def ipv6(self) -> Optional[str]:
        """
        IPv6 address in the subnet that you want to use for DNS queries.
        """
        return pulumi.get(self, "ipv6")


@pulumi.output_type
class ResolverRuleTargetIp(dict):
    def __init__(__self__, *,
                 ip: Optional[str] = None,
                 ipv6: Optional[str] = None,
                 port: Optional[int] = None,
                 protocol: Optional[str] = None):
        """
        :param str ip: One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
        :param str ipv6: One IPv6 address that you want to forward DNS queries to.
        :param int port: Port at `ip` that you want to forward DNS queries to. Default value is `53`.
        :param str protocol: Protocol for the resolver endpoint. Valid values can be found in the [AWS documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_TargetAddress.html). Default value is `Do53`.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def ipv6(self) -> Optional[str]:
        """
        One IPv6 address that you want to forward DNS queries to.
        """
        return pulumi.get(self, "ipv6")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port at `ip` that you want to forward DNS queries to. Default value is `53`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol for the resolver endpoint. Valid values can be found in the [AWS documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_TargetAddress.html). Default value is `Do53`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ZoneVpc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"
        elif key == "vpcRegion":
            suggest = "vpc_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: str,
                 vpc_region: Optional[str] = None):
        """
        :param str vpc_id: ID of the VPC to associate.
        :param str vpc_region: Region of the VPC to associate. Defaults to AWS provider region.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_region is not None:
            pulumi.set(__self__, "vpc_region", vpc_region)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        ID of the VPC to associate.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcRegion")
    def vpc_region(self) -> Optional[str]:
        """
        Region of the VPC to associate. Defaults to AWS provider region.
        """
        return pulumi.get(self, "vpc_region")


@pulumi.output_type
class GetProfilesProfilesProfileResult(dict):
    def __init__(__self__, *,
                 arn: str,
                 id: str,
                 name: str,
                 share_status: str):
        """
        :param str arn: ARN of the Profile.
        :param str id: ID of the Profile.
        :param str name: Name of the Profile.
        :param str share_status: Share status of the Profile. Valid values [AWS docs](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_Profile.html)
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "share_status", share_status)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the Profile.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the Profile.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="shareStatus")
    def share_status(self) -> str:
        """
        Share status of the Profile. Valid values [AWS docs](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53profiles_Profile.html)
        """
        return pulumi.get(self, "share_status")


@pulumi.output_type
class GetQueryLogConfigFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the query logging configuration.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the query logging configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class GetResolverEndpointFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class GetResolverFirewallRulesFirewallRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 block_override_dns_type: str,
                 block_override_domain: str,
                 block_override_ttl: int,
                 block_response: str,
                 creation_time: str,
                 creator_request_id: str,
                 firewall_domain_list_id: str,
                 firewall_rule_group_id: str,
                 modification_time: str,
                 name: str,
                 priority: int):
        """
        :param str action: The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list.
        :param str block_override_dns_type: The DNS record's type.
        :param str block_override_domain: The custom DNS record to send back in response to the query.
        :param int block_override_ttl: The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record.
        :param str block_response: The way that you want DNS Firewall to block the request.
        :param str creation_time: The date and time that the rule was created, in Unix time format and Coordinated Universal Time (UTC).
        :param str creator_request_id: A unique string defined by you to identify the request.
        :param str firewall_domain_list_id: The ID of the domain list that's used in the rule.
        :param str firewall_rule_group_id: The unique identifier of the firewall rule group that you want to retrieve the rules for.
        :param str modification_time: The date and time that the rule was last modified, in Unix time format and Coordinated Universal Time (UTC).
        :param str name: The name of the rule.
        :param int priority: The setting that determines the processing order of the rules in a rule group.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "block_override_dns_type", block_override_dns_type)
        pulumi.set(__self__, "block_override_domain", block_override_domain)
        pulumi.set(__self__, "block_override_ttl", block_override_ttl)
        pulumi.set(__self__, "block_response", block_response)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "creator_request_id", creator_request_id)
        pulumi.set(__self__, "firewall_domain_list_id", firewall_domain_list_id)
        pulumi.set(__self__, "firewall_rule_group_id", firewall_rule_group_id)
        pulumi.set(__self__, "modification_time", modification_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="blockOverrideDnsType")
    def block_override_dns_type(self) -> str:
        """
        The DNS record's type.
        """
        return pulumi.get(self, "block_override_dns_type")

    @property
    @pulumi.getter(name="blockOverrideDomain")
    def block_override_domain(self) -> str:
        """
        The custom DNS record to send back in response to the query.
        """
        return pulumi.get(self, "block_override_domain")

    @property
    @pulumi.getter(name="blockOverrideTtl")
    def block_override_ttl(self) -> int:
        """
        The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record.
        """
        return pulumi.get(self, "block_override_ttl")

    @property
    @pulumi.getter(name="blockResponse")
    def block_response(self) -> str:
        """
        The way that you want DNS Firewall to block the request.
        """
        return pulumi.get(self, "block_response")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The date and time that the rule was created, in Unix time format and Coordinated Universal Time (UTC).
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="creatorRequestId")
    def creator_request_id(self) -> str:
        """
        A unique string defined by you to identify the request.
        """
        return pulumi.get(self, "creator_request_id")

    @property
    @pulumi.getter(name="firewallDomainListId")
    def firewall_domain_list_id(self) -> str:
        """
        The ID of the domain list that's used in the rule.
        """
        return pulumi.get(self, "firewall_domain_list_id")

    @property
    @pulumi.getter(name="firewallRuleGroupId")
    def firewall_rule_group_id(self) -> str:
        """
        The unique identifier of the firewall rule group that you want to retrieve the rules for.
        """
        return pulumi.get(self, "firewall_rule_group_id")

    @property
    @pulumi.getter(name="modificationTime")
    def modification_time(self) -> str:
        """
        The date and time that the rule was last modified, in Unix time format and Coordinated Universal Time (UTC).
        """
        return pulumi.get(self, "modification_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The setting that determines the processing order of the rules in a rule group.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class GetTrafficPolicyDocumentEndpointResult(dict):
    def __init__(__self__, *,
                 id: str,
                 region: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str id: ID of an endpoint you want to assign.
        :param str region: To route traffic to an Amazon S3 bucket that is configured as a website endpoint, specify the region in which you created the bucket for `region`.
        :param str type: Type of the endpoint. Valid values are `value`, `cloudfront`, `elastic-load-balancer`, `s3-website`, `application-load-balancer`, `network-load-balancer` and `elastic-beanstalk`
        :param str value: Value of the `type`.
        """
        pulumi.set(__self__, "id", id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of an endpoint you want to assign.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        To route traffic to an Amazon S3 bucket that is configured as a website endpoint, specify the region in which you created the bucket for `region`.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the endpoint. Valid values are `value`, `cloudfront`, `elastic-load-balancer`, `s3-website`, `application-load-balancer`, `network-load-balancer` and `elastic-beanstalk`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value of the `type`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetTrafficPolicyDocumentRuleResult(dict):
    def __init__(__self__, *,
                 id: str,
                 geo_proximity_locations: Optional[Sequence['outputs.GetTrafficPolicyDocumentRuleGeoProximityLocationResult']] = None,
                 items: Optional[Sequence['outputs.GetTrafficPolicyDocumentRuleItemResult']] = None,
                 locations: Optional[Sequence['outputs.GetTrafficPolicyDocumentRuleLocationResult']] = None,
                 primary: Optional['outputs.GetTrafficPolicyDocumentRulePrimaryResult'] = None,
                 regions: Optional[Sequence['outputs.GetTrafficPolicyDocumentRuleRegionResult']] = None,
                 secondary: Optional['outputs.GetTrafficPolicyDocumentRuleSecondaryResult'] = None,
                 type: Optional[str] = None):
        """
        :param str id: ID of a rule you want to assign.
        :param Sequence['GetTrafficPolicyDocumentRuleGeoProximityLocationArgs'] geo_proximity_locations: Configuration block for when you add a geoproximity rule, you configure Amazon Route 53 to route traffic to your resources based on the geographic location of your resources. Only valid for `geoproximity` type. See below
        :param Sequence['GetTrafficPolicyDocumentRuleItemArgs'] items: Configuration block for when you add a multivalue answer rule, you configure your traffic policy to route traffic approximately randomly to your healthy resources.  Only valid for `multivalue` type. See below
        :param Sequence['GetTrafficPolicyDocumentRuleLocationArgs'] locations: Configuration block for when you add a geolocation rule, you configure your traffic policy to route your traffic based on the geographic location of your users.  Only valid for `geo` type. See below
        :param 'GetTrafficPolicyDocumentRulePrimaryArgs' primary: Configuration block for the settings for the rule or endpoint that you want to route traffic to whenever the corresponding resources are available. Only valid for `failover` type. See below
        :param 'GetTrafficPolicyDocumentRuleSecondaryArgs' secondary: Configuration block for the rule or endpoint that you want to route traffic to whenever the primary resources are not available. Only valid for `failover` type. See below
        :param str type: Type of the rule.
        """
        pulumi.set(__self__, "id", id)
        if geo_proximity_locations is not None:
            pulumi.set(__self__, "geo_proximity_locations", geo_proximity_locations)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if secondary is not None:
            pulumi.set(__self__, "secondary", secondary)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of a rule you want to assign.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="geoProximityLocations")
    def geo_proximity_locations(self) -> Optional[Sequence['outputs.GetTrafficPolicyDocumentRuleGeoProximityLocationResult']]:
        """
        Configuration block for when you add a geoproximity rule, you configure Amazon Route 53 to route traffic to your resources based on the geographic location of your resources. Only valid for `geoproximity` type. See below
        """
        return pulumi.get(self, "geo_proximity_locations")

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.GetTrafficPolicyDocumentRuleItemResult']]:
        """
        Configuration block for when you add a multivalue answer rule, you configure your traffic policy to route traffic approximately randomly to your healthy resources.  Only valid for `multivalue` type. See below
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence['outputs.GetTrafficPolicyDocumentRuleLocationResult']]:
        """
        Configuration block for when you add a geolocation rule, you configure your traffic policy to route your traffic based on the geographic location of your users.  Only valid for `geo` type. See below
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def primary(self) -> Optional['outputs.GetTrafficPolicyDocumentRulePrimaryResult']:
        """
        Configuration block for the settings for the rule or endpoint that you want to route traffic to whenever the corresponding resources are available. Only valid for `failover` type. See below
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence['outputs.GetTrafficPolicyDocumentRuleRegionResult']]:
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter
    def secondary(self) -> Optional['outputs.GetTrafficPolicyDocumentRuleSecondaryResult']:
        """
        Configuration block for the rule or endpoint that you want to route traffic to whenever the primary resources are not available. Only valid for `failover` type. See below
        """
        return pulumi.get(self, "secondary")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the rule.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTrafficPolicyDocumentRuleGeoProximityLocationResult(dict):
    def __init__(__self__, *,
                 bias: Optional[str] = None,
                 endpoint_reference: Optional[str] = None,
                 evaluate_target_health: Optional[bool] = None,
                 health_check: Optional[str] = None,
                 latitude: Optional[str] = None,
                 longitude: Optional[str] = None,
                 region: Optional[str] = None,
                 rule_reference: Optional[str] = None):
        """
        :param str bias: Specify a value for `bias` if you want to route more traffic to an endpoint from nearby endpoints (positive values) or route less traffic to an endpoint (negative values).
        :param str endpoint_reference: References to an endpoint.
        :param bool evaluate_target_health: Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        :param str health_check: If you want to associate a health check with the endpoint or rule.
        :param str latitude: Represents the location south (negative) or north (positive) of the equator. Valid values are -90 degrees to 90 degrees.
        :param str longitude: Represents the location west (negative) or east (positive) of the prime meridian. Valid values are -180 degrees to 180 degrees.
        :param str region: If your endpoint is an AWS resource, specify the AWS Region that you created the resource in.
        :param str rule_reference: References to a rule.
        """
        if bias is not None:
            pulumi.set(__self__, "bias", bias)
        if endpoint_reference is not None:
            pulumi.set(__self__, "endpoint_reference", endpoint_reference)
        if evaluate_target_health is not None:
            pulumi.set(__self__, "evaluate_target_health", evaluate_target_health)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_reference is not None:
            pulumi.set(__self__, "rule_reference", rule_reference)

    @property
    @pulumi.getter
    def bias(self) -> Optional[str]:
        """
        Specify a value for `bias` if you want to route more traffic to an endpoint from nearby endpoints (positive values) or route less traffic to an endpoint (negative values).
        """
        return pulumi.get(self, "bias")

    @property
    @pulumi.getter(name="endpointReference")
    def endpoint_reference(self) -> Optional[str]:
        """
        References to an endpoint.
        """
        return pulumi.get(self, "endpoint_reference")

    @property
    @pulumi.getter(name="evaluateTargetHealth")
    def evaluate_target_health(self) -> Optional[bool]:
        """
        Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        """
        return pulumi.get(self, "evaluate_target_health")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[str]:
        """
        If you want to associate a health check with the endpoint or rule.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter
    def latitude(self) -> Optional[str]:
        """
        Represents the location south (negative) or north (positive) of the equator. Valid values are -90 degrees to 90 degrees.
        """
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> Optional[str]:
        """
        Represents the location west (negative) or east (positive) of the prime meridian. Valid values are -180 degrees to 180 degrees.
        """
        return pulumi.get(self, "longitude")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        If your endpoint is an AWS resource, specify the AWS Region that you created the resource in.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="ruleReference")
    def rule_reference(self) -> Optional[str]:
        """
        References to a rule.
        """
        return pulumi.get(self, "rule_reference")


@pulumi.output_type
class GetTrafficPolicyDocumentRuleItemResult(dict):
    def __init__(__self__, *,
                 endpoint_reference: Optional[str] = None,
                 health_check: Optional[str] = None):
        if endpoint_reference is not None:
            pulumi.set(__self__, "endpoint_reference", endpoint_reference)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)

    @property
    @pulumi.getter(name="endpointReference")
    def endpoint_reference(self) -> Optional[str]:
        return pulumi.get(self, "endpoint_reference")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[str]:
        return pulumi.get(self, "health_check")


@pulumi.output_type
class GetTrafficPolicyDocumentRuleLocationResult(dict):
    def __init__(__self__, *,
                 continent: Optional[str] = None,
                 country: Optional[str] = None,
                 endpoint_reference: Optional[str] = None,
                 evaluate_target_health: Optional[bool] = None,
                 health_check: Optional[str] = None,
                 is_default: Optional[bool] = None,
                 rule_reference: Optional[str] = None,
                 subdivision: Optional[str] = None):
        """
        :param str continent: Value of a continent.
        :param str country: Value of a country.
        :param str endpoint_reference: References to an endpoint.
        :param bool evaluate_target_health: Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        :param str health_check: If you want to associate a health check with the endpoint or rule.
        :param bool is_default: Indicates whether this set of values represents the default location.
        :param str rule_reference: References to a rule.
        :param str subdivision: Value of a subdivision.
        """
        if continent is not None:
            pulumi.set(__self__, "continent", continent)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if endpoint_reference is not None:
            pulumi.set(__self__, "endpoint_reference", endpoint_reference)
        if evaluate_target_health is not None:
            pulumi.set(__self__, "evaluate_target_health", evaluate_target_health)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if rule_reference is not None:
            pulumi.set(__self__, "rule_reference", rule_reference)
        if subdivision is not None:
            pulumi.set(__self__, "subdivision", subdivision)

    @property
    @pulumi.getter
    def continent(self) -> Optional[str]:
        """
        Value of a continent.
        """
        return pulumi.get(self, "continent")

    @property
    @pulumi.getter
    def country(self) -> Optional[str]:
        """
        Value of a country.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="endpointReference")
    def endpoint_reference(self) -> Optional[str]:
        """
        References to an endpoint.
        """
        return pulumi.get(self, "endpoint_reference")

    @property
    @pulumi.getter(name="evaluateTargetHealth")
    def evaluate_target_health(self) -> Optional[bool]:
        """
        Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        """
        return pulumi.get(self, "evaluate_target_health")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[str]:
        """
        If you want to associate a health check with the endpoint or rule.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[bool]:
        """
        Indicates whether this set of values represents the default location.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="ruleReference")
    def rule_reference(self) -> Optional[str]:
        """
        References to a rule.
        """
        return pulumi.get(self, "rule_reference")

    @property
    @pulumi.getter
    def subdivision(self) -> Optional[str]:
        """
        Value of a subdivision.
        """
        return pulumi.get(self, "subdivision")


@pulumi.output_type
class GetTrafficPolicyDocumentRulePrimaryResult(dict):
    def __init__(__self__, *,
                 endpoint_reference: Optional[str] = None,
                 evaluate_target_health: Optional[bool] = None,
                 health_check: Optional[str] = None,
                 rule_reference: Optional[str] = None):
        """
        :param str endpoint_reference: References to an endpoint.
        :param bool evaluate_target_health: Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        :param str health_check: If you want to associate a health check with the endpoint or rule.
        :param str rule_reference: References to a rule.
        """
        if endpoint_reference is not None:
            pulumi.set(__self__, "endpoint_reference", endpoint_reference)
        if evaluate_target_health is not None:
            pulumi.set(__self__, "evaluate_target_health", evaluate_target_health)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if rule_reference is not None:
            pulumi.set(__self__, "rule_reference", rule_reference)

    @property
    @pulumi.getter(name="endpointReference")
    def endpoint_reference(self) -> Optional[str]:
        """
        References to an endpoint.
        """
        return pulumi.get(self, "endpoint_reference")

    @property
    @pulumi.getter(name="evaluateTargetHealth")
    def evaluate_target_health(self) -> Optional[bool]:
        """
        Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        """
        return pulumi.get(self, "evaluate_target_health")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[str]:
        """
        If you want to associate a health check with the endpoint or rule.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="ruleReference")
    def rule_reference(self) -> Optional[str]:
        """
        References to a rule.
        """
        return pulumi.get(self, "rule_reference")


@pulumi.output_type
class GetTrafficPolicyDocumentRuleRegionResult(dict):
    def __init__(__self__, *,
                 endpoint_reference: Optional[str] = None,
                 evaluate_target_health: Optional[bool] = None,
                 health_check: Optional[str] = None,
                 region: Optional[str] = None,
                 rule_reference: Optional[str] = None):
        """
        :param str endpoint_reference: References to an endpoint.
        :param bool evaluate_target_health: Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        :param str health_check: If you want to associate a health check with the endpoint or rule.
        :param str region: Region code for the AWS Region that you created the resource in.
        :param str rule_reference: References to a rule.
        """
        if endpoint_reference is not None:
            pulumi.set(__self__, "endpoint_reference", endpoint_reference)
        if evaluate_target_health is not None:
            pulumi.set(__self__, "evaluate_target_health", evaluate_target_health)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_reference is not None:
            pulumi.set(__self__, "rule_reference", rule_reference)

    @property
    @pulumi.getter(name="endpointReference")
    def endpoint_reference(self) -> Optional[str]:
        """
        References to an endpoint.
        """
        return pulumi.get(self, "endpoint_reference")

    @property
    @pulumi.getter(name="evaluateTargetHealth")
    def evaluate_target_health(self) -> Optional[bool]:
        """
        Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        """
        return pulumi.get(self, "evaluate_target_health")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[str]:
        """
        If you want to associate a health check with the endpoint or rule.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Region code for the AWS Region that you created the resource in.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="ruleReference")
    def rule_reference(self) -> Optional[str]:
        """
        References to a rule.
        """
        return pulumi.get(self, "rule_reference")


@pulumi.output_type
class GetTrafficPolicyDocumentRuleSecondaryResult(dict):
    def __init__(__self__, *,
                 endpoint_reference: Optional[str] = None,
                 evaluate_target_health: Optional[bool] = None,
                 health_check: Optional[str] = None,
                 rule_reference: Optional[str] = None):
        if endpoint_reference is not None:
            pulumi.set(__self__, "endpoint_reference", endpoint_reference)
        if evaluate_target_health is not None:
            pulumi.set(__self__, "evaluate_target_health", evaluate_target_health)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if rule_reference is not None:
            pulumi.set(__self__, "rule_reference", rule_reference)

    @property
    @pulumi.getter(name="endpointReference")
    def endpoint_reference(self) -> Optional[str]:
        return pulumi.get(self, "endpoint_reference")

    @property
    @pulumi.getter(name="evaluateTargetHealth")
    def evaluate_target_health(self) -> Optional[bool]:
        return pulumi.get(self, "evaluate_target_health")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[str]:
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="ruleReference")
    def rule_reference(self) -> Optional[str]:
        return pulumi.get(self, "rule_reference")


