# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccessPointPublicAccessBlockConfiguration',
    'AccessPointVpcConfiguration',
    'AnalyticsConfigurationFilter',
    'AnalyticsConfigurationStorageClassAnalysis',
    'AnalyticsConfigurationStorageClassAnalysisDataExport',
    'AnalyticsConfigurationStorageClassAnalysisDataExportDestination',
    'AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination',
    'BucketAclV2AccessControlPolicy',
    'BucketAclV2AccessControlPolicyGrant',
    'BucketAclV2AccessControlPolicyGrantGrantee',
    'BucketAclV2AccessControlPolicyOwner',
    'BucketCorsConfigurationV2CorsRule',
    'BucketCorsRule',
    'BucketGrant',
    'BucketIntelligentTieringConfigurationFilter',
    'BucketIntelligentTieringConfigurationTiering',
    'BucketLifecycleConfigurationV2Rule',
    'BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUpload',
    'BucketLifecycleConfigurationV2RuleExpiration',
    'BucketLifecycleConfigurationV2RuleFilter',
    'BucketLifecycleConfigurationV2RuleFilterAnd',
    'BucketLifecycleConfigurationV2RuleFilterTag',
    'BucketLifecycleConfigurationV2RuleNoncurrentVersionExpiration',
    'BucketLifecycleConfigurationV2RuleNoncurrentVersionTransition',
    'BucketLifecycleConfigurationV2RuleTransition',
    'BucketLifecycleRule',
    'BucketLifecycleRuleExpiration',
    'BucketLifecycleRuleNoncurrentVersionExpiration',
    'BucketLifecycleRuleNoncurrentVersionTransition',
    'BucketLifecycleRuleTransition',
    'BucketLogging',
    'BucketLoggingV2TargetGrant',
    'BucketLoggingV2TargetGrantGrantee',
    'BucketLoggingV2TargetObjectKeyFormat',
    'BucketLoggingV2TargetObjectKeyFormatPartitionedPrefix',
    'BucketLoggingV2TargetObjectKeyFormatSimplePrefix',
    'BucketMetricFilter',
    'BucketNotificationLambdaFunction',
    'BucketNotificationQueue',
    'BucketNotificationTopic',
    'BucketObjectLockConfiguration',
    'BucketObjectLockConfigurationRule',
    'BucketObjectLockConfigurationRuleDefaultRetention',
    'BucketObjectLockConfigurationV2Rule',
    'BucketObjectLockConfigurationV2RuleDefaultRetention',
    'BucketObjectv2OverrideProvider',
    'BucketObjectv2OverrideProviderDefaultTags',
    'BucketOwnershipControlsRule',
    'BucketReplicationConfigRule',
    'BucketReplicationConfigRuleDeleteMarkerReplication',
    'BucketReplicationConfigRuleDestination',
    'BucketReplicationConfigRuleDestinationAccessControlTranslation',
    'BucketReplicationConfigRuleDestinationEncryptionConfiguration',
    'BucketReplicationConfigRuleDestinationMetrics',
    'BucketReplicationConfigRuleDestinationMetricsEventThreshold',
    'BucketReplicationConfigRuleDestinationReplicationTime',
    'BucketReplicationConfigRuleDestinationReplicationTimeTime',
    'BucketReplicationConfigRuleExistingObjectReplication',
    'BucketReplicationConfigRuleFilter',
    'BucketReplicationConfigRuleFilterAnd',
    'BucketReplicationConfigRuleFilterTag',
    'BucketReplicationConfigRuleSourceSelectionCriteria',
    'BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModifications',
    'BucketReplicationConfigRuleSourceSelectionCriteriaSseKmsEncryptedObjects',
    'BucketReplicationConfiguration',
    'BucketReplicationConfigurationRule',
    'BucketReplicationConfigurationRuleDestination',
    'BucketReplicationConfigurationRuleDestinationAccessControlTranslation',
    'BucketReplicationConfigurationRuleDestinationMetrics',
    'BucketReplicationConfigurationRuleDestinationReplicationTime',
    'BucketReplicationConfigurationRuleFilter',
    'BucketReplicationConfigurationRuleSourceSelectionCriteria',
    'BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjects',
    'BucketServerSideEncryptionConfiguration',
    'BucketServerSideEncryptionConfigurationRule',
    'BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault',
    'BucketServerSideEncryptionConfigurationV2Rule',
    'BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefault',
    'BucketV2CorsRule',
    'BucketV2Grant',
    'BucketV2LifecycleRule',
    'BucketV2LifecycleRuleExpiration',
    'BucketV2LifecycleRuleNoncurrentVersionExpiration',
    'BucketV2LifecycleRuleNoncurrentVersionTransition',
    'BucketV2LifecycleRuleTransition',
    'BucketV2Logging',
    'BucketV2ObjectLockConfiguration',
    'BucketV2ObjectLockConfigurationRule',
    'BucketV2ObjectLockConfigurationRuleDefaultRetention',
    'BucketV2ReplicationConfiguration',
    'BucketV2ReplicationConfigurationRule',
    'BucketV2ReplicationConfigurationRuleDestination',
    'BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslation',
    'BucketV2ReplicationConfigurationRuleDestinationMetric',
    'BucketV2ReplicationConfigurationRuleDestinationReplicationTime',
    'BucketV2ReplicationConfigurationRuleFilter',
    'BucketV2ReplicationConfigurationRuleSourceSelectionCriteria',
    'BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObject',
    'BucketV2ServerSideEncryptionConfiguration',
    'BucketV2ServerSideEncryptionConfigurationRule',
    'BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault',
    'BucketV2Versioning',
    'BucketV2Website',
    'BucketVersioning',
    'BucketVersioningV2VersioningConfiguration',
    'BucketWebsite',
    'BucketWebsiteConfigurationV2ErrorDocument',
    'BucketWebsiteConfigurationV2IndexDocument',
    'BucketWebsiteConfigurationV2RedirectAllRequestsTo',
    'BucketWebsiteConfigurationV2RoutingRule',
    'BucketWebsiteConfigurationV2RoutingRuleCondition',
    'BucketWebsiteConfigurationV2RoutingRuleRedirect',
    'DirectoryBucketLocation',
    'InventoryDestination',
    'InventoryDestinationBucket',
    'InventoryDestinationBucketEncryption',
    'InventoryDestinationBucketEncryptionSseKms',
    'InventoryDestinationBucketEncryptionSseS3',
    'InventoryFilter',
    'InventorySchedule',
    'ObjectCopyGrant',
]

@pulumi.output_type
class AccessPointPublicAccessBlockConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockPublicAcls":
            suggest = "block_public_acls"
        elif key == "blockPublicPolicy":
            suggest = "block_public_policy"
        elif key == "ignorePublicAcls":
            suggest = "ignore_public_acls"
        elif key == "restrictPublicBuckets":
            suggest = "restrict_public_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointPublicAccessBlockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_public_acls: Optional[bool] = None,
                 block_public_policy: Optional[bool] = None,
                 ignore_public_acls: Optional[bool] = None,
                 restrict_public_buckets: Optional[bool] = None):
        """
        :param bool block_public_acls: Whether Amazon S3 should block public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
               * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
               * PUT Object calls fail if the request includes a public ACL.
               * PUT Bucket calls fail if the request includes a public ACL.
        :param bool block_public_policy: Whether Amazon S3 should block public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing bucket policies. When set to `true` causes Amazon S3 to:
               * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
        :param bool ignore_public_acls: Whether Amazon S3 should ignore public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
               * Ignore all public ACLs on buckets in this account and any objects that they contain.
        :param bool restrict_public_buckets: Whether Amazon S3 should restrict public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
               * Only the bucket owner and AWS Services can access buckets with public policies.
        """
        if block_public_acls is not None:
            pulumi.set(__self__, "block_public_acls", block_public_acls)
        if block_public_policy is not None:
            pulumi.set(__self__, "block_public_policy", block_public_policy)
        if ignore_public_acls is not None:
            pulumi.set(__self__, "ignore_public_acls", ignore_public_acls)
        if restrict_public_buckets is not None:
            pulumi.set(__self__, "restrict_public_buckets", restrict_public_buckets)

    @property
    @pulumi.getter(name="blockPublicAcls")
    def block_public_acls(self) -> Optional[bool]:
        """
        Whether Amazon S3 should block public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
        * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
        * PUT Object calls fail if the request includes a public ACL.
        * PUT Bucket calls fail if the request includes a public ACL.
        """
        return pulumi.get(self, "block_public_acls")

    @property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> Optional[bool]:
        """
        Whether Amazon S3 should block public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing bucket policies. When set to `true` causes Amazon S3 to:
        * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
        """
        return pulumi.get(self, "block_public_policy")

    @property
    @pulumi.getter(name="ignorePublicAcls")
    def ignore_public_acls(self) -> Optional[bool]:
        """
        Whether Amazon S3 should ignore public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
        * Ignore all public ACLs on buckets in this account and any objects that they contain.
        """
        return pulumi.get(self, "ignore_public_acls")

    @property
    @pulumi.getter(name="restrictPublicBuckets")
    def restrict_public_buckets(self) -> Optional[bool]:
        """
        Whether Amazon S3 should restrict public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
        * Only the bucket owner and AWS Services can access buckets with public policies.
        """
        return pulumi.get(self, "restrict_public_buckets")


@pulumi.output_type
class AccessPointVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: str):
        """
        :param str vpc_id: This access point will only allow connections from the specified VPC ID.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        This access point will only allow connections from the specified VPC ID.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class AnalyticsConfigurationFilter(dict):
    def __init__(__self__, *,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str prefix: Object prefix for filtering.
        :param Mapping[str, str] tags: Set of object tags for filtering.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object prefix for filtering.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Set of object tags for filtering.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class AnalyticsConfigurationStorageClassAnalysis(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataExport":
            suggest = "data_export"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsConfigurationStorageClassAnalysis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsConfigurationStorageClassAnalysis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsConfigurationStorageClassAnalysis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_export: 'outputs.AnalyticsConfigurationStorageClassAnalysisDataExport'):
        """
        :param 'AnalyticsConfigurationStorageClassAnalysisDataExportArgs' data_export: Data export configuration (documented below).
        """
        pulumi.set(__self__, "data_export", data_export)

    @property
    @pulumi.getter(name="dataExport")
    def data_export(self) -> 'outputs.AnalyticsConfigurationStorageClassAnalysisDataExport':
        """
        Data export configuration (documented below).
        """
        return pulumi.get(self, "data_export")


@pulumi.output_type
class AnalyticsConfigurationStorageClassAnalysisDataExport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputSchemaVersion":
            suggest = "output_schema_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsConfigurationStorageClassAnalysisDataExport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsConfigurationStorageClassAnalysisDataExport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsConfigurationStorageClassAnalysisDataExport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestination',
                 output_schema_version: Optional[str] = None):
        """
        :param 'AnalyticsConfigurationStorageClassAnalysisDataExportDestinationArgs' destination: Specifies the destination for the exported analytics data (documented below).
        :param str output_schema_version: Schema version of exported analytics data. Allowed values: `V_1`. Default value: `V_1`.
        """
        pulumi.set(__self__, "destination", destination)
        if output_schema_version is not None:
            pulumi.set(__self__, "output_schema_version", output_schema_version)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestination':
        """
        Specifies the destination for the exported analytics data (documented below).
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="outputSchemaVersion")
    def output_schema_version(self) -> Optional[str]:
        """
        Schema version of exported analytics data. Allowed values: `V_1`. Default value: `V_1`.
        """
        return pulumi.get(self, "output_schema_version")


@pulumi.output_type
class AnalyticsConfigurationStorageClassAnalysisDataExportDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketDestination":
            suggest = "s3_bucket_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsConfigurationStorageClassAnalysisDataExportDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsConfigurationStorageClassAnalysisDataExportDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsConfigurationStorageClassAnalysisDataExportDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_destination: 'outputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination'):
        """
        :param 'AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestinationArgs' s3_bucket_destination: Analytics data export currently only supports an S3 bucket destination (documented below).
        """
        pulumi.set(__self__, "s3_bucket_destination", s3_bucket_destination)

    @property
    @pulumi.getter(name="s3BucketDestination")
    def s3_bucket_destination(self) -> 'outputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination':
        """
        Analytics data export currently only supports an S3 bucket destination (documented below).
        """
        return pulumi.get(self, "s3_bucket_destination")


@pulumi.output_type
class AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketArn":
            suggest = "bucket_arn"
        elif key == "bucketAccountId":
            suggest = "bucket_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: str,
                 bucket_account_id: Optional[str] = None,
                 format: Optional[str] = None,
                 prefix: Optional[str] = None):
        """
        :param str bucket_arn: ARN of the destination bucket.
        :param str bucket_account_id: Account ID that owns the destination bucket.
        :param str format: Output format of exported analytics data. Allowed values: `CSV`. Default value: `CSV`.
        :param str prefix: Prefix to append to exported analytics data.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        if bucket_account_id is not None:
            pulumi.set(__self__, "bucket_account_id", bucket_account_id)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> str:
        """
        ARN of the destination bucket.
        """
        return pulumi.get(self, "bucket_arn")

    @property
    @pulumi.getter(name="bucketAccountId")
    def bucket_account_id(self) -> Optional[str]:
        """
        Account ID that owns the destination bucket.
        """
        return pulumi.get(self, "bucket_account_id")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Output format of exported analytics data. Allowed values: `CSV`. Default value: `CSV`.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Prefix to append to exported analytics data.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class BucketAclV2AccessControlPolicy(dict):
    def __init__(__self__, *,
                 owner: 'outputs.BucketAclV2AccessControlPolicyOwner',
                 grants: Optional[Sequence['outputs.BucketAclV2AccessControlPolicyGrant']] = None):
        """
        :param 'BucketAclV2AccessControlPolicyOwnerArgs' owner: Configuration block for the bucket owner's display name and ID. See below.
        :param Sequence['BucketAclV2AccessControlPolicyGrantArgs'] grants: Set of `grant` configuration blocks. See below.
        """
        pulumi.set(__self__, "owner", owner)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)

    @property
    @pulumi.getter
    def owner(self) -> 'outputs.BucketAclV2AccessControlPolicyOwner':
        """
        Configuration block for the bucket owner's display name and ID. See below.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def grants(self) -> Optional[Sequence['outputs.BucketAclV2AccessControlPolicyGrant']]:
        """
        Set of `grant` configuration blocks. See below.
        """
        return pulumi.get(self, "grants")


@pulumi.output_type
class BucketAclV2AccessControlPolicyGrant(dict):
    def __init__(__self__, *,
                 permission: str,
                 grantee: Optional['outputs.BucketAclV2AccessControlPolicyGrantGrantee'] = None):
        """
        :param str permission: Logging permissions assigned to the grantee for the bucket. Valid values: `FULL_CONTROL`, `WRITE`, `WRITE_ACP`, `READ`, `READ_ACP`. See [What permissions can I grant?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#permissions) for more details about what each permission means in the context of buckets.
        :param 'BucketAclV2AccessControlPolicyGrantGranteeArgs' grantee: Configuration block for the person being granted permissions. See below.
        """
        pulumi.set(__self__, "permission", permission)
        if grantee is not None:
            pulumi.set(__self__, "grantee", grantee)

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        Logging permissions assigned to the grantee for the bucket. Valid values: `FULL_CONTROL`, `WRITE`, `WRITE_ACP`, `READ`, `READ_ACP`. See [What permissions can I grant?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#permissions) for more details about what each permission means in the context of buckets.
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter
    def grantee(self) -> Optional['outputs.BucketAclV2AccessControlPolicyGrantGrantee']:
        """
        Configuration block for the person being granted permissions. See below.
        """
        return pulumi.get(self, "grantee")


@pulumi.output_type
class BucketAclV2AccessControlPolicyGrantGrantee(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "emailAddress":
            suggest = "email_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAclV2AccessControlPolicyGrantGrantee. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAclV2AccessControlPolicyGrantGrantee.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAclV2AccessControlPolicyGrantGrantee.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 display_name: Optional[str] = None,
                 email_address: Optional[str] = None,
                 id: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str type: Type of grantee. Valid values: `CanonicalUser`, `AmazonCustomerByEmail`, `Group`.
        :param str display_name: Display name of the owner.
        :param str email_address: Email address of the grantee. See [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) for supported AWS regions where this argument can be specified.
        :param str id: Canonical user ID of the grantee.
        :param str uri: URI of the grantee group.
        """
        pulumi.set(__self__, "type", type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of grantee. Valid values: `CanonicalUser`, `AmazonCustomerByEmail`, `Group`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the owner.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[str]:
        """
        Email address of the grantee. See [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) for supported AWS regions where this argument can be specified.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Canonical user ID of the grantee.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        URI of the grantee group.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class BucketAclV2AccessControlPolicyOwner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAclV2AccessControlPolicyOwner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAclV2AccessControlPolicyOwner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAclV2AccessControlPolicyOwner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 display_name: Optional[str] = None):
        """
        :param str id: ID of the owner.
        :param str display_name: Display name of the owner.
        """
        pulumi.set(__self__, "id", id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the owner.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the owner.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class BucketCorsConfigurationV2CorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCorsConfigurationV2CorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCorsConfigurationV2CorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCorsConfigurationV2CorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 allowed_headers: Optional[Sequence[str]] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 id: Optional[str] = None,
                 max_age_seconds: Optional[int] = None):
        """
        :param Sequence[str] allowed_methods: Set of HTTP methods that you allow the origin to execute. Valid values are `GET`, `PUT`, `HEAD`, `POST`, and `DELETE`.
        :param Sequence[str] allowed_origins: Set of origins you want customers to be able to access the bucket from.
        :param Sequence[str] allowed_headers: Set of Headers that are specified in the `Access-Control-Request-Headers` header.
        :param Sequence[str] expose_headers: Set of headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
        :param str id: Unique identifier for the rule. The value cannot be longer than 255 characters.
        :param int max_age_seconds: Time in seconds that your browser is to cache the preflight response for the specified resource.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        """
        Set of HTTP methods that you allow the origin to execute. Valid values are `GET`, `PUT`, `HEAD`, `POST`, and `DELETE`.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        Set of origins you want customers to be able to access the bucket from.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[str]]:
        """
        Set of Headers that are specified in the `Access-Control-Request-Headers` header.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        Set of headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for the rule. The value cannot be longer than 255 characters.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[int]:
        """
        Time in seconds that your browser is to cache the preflight response for the specified resource.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class BucketCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 allowed_headers: Optional[Sequence[str]] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age_seconds: Optional[int] = None):
        """
        :param Sequence[str] allowed_methods: Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        :param Sequence[str] allowed_origins: Specifies which origins are allowed.
        :param Sequence[str] allowed_headers: Specifies which headers are allowed.
        :param Sequence[str] expose_headers: Specifies expose header in the response.
        :param int max_age_seconds: Specifies time in seconds that browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        """
        Specifies which methods are allowed. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        Specifies which origins are allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[str]]:
        """
        Specifies which headers are allowed.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        Specifies expose header in the response.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[int]:
        """
        Specifies time in seconds that browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class BucketGrant(dict):
    def __init__(__self__, *,
                 permissions: Sequence[str],
                 type: str,
                 id: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param Sequence[str] permissions: List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
        :param str type: Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
        :param str id: Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
        :param str uri: Uri address to grant for. Used only when `type` is `Group`.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Uri address to grant for. Used only when `type` is `Group`.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class BucketIntelligentTieringConfigurationFilter(dict):
    def __init__(__self__, *,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str prefix: Object key name prefix that identifies the subset of objects to which the configuration applies.
        :param Mapping[str, str] tags: All of these tags must exist in the object's tag set in order for the configuration to apply.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object key name prefix that identifies the subset of objects to which the configuration applies.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        All of these tags must exist in the object's tag set in order for the configuration to apply.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class BucketIntelligentTieringConfigurationTiering(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessTier":
            suggest = "access_tier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketIntelligentTieringConfigurationTiering. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketIntelligentTieringConfigurationTiering.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketIntelligentTieringConfigurationTiering.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_tier: str,
                 days: int):
        """
        :param str access_tier: S3 Intelligent-Tiering access tier. Valid values: `ARCHIVE_ACCESS`, `DEEP_ARCHIVE_ACCESS`.
        :param int days: Number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier.
        """
        pulumi.set(__self__, "access_tier", access_tier)
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="accessTier")
    def access_tier(self) -> str:
        """
        S3 Intelligent-Tiering access tier. Valid values: `ARCHIVE_ACCESS`, `DEEP_ARCHIVE_ACCESS`.
        """
        return pulumi.get(self, "access_tier")

    @property
    @pulumi.getter
    def days(self) -> int:
        """
        Number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleConfigurationV2Rule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUpload":
            suggest = "abort_incomplete_multipart_upload"
        elif key == "noncurrentVersionExpiration":
            suggest = "noncurrent_version_expiration"
        elif key == "noncurrentVersionTransitions":
            suggest = "noncurrent_version_transitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleConfigurationV2Rule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleConfigurationV2Rule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleConfigurationV2Rule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 status: str,
                 abort_incomplete_multipart_upload: Optional['outputs.BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUpload'] = None,
                 expiration: Optional['outputs.BucketLifecycleConfigurationV2RuleExpiration'] = None,
                 filter: Optional['outputs.BucketLifecycleConfigurationV2RuleFilter'] = None,
                 noncurrent_version_expiration: Optional['outputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionExpiration'] = None,
                 noncurrent_version_transitions: Optional[Sequence['outputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionTransition']] = None,
                 prefix: Optional[str] = None,
                 transitions: Optional[Sequence['outputs.BucketLifecycleConfigurationV2RuleTransition']] = None):
        """
        :param str id: Unique identifier for the rule. The value cannot be longer than 255 characters.
        :param str status: Whether the rule is currently being applied. Valid values: `Enabled` or `Disabled`.
        :param 'BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUploadArgs' abort_incomplete_multipart_upload: Configuration block that specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. See below.
        :param 'BucketLifecycleConfigurationV2RuleExpirationArgs' expiration: Configuration block that specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker. See below.
        :param 'BucketLifecycleConfigurationV2RuleFilterArgs' filter: Configuration block used to identify objects that a Lifecycle Rule applies to. See below. If not specified, the `rule` will default to using `prefix`.
        :param 'BucketLifecycleConfigurationV2RuleNoncurrentVersionExpirationArgs' noncurrent_version_expiration: Configuration block that specifies when noncurrent object versions expire. See below.
        :param Sequence['BucketLifecycleConfigurationV2RuleNoncurrentVersionTransitionArgs'] noncurrent_version_transitions: Set of configuration blocks that specify the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. See below.
        :param str prefix: **DEPRECATED** Use `filter` instead. This has been deprecated by Amazon S3. Prefix identifying one or more objects to which the rule applies. Defaults to an empty string (`""`) if `filter` is not specified.
        :param Sequence['BucketLifecycleConfigurationV2RuleTransitionArgs'] transitions: Set of configuration blocks that specify when an Amazon S3 object transitions to a specified storage class. See below.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        if abort_incomplete_multipart_upload is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload", abort_incomplete_multipart_upload)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if noncurrent_version_expiration is not None:
            pulumi.set(__self__, "noncurrent_version_expiration", noncurrent_version_expiration)
        if noncurrent_version_transitions is not None:
            pulumi.set(__self__, "noncurrent_version_transitions", noncurrent_version_transitions)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier for the rule. The value cannot be longer than 255 characters.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Whether the rule is currently being applied. Valid values: `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="abortIncompleteMultipartUpload")
    def abort_incomplete_multipart_upload(self) -> Optional['outputs.BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUpload']:
        """
        Configuration block that specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. See below.
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload")

    @property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.BucketLifecycleConfigurationV2RuleExpiration']:
        """
        Configuration block that specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker. See below.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketLifecycleConfigurationV2RuleFilter']:
        """
        Configuration block used to identify objects that a Lifecycle Rule applies to. See below. If not specified, the `rule` will default to using `prefix`.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="noncurrentVersionExpiration")
    def noncurrent_version_expiration(self) -> Optional['outputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionExpiration']:
        """
        Configuration block that specifies when noncurrent object versions expire. See below.
        """
        return pulumi.get(self, "noncurrent_version_expiration")

    @property
    @pulumi.getter(name="noncurrentVersionTransitions")
    def noncurrent_version_transitions(self) -> Optional[Sequence['outputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionTransition']]:
        """
        Set of configuration blocks that specify the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. See below.
        """
        return pulumi.get(self, "noncurrent_version_transitions")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use filter instead""")
    def prefix(self) -> Optional[str]:
        """
        **DEPRECATED** Use `filter` instead. This has been deprecated by Amazon S3. Prefix identifying one or more objects to which the rule applies. Defaults to an empty string (`""`) if `filter` is not specified.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.BucketLifecycleConfigurationV2RuleTransition']]:
        """
        Set of configuration blocks that specify when an Amazon S3 object transitions to a specified storage class. See below.
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUpload(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysAfterInitiation":
            suggest = "days_after_initiation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUpload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUpload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUpload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_after_initiation: Optional[int] = None):
        """
        :param int days_after_initiation: Number of days after which Amazon S3 aborts an incomplete multipart upload.
        """
        if days_after_initiation is not None:
            pulumi.set(__self__, "days_after_initiation", days_after_initiation)

    @property
    @pulumi.getter(name="daysAfterInitiation")
    def days_after_initiation(self) -> Optional[int]:
        """
        Number of days after which Amazon S3 aborts an incomplete multipart upload.
        """
        return pulumi.get(self, "days_after_initiation")


@pulumi.output_type
class BucketLifecycleConfigurationV2RuleExpiration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredObjectDeleteMarker":
            suggest = "expired_object_delete_marker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleConfigurationV2RuleExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleConfigurationV2RuleExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleConfigurationV2RuleExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[str] = None,
                 days: Optional[int] = None,
                 expired_object_delete_marker: Optional[bool] = None):
        """
        :param str date: Date the object is to be moved or deleted. The date value must be in [RFC3339 full-date format](https://datatracker.ietf.org/doc/html/rfc3339#section-5.6) e.g. `2023-08-22`.
        :param int days: Lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.
        :param bool expired_object_delete_marker: Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to `true`, the delete marker will be expired; if set to `false` the policy takes no action.
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        Date the object is to be moved or deleted. The date value must be in [RFC3339 full-date format](https://datatracker.ietf.org/doc/html/rfc3339#section-5.6) e.g. `2023-08-22`.
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[bool]:
        """
        Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to `true`, the delete marker will be expired; if set to `false` the policy takes no action.
        """
        return pulumi.get(self, "expired_object_delete_marker")


@pulumi.output_type
class BucketLifecycleConfigurationV2RuleFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "and":
            suggest = "and_"
        elif key == "objectSizeGreaterThan":
            suggest = "object_size_greater_than"
        elif key == "objectSizeLessThan":
            suggest = "object_size_less_than"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleConfigurationV2RuleFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleConfigurationV2RuleFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleConfigurationV2RuleFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 and_: Optional['outputs.BucketLifecycleConfigurationV2RuleFilterAnd'] = None,
                 object_size_greater_than: Optional[str] = None,
                 object_size_less_than: Optional[str] = None,
                 prefix: Optional[str] = None,
                 tag: Optional['outputs.BucketLifecycleConfigurationV2RuleFilterTag'] = None):
        """
        :param 'BucketLifecycleConfigurationV2RuleFilterAndArgs' and_: Configuration block used to apply a logical `AND` to two or more predicates. See below. The Lifecycle Rule will apply to any object matching all the predicates configured inside the `and` block.
        :param str object_size_greater_than: Minimum object size (in bytes) to which the rule applies.
        :param str object_size_less_than: Maximum object size (in bytes) to which the rule applies.
        :param str prefix: Prefix identifying one or more objects to which the rule applies. Defaults to an empty string (`""`) if not specified.
        :param 'BucketLifecycleConfigurationV2RuleFilterTagArgs' tag: Configuration block for specifying a tag key and value. See below.
        """
        if and_ is not None:
            pulumi.set(__self__, "and_", and_)
        if object_size_greater_than is not None:
            pulumi.set(__self__, "object_size_greater_than", object_size_greater_than)
        if object_size_less_than is not None:
            pulumi.set(__self__, "object_size_less_than", object_size_less_than)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="and")
    def and_(self) -> Optional['outputs.BucketLifecycleConfigurationV2RuleFilterAnd']:
        """
        Configuration block used to apply a logical `AND` to two or more predicates. See below. The Lifecycle Rule will apply to any object matching all the predicates configured inside the `and` block.
        """
        return pulumi.get(self, "and_")

    @property
    @pulumi.getter(name="objectSizeGreaterThan")
    def object_size_greater_than(self) -> Optional[str]:
        """
        Minimum object size (in bytes) to which the rule applies.
        """
        return pulumi.get(self, "object_size_greater_than")

    @property
    @pulumi.getter(name="objectSizeLessThan")
    def object_size_less_than(self) -> Optional[str]:
        """
        Maximum object size (in bytes) to which the rule applies.
        """
        return pulumi.get(self, "object_size_less_than")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Prefix identifying one or more objects to which the rule applies. Defaults to an empty string (`""`) if not specified.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tag(self) -> Optional['outputs.BucketLifecycleConfigurationV2RuleFilterTag']:
        """
        Configuration block for specifying a tag key and value. See below.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class BucketLifecycleConfigurationV2RuleFilterAnd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectSizeGreaterThan":
            suggest = "object_size_greater_than"
        elif key == "objectSizeLessThan":
            suggest = "object_size_less_than"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleConfigurationV2RuleFilterAnd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleConfigurationV2RuleFilterAnd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleConfigurationV2RuleFilterAnd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_size_greater_than: Optional[int] = None,
                 object_size_less_than: Optional[int] = None,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param int object_size_greater_than: Minimum object size to which the rule applies. Value must be at least `0` if specified. Defaults to 128000 (128 KB) for all `storage_class` values unless `transition_default_minimum_object_size` specifies otherwise.
        :param int object_size_less_than: Maximum object size to which the rule applies. Value must be at least `1` if specified.
        :param str prefix: Prefix identifying one or more objects to which the rule applies.
        :param Mapping[str, str] tags: Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
        """
        if object_size_greater_than is not None:
            pulumi.set(__self__, "object_size_greater_than", object_size_greater_than)
        if object_size_less_than is not None:
            pulumi.set(__self__, "object_size_less_than", object_size_less_than)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="objectSizeGreaterThan")
    def object_size_greater_than(self) -> Optional[int]:
        """
        Minimum object size to which the rule applies. Value must be at least `0` if specified. Defaults to 128000 (128 KB) for all `storage_class` values unless `transition_default_minimum_object_size` specifies otherwise.
        """
        return pulumi.get(self, "object_size_greater_than")

    @property
    @pulumi.getter(name="objectSizeLessThan")
    def object_size_less_than(self) -> Optional[int]:
        """
        Maximum object size to which the rule applies. Value must be at least `1` if specified.
        """
        return pulumi.get(self, "object_size_less_than")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Prefix identifying one or more objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class BucketLifecycleConfigurationV2RuleFilterTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: Name of the object key.
        :param str value: Value of the tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Name of the object key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the tag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BucketLifecycleConfigurationV2RuleNoncurrentVersionExpiration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newerNoncurrentVersions":
            suggest = "newer_noncurrent_versions"
        elif key == "noncurrentDays":
            suggest = "noncurrent_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleConfigurationV2RuleNoncurrentVersionExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleConfigurationV2RuleNoncurrentVersionExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleConfigurationV2RuleNoncurrentVersionExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 newer_noncurrent_versions: Optional[str] = None,
                 noncurrent_days: Optional[int] = None):
        """
        :param str newer_noncurrent_versions: Number of noncurrent versions Amazon S3 will retain. Must be a non-zero positive integer.
        :param int noncurrent_days: Number of days an object is noncurrent before Amazon S3 can perform the associated action. Must be a positive integer.
        """
        if newer_noncurrent_versions is not None:
            pulumi.set(__self__, "newer_noncurrent_versions", newer_noncurrent_versions)
        if noncurrent_days is not None:
            pulumi.set(__self__, "noncurrent_days", noncurrent_days)

    @property
    @pulumi.getter(name="newerNoncurrentVersions")
    def newer_noncurrent_versions(self) -> Optional[str]:
        """
        Number of noncurrent versions Amazon S3 will retain. Must be a non-zero positive integer.
        """
        return pulumi.get(self, "newer_noncurrent_versions")

    @property
    @pulumi.getter(name="noncurrentDays")
    def noncurrent_days(self) -> Optional[int]:
        """
        Number of days an object is noncurrent before Amazon S3 can perform the associated action. Must be a positive integer.
        """
        return pulumi.get(self, "noncurrent_days")


@pulumi.output_type
class BucketLifecycleConfigurationV2RuleNoncurrentVersionTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"
        elif key == "newerNoncurrentVersions":
            suggest = "newer_noncurrent_versions"
        elif key == "noncurrentDays":
            suggest = "noncurrent_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleConfigurationV2RuleNoncurrentVersionTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleConfigurationV2RuleNoncurrentVersionTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleConfigurationV2RuleNoncurrentVersionTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: str,
                 newer_noncurrent_versions: Optional[str] = None,
                 noncurrent_days: Optional[int] = None):
        """
        :param str storage_class: Class of storage used to store the object. Valid Values: `GLACIER`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `DEEP_ARCHIVE`, `GLACIER_IR`.
        :param str newer_noncurrent_versions: Number of noncurrent versions Amazon S3 will retain. Must be a non-zero positive integer.
        :param int noncurrent_days: Number of days an object is noncurrent before Amazon S3 can perform the associated action.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if newer_noncurrent_versions is not None:
            pulumi.set(__self__, "newer_noncurrent_versions", newer_noncurrent_versions)
        if noncurrent_days is not None:
            pulumi.set(__self__, "noncurrent_days", noncurrent_days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        Class of storage used to store the object. Valid Values: `GLACIER`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `DEEP_ARCHIVE`, `GLACIER_IR`.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="newerNoncurrentVersions")
    def newer_noncurrent_versions(self) -> Optional[str]:
        """
        Number of noncurrent versions Amazon S3 will retain. Must be a non-zero positive integer.
        """
        return pulumi.get(self, "newer_noncurrent_versions")

    @property
    @pulumi.getter(name="noncurrentDays")
    def noncurrent_days(self) -> Optional[int]:
        """
        Number of days an object is noncurrent before Amazon S3 can perform the associated action.
        """
        return pulumi.get(self, "noncurrent_days")


@pulumi.output_type
class BucketLifecycleConfigurationV2RuleTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleConfigurationV2RuleTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleConfigurationV2RuleTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleConfigurationV2RuleTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: str,
                 date: Optional[str] = None,
                 days: Optional[int] = None):
        """
        :param str storage_class: Class of storage used to store the object. Valid Values: `GLACIER`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `DEEP_ARCHIVE`, `GLACIER_IR`.
        :param str date: Date objects are transitioned to the specified storage class. The date value must be in [RFC3339 full-date format](https://datatracker.ietf.org/doc/html/rfc3339#section-5.6) e.g. `2023-08-22`.
        :param int days: Number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer. If both `days` and `date` are not specified, defaults to `0`. Valid values depend on `storage_class`, see [Transition objects using Amazon S3 Lifecycle](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-transition-general-considerations.html) for more details.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        Class of storage used to store the object. Valid Values: `GLACIER`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`, `DEEP_ARCHIVE`, `GLACIER_IR`.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        Date objects are transitioned to the specified storage class. The date value must be in [RFC3339 full-date format](https://datatracker.ietf.org/doc/html/rfc3339#section-5.6) e.g. `2023-08-22`.
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer. If both `days` and `date` are not specified, defaults to `0`. Valid values depend on `storage_class`, see [Transition objects using Amazon S3 Lifecycle](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-transition-general-considerations.html) for more details.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUploadDays":
            suggest = "abort_incomplete_multipart_upload_days"
        elif key == "noncurrentVersionExpiration":
            suggest = "noncurrent_version_expiration"
        elif key == "noncurrentVersionTransitions":
            suggest = "noncurrent_version_transitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 abort_incomplete_multipart_upload_days: Optional[int] = None,
                 expiration: Optional['outputs.BucketLifecycleRuleExpiration'] = None,
                 id: Optional[str] = None,
                 noncurrent_version_expiration: Optional['outputs.BucketLifecycleRuleNoncurrentVersionExpiration'] = None,
                 noncurrent_version_transitions: Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionTransition']] = None,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 transitions: Optional[Sequence['outputs.BucketLifecycleRuleTransition']] = None):
        """
        :param bool enabled: Specifies lifecycle rule status.
        :param int abort_incomplete_multipart_upload_days: Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
        :param 'BucketLifecycleRuleExpirationArgs' expiration: Specifies a period in the object's expire (documented below).
        :param str id: Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        :param 'BucketLifecycleRuleNoncurrentVersionExpirationArgs' noncurrent_version_expiration: Specifies when noncurrent object versions expire (documented below).
        :param Sequence['BucketLifecycleRuleNoncurrentVersionTransitionArgs'] noncurrent_version_transitions: Specifies when noncurrent object versions transitions (documented below).
               
               At least one of `abort_incomplete_multipart_upload_days`, `expiration`, `transition`, `noncurrent_version_expiration`, `noncurrent_version_transition` must be specified.
        :param str prefix: Object key prefix identifying one or more objects to which the rule applies.
        :param Mapping[str, str] tags: Specifies object tags key and value.
        :param Sequence['BucketLifecycleRuleTransitionArgs'] transitions: Specifies a period in the object's transitions (documented below).
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_incomplete_multipart_upload_days is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if noncurrent_version_expiration is not None:
            pulumi.set(__self__, "noncurrent_version_expiration", noncurrent_version_expiration)
        if noncurrent_version_transitions is not None:
            pulumi.set(__self__, "noncurrent_version_transitions", noncurrent_version_transitions)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies lifecycle rule status.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> Optional[int]:
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.BucketLifecycleRuleExpiration']:
        """
        Specifies a period in the object's expire (documented below).
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="noncurrentVersionExpiration")
    def noncurrent_version_expiration(self) -> Optional['outputs.BucketLifecycleRuleNoncurrentVersionExpiration']:
        """
        Specifies when noncurrent object versions expire (documented below).
        """
        return pulumi.get(self, "noncurrent_version_expiration")

    @property
    @pulumi.getter(name="noncurrentVersionTransitions")
    def noncurrent_version_transitions(self) -> Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionTransition']]:
        """
        Specifies when noncurrent object versions transitions (documented below).

        At least one of `abort_incomplete_multipart_upload_days`, `expiration`, `transition`, `noncurrent_version_expiration`, `noncurrent_version_transition` must be specified.
        """
        return pulumi.get(self, "noncurrent_version_transitions")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object key prefix identifying one or more objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Specifies object tags key and value.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.BucketLifecycleRuleTransition']]:
        """
        Specifies a period in the object's transitions (documented below).
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class BucketLifecycleRuleExpiration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredObjectDeleteMarker":
            suggest = "expired_object_delete_marker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[str] = None,
                 days: Optional[int] = None,
                 expired_object_delete_marker: Optional[bool] = None):
        """
        :param str date: Specifies the date after which you want the corresponding action to take effect.
        :param int days: Specifies the number of days after object creation when the specific rule action takes effect.
        :param bool expired_object_delete_marker: On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct Amazon S3 to delete expired object delete markers. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        Specifies the date after which you want the corresponding action to take effect.
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[bool]:
        """
        On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct Amazon S3 to delete expired object delete markers. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.
        """
        return pulumi.get(self, "expired_object_delete_marker")


@pulumi.output_type
class BucketLifecycleRuleNoncurrentVersionExpiration(dict):
    def __init__(__self__, *,
                 days: Optional[int] = None):
        """
        :param int days: Specifies the number of days noncurrent object versions expire.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days noncurrent object versions expire.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRuleNoncurrentVersionTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleNoncurrentVersionTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleNoncurrentVersionTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleNoncurrentVersionTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: str,
                 days: Optional[int] = None):
        """
        :param str storage_class: Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
        :param int days: Specifies the number of days noncurrent object versions transition.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRuleTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: str,
                 date: Optional[str] = None,
                 days: Optional[int] = None):
        """
        :param str storage_class: Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
        :param str date: Specifies the date after which you want the corresponding action to take effect.
        :param int days: Specifies the number of days after object creation when the specific rule action takes effect.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        Specifies the date after which you want the corresponding action to take effect.
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetBucket":
            suggest = "target_bucket"
        elif key == "targetPrefix":
            suggest = "target_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_bucket: str,
                 target_prefix: Optional[str] = None):
        """
        :param str target_bucket: The name of the bucket that will receive the log objects.
        :param str target_prefix: To specify a key prefix for log objects.
        """
        pulumi.set(__self__, "target_bucket", target_bucket)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)

    @property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> str:
        """
        The name of the bucket that will receive the log objects.
        """
        return pulumi.get(self, "target_bucket")

    @property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[str]:
        """
        To specify a key prefix for log objects.
        """
        return pulumi.get(self, "target_prefix")


@pulumi.output_type
class BucketLoggingV2TargetGrant(dict):
    def __init__(__self__, *,
                 grantee: 'outputs.BucketLoggingV2TargetGrantGrantee',
                 permission: str):
        """
        :param 'BucketLoggingV2TargetGrantGranteeArgs' grantee: Configuration block for the person being granted permissions. See below.
        :param str permission: Logging permissions assigned to the grantee for the bucket. Valid values: `FULL_CONTROL`, `READ`, `WRITE`.
        """
        pulumi.set(__self__, "grantee", grantee)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def grantee(self) -> 'outputs.BucketLoggingV2TargetGrantGrantee':
        """
        Configuration block for the person being granted permissions. See below.
        """
        return pulumi.get(self, "grantee")

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        Logging permissions assigned to the grantee for the bucket. Valid values: `FULL_CONTROL`, `READ`, `WRITE`.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class BucketLoggingV2TargetGrantGrantee(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "emailAddress":
            suggest = "email_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLoggingV2TargetGrantGrantee. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLoggingV2TargetGrantGrantee.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLoggingV2TargetGrantGrantee.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 display_name: Optional[str] = None,
                 email_address: Optional[str] = None,
                 id: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str type: Type of grantee. Valid values: `CanonicalUser`, `AmazonCustomerByEmail`, `Group`.
        :param str email_address: Email address of the grantee. See [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) for supported AWS regions where this argument can be specified.
        :param str id: Canonical user ID of the grantee.
        :param str uri: URI of the grantee group.
        """
        pulumi.set(__self__, "type", type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of grantee. Valid values: `CanonicalUser`, `AmazonCustomerByEmail`, `Group`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[str]:
        """
        Email address of the grantee. See [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) for supported AWS regions where this argument can be specified.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Canonical user ID of the grantee.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        URI of the grantee group.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class BucketLoggingV2TargetObjectKeyFormat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionedPrefix":
            suggest = "partitioned_prefix"
        elif key == "simplePrefix":
            suggest = "simple_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLoggingV2TargetObjectKeyFormat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLoggingV2TargetObjectKeyFormat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLoggingV2TargetObjectKeyFormat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partitioned_prefix: Optional['outputs.BucketLoggingV2TargetObjectKeyFormatPartitionedPrefix'] = None,
                 simple_prefix: Optional['outputs.BucketLoggingV2TargetObjectKeyFormatSimplePrefix'] = None):
        """
        :param 'BucketLoggingV2TargetObjectKeyFormatPartitionedPrefixArgs' partitioned_prefix: Partitioned S3 key for log objects. See below.
        :param 'BucketLoggingV2TargetObjectKeyFormatSimplePrefixArgs' simple_prefix: Use the simple format for S3 keys for log objects. To use, set `simple_prefix {}`.
        """
        if partitioned_prefix is not None:
            pulumi.set(__self__, "partitioned_prefix", partitioned_prefix)
        if simple_prefix is not None:
            pulumi.set(__self__, "simple_prefix", simple_prefix)

    @property
    @pulumi.getter(name="partitionedPrefix")
    def partitioned_prefix(self) -> Optional['outputs.BucketLoggingV2TargetObjectKeyFormatPartitionedPrefix']:
        """
        Partitioned S3 key for log objects. See below.
        """
        return pulumi.get(self, "partitioned_prefix")

    @property
    @pulumi.getter(name="simplePrefix")
    def simple_prefix(self) -> Optional['outputs.BucketLoggingV2TargetObjectKeyFormatSimplePrefix']:
        """
        Use the simple format for S3 keys for log objects. To use, set `simple_prefix {}`.
        """
        return pulumi.get(self, "simple_prefix")


@pulumi.output_type
class BucketLoggingV2TargetObjectKeyFormatPartitionedPrefix(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionDateSource":
            suggest = "partition_date_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLoggingV2TargetObjectKeyFormatPartitionedPrefix. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLoggingV2TargetObjectKeyFormatPartitionedPrefix.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLoggingV2TargetObjectKeyFormatPartitionedPrefix.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partition_date_source: str):
        """
        :param str partition_date_source: Specifies the partition date source for the partitioned prefix. Valid values: `EventTime`, `DeliveryTime`.
        """
        pulumi.set(__self__, "partition_date_source", partition_date_source)

    @property
    @pulumi.getter(name="partitionDateSource")
    def partition_date_source(self) -> str:
        """
        Specifies the partition date source for the partitioned prefix. Valid values: `EventTime`, `DeliveryTime`.
        """
        return pulumi.get(self, "partition_date_source")


@pulumi.output_type
class BucketLoggingV2TargetObjectKeyFormatSimplePrefix(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class BucketMetricFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessPoint":
            suggest = "access_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketMetricFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketMetricFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketMetricFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_point: Optional[str] = None,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str access_point: S3 Access Point ARN for filtering (singular).
        :param str prefix: Object prefix for filtering (singular).
        :param Mapping[str, str] tags: Object tags for filtering (up to 10).
        """
        if access_point is not None:
            pulumi.set(__self__, "access_point", access_point)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accessPoint")
    def access_point(self) -> Optional[str]:
        """
        S3 Access Point ARN for filtering (singular).
        """
        return pulumi.get(self, "access_point")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object prefix for filtering (singular).
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Object tags for filtering (up to 10).
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class BucketNotificationLambdaFunction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterPrefix":
            suggest = "filter_prefix"
        elif key == "filterSuffix":
            suggest = "filter_suffix"
        elif key == "lambdaFunctionArn":
            suggest = "lambda_function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketNotificationLambdaFunction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketNotificationLambdaFunction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketNotificationLambdaFunction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 events: Sequence[str],
                 filter_prefix: Optional[str] = None,
                 filter_suffix: Optional[str] = None,
                 id: Optional[str] = None,
                 lambda_function_arn: Optional[str] = None):
        """
        :param Sequence[str] events: [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        :param str filter_prefix: Object key name prefix.
        :param str filter_suffix: Object key name suffix.
        :param str id: Unique identifier for each of the notification configurations.
        :param str lambda_function_arn: Lambda function ARN.
        """
        pulumi.set(__self__, "events", events)
        if filter_prefix is not None:
            pulumi.set(__self__, "filter_prefix", filter_prefix)
        if filter_suffix is not None:
            pulumi.set(__self__, "filter_suffix", filter_suffix)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if lambda_function_arn is not None:
            pulumi.set(__self__, "lambda_function_arn", lambda_function_arn)

    @property
    @pulumi.getter
    def events(self) -> Sequence[str]:
        """
        [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="filterPrefix")
    def filter_prefix(self) -> Optional[str]:
        """
        Object key name prefix.
        """
        return pulumi.get(self, "filter_prefix")

    @property
    @pulumi.getter(name="filterSuffix")
    def filter_suffix(self) -> Optional[str]:
        """
        Object key name suffix.
        """
        return pulumi.get(self, "filter_suffix")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for each of the notification configurations.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lambdaFunctionArn")
    def lambda_function_arn(self) -> Optional[str]:
        """
        Lambda function ARN.
        """
        return pulumi.get(self, "lambda_function_arn")


@pulumi.output_type
class BucketNotificationQueue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueArn":
            suggest = "queue_arn"
        elif key == "filterPrefix":
            suggest = "filter_prefix"
        elif key == "filterSuffix":
            suggest = "filter_suffix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketNotificationQueue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketNotificationQueue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketNotificationQueue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 events: Sequence[str],
                 queue_arn: str,
                 filter_prefix: Optional[str] = None,
                 filter_suffix: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param Sequence[str] events: Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        :param str queue_arn: SQS queue ARN.
        :param str filter_prefix: Object key name prefix.
        :param str filter_suffix: Object key name suffix.
        :param str id: Unique identifier for each of the notification configurations.
        """
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "queue_arn", queue_arn)
        if filter_prefix is not None:
            pulumi.set(__self__, "filter_prefix", filter_prefix)
        if filter_suffix is not None:
            pulumi.set(__self__, "filter_suffix", filter_suffix)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def events(self) -> Sequence[str]:
        """
        Specifies [event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="queueArn")
    def queue_arn(self) -> str:
        """
        SQS queue ARN.
        """
        return pulumi.get(self, "queue_arn")

    @property
    @pulumi.getter(name="filterPrefix")
    def filter_prefix(self) -> Optional[str]:
        """
        Object key name prefix.
        """
        return pulumi.get(self, "filter_prefix")

    @property
    @pulumi.getter(name="filterSuffix")
    def filter_suffix(self) -> Optional[str]:
        """
        Object key name suffix.
        """
        return pulumi.get(self, "filter_suffix")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for each of the notification configurations.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class BucketNotificationTopic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicArn":
            suggest = "topic_arn"
        elif key == "filterPrefix":
            suggest = "filter_prefix"
        elif key == "filterSuffix":
            suggest = "filter_suffix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketNotificationTopic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketNotificationTopic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketNotificationTopic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 events: Sequence[str],
                 topic_arn: str,
                 filter_prefix: Optional[str] = None,
                 filter_suffix: Optional[str] = None,
                 id: Optional[str] = None):
        """
        :param Sequence[str] events: [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        :param str topic_arn: SNS topic ARN.
        :param str filter_prefix: Object key name prefix.
        :param str filter_suffix: Object key name suffix.
        :param str id: Unique identifier for each of the notification configurations.
        """
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "topic_arn", topic_arn)
        if filter_prefix is not None:
            pulumi.set(__self__, "filter_prefix", filter_prefix)
        if filter_suffix is not None:
            pulumi.set(__self__, "filter_suffix", filter_suffix)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def events(self) -> Sequence[str]:
        """
        [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> str:
        """
        SNS topic ARN.
        """
        return pulumi.get(self, "topic_arn")

    @property
    @pulumi.getter(name="filterPrefix")
    def filter_prefix(self) -> Optional[str]:
        """
        Object key name prefix.
        """
        return pulumi.get(self, "filter_prefix")

    @property
    @pulumi.getter(name="filterSuffix")
    def filter_suffix(self) -> Optional[str]:
        """
        Object key name suffix.
        """
        return pulumi.get(self, "filter_suffix")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for each of the notification configurations.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class BucketObjectLockConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectLockEnabled":
            suggest = "object_lock_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectLockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectLockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectLockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_lock_enabled: str,
                 rule: Optional['outputs.BucketObjectLockConfigurationRule'] = None):
        """
        :param str object_lock_enabled: Indicates whether this bucket has an Object Lock configuration enabled. Valid value is `Enabled`.
        :param 'BucketObjectLockConfigurationRuleArgs' rule: The Object Lock rule in place for this bucket.
        """
        pulumi.set(__self__, "object_lock_enabled", object_lock_enabled)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> str:
        """
        Indicates whether this bucket has an Object Lock configuration enabled. Valid value is `Enabled`.
        """
        return pulumi.get(self, "object_lock_enabled")

    @property
    @pulumi.getter
    def rule(self) -> Optional['outputs.BucketObjectLockConfigurationRule']:
        """
        The Object Lock rule in place for this bucket.
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class BucketObjectLockConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRetention":
            suggest = "default_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectLockConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectLockConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectLockConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_retention: 'outputs.BucketObjectLockConfigurationRuleDefaultRetention'):
        """
        :param 'BucketObjectLockConfigurationRuleDefaultRetentionArgs' default_retention: The default retention period that you want to apply to new objects placed in this bucket.
        """
        pulumi.set(__self__, "default_retention", default_retention)

    @property
    @pulumi.getter(name="defaultRetention")
    def default_retention(self) -> 'outputs.BucketObjectLockConfigurationRuleDefaultRetention':
        """
        The default retention period that you want to apply to new objects placed in this bucket.
        """
        return pulumi.get(self, "default_retention")


@pulumi.output_type
class BucketObjectLockConfigurationRuleDefaultRetention(dict):
    def __init__(__self__, *,
                 mode: str,
                 days: Optional[int] = None,
                 years: Optional[int] = None):
        """
        :param str mode: The default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        :param int days: The number of days that you want to specify for the default retention period.
        :param int years: The number of years that you want to specify for the default retention period.
               
               Either `days` or `years` must be specified, but not both.
               
               > **NOTE on `object_lock_configuration`:** You can only enable S3 Object Lock for new buckets. If you need to turn on S3 Object Lock for an existing bucket, please contact AWS Support.
               When you create a bucket with S3 Object Lock enabled, Amazon S3 automatically enables versioning for the bucket.
               Once you create a bucket with S3 Object Lock enabled, you can't disable Object Lock or suspend versioning for the bucket.
        """
        pulumi.set(__self__, "mode", mode)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        The default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        The number of days that you want to specify for the default retention period.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def years(self) -> Optional[int]:
        """
        The number of years that you want to specify for the default retention period.

        Either `days` or `years` must be specified, but not both.

        > **NOTE on `object_lock_configuration`:** You can only enable S3 Object Lock for new buckets. If you need to turn on S3 Object Lock for an existing bucket, please contact AWS Support.
        When you create a bucket with S3 Object Lock enabled, Amazon S3 automatically enables versioning for the bucket.
        Once you create a bucket with S3 Object Lock enabled, you can't disable Object Lock or suspend versioning for the bucket.
        """
        return pulumi.get(self, "years")


@pulumi.output_type
class BucketObjectLockConfigurationV2Rule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRetention":
            suggest = "default_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectLockConfigurationV2Rule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectLockConfigurationV2Rule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectLockConfigurationV2Rule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_retention: 'outputs.BucketObjectLockConfigurationV2RuleDefaultRetention'):
        """
        :param 'BucketObjectLockConfigurationV2RuleDefaultRetentionArgs' default_retention: Configuration block for specifying the default Object Lock retention settings for new objects placed in the specified bucket. See below.
        """
        pulumi.set(__self__, "default_retention", default_retention)

    @property
    @pulumi.getter(name="defaultRetention")
    def default_retention(self) -> 'outputs.BucketObjectLockConfigurationV2RuleDefaultRetention':
        """
        Configuration block for specifying the default Object Lock retention settings for new objects placed in the specified bucket. See below.
        """
        return pulumi.get(self, "default_retention")


@pulumi.output_type
class BucketObjectLockConfigurationV2RuleDefaultRetention(dict):
    def __init__(__self__, *,
                 days: Optional[int] = None,
                 mode: Optional[str] = None,
                 years: Optional[int] = None):
        """
        :param int days: Number of days that you want to specify for the default retention period.
        :param str mode: Default Object Lock retention mode you want to apply to new objects placed in the specified bucket. Valid values: `COMPLIANCE`, `GOVERNANCE`.
        :param int years: Number of years that you want to specify for the default retention period.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Number of days that you want to specify for the default retention period.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Default Object Lock retention mode you want to apply to new objects placed in the specified bucket. Valid values: `COMPLIANCE`, `GOVERNANCE`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def years(self) -> Optional[int]:
        """
        Number of years that you want to specify for the default retention period.
        """
        return pulumi.get(self, "years")


@pulumi.output_type
class BucketObjectv2OverrideProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultTags":
            suggest = "default_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectv2OverrideProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectv2OverrideProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectv2OverrideProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_tags: Optional['outputs.BucketObjectv2OverrideProviderDefaultTags'] = None):
        """
        :param 'BucketObjectv2OverrideProviderDefaultTagsArgs' default_tags: Override the provider `default_tags` configuration block.
        """
        if default_tags is not None:
            pulumi.set(__self__, "default_tags", default_tags)

    @property
    @pulumi.getter(name="defaultTags")
    def default_tags(self) -> Optional['outputs.BucketObjectv2OverrideProviderDefaultTags']:
        """
        Override the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "default_tags")


@pulumi.output_type
class BucketObjectv2OverrideProviderDefaultTags(dict):
    def __init__(__self__, *,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class BucketOwnershipControlsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectOwnership":
            suggest = "object_ownership"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketOwnershipControlsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketOwnershipControlsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketOwnershipControlsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_ownership: str):
        """
        :param str object_ownership: Object ownership. Valid values: `BucketOwnerPreferred`, `ObjectWriter` or `BucketOwnerEnforced`
               * `BucketOwnerPreferred` - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the `bucket-owner-full-control` canned ACL.
               * `ObjectWriter` - Uploading account will own the object if the object is uploaded with the `bucket-owner-full-control` canned ACL.
               * `BucketOwnerEnforced` - Bucket owner automatically owns and has full control over every object in the bucket. ACLs no longer affect permissions to data in the S3 bucket.
        """
        pulumi.set(__self__, "object_ownership", object_ownership)

    @property
    @pulumi.getter(name="objectOwnership")
    def object_ownership(self) -> str:
        """
        Object ownership. Valid values: `BucketOwnerPreferred`, `ObjectWriter` or `BucketOwnerEnforced`
        * `BucketOwnerPreferred` - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the `bucket-owner-full-control` canned ACL.
        * `ObjectWriter` - Uploading account will own the object if the object is uploaded with the `bucket-owner-full-control` canned ACL.
        * `BucketOwnerEnforced` - Bucket owner automatically owns and has full control over every object in the bucket. ACLs no longer affect permissions to data in the S3 bucket.
        """
        return pulumi.get(self, "object_ownership")


@pulumi.output_type
class BucketReplicationConfigRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteMarkerReplication":
            suggest = "delete_marker_replication"
        elif key == "existingObjectReplication":
            suggest = "existing_object_replication"
        elif key == "sourceSelectionCriteria":
            suggest = "source_selection_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationConfigRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationConfigRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationConfigRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.BucketReplicationConfigRuleDestination',
                 status: str,
                 delete_marker_replication: Optional['outputs.BucketReplicationConfigRuleDeleteMarkerReplication'] = None,
                 existing_object_replication: Optional['outputs.BucketReplicationConfigRuleExistingObjectReplication'] = None,
                 filter: Optional['outputs.BucketReplicationConfigRuleFilter'] = None,
                 id: Optional[str] = None,
                 prefix: Optional[str] = None,
                 priority: Optional[int] = None,
                 source_selection_criteria: Optional['outputs.BucketReplicationConfigRuleSourceSelectionCriteria'] = None):
        """
        :param 'BucketReplicationConfigRuleDestinationArgs' destination: Specifies the destination for the rule. See below.
        :param str status: Status of the rule. Either `"Enabled"` or `"Disabled"`. The rule is ignored if status is not "Enabled".
        :param 'BucketReplicationConfigRuleDeleteMarkerReplicationArgs' delete_marker_replication: Whether delete markers are replicated. This argument is only valid with V2 replication configurations (i.e., when `filter` is used)documented below.
        :param 'BucketReplicationConfigRuleExistingObjectReplicationArgs' existing_object_replication: Replicate existing objects in the source bucket according to the rule configurations. See below.
        :param 'BucketReplicationConfigRuleFilterArgs' filter: Filter that identifies subset of objects to which the replication rule applies. See below. If not specified, the `rule` will default to using `prefix`.
        :param str id: Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        :param str prefix: Object key name prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length. Defaults to an empty string (`""`) if `filter` is not specified.
        :param int priority: Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
        :param 'BucketReplicationConfigRuleSourceSelectionCriteriaArgs' source_selection_criteria: Specifies special object selection criteria. See below.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "status", status)
        if delete_marker_replication is not None:
            pulumi.set(__self__, "delete_marker_replication", delete_marker_replication)
        if existing_object_replication is not None:
            pulumi.set(__self__, "existing_object_replication", existing_object_replication)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_selection_criteria is not None:
            pulumi.set(__self__, "source_selection_criteria", source_selection_criteria)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.BucketReplicationConfigRuleDestination':
        """
        Specifies the destination for the rule. See below.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the rule. Either `"Enabled"` or `"Disabled"`. The rule is ignored if status is not "Enabled".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="deleteMarkerReplication")
    def delete_marker_replication(self) -> Optional['outputs.BucketReplicationConfigRuleDeleteMarkerReplication']:
        """
        Whether delete markers are replicated. This argument is only valid with V2 replication configurations (i.e., when `filter` is used)documented below.
        """
        return pulumi.get(self, "delete_marker_replication")

    @property
    @pulumi.getter(name="existingObjectReplication")
    def existing_object_replication(self) -> Optional['outputs.BucketReplicationConfigRuleExistingObjectReplication']:
        """
        Replicate existing objects in the source bucket according to the rule configurations. See below.
        """
        return pulumi.get(self, "existing_object_replication")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketReplicationConfigRuleFilter']:
        """
        Filter that identifies subset of objects to which the replication rule applies. See below. If not specified, the `rule` will default to using `prefix`.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use filter instead""")
    def prefix(self) -> Optional[str]:
        """
        Object key name prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length. Defaults to an empty string (`""`) if `filter` is not specified.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceSelectionCriteria")
    def source_selection_criteria(self) -> Optional['outputs.BucketReplicationConfigRuleSourceSelectionCriteria']:
        """
        Specifies special object selection criteria. See below.
        """
        return pulumi.get(self, "source_selection_criteria")


@pulumi.output_type
class BucketReplicationConfigRuleDeleteMarkerReplication(dict):
    def __init__(__self__, *,
                 status: str):
        """
        :param str status: Whether delete markers should be replicated. Either `"Enabled"` or `"Disabled"`.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Whether delete markers should be replicated. Either `"Enabled"` or `"Disabled"`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketReplicationConfigRuleDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControlTranslation":
            suggest = "access_control_translation"
        elif key == "encryptionConfiguration":
            suggest = "encryption_configuration"
        elif key == "replicationTime":
            suggest = "replication_time"
        elif key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationConfigRuleDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationConfigRuleDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationConfigRuleDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 access_control_translation: Optional['outputs.BucketReplicationConfigRuleDestinationAccessControlTranslation'] = None,
                 account: Optional[str] = None,
                 encryption_configuration: Optional['outputs.BucketReplicationConfigRuleDestinationEncryptionConfiguration'] = None,
                 metrics: Optional['outputs.BucketReplicationConfigRuleDestinationMetrics'] = None,
                 replication_time: Optional['outputs.BucketReplicationConfigRuleDestinationReplicationTime'] = None,
                 storage_class: Optional[str] = None):
        """
        :param str bucket: ARN of the bucket where you want Amazon S3 to store the results.
        :param 'BucketReplicationConfigRuleDestinationAccessControlTranslationArgs' access_control_translation: Configuration block that specifies the overrides to use for object owners on replication. See below. Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same AWS account that owns the source object. Must be used in conjunction with `account` owner override configuration.
        :param str account: Account ID to specify the replica ownership. Must be used in conjunction with `access_control_translation` override configuration.
        :param 'BucketReplicationConfigRuleDestinationEncryptionConfigurationArgs' encryption_configuration: Configuration block that provides information about encryption. See below. If `source_selection_criteria` is specified, you must specify this element.
        :param 'BucketReplicationConfigRuleDestinationMetricsArgs' metrics: Configuration block that specifies replication metrics-related settings enabling replication metrics and events. See below.
        :param 'BucketReplicationConfigRuleDestinationReplicationTimeArgs' replication_time: Configuration block that specifies S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. See below. Replication Time Control must be used in conjunction with `metrics`.
        :param str storage_class: The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
        """
        pulumi.set(__self__, "bucket", bucket)
        if access_control_translation is not None:
            pulumi.set(__self__, "access_control_translation", access_control_translation)
        if account is not None:
            pulumi.set(__self__, "account", account)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if replication_time is not None:
            pulumi.set(__self__, "replication_time", replication_time)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        ARN of the bucket where you want Amazon S3 to store the results.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="accessControlTranslation")
    def access_control_translation(self) -> Optional['outputs.BucketReplicationConfigRuleDestinationAccessControlTranslation']:
        """
        Configuration block that specifies the overrides to use for object owners on replication. See below. Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same AWS account that owns the source object. Must be used in conjunction with `account` owner override configuration.
        """
        return pulumi.get(self, "access_control_translation")

    @property
    @pulumi.getter
    def account(self) -> Optional[str]:
        """
        Account ID to specify the replica ownership. Must be used in conjunction with `access_control_translation` override configuration.
        """
        return pulumi.get(self, "account")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional['outputs.BucketReplicationConfigRuleDestinationEncryptionConfiguration']:
        """
        Configuration block that provides information about encryption. See below. If `source_selection_criteria` is specified, you must specify this element.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter
    def metrics(self) -> Optional['outputs.BucketReplicationConfigRuleDestinationMetrics']:
        """
        Configuration block that specifies replication metrics-related settings enabling replication metrics and events. See below.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="replicationTime")
    def replication_time(self) -> Optional['outputs.BucketReplicationConfigRuleDestinationReplicationTime']:
        """
        Configuration block that specifies S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. See below. Replication Time Control must be used in conjunction with `metrics`.
        """
        return pulumi.get(self, "replication_time")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[str]:
        """
        The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class BucketReplicationConfigRuleDestinationAccessControlTranslation(dict):
    def __init__(__self__, *,
                 owner: str):
        """
        :param str owner: Specifies the replica ownership. For default and valid values, see [PUT bucket replication](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html) in the Amazon S3 API Reference. Valid values: `Destination`.
        """
        pulumi.set(__self__, "owner", owner)

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        Specifies the replica ownership. For default and valid values, see [PUT bucket replication](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html) in the Amazon S3 API Reference. Valid values: `Destination`.
        """
        return pulumi.get(self, "owner")


@pulumi.output_type
class BucketReplicationConfigRuleDestinationEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicaKmsKeyId":
            suggest = "replica_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationConfigRuleDestinationEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationConfigRuleDestinationEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationConfigRuleDestinationEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replica_kms_key_id: str):
        """
        :param str replica_kms_key_id: ID (Key ARN or Alias ARN) of the customer managed AWS KMS key stored in AWS Key Management Service (KMS) for the destination bucket.
        """
        pulumi.set(__self__, "replica_kms_key_id", replica_kms_key_id)

    @property
    @pulumi.getter(name="replicaKmsKeyId")
    def replica_kms_key_id(self) -> str:
        """
        ID (Key ARN or Alias ARN) of the customer managed AWS KMS key stored in AWS Key Management Service (KMS) for the destination bucket.
        """
        return pulumi.get(self, "replica_kms_key_id")


@pulumi.output_type
class BucketReplicationConfigRuleDestinationMetrics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventThreshold":
            suggest = "event_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationConfigRuleDestinationMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationConfigRuleDestinationMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationConfigRuleDestinationMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: str,
                 event_threshold: Optional['outputs.BucketReplicationConfigRuleDestinationMetricsEventThreshold'] = None):
        """
        :param str status: Status of the Destination Metrics. Either `"Enabled"` or `"Disabled"`.
        :param 'BucketReplicationConfigRuleDestinationMetricsEventThresholdArgs' event_threshold: Configuration block that specifies the time threshold for emitting the `s3:Replication:OperationMissedThreshold` event. See below.
        """
        pulumi.set(__self__, "status", status)
        if event_threshold is not None:
            pulumi.set(__self__, "event_threshold", event_threshold)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the Destination Metrics. Either `"Enabled"` or `"Disabled"`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="eventThreshold")
    def event_threshold(self) -> Optional['outputs.BucketReplicationConfigRuleDestinationMetricsEventThreshold']:
        """
        Configuration block that specifies the time threshold for emitting the `s3:Replication:OperationMissedThreshold` event. See below.
        """
        return pulumi.get(self, "event_threshold")


@pulumi.output_type
class BucketReplicationConfigRuleDestinationMetricsEventThreshold(dict):
    def __init__(__self__, *,
                 minutes: int):
        """
        :param int minutes: Time in minutes. Valid values: `15`.
        """
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Time in minutes. Valid values: `15`.
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class BucketReplicationConfigRuleDestinationReplicationTime(dict):
    def __init__(__self__, *,
                 status: str,
                 time: 'outputs.BucketReplicationConfigRuleDestinationReplicationTimeTime'):
        """
        :param str status: Status of the Replication Time Control. Either `"Enabled"` or `"Disabled"`.
        :param 'BucketReplicationConfigRuleDestinationReplicationTimeTimeArgs' time: Configuration block specifying the time by which replication should be complete for all objects and operations on objects. See below.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the Replication Time Control. Either `"Enabled"` or `"Disabled"`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def time(self) -> 'outputs.BucketReplicationConfigRuleDestinationReplicationTimeTime':
        """
        Configuration block specifying the time by which replication should be complete for all objects and operations on objects. See below.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class BucketReplicationConfigRuleDestinationReplicationTimeTime(dict):
    def __init__(__self__, *,
                 minutes: int):
        """
        :param int minutes: Time in minutes. Valid values: `15`.
        """
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Time in minutes. Valid values: `15`.
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class BucketReplicationConfigRuleExistingObjectReplication(dict):
    def __init__(__self__, *,
                 status: str):
        """
        :param str status: Whether the existing objects should be replicated. Either `"Enabled"` or `"Disabled"`.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Whether the existing objects should be replicated. Either `"Enabled"` or `"Disabled"`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketReplicationConfigRuleFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "and":
            suggest = "and_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationConfigRuleFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationConfigRuleFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationConfigRuleFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 and_: Optional['outputs.BucketReplicationConfigRuleFilterAnd'] = None,
                 prefix: Optional[str] = None,
                 tag: Optional['outputs.BucketReplicationConfigRuleFilterTag'] = None):
        """
        :param 'BucketReplicationConfigRuleFilterAndArgs' and_: Configuration block for specifying rule filters. This element is required only if you specify more than one filter. See and below for more details.
        :param str prefix: Object key name prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        :param 'BucketReplicationConfigRuleFilterTagArgs' tag: Configuration block for specifying a tag key and value. See below.
        """
        if and_ is not None:
            pulumi.set(__self__, "and_", and_)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="and")
    def and_(self) -> Optional['outputs.BucketReplicationConfigRuleFilterAnd']:
        """
        Configuration block for specifying rule filters. This element is required only if you specify more than one filter. See and below for more details.
        """
        return pulumi.get(self, "and_")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object key name prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tag(self) -> Optional['outputs.BucketReplicationConfigRuleFilterTag']:
        """
        Configuration block for specifying a tag key and value. See below.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class BucketReplicationConfigRuleFilterAnd(dict):
    def __init__(__self__, *,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str prefix: Object key name prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        :param Mapping[str, str] tags: Map of tags (key and value pairs) that identifies a subset of objects to which the rule applies. The rule applies only to objects having all the tags in its tagset.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object key name prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Map of tags (key and value pairs) that identifies a subset of objects to which the rule applies. The rule applies only to objects having all the tags in its tagset.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class BucketReplicationConfigRuleFilterTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: Name of the object key.
        :param str value: Value of the tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Name of the object key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the tag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BucketReplicationConfigRuleSourceSelectionCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicaModifications":
            suggest = "replica_modifications"
        elif key == "sseKmsEncryptedObjects":
            suggest = "sse_kms_encrypted_objects"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationConfigRuleSourceSelectionCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationConfigRuleSourceSelectionCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationConfigRuleSourceSelectionCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replica_modifications: Optional['outputs.BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModifications'] = None,
                 sse_kms_encrypted_objects: Optional['outputs.BucketReplicationConfigRuleSourceSelectionCriteriaSseKmsEncryptedObjects'] = None):
        """
        :param 'BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgs' replica_modifications: Configuration block that you can specify for selections for modifications on replicas. Amazon S3 doesn't replicate replica modifications by default. In the latest version of replication configuration (when `filter` is specified), you can specify this element and set the status to `Enabled` to replicate modifications on replicas.
        :param 'BucketReplicationConfigRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs' sse_kms_encrypted_objects: Configuration block for filter information for the selection of Amazon S3 objects encrypted with AWS KMS. If specified, `replica_kms_key_id` in `destination` `encryption_configuration` must be specified as well.
        """
        if replica_modifications is not None:
            pulumi.set(__self__, "replica_modifications", replica_modifications)
        if sse_kms_encrypted_objects is not None:
            pulumi.set(__self__, "sse_kms_encrypted_objects", sse_kms_encrypted_objects)

    @property
    @pulumi.getter(name="replicaModifications")
    def replica_modifications(self) -> Optional['outputs.BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModifications']:
        """
        Configuration block that you can specify for selections for modifications on replicas. Amazon S3 doesn't replicate replica modifications by default. In the latest version of replication configuration (when `filter` is specified), you can specify this element and set the status to `Enabled` to replicate modifications on replicas.
        """
        return pulumi.get(self, "replica_modifications")

    @property
    @pulumi.getter(name="sseKmsEncryptedObjects")
    def sse_kms_encrypted_objects(self) -> Optional['outputs.BucketReplicationConfigRuleSourceSelectionCriteriaSseKmsEncryptedObjects']:
        """
        Configuration block for filter information for the selection of Amazon S3 objects encrypted with AWS KMS. If specified, `replica_kms_key_id` in `destination` `encryption_configuration` must be specified as well.
        """
        return pulumi.get(self, "sse_kms_encrypted_objects")


@pulumi.output_type
class BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModifications(dict):
    def __init__(__self__, *,
                 status: str):
        """
        :param str status: Whether the existing objects should be replicated. Either `"Enabled"` or `"Disabled"`.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Whether the existing objects should be replicated. Either `"Enabled"` or `"Disabled"`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketReplicationConfigRuleSourceSelectionCriteriaSseKmsEncryptedObjects(dict):
    def __init__(__self__, *,
                 status: str):
        """
        :param str status: Whether the existing objects should be replicated. Either `"Enabled"` or `"Disabled"`.
        """
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Whether the existing objects should be replicated. Either `"Enabled"` or `"Disabled"`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketReplicationConfiguration(dict):
    def __init__(__self__, *,
                 role: str,
                 rules: Sequence['outputs.BucketReplicationConfigurationRule']):
        """
        :param str role: The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        :param Sequence['BucketReplicationConfigurationRuleArgs'] rules: Specifies the rules managing the replication (documented below).
        """
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.BucketReplicationConfigurationRule']:
        """
        Specifies the rules managing the replication (documented below).
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class BucketReplicationConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteMarkerReplicationStatus":
            suggest = "delete_marker_replication_status"
        elif key == "sourceSelectionCriteria":
            suggest = "source_selection_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.BucketReplicationConfigurationRuleDestination',
                 status: str,
                 delete_marker_replication_status: Optional[str] = None,
                 filter: Optional['outputs.BucketReplicationConfigurationRuleFilter'] = None,
                 id: Optional[str] = None,
                 prefix: Optional[str] = None,
                 priority: Optional[int] = None,
                 source_selection_criteria: Optional['outputs.BucketReplicationConfigurationRuleSourceSelectionCriteria'] = None):
        """
        :param 'BucketReplicationConfigurationRuleDestinationArgs' destination: Specifies the destination for the rule (documented below).
        :param str status: The status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
               
               > **NOTE:** Replication to multiple destination buckets requires that `priority` is specified in the `rules` object. If the corresponding rule requires no filter, an empty configuration block `filter {}` must be specified.
        :param str delete_marker_replication_status: Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
        :param 'BucketReplicationConfigurationRuleFilterArgs' filter: Filter that identifies subset of objects to which the replication rule applies (documented below).
        :param str id: Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        :param str prefix: Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        :param int priority: The priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
        :param 'BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs' source_selection_criteria: Specifies special object selection criteria (documented below).
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "status", status)
        if delete_marker_replication_status is not None:
            pulumi.set(__self__, "delete_marker_replication_status", delete_marker_replication_status)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_selection_criteria is not None:
            pulumi.set(__self__, "source_selection_criteria", source_selection_criteria)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.BucketReplicationConfigurationRuleDestination':
        """
        Specifies the destination for the rule (documented below).
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.

        > **NOTE:** Replication to multiple destination buckets requires that `priority` is specified in the `rules` object. If the corresponding rule requires no filter, an empty configuration block `filter {}` must be specified.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="deleteMarkerReplicationStatus")
    def delete_marker_replication_status(self) -> Optional[str]:
        """
        Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
        """
        return pulumi.get(self, "delete_marker_replication_status")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketReplicationConfigurationRuleFilter']:
        """
        Filter that identifies subset of objects to which the replication rule applies (documented below).
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        The priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceSelectionCriteria")
    def source_selection_criteria(self) -> Optional['outputs.BucketReplicationConfigurationRuleSourceSelectionCriteria']:
        """
        Specifies special object selection criteria (documented below).
        """
        return pulumi.get(self, "source_selection_criteria")


@pulumi.output_type
class BucketReplicationConfigurationRuleDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControlTranslation":
            suggest = "access_control_translation"
        elif key == "accountId":
            suggest = "account_id"
        elif key == "replicaKmsKeyId":
            suggest = "replica_kms_key_id"
        elif key == "replicationTime":
            suggest = "replication_time"
        elif key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationConfigurationRuleDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationConfigurationRuleDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationConfigurationRuleDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 access_control_translation: Optional['outputs.BucketReplicationConfigurationRuleDestinationAccessControlTranslation'] = None,
                 account_id: Optional[str] = None,
                 metrics: Optional['outputs.BucketReplicationConfigurationRuleDestinationMetrics'] = None,
                 replica_kms_key_id: Optional[str] = None,
                 replication_time: Optional['outputs.BucketReplicationConfigurationRuleDestinationReplicationTime'] = None,
                 storage_class: Optional[str] = None):
        """
        :param str bucket: The ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
        :param 'BucketReplicationConfigurationRuleDestinationAccessControlTranslationArgs' access_control_translation: Specifies the overrides to use for object owners on replication. Must be used in conjunction with `account_id` owner override configuration.
        :param str account_id: The Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
        :param 'BucketReplicationConfigurationRuleDestinationMetricsArgs' metrics: Enables replication metrics (required for S3 RTC) (documented below).
        :param str replica_kms_key_id: Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
               `sse_kms_encrypted_objects` source selection criteria.
        :param 'BucketReplicationConfigurationRuleDestinationReplicationTimeArgs' replication_time: Enables S3 Replication Time Control (S3 RTC) (documented below).
        :param str storage_class: The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
        """
        pulumi.set(__self__, "bucket", bucket)
        if access_control_translation is not None:
            pulumi.set(__self__, "access_control_translation", access_control_translation)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if replica_kms_key_id is not None:
            pulumi.set(__self__, "replica_kms_key_id", replica_kms_key_id)
        if replication_time is not None:
            pulumi.set(__self__, "replication_time", replication_time)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="accessControlTranslation")
    def access_control_translation(self) -> Optional['outputs.BucketReplicationConfigurationRuleDestinationAccessControlTranslation']:
        """
        Specifies the overrides to use for object owners on replication. Must be used in conjunction with `account_id` owner override configuration.
        """
        return pulumi.get(self, "access_control_translation")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        The Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def metrics(self) -> Optional['outputs.BucketReplicationConfigurationRuleDestinationMetrics']:
        """
        Enables replication metrics (required for S3 RTC) (documented below).
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="replicaKmsKeyId")
    def replica_kms_key_id(self) -> Optional[str]:
        """
        Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
        `sse_kms_encrypted_objects` source selection criteria.
        """
        return pulumi.get(self, "replica_kms_key_id")

    @property
    @pulumi.getter(name="replicationTime")
    def replication_time(self) -> Optional['outputs.BucketReplicationConfigurationRuleDestinationReplicationTime']:
        """
        Enables S3 Replication Time Control (S3 RTC) (documented below).
        """
        return pulumi.get(self, "replication_time")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[str]:
        """
        The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class BucketReplicationConfigurationRuleDestinationAccessControlTranslation(dict):
    def __init__(__self__, *,
                 owner: str):
        """
        :param str owner: The override value for the owner on replicated objects. Currently only `Destination` is supported.
        """
        pulumi.set(__self__, "owner", owner)

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        The override value for the owner on replicated objects. Currently only `Destination` is supported.
        """
        return pulumi.get(self, "owner")


@pulumi.output_type
class BucketReplicationConfigurationRuleDestinationMetrics(dict):
    def __init__(__self__, *,
                 minutes: Optional[int] = None,
                 status: Optional[str] = None):
        """
        :param int minutes: Threshold within which objects are to be replicated. The only valid value is `15`.
        :param str status: The status of replication metrics. Either `Enabled` or `Disabled`.
        """
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[int]:
        """
        Threshold within which objects are to be replicated. The only valid value is `15`.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of replication metrics. Either `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketReplicationConfigurationRuleDestinationReplicationTime(dict):
    def __init__(__self__, *,
                 minutes: Optional[int] = None,
                 status: Optional[str] = None):
        """
        :param int minutes: Threshold within which objects are to be replicated. The only valid value is `15`.
        :param str status: The status of RTC. Either `Enabled` or `Disabled`.
        """
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[int]:
        """
        Threshold within which objects are to be replicated. The only valid value is `15`.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of RTC. Either `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketReplicationConfigurationRuleFilter(dict):
    def __init__(__self__, *,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str prefix: Object keyname prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        :param Mapping[str, str] tags: A map of tags that identifies subset of objects to which the rule applies.
               The rule applies only to objects having all the tags in its tagset.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object keyname prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        A map of tags that identifies subset of objects to which the rule applies.
        The rule applies only to objects having all the tags in its tagset.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class BucketReplicationConfigurationRuleSourceSelectionCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseKmsEncryptedObjects":
            suggest = "sse_kms_encrypted_objects"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationConfigurationRuleSourceSelectionCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationConfigurationRuleSourceSelectionCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationConfigurationRuleSourceSelectionCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_kms_encrypted_objects: Optional['outputs.BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjects'] = None):
        """
        :param 'BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs' sse_kms_encrypted_objects: Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
               in `destination` must be specified as well.
        """
        if sse_kms_encrypted_objects is not None:
            pulumi.set(__self__, "sse_kms_encrypted_objects", sse_kms_encrypted_objects)

    @property
    @pulumi.getter(name="sseKmsEncryptedObjects")
    def sse_kms_encrypted_objects(self) -> Optional['outputs.BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjects']:
        """
        Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
        in `destination` must be specified as well.
        """
        return pulumi.get(self, "sse_kms_encrypted_objects")


@pulumi.output_type
class BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjects(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Boolean which indicates if this criteria is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Boolean which indicates if this criteria is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BucketServerSideEncryptionConfiguration(dict):
    def __init__(__self__, *,
                 rule: 'outputs.BucketServerSideEncryptionConfigurationRule'):
        """
        :param 'BucketServerSideEncryptionConfigurationRuleArgs' rule: A single object for server-side encryption by default configuration. (documented below)
        """
        pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter
    def rule(self) -> 'outputs.BucketServerSideEncryptionConfigurationRule':
        """
        A single object for server-side encryption by default configuration. (documented below)
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class BucketServerSideEncryptionConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyServerSideEncryptionByDefault":
            suggest = "apply_server_side_encryption_by_default"
        elif key == "bucketKeyEnabled":
            suggest = "bucket_key_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketServerSideEncryptionConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketServerSideEncryptionConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketServerSideEncryptionConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_server_side_encryption_by_default: 'outputs.BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault',
                 bucket_key_enabled: Optional[bool] = None):
        """
        :param 'BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs' apply_server_side_encryption_by_default: A single object for setting server-side encryption by default. (documented below)
        :param bool bucket_key_enabled: Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        """
        pulumi.set(__self__, "apply_server_side_encryption_by_default", apply_server_side_encryption_by_default)
        if bucket_key_enabled is not None:
            pulumi.set(__self__, "bucket_key_enabled", bucket_key_enabled)

    @property
    @pulumi.getter(name="applyServerSideEncryptionByDefault")
    def apply_server_side_encryption_by_default(self) -> 'outputs.BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault':
        """
        A single object for setting server-side encryption by default. (documented below)
        """
        return pulumi.get(self, "apply_server_side_encryption_by_default")

    @property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> Optional[bool]:
        """
        Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        """
        return pulumi.get(self, "bucket_key_enabled")


@pulumi.output_type
class BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseAlgorithm":
            suggest = "sse_algorithm"
        elif key == "kmsMasterKeyId":
            suggest = "kms_master_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_algorithm: str,
                 kms_master_key_id: Optional[str] = None):
        """
        :param str sse_algorithm: The server-side encryption algorithm to use. Valid values are `AES256` and `aws:kms`
        :param str kms_master_key_id: The AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
        """
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)

    @property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> str:
        """
        The server-side encryption algorithm to use. Valid values are `AES256` and `aws:kms`
        """
        return pulumi.get(self, "sse_algorithm")

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[str]:
        """
        The AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
        """
        return pulumi.get(self, "kms_master_key_id")


@pulumi.output_type
class BucketServerSideEncryptionConfigurationV2Rule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyServerSideEncryptionByDefault":
            suggest = "apply_server_side_encryption_by_default"
        elif key == "bucketKeyEnabled":
            suggest = "bucket_key_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketServerSideEncryptionConfigurationV2Rule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketServerSideEncryptionConfigurationV2Rule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketServerSideEncryptionConfigurationV2Rule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_server_side_encryption_by_default: Optional['outputs.BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefault'] = None,
                 bucket_key_enabled: Optional[bool] = None):
        """
        :param 'BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefaultArgs' apply_server_side_encryption_by_default: Single object for setting server-side encryption by default. See below.
        :param bool bucket_key_enabled: Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        """
        if apply_server_side_encryption_by_default is not None:
            pulumi.set(__self__, "apply_server_side_encryption_by_default", apply_server_side_encryption_by_default)
        if bucket_key_enabled is not None:
            pulumi.set(__self__, "bucket_key_enabled", bucket_key_enabled)

    @property
    @pulumi.getter(name="applyServerSideEncryptionByDefault")
    def apply_server_side_encryption_by_default(self) -> Optional['outputs.BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefault']:
        """
        Single object for setting server-side encryption by default. See below.
        """
        return pulumi.get(self, "apply_server_side_encryption_by_default")

    @property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> Optional[bool]:
        """
        Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        """
        return pulumi.get(self, "bucket_key_enabled")


@pulumi.output_type
class BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefault(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseAlgorithm":
            suggest = "sse_algorithm"
        elif key == "kmsMasterKeyId":
            suggest = "kms_master_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_algorithm: str,
                 kms_master_key_id: Optional[str] = None):
        """
        :param str sse_algorithm: Server-side encryption algorithm to use. Valid values are `AES256`, `aws:kms`, and `aws:kms:dsse`
        :param str kms_master_key_id: AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
        """
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)

    @property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> str:
        """
        Server-side encryption algorithm to use. Valid values are `AES256`, `aws:kms`, and `aws:kms:dsse`
        """
        return pulumi.get(self, "sse_algorithm")

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[str]:
        """
        AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
        """
        return pulumi.get(self, "kms_master_key_id")


@pulumi.output_type
class BucketV2CorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2CorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2CorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2CorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 allowed_headers: Optional[Sequence[str]] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age_seconds: Optional[int] = None):
        """
        :param Sequence[str] allowed_methods: One or more HTTP methods that you allow the origin to execute. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        :param Sequence[str] allowed_origins: One or more origins you want customers to be able to access the bucket from.
        :param Sequence[str] allowed_headers: List of headers allowed.
        :param Sequence[str] expose_headers: One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
        :param int max_age_seconds: Specifies time in seconds that browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        """
        One or more HTTP methods that you allow the origin to execute. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        One or more origins you want customers to be able to access the bucket from.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[str]]:
        """
        List of headers allowed.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[int]:
        """
        Specifies time in seconds that browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class BucketV2Grant(dict):
    def __init__(__self__, *,
                 permissions: Sequence[str],
                 type: str,
                 id: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param Sequence[str] permissions: List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
        :param str type: Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
        :param str id: Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
        :param str uri: Uri address to grant for. Used only when `type` is `Group`.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Uri address to grant for. Used only when `type` is `Group`.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class BucketV2LifecycleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUploadDays":
            suggest = "abort_incomplete_multipart_upload_days"
        elif key == "noncurrentVersionExpirations":
            suggest = "noncurrent_version_expirations"
        elif key == "noncurrentVersionTransitions":
            suggest = "noncurrent_version_transitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2LifecycleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2LifecycleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2LifecycleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 abort_incomplete_multipart_upload_days: Optional[int] = None,
                 expirations: Optional[Sequence['outputs.BucketV2LifecycleRuleExpiration']] = None,
                 id: Optional[str] = None,
                 noncurrent_version_expirations: Optional[Sequence['outputs.BucketV2LifecycleRuleNoncurrentVersionExpiration']] = None,
                 noncurrent_version_transitions: Optional[Sequence['outputs.BucketV2LifecycleRuleNoncurrentVersionTransition']] = None,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 transitions: Optional[Sequence['outputs.BucketV2LifecycleRuleTransition']] = None):
        """
        :param bool enabled: Specifies lifecycle rule status.
        :param int abort_incomplete_multipart_upload_days: Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
        :param Sequence['BucketV2LifecycleRuleExpirationArgs'] expirations: Specifies a period in the object's expire. See Expiration below for details.
        :param str id: Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        :param Sequence['BucketV2LifecycleRuleNoncurrentVersionExpirationArgs'] noncurrent_version_expirations: Specifies when noncurrent object versions expire. See Noncurrent Version Expiration below for details.
        :param Sequence['BucketV2LifecycleRuleNoncurrentVersionTransitionArgs'] noncurrent_version_transitions: Specifies when noncurrent object versions transitions. See Noncurrent Version Transition below for details.
        :param str prefix: Object key prefix identifying one or more objects to which the rule applies.
        :param Mapping[str, str] tags: Specifies object tags key and value.
        :param Sequence['BucketV2LifecycleRuleTransitionArgs'] transitions: Specifies a period in the object's transitions. See Transition below for details.
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_incomplete_multipart_upload_days is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        if expirations is not None:
            pulumi.set(__self__, "expirations", expirations)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if noncurrent_version_expirations is not None:
            pulumi.set(__self__, "noncurrent_version_expirations", noncurrent_version_expirations)
        if noncurrent_version_transitions is not None:
            pulumi.set(__self__, "noncurrent_version_transitions", noncurrent_version_transitions)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies lifecycle rule status.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> Optional[int]:
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @property
    @pulumi.getter
    def expirations(self) -> Optional[Sequence['outputs.BucketV2LifecycleRuleExpiration']]:
        """
        Specifies a period in the object's expire. See Expiration below for details.
        """
        return pulumi.get(self, "expirations")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="noncurrentVersionExpirations")
    def noncurrent_version_expirations(self) -> Optional[Sequence['outputs.BucketV2LifecycleRuleNoncurrentVersionExpiration']]:
        """
        Specifies when noncurrent object versions expire. See Noncurrent Version Expiration below for details.
        """
        return pulumi.get(self, "noncurrent_version_expirations")

    @property
    @pulumi.getter(name="noncurrentVersionTransitions")
    def noncurrent_version_transitions(self) -> Optional[Sequence['outputs.BucketV2LifecycleRuleNoncurrentVersionTransition']]:
        """
        Specifies when noncurrent object versions transitions. See Noncurrent Version Transition below for details.
        """
        return pulumi.get(self, "noncurrent_version_transitions")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object key prefix identifying one or more objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Specifies object tags key and value.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.BucketV2LifecycleRuleTransition']]:
        """
        Specifies a period in the object's transitions. See Transition below for details.
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class BucketV2LifecycleRuleExpiration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredObjectDeleteMarker":
            suggest = "expired_object_delete_marker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2LifecycleRuleExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2LifecycleRuleExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2LifecycleRuleExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[str] = None,
                 days: Optional[int] = None,
                 expired_object_delete_marker: Optional[bool] = None):
        """
        :param str date: Specifies the date after which you want the corresponding action to take effect.
        :param int days: Specifies the number of days after object creation when the specific rule action takes effect.
        :param bool expired_object_delete_marker: On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct Amazon S3 to delete expired object delete markers. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        Specifies the date after which you want the corresponding action to take effect.
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[bool]:
        """
        On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct Amazon S3 to delete expired object delete markers. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.
        """
        return pulumi.get(self, "expired_object_delete_marker")


@pulumi.output_type
class BucketV2LifecycleRuleNoncurrentVersionExpiration(dict):
    def __init__(__self__, *,
                 days: Optional[int] = None):
        """
        :param int days: Specifies the number of days noncurrent object versions expire.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days noncurrent object versions expire.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketV2LifecycleRuleNoncurrentVersionTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2LifecycleRuleNoncurrentVersionTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2LifecycleRuleNoncurrentVersionTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2LifecycleRuleNoncurrentVersionTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: str,
                 days: Optional[int] = None):
        """
        :param str storage_class: Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
        :param int days: Specifies the number of days noncurrent object versions transition.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketV2LifecycleRuleTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2LifecycleRuleTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2LifecycleRuleTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2LifecycleRuleTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: str,
                 date: Optional[str] = None,
                 days: Optional[int] = None):
        """
        :param str storage_class: Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
        :param str date: Specifies the date after which you want the corresponding action to take effect.
        :param int days: Specifies the number of days after object creation when the specific rule action takes effect.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        Specifies the date after which you want the corresponding action to take effect.
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days after object creation when the specific rule action takes effect.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketV2Logging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetBucket":
            suggest = "target_bucket"
        elif key == "targetPrefix":
            suggest = "target_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2Logging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2Logging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2Logging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_bucket: str,
                 target_prefix: Optional[str] = None):
        """
        :param str target_bucket: Name of the bucket that will receive the log objects.
        :param str target_prefix: To specify a key prefix for log objects.
        """
        pulumi.set(__self__, "target_bucket", target_bucket)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)

    @property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> str:
        """
        Name of the bucket that will receive the log objects.
        """
        return pulumi.get(self, "target_bucket")

    @property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[str]:
        """
        To specify a key prefix for log objects.
        """
        return pulumi.get(self, "target_prefix")


@pulumi.output_type
class BucketV2ObjectLockConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectLockEnabled":
            suggest = "object_lock_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2ObjectLockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2ObjectLockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2ObjectLockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_lock_enabled: Optional[str] = None,
                 rules: Optional[Sequence['outputs.BucketV2ObjectLockConfigurationRule']] = None):
        """
        :param str object_lock_enabled: Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
        :param Sequence['BucketV2ObjectLockConfigurationRuleArgs'] rules: Object Lock rule in place for this bucket (documented below).
        """
        if object_lock_enabled is not None:
            pulumi.set(__self__, "object_lock_enabled", object_lock_enabled)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="objectLockEnabled")
    @_utilities.deprecated("""Use the top-level parameter object_lock_enabled instead""")
    def object_lock_enabled(self) -> Optional[str]:
        """
        Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
        """
        return pulumi.get(self, "object_lock_enabled")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use the s3.BucketObjectLockConfigurationV2 resource instead""")
    def rules(self) -> Optional[Sequence['outputs.BucketV2ObjectLockConfigurationRule']]:
        """
        Object Lock rule in place for this bucket (documented below).
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class BucketV2ObjectLockConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRetentions":
            suggest = "default_retentions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2ObjectLockConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2ObjectLockConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2ObjectLockConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_retentions: Sequence['outputs.BucketV2ObjectLockConfigurationRuleDefaultRetention']):
        """
        :param Sequence['BucketV2ObjectLockConfigurationRuleDefaultRetentionArgs'] default_retentions: Default retention period that you want to apply to new objects placed in this bucket (documented below).
        """
        pulumi.set(__self__, "default_retentions", default_retentions)

    @property
    @pulumi.getter(name="defaultRetentions")
    def default_retentions(self) -> Sequence['outputs.BucketV2ObjectLockConfigurationRuleDefaultRetention']:
        """
        Default retention period that you want to apply to new objects placed in this bucket (documented below).
        """
        return pulumi.get(self, "default_retentions")


@pulumi.output_type
class BucketV2ObjectLockConfigurationRuleDefaultRetention(dict):
    def __init__(__self__, *,
                 mode: str,
                 days: Optional[int] = None,
                 years: Optional[int] = None):
        """
        :param str mode: Default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        :param int days: Number of days that you want to specify for the default retention period.
        :param int years: Number of years that you want to specify for the default retention period.
        """
        pulumi.set(__self__, "mode", mode)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if years is not None:
            pulumi.set(__self__, "years", years)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Number of days that you want to specify for the default retention period.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def years(self) -> Optional[int]:
        """
        Number of years that you want to specify for the default retention period.
        """
        return pulumi.get(self, "years")


@pulumi.output_type
class BucketV2ReplicationConfiguration(dict):
    def __init__(__self__, *,
                 role: str,
                 rules: Sequence['outputs.BucketV2ReplicationConfigurationRule']):
        """
        :param str role: ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        :param Sequence['BucketV2ReplicationConfigurationRuleArgs'] rules: Specifies the rules managing the replication (documented below).
        """
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        ARN of the IAM role for Amazon S3 to assume when replicating the objects.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.BucketV2ReplicationConfigurationRule']:
        """
        Specifies the rules managing the replication (documented below).
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class BucketV2ReplicationConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteMarkerReplicationStatus":
            suggest = "delete_marker_replication_status"
        elif key == "sourceSelectionCriterias":
            suggest = "source_selection_criterias"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2ReplicationConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2ReplicationConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2ReplicationConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destinations: Sequence['outputs.BucketV2ReplicationConfigurationRuleDestination'],
                 status: str,
                 delete_marker_replication_status: Optional[str] = None,
                 filters: Optional[Sequence['outputs.BucketV2ReplicationConfigurationRuleFilter']] = None,
                 id: Optional[str] = None,
                 prefix: Optional[str] = None,
                 priority: Optional[int] = None,
                 source_selection_criterias: Optional[Sequence['outputs.BucketV2ReplicationConfigurationRuleSourceSelectionCriteria']] = None):
        """
        :param Sequence['BucketV2ReplicationConfigurationRuleDestinationArgs'] destinations: Specifies the destination for the rule (documented below).
        :param str status: Status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
        :param str delete_marker_replication_status: Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
        :param Sequence['BucketV2ReplicationConfigurationRuleFilterArgs'] filters: Filter that identifies subset of objects to which the replication rule applies (documented below).
        :param str id: Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        :param str prefix: Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        :param int priority: Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
        :param Sequence['BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs'] source_selection_criterias: Specifies special object selection criteria (documented below).
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "status", status)
        if delete_marker_replication_status is not None:
            pulumi.set(__self__, "delete_marker_replication_status", delete_marker_replication_status)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_selection_criterias is not None:
            pulumi.set(__self__, "source_selection_criterias", source_selection_criterias)

    @property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.BucketV2ReplicationConfigurationRuleDestination']:
        """
        Specifies the destination for the rule (documented below).
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="deleteMarkerReplicationStatus")
    def delete_marker_replication_status(self) -> Optional[str]:
        """
        Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
        """
        return pulumi.get(self, "delete_marker_replication_status")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.BucketV2ReplicationConfigurationRuleFilter']]:
        """
        Filter that identifies subset of objects to which the replication rule applies (documented below).
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for the rule. Must be less than or equal to 255 characters in length.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceSelectionCriterias")
    def source_selection_criterias(self) -> Optional[Sequence['outputs.BucketV2ReplicationConfigurationRuleSourceSelectionCriteria']]:
        """
        Specifies special object selection criteria (documented below).
        """
        return pulumi.get(self, "source_selection_criterias")


@pulumi.output_type
class BucketV2ReplicationConfigurationRuleDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControlTranslations":
            suggest = "access_control_translations"
        elif key == "accountId":
            suggest = "account_id"
        elif key == "replicaKmsKeyId":
            suggest = "replica_kms_key_id"
        elif key == "replicationTimes":
            suggest = "replication_times"
        elif key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2ReplicationConfigurationRuleDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2ReplicationConfigurationRuleDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2ReplicationConfigurationRuleDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 access_control_translations: Optional[Sequence['outputs.BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslation']] = None,
                 account_id: Optional[str] = None,
                 metrics: Optional[Sequence['outputs.BucketV2ReplicationConfigurationRuleDestinationMetric']] = None,
                 replica_kms_key_id: Optional[str] = None,
                 replication_times: Optional[Sequence['outputs.BucketV2ReplicationConfigurationRuleDestinationReplicationTime']] = None,
                 storage_class: Optional[str] = None):
        """
        :param str bucket: ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
        :param Sequence['BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslationArgs'] access_control_translations: Specifies the overrides to use for object owners on replication (documented below). Must be used in conjunction with `account_id` owner override configuration.
        :param str account_id: Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
        :param Sequence['BucketV2ReplicationConfigurationRuleDestinationMetricArgs'] metrics: Enables replication metrics (required for S3 RTC) (documented below).
        :param str replica_kms_key_id: Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
               `sse_kms_encrypted_objects` source selection criteria.
        :param Sequence['BucketV2ReplicationConfigurationRuleDestinationReplicationTimeArgs'] replication_times: Enables S3 Replication Time Control (S3 RTC) (documented below).
        :param str storage_class: The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
        """
        pulumi.set(__self__, "bucket", bucket)
        if access_control_translations is not None:
            pulumi.set(__self__, "access_control_translations", access_control_translations)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if replica_kms_key_id is not None:
            pulumi.set(__self__, "replica_kms_key_id", replica_kms_key_id)
        if replication_times is not None:
            pulumi.set(__self__, "replication_times", replication_times)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="accessControlTranslations")
    def access_control_translations(self) -> Optional[Sequence['outputs.BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslation']]:
        """
        Specifies the overrides to use for object owners on replication (documented below). Must be used in conjunction with `account_id` owner override configuration.
        """
        return pulumi.get(self, "access_control_translations")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.BucketV2ReplicationConfigurationRuleDestinationMetric']]:
        """
        Enables replication metrics (required for S3 RTC) (documented below).
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="replicaKmsKeyId")
    def replica_kms_key_id(self) -> Optional[str]:
        """
        Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
        `sse_kms_encrypted_objects` source selection criteria.
        """
        return pulumi.get(self, "replica_kms_key_id")

    @property
    @pulumi.getter(name="replicationTimes")
    def replication_times(self) -> Optional[Sequence['outputs.BucketV2ReplicationConfigurationRuleDestinationReplicationTime']]:
        """
        Enables S3 Replication Time Control (S3 RTC) (documented below).
        """
        return pulumi.get(self, "replication_times")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[str]:
        """
        The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslation(dict):
    def __init__(__self__, *,
                 owner: str):
        """
        :param str owner: Specifies the replica ownership. For default and valid values, see [PUT bucket replication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html) in the Amazon S3 API Reference. The only valid value is `Destination`.
        """
        pulumi.set(__self__, "owner", owner)

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        Specifies the replica ownership. For default and valid values, see [PUT bucket replication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html) in the Amazon S3 API Reference. The only valid value is `Destination`.
        """
        return pulumi.get(self, "owner")


@pulumi.output_type
class BucketV2ReplicationConfigurationRuleDestinationMetric(dict):
    def __init__(__self__, *,
                 minutes: Optional[int] = None,
                 status: Optional[str] = None):
        """
        :param int minutes: Threshold within which objects are to be replicated. The only valid value is `15`.
        :param str status: Status of replication metrics. Either `Enabled` or `Disabled`.
        """
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[int]:
        """
        Threshold within which objects are to be replicated. The only valid value is `15`.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of replication metrics. Either `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketV2ReplicationConfigurationRuleDestinationReplicationTime(dict):
    def __init__(__self__, *,
                 minutes: Optional[int] = None,
                 status: Optional[str] = None):
        """
        :param int minutes: Threshold within which objects are to be replicated. The only valid value is `15`.
        :param str status: Status of RTC. Either `Enabled` or `Disabled`.
        """
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[int]:
        """
        Threshold within which objects are to be replicated. The only valid value is `15`.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of RTC. Either `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketV2ReplicationConfigurationRuleFilter(dict):
    def __init__(__self__, *,
                 prefix: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str prefix: Object keyname prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        :param Mapping[str, str] tags: A map of tags that identifies subset of objects to which the rule applies.
               The rule applies only to objects having all the tags in its tagset.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object keyname prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        A map of tags that identifies subset of objects to which the rule applies.
        The rule applies only to objects having all the tags in its tagset.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class BucketV2ReplicationConfigurationRuleSourceSelectionCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseKmsEncryptedObjects":
            suggest = "sse_kms_encrypted_objects"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2ReplicationConfigurationRuleSourceSelectionCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2ReplicationConfigurationRuleSourceSelectionCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2ReplicationConfigurationRuleSourceSelectionCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_kms_encrypted_objects: Optional[Sequence['outputs.BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObject']] = None):
        """
        :param Sequence['BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectArgs'] sse_kms_encrypted_objects: Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
               in `destination` must be specified as well.
        """
        if sse_kms_encrypted_objects is not None:
            pulumi.set(__self__, "sse_kms_encrypted_objects", sse_kms_encrypted_objects)

    @property
    @pulumi.getter(name="sseKmsEncryptedObjects")
    def sse_kms_encrypted_objects(self) -> Optional[Sequence['outputs.BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObject']]:
        """
        Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
        in `destination` must be specified as well.
        """
        return pulumi.get(self, "sse_kms_encrypted_objects")


@pulumi.output_type
class BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObject(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Boolean which indicates if this criteria is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Boolean which indicates if this criteria is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BucketV2ServerSideEncryptionConfiguration(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.BucketV2ServerSideEncryptionConfigurationRule']):
        """
        :param Sequence['BucketV2ServerSideEncryptionConfigurationRuleArgs'] rules: Single object for server-side encryption by default configuration. (documented below)
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.BucketV2ServerSideEncryptionConfigurationRule']:
        """
        Single object for server-side encryption by default configuration. (documented below)
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class BucketV2ServerSideEncryptionConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyServerSideEncryptionByDefaults":
            suggest = "apply_server_side_encryption_by_defaults"
        elif key == "bucketKeyEnabled":
            suggest = "bucket_key_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2ServerSideEncryptionConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2ServerSideEncryptionConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2ServerSideEncryptionConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_server_side_encryption_by_defaults: Sequence['outputs.BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault'],
                 bucket_key_enabled: Optional[bool] = None):
        """
        :param Sequence['BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs'] apply_server_side_encryption_by_defaults: Single object for setting server-side encryption by default. (documented below)
        :param bool bucket_key_enabled: Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        """
        pulumi.set(__self__, "apply_server_side_encryption_by_defaults", apply_server_side_encryption_by_defaults)
        if bucket_key_enabled is not None:
            pulumi.set(__self__, "bucket_key_enabled", bucket_key_enabled)

    @property
    @pulumi.getter(name="applyServerSideEncryptionByDefaults")
    def apply_server_side_encryption_by_defaults(self) -> Sequence['outputs.BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault']:
        """
        Single object for setting server-side encryption by default. (documented below)
        """
        return pulumi.get(self, "apply_server_side_encryption_by_defaults")

    @property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> Optional[bool]:
        """
        Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
        """
        return pulumi.get(self, "bucket_key_enabled")


@pulumi.output_type
class BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseAlgorithm":
            suggest = "sse_algorithm"
        elif key == "kmsMasterKeyId":
            suggest = "kms_master_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_algorithm: str,
                 kms_master_key_id: Optional[str] = None):
        """
        :param str sse_algorithm: Server-side encryption algorithm to use. Valid values are `AES256` and `aws:kms`
        :param str kms_master_key_id: AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
        """
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)

    @property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> str:
        """
        Server-side encryption algorithm to use. Valid values are `AES256` and `aws:kms`
        """
        return pulumi.get(self, "sse_algorithm")

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[str]:
        """
        AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
        """
        return pulumi.get(self, "kms_master_key_id")


@pulumi.output_type
class BucketV2Versioning(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mfaDelete":
            suggest = "mfa_delete"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2Versioning. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2Versioning.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2Versioning.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 mfa_delete: Optional[bool] = None):
        """
        :param bool enabled: Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        :param bool mfa_delete: Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if mfa_delete is not None:
            pulumi.set(__self__, "mfa_delete", mfa_delete)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="mfaDelete")
    def mfa_delete(self) -> Optional[bool]:
        """
        Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
        """
        return pulumi.get(self, "mfa_delete")


@pulumi.output_type
class BucketV2Website(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorDocument":
            suggest = "error_document"
        elif key == "indexDocument":
            suggest = "index_document"
        elif key == "redirectAllRequestsTo":
            suggest = "redirect_all_requests_to"
        elif key == "routingRules":
            suggest = "routing_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketV2Website. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketV2Website.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketV2Website.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_document: Optional[str] = None,
                 index_document: Optional[str] = None,
                 redirect_all_requests_to: Optional[str] = None,
                 routing_rules: Optional[str] = None):
        """
        :param str error_document: Absolute path to the document to return in case of a 4XX error.
        :param str index_document: Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
        :param str redirect_all_requests_to: Hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
        :param str routing_rules: JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
               describing redirect behavior and when redirects are applied.
        """
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if redirect_all_requests_to is not None:
            pulumi.set(__self__, "redirect_all_requests_to", redirect_all_requests_to)
        if routing_rules is not None:
            pulumi.set(__self__, "routing_rules", routing_rules)

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[str]:
        """
        Absolute path to the document to return in case of a 4XX error.
        """
        return pulumi.get(self, "error_document")

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[str]:
        """
        Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
        """
        return pulumi.get(self, "index_document")

    @property
    @pulumi.getter(name="redirectAllRequestsTo")
    def redirect_all_requests_to(self) -> Optional[str]:
        """
        Hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
        """
        return pulumi.get(self, "redirect_all_requests_to")

    @property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> Optional[str]:
        """
        JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
        describing redirect behavior and when redirects are applied.
        """
        return pulumi.get(self, "routing_rules")


@pulumi.output_type
class BucketVersioning(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mfaDelete":
            suggest = "mfa_delete"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketVersioning. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketVersioning.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketVersioning.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 mfa_delete: Optional[bool] = None):
        """
        :param bool enabled: Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        :param bool mfa_delete: Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if mfa_delete is not None:
            pulumi.set(__self__, "mfa_delete", mfa_delete)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="mfaDelete")
    def mfa_delete(self) -> Optional[bool]:
        """
        Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
        """
        return pulumi.get(self, "mfa_delete")


@pulumi.output_type
class BucketVersioningV2VersioningConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mfaDelete":
            suggest = "mfa_delete"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketVersioningV2VersioningConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketVersioningV2VersioningConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketVersioningV2VersioningConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: str,
                 mfa_delete: Optional[str] = None):
        """
        :param str status: Versioning state of the bucket. Valid values: `Enabled`, `Suspended`, or `Disabled`. `Disabled` should only be used when creating or importing resources that correspond to unversioned S3 buckets.
        :param str mfa_delete: Specifies whether MFA delete is enabled in the bucket versioning configuration. Valid values: `Enabled` or `Disabled`.
        """
        pulumi.set(__self__, "status", status)
        if mfa_delete is not None:
            pulumi.set(__self__, "mfa_delete", mfa_delete)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Versioning state of the bucket. Valid values: `Enabled`, `Suspended`, or `Disabled`. `Disabled` should only be used when creating or importing resources that correspond to unversioned S3 buckets.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="mfaDelete")
    def mfa_delete(self) -> Optional[str]:
        """
        Specifies whether MFA delete is enabled in the bucket versioning configuration. Valid values: `Enabled` or `Disabled`.
        """
        return pulumi.get(self, "mfa_delete")


@pulumi.output_type
class BucketWebsite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorDocument":
            suggest = "error_document"
        elif key == "indexDocument":
            suggest = "index_document"
        elif key == "redirectAllRequestsTo":
            suggest = "redirect_all_requests_to"
        elif key == "routingRules":
            suggest = "routing_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_document: Optional[str] = None,
                 index_document: Optional[str] = None,
                 redirect_all_requests_to: Optional[str] = None,
                 routing_rules: Optional[str] = None):
        """
        :param str error_document: An absolute path to the document to return in case of a 4XX error.
        :param str index_document: Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
        :param str redirect_all_requests_to: A hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
        :param Union[str, Sequence[str]] routing_rules: A json array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
               describing redirect behavior and when redirects are applied.
               
               The `CORS` object supports the following:
        """
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if redirect_all_requests_to is not None:
            pulumi.set(__self__, "redirect_all_requests_to", redirect_all_requests_to)
        if routing_rules is not None:
            pulumi.set(__self__, "routing_rules", routing_rules)

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[str]:
        """
        An absolute path to the document to return in case of a 4XX error.
        """
        return pulumi.get(self, "error_document")

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[str]:
        """
        Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
        """
        return pulumi.get(self, "index_document")

    @property
    @pulumi.getter(name="redirectAllRequestsTo")
    def redirect_all_requests_to(self) -> Optional[str]:
        """
        A hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
        """
        return pulumi.get(self, "redirect_all_requests_to")

    @property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> Optional[str]:
        """
        A json array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
        describing redirect behavior and when redirects are applied.

        The `CORS` object supports the following:
        """
        return pulumi.get(self, "routing_rules")


@pulumi.output_type
class BucketWebsiteConfigurationV2ErrorDocument(dict):
    def __init__(__self__, *,
                 key: str):
        """
        :param str key: Object key name to use when a 4XX class error occurs.
        """
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Object key name to use when a 4XX class error occurs.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class BucketWebsiteConfigurationV2IndexDocument(dict):
    def __init__(__self__, *,
                 suffix: str):
        """
        :param str suffix: Suffix that is appended to a request that is for a directory on the website endpoint.
               For example, if the suffix is `index.html` and you make a request to `samplebucket/images/`, the data that is returned will be for the object with the key name `images/index.html`.
               The suffix must not be empty and must not include a slash character.
        """
        pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def suffix(self) -> str:
        """
        Suffix that is appended to a request that is for a directory on the website endpoint.
        For example, if the suffix is `index.html` and you make a request to `samplebucket/images/`, the data that is returned will be for the object with the key name `images/index.html`.
        The suffix must not be empty and must not include a slash character.
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class BucketWebsiteConfigurationV2RedirectAllRequestsTo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteConfigurationV2RedirectAllRequestsTo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteConfigurationV2RedirectAllRequestsTo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteConfigurationV2RedirectAllRequestsTo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: str,
                 protocol: Optional[str] = None):
        """
        :param str host_name: Name of the host where requests are redirected.
        :param str protocol: Protocol to use when redirecting requests. The default is the protocol that is used in the original request. Valid values: `http`, `https`.
        """
        pulumi.set(__self__, "host_name", host_name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        Name of the host where requests are redirected.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol to use when redirecting requests. The default is the protocol that is used in the original request. Valid values: `http`, `https`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class BucketWebsiteConfigurationV2RoutingRule(dict):
    def __init__(__self__, *,
                 redirect: 'outputs.BucketWebsiteConfigurationV2RoutingRuleRedirect',
                 condition: Optional['outputs.BucketWebsiteConfigurationV2RoutingRuleCondition'] = None):
        """
        :param 'BucketWebsiteConfigurationV2RoutingRuleRedirectArgs' redirect: Configuration block for redirect information. See below.
        :param 'BucketWebsiteConfigurationV2RoutingRuleConditionArgs' condition: Configuration block for describing a condition that must be met for the specified redirect to apply. See below.
        """
        pulumi.set(__self__, "redirect", redirect)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def redirect(self) -> 'outputs.BucketWebsiteConfigurationV2RoutingRuleRedirect':
        """
        Configuration block for redirect information. See below.
        """
        return pulumi.get(self, "redirect")

    @property
    @pulumi.getter
    def condition(self) -> Optional['outputs.BucketWebsiteConfigurationV2RoutingRuleCondition']:
        """
        Configuration block for describing a condition that must be met for the specified redirect to apply. See below.
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class BucketWebsiteConfigurationV2RoutingRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpErrorCodeReturnedEquals":
            suggest = "http_error_code_returned_equals"
        elif key == "keyPrefixEquals":
            suggest = "key_prefix_equals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteConfigurationV2RoutingRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteConfigurationV2RoutingRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteConfigurationV2RoutingRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_error_code_returned_equals: Optional[str] = None,
                 key_prefix_equals: Optional[str] = None):
        """
        :param str http_error_code_returned_equals: HTTP error code when the redirect is applied. If specified with `key_prefix_equals`, then both must be true for the redirect to be applied.
        :param str key_prefix_equals: Object key name prefix when the redirect is applied. If specified with `http_error_code_returned_equals`, then both must be true for the redirect to be applied.
        """
        if http_error_code_returned_equals is not None:
            pulumi.set(__self__, "http_error_code_returned_equals", http_error_code_returned_equals)
        if key_prefix_equals is not None:
            pulumi.set(__self__, "key_prefix_equals", key_prefix_equals)

    @property
    @pulumi.getter(name="httpErrorCodeReturnedEquals")
    def http_error_code_returned_equals(self) -> Optional[str]:
        """
        HTTP error code when the redirect is applied. If specified with `key_prefix_equals`, then both must be true for the redirect to be applied.
        """
        return pulumi.get(self, "http_error_code_returned_equals")

    @property
    @pulumi.getter(name="keyPrefixEquals")
    def key_prefix_equals(self) -> Optional[str]:
        """
        Object key name prefix when the redirect is applied. If specified with `http_error_code_returned_equals`, then both must be true for the redirect to be applied.
        """
        return pulumi.get(self, "key_prefix_equals")


@pulumi.output_type
class BucketWebsiteConfigurationV2RoutingRuleRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "httpRedirectCode":
            suggest = "http_redirect_code"
        elif key == "replaceKeyPrefixWith":
            suggest = "replace_key_prefix_with"
        elif key == "replaceKeyWith":
            suggest = "replace_key_with"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteConfigurationV2RoutingRuleRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteConfigurationV2RoutingRuleRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteConfigurationV2RoutingRuleRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: Optional[str] = None,
                 http_redirect_code: Optional[str] = None,
                 protocol: Optional[str] = None,
                 replace_key_prefix_with: Optional[str] = None,
                 replace_key_with: Optional[str] = None):
        """
        :param str host_name: Host name to use in the redirect request.
        :param str http_redirect_code: HTTP redirect code to use on the response.
        :param str protocol: Protocol to use when redirecting requests. The default is the protocol that is used in the original request. Valid values: `http`, `https`.
        :param str replace_key_prefix_with: Object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix `docs/` (objects in the `docs/` folder) to `documents/`, you can set a `condition` block with `key_prefix_equals` set to `docs/` and in the `redirect` set `replace_key_prefix_with` to `/documents`.
        :param str replace_key_with: Specific object key to use in the redirect request. For example, redirect request to `error.html`.
        """
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if http_redirect_code is not None:
            pulumi.set(__self__, "http_redirect_code", http_redirect_code)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if replace_key_prefix_with is not None:
            pulumi.set(__self__, "replace_key_prefix_with", replace_key_prefix_with)
        if replace_key_with is not None:
            pulumi.set(__self__, "replace_key_with", replace_key_with)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        Host name to use in the redirect request.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="httpRedirectCode")
    def http_redirect_code(self) -> Optional[str]:
        """
        HTTP redirect code to use on the response.
        """
        return pulumi.get(self, "http_redirect_code")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol to use when redirecting requests. The default is the protocol that is used in the original request. Valid values: `http`, `https`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="replaceKeyPrefixWith")
    def replace_key_prefix_with(self) -> Optional[str]:
        """
        Object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix `docs/` (objects in the `docs/` folder) to `documents/`, you can set a `condition` block with `key_prefix_equals` set to `docs/` and in the `redirect` set `replace_key_prefix_with` to `/documents`.
        """
        return pulumi.get(self, "replace_key_prefix_with")

    @property
    @pulumi.getter(name="replaceKeyWith")
    def replace_key_with(self) -> Optional[str]:
        """
        Specific object key to use in the redirect request. For example, redirect request to `error.html`.
        """
        return pulumi.get(self, "replace_key_with")


@pulumi.output_type
class DirectoryBucketLocation(dict):
    def __init__(__self__, *,
                 name: str,
                 type: Optional[str] = None):
        """
        :param str name: [Availability Zone ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#az-ids).
        :param str type: Location type. Valid values: `AvailabilityZone`.
        """
        pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        [Availability Zone ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#az-ids).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Location type. Valid values: `AvailabilityZone`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InventoryDestination(dict):
    def __init__(__self__, *,
                 bucket: 'outputs.InventoryDestinationBucket'):
        """
        :param 'InventoryDestinationBucketArgs' bucket: S3 bucket configuration where inventory results are published (documented below).
        """
        pulumi.set(__self__, "bucket", bucket)

    @property
    @pulumi.getter
    def bucket(self) -> 'outputs.InventoryDestinationBucket':
        """
        S3 bucket configuration where inventory results are published (documented below).
        """
        return pulumi.get(self, "bucket")


@pulumi.output_type
class InventoryDestinationBucket(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketArn":
            suggest = "bucket_arn"
        elif key == "accountId":
            suggest = "account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InventoryDestinationBucket. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InventoryDestinationBucket.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InventoryDestinationBucket.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: str,
                 format: str,
                 account_id: Optional[str] = None,
                 encryption: Optional['outputs.InventoryDestinationBucketEncryption'] = None,
                 prefix: Optional[str] = None):
        """
        :param str bucket_arn: Amazon S3 bucket ARN of the destination.
        :param str format: Specifies the output format of the inventory results. Can be `CSV`, [`ORC`](https://orc.apache.org/) or [`Parquet`](https://parquet.apache.org/).
        :param str account_id: ID of the account that owns the destination bucket. Recommended to be set to prevent problems if the destination bucket ownership changes.
        :param 'InventoryDestinationBucketEncryptionArgs' encryption: Contains the type of server-side encryption to use to encrypt the inventory (documented below).
        :param str prefix: Prefix that is prepended to all inventory results.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        pulumi.set(__self__, "format", format)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> str:
        """
        Amazon S3 bucket ARN of the destination.
        """
        return pulumi.get(self, "bucket_arn")

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        Specifies the output format of the inventory results. Can be `CSV`, [`ORC`](https://orc.apache.org/) or [`Parquet`](https://parquet.apache.org/).
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        ID of the account that owns the destination bucket. Recommended to be set to prevent problems if the destination bucket ownership changes.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.InventoryDestinationBucketEncryption']:
        """
        Contains the type of server-side encryption to use to encrypt the inventory (documented below).
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Prefix that is prepended to all inventory results.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class InventoryDestinationBucketEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseKms":
            suggest = "sse_kms"
        elif key == "sseS3":
            suggest = "sse_s3"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InventoryDestinationBucketEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InventoryDestinationBucketEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InventoryDestinationBucketEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_kms: Optional['outputs.InventoryDestinationBucketEncryptionSseKms'] = None,
                 sse_s3: Optional['outputs.InventoryDestinationBucketEncryptionSseS3'] = None):
        """
        :param 'InventoryDestinationBucketEncryptionSseKmsArgs' sse_kms: Specifies to use server-side encryption with AWS KMS-managed keys to encrypt the inventory file (documented below).
        :param 'InventoryDestinationBucketEncryptionSseS3Args' sse_s3: Specifies to use server-side encryption with Amazon S3-managed keys (SSE-S3) to encrypt the inventory file.
        """
        if sse_kms is not None:
            pulumi.set(__self__, "sse_kms", sse_kms)
        if sse_s3 is not None:
            pulumi.set(__self__, "sse_s3", sse_s3)

    @property
    @pulumi.getter(name="sseKms")
    def sse_kms(self) -> Optional['outputs.InventoryDestinationBucketEncryptionSseKms']:
        """
        Specifies to use server-side encryption with AWS KMS-managed keys to encrypt the inventory file (documented below).
        """
        return pulumi.get(self, "sse_kms")

    @property
    @pulumi.getter(name="sseS3")
    def sse_s3(self) -> Optional['outputs.InventoryDestinationBucketEncryptionSseS3']:
        """
        Specifies to use server-side encryption with Amazon S3-managed keys (SSE-S3) to encrypt the inventory file.
        """
        return pulumi.get(self, "sse_s3")


@pulumi.output_type
class InventoryDestinationBucketEncryptionSseKms(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InventoryDestinationBucketEncryptionSseKms. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InventoryDestinationBucketEncryptionSseKms.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InventoryDestinationBucketEncryptionSseKms.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: str):
        """
        :param str key_id: ARN of the KMS customer master key (CMK) used to encrypt the inventory file.
        """
        pulumi.set(__self__, "key_id", key_id)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        ARN of the KMS customer master key (CMK) used to encrypt the inventory file.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class InventoryDestinationBucketEncryptionSseS3(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class InventoryFilter(dict):
    def __init__(__self__, *,
                 prefix: Optional[str] = None):
        """
        :param str prefix: Prefix that an object must have to be included in the inventory results.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Prefix that an object must have to be included in the inventory results.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class InventorySchedule(dict):
    def __init__(__self__, *,
                 frequency: str):
        """
        :param str frequency: Specifies how frequently inventory results are produced. Valid values: `Daily`, `Weekly`.
        """
        pulumi.set(__self__, "frequency", frequency)

    @property
    @pulumi.getter
    def frequency(self) -> str:
        """
        Specifies how frequently inventory results are produced. Valid values: `Daily`, `Weekly`.
        """
        return pulumi.get(self, "frequency")


@pulumi.output_type
class ObjectCopyGrant(dict):
    def __init__(__self__, *,
                 permissions: Sequence[str],
                 type: str,
                 email: Optional[str] = None,
                 id: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param Sequence[str] permissions: List of permissions to grant to grantee. Valid values are `READ`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
        :param str type: Type of grantee. Valid values are `CanonicalUser`, `Group`, and `AmazonCustomerByEmail`.
               
               This configuration block has the following optional arguments (one of the three is required):
        :param str email: Email address of the grantee. Used only when `type` is `AmazonCustomerByEmail`.
        :param str id: Canonical user ID of the grantee. Used only when `type` is `CanonicalUser`.
        :param str uri: URI of the grantee group. Used only when `type` is `Group`.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "type", type)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        List of permissions to grant to grantee. Valid values are `READ`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of grantee. Valid values are `CanonicalUser`, `Group`, and `AmazonCustomerByEmail`.

        This configuration block has the following optional arguments (one of the three is required):
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Email address of the grantee. Used only when `type` is `AmazonCustomerByEmail`.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Canonical user ID of the grantee. Used only when `type` is `CanonicalUser`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        URI of the grantee group. Used only when `type` is `Group`.
        """
        return pulumi.get(self, "uri")


