# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecretVersionsResult',
    'AwaitableGetSecretVersionsResult',
    'get_secret_versions',
    'get_secret_versions_output',
]

@pulumi.output_type
class GetSecretVersionsResult:
    """
    A collection of values returned by getSecretVersions.
    """
    def __init__(__self__, arn=None, id=None, include_deprecated=None, name=None, secret_id=None, versions=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_deprecated and not isinstance(include_deprecated, bool):
            raise TypeError("Expected argument 'include_deprecated' to be a bool")
        pulumi.set(__self__, "include_deprecated", include_deprecated)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the secret.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includeDeprecated")
    def include_deprecated(self) -> Optional[bool]:
        return pulumi.get(self, "include_deprecated")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetSecretVersionsVersionResult']:
        """
        List of the versions of the secret. Attributes are specified below.
        """
        return pulumi.get(self, "versions")


class AwaitableGetSecretVersionsResult(GetSecretVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretVersionsResult(
            arn=self.arn,
            id=self.id,
            include_deprecated=self.include_deprecated,
            name=self.name,
            secret_id=self.secret_id,
            versions=self.versions)


def get_secret_versions(include_deprecated: Optional[bool] = None,
                        secret_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretVersionsResult:
    """
    Use this data source to access information about an existing resource.

    :param bool include_deprecated: If true, all deprecated secret versions are included in the response.
           If false, no deprecated secret versions are included in the response. If no value is specified, the default value is `false`.
    :param str secret_id: Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
    """
    __args__ = dict()
    __args__['includeDeprecated'] = include_deprecated
    __args__['secretId'] = secret_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:secretsmanager/getSecretVersions:getSecretVersions', __args__, opts=opts, typ=GetSecretVersionsResult).value

    return AwaitableGetSecretVersionsResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        include_deprecated=pulumi.get(__ret__, 'include_deprecated'),
        name=pulumi.get(__ret__, 'name'),
        secret_id=pulumi.get(__ret__, 'secret_id'),
        versions=pulumi.get(__ret__, 'versions'))
def get_secret_versions_output(include_deprecated: Optional[pulumi.Input[Optional[bool]]] = None,
                               secret_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecretVersionsResult]:
    """
    Use this data source to access information about an existing resource.

    :param bool include_deprecated: If true, all deprecated secret versions are included in the response.
           If false, no deprecated secret versions are included in the response. If no value is specified, the default value is `false`.
    :param str secret_id: Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
    """
    __args__ = dict()
    __args__['includeDeprecated'] = include_deprecated
    __args__['secretId'] = secret_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:secretsmanager/getSecretVersions:getSecretVersions', __args__, opts=opts, typ=GetSecretVersionsResult)
    return __ret__.apply(lambda __response__: GetSecretVersionsResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        include_deprecated=pulumi.get(__response__, 'include_deprecated'),
        name=pulumi.get(__response__, 'name'),
        secret_id=pulumi.get(__response__, 'secret_id'),
        versions=pulumi.get(__response__, 'versions')))
