# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SubscriberNotificationArgs', 'SubscriberNotification']

@pulumi.input_type
class SubscriberNotificationArgs:
    def __init__(__self__, *,
                 subscriber_id: pulumi.Input[str],
                 configuration: Optional[pulumi.Input['SubscriberNotificationConfigurationArgs']] = None):
        """
        The set of arguments for constructing a SubscriberNotification resource.
        :param pulumi.Input[str] subscriber_id: The subscriber ID for the notification subscription.
        :param pulumi.Input['SubscriberNotificationConfigurationArgs'] configuration: Specify the configuration using which you want to create the subscriber notification..
        """
        pulumi.set(__self__, "subscriber_id", subscriber_id)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)

    @property
    @pulumi.getter(name="subscriberId")
    def subscriber_id(self) -> pulumi.Input[str]:
        """
        The subscriber ID for the notification subscription.
        """
        return pulumi.get(self, "subscriber_id")

    @subscriber_id.setter
    def subscriber_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subscriber_id", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['SubscriberNotificationConfigurationArgs']]:
        """
        Specify the configuration using which you want to create the subscriber notification..
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['SubscriberNotificationConfigurationArgs']]):
        pulumi.set(self, "configuration", value)


@pulumi.input_type
class _SubscriberNotificationState:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input['SubscriberNotificationConfigurationArgs']] = None,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 subscriber_endpoint: Optional[pulumi.Input[str]] = None,
                 subscriber_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SubscriberNotification resources.
        :param pulumi.Input['SubscriberNotificationConfigurationArgs'] configuration: Specify the configuration using which you want to create the subscriber notification..
        :param pulumi.Input[str] endpoint_id: (**Deprecated**) The subscriber endpoint to which exception messages are posted.
        :param pulumi.Input[str] subscriber_endpoint: The subscriber endpoint to which exception messages are posted.
        :param pulumi.Input[str] subscriber_id: The subscriber ID for the notification subscription.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if endpoint_id is not None:
            warnings.warn("""Use subscriber_endpoint instead""", DeprecationWarning)
            pulumi.log.warn("""endpoint_id is deprecated: Use subscriber_endpoint instead""")
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if subscriber_endpoint is not None:
            pulumi.set(__self__, "subscriber_endpoint", subscriber_endpoint)
        if subscriber_id is not None:
            pulumi.set(__self__, "subscriber_id", subscriber_id)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['SubscriberNotificationConfigurationArgs']]:
        """
        Specify the configuration using which you want to create the subscriber notification..
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['SubscriberNotificationConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="endpointId")
    @_utilities.deprecated("""Use subscriber_endpoint instead""")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        (**Deprecated**) The subscriber endpoint to which exception messages are posted.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter(name="subscriberEndpoint")
    def subscriber_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The subscriber endpoint to which exception messages are posted.
        """
        return pulumi.get(self, "subscriber_endpoint")

    @subscriber_endpoint.setter
    def subscriber_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscriber_endpoint", value)

    @property
    @pulumi.getter(name="subscriberId")
    def subscriber_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subscriber ID for the notification subscription.
        """
        return pulumi.get(self, "subscriber_id")

    @subscriber_id.setter
    def subscriber_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscriber_id", value)


class SubscriberNotification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['SubscriberNotificationConfigurationArgs', 'SubscriberNotificationConfigurationArgsDict']]] = None,
                 subscriber_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Security Lake Subscriber Notification.

        ## Example Usage

        ### SQS Notification

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securitylake.SubscriberNotification("example",
            subscriber_id=example_aws_securitylake_subscriber["id"],
            configuration={
                "sqs_notification_configuration": {},
            })
        ```

        ### HTTPS Notification

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securitylake.SubscriberNotification("example",
            subscriber_id=example_aws_securitylake_subscriber["id"],
            configuration={
                "https_notification_configuration": {
                    "endpoint": test["apiEndpoint"],
                    "target_role_arn": event_bridge["arn"],
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SubscriberNotificationConfigurationArgs', 'SubscriberNotificationConfigurationArgsDict']] configuration: Specify the configuration using which you want to create the subscriber notification..
        :param pulumi.Input[str] subscriber_id: The subscriber ID for the notification subscription.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriberNotificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Security Lake Subscriber Notification.

        ## Example Usage

        ### SQS Notification

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securitylake.SubscriberNotification("example",
            subscriber_id=example_aws_securitylake_subscriber["id"],
            configuration={
                "sqs_notification_configuration": {},
            })
        ```

        ### HTTPS Notification

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securitylake.SubscriberNotification("example",
            subscriber_id=example_aws_securitylake_subscriber["id"],
            configuration={
                "https_notification_configuration": {
                    "endpoint": test["apiEndpoint"],
                    "target_role_arn": event_bridge["arn"],
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param SubscriberNotificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriberNotificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['SubscriberNotificationConfigurationArgs', 'SubscriberNotificationConfigurationArgsDict']]] = None,
                 subscriber_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriberNotificationArgs.__new__(SubscriberNotificationArgs)

            __props__.__dict__["configuration"] = configuration
            if subscriber_id is None and not opts.urn:
                raise TypeError("Missing required property 'subscriber_id'")
            __props__.__dict__["subscriber_id"] = subscriber_id
            __props__.__dict__["endpoint_id"] = None
            __props__.__dict__["subscriber_endpoint"] = None
        super(SubscriberNotification, __self__).__init__(
            'aws:securitylake/subscriberNotification:SubscriberNotification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration: Optional[pulumi.Input[Union['SubscriberNotificationConfigurationArgs', 'SubscriberNotificationConfigurationArgsDict']]] = None,
            endpoint_id: Optional[pulumi.Input[str]] = None,
            subscriber_endpoint: Optional[pulumi.Input[str]] = None,
            subscriber_id: Optional[pulumi.Input[str]] = None) -> 'SubscriberNotification':
        """
        Get an existing SubscriberNotification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SubscriberNotificationConfigurationArgs', 'SubscriberNotificationConfigurationArgsDict']] configuration: Specify the configuration using which you want to create the subscriber notification..
        :param pulumi.Input[str] endpoint_id: (**Deprecated**) The subscriber endpoint to which exception messages are posted.
        :param pulumi.Input[str] subscriber_endpoint: The subscriber endpoint to which exception messages are posted.
        :param pulumi.Input[str] subscriber_id: The subscriber ID for the notification subscription.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubscriberNotificationState.__new__(_SubscriberNotificationState)

        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["endpoint_id"] = endpoint_id
        __props__.__dict__["subscriber_endpoint"] = subscriber_endpoint
        __props__.__dict__["subscriber_id"] = subscriber_id
        return SubscriberNotification(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Optional['outputs.SubscriberNotificationConfiguration']]:
        """
        Specify the configuration using which you want to create the subscriber notification..
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="endpointId")
    @_utilities.deprecated("""Use subscriber_endpoint instead""")
    def endpoint_id(self) -> pulumi.Output[str]:
        """
        (**Deprecated**) The subscriber endpoint to which exception messages are posted.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="subscriberEndpoint")
    def subscriber_endpoint(self) -> pulumi.Output[str]:
        """
        The subscriber endpoint to which exception messages are posted.
        """
        return pulumi.get(self, "subscriber_endpoint")

    @property
    @pulumi.getter(name="subscriberId")
    def subscriber_id(self) -> pulumi.Output[str]:
        """
        The subscriber ID for the notification subscription.
        """
        return pulumi.get(self, "subscriber_id")

