# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AppregistryApplicationArgs', 'AppregistryApplication']

@pulumi.input_type
class AppregistryApplicationArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AppregistryApplication resource.
        :param pulumi.Input[str] description: Description of the application.
        :param pulumi.Input[str] name: Name of the application. The name must be unique within an AWS region.
               
               The following arguments are optional:
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the application.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the application. The name must be unique within an AWS region.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AppregistryApplicationState:
    def __init__(__self__, *,
                 application_tag: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AppregistryApplication resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] application_tag: A map with a single tag key-value pair used to associate resources with the application. This attribute can be passed directly into the `tags` argument of another resource, or merged into a map of existing tags.
        :param pulumi.Input[str] arn: ARN (Amazon Resource Name) of the application.
        :param pulumi.Input[str] description: Description of the application.
        :param pulumi.Input[str] name: Name of the application. The name must be unique within an AWS region.
               
               The following arguments are optional:
        """
        if application_tag is not None:
            pulumi.set(__self__, "application_tag", application_tag)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="applicationTag")
    def application_tag(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map with a single tag key-value pair used to associate resources with the application. This attribute can be passed directly into the `tags` argument of another resource, or merged into a map of existing tags.
        """
        return pulumi.get(self, "application_tag")

    @application_tag.setter
    def application_tag(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "application_tag", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN (Amazon Resource Name) of the application.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the application.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the application. The name must be unique within an AWS region.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class AppregistryApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Service Catalog AppRegistry Application.

        > An AWS Service Catalog AppRegistry Application is displayed in the AWS Console under "MyApplications".

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.servicecatalog.AppregistryApplication("example", name="example-app")
        ```

        ### Connecting Resources

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.servicecatalog.AppregistryApplication("example", name="example-app")
        bucket = aws.s3.BucketV2("bucket",
            bucket="example-bucket",
            tags=example.application_tag)
        ```

        ## Import

        Using `pulumi import`, import AWS Service Catalog AppRegistry Application using the `id`. For example:

        ```sh
        $ pulumi import aws:servicecatalog/appregistryApplication:AppregistryApplication example application-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the application.
        :param pulumi.Input[str] name: Name of the application. The name must be unique within an AWS region.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AppregistryApplicationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Service Catalog AppRegistry Application.

        > An AWS Service Catalog AppRegistry Application is displayed in the AWS Console under "MyApplications".

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.servicecatalog.AppregistryApplication("example", name="example-app")
        ```

        ### Connecting Resources

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.servicecatalog.AppregistryApplication("example", name="example-app")
        bucket = aws.s3.BucketV2("bucket",
            bucket="example-bucket",
            tags=example.application_tag)
        ```

        ## Import

        Using `pulumi import`, import AWS Service Catalog AppRegistry Application using the `id`. For example:

        ```sh
        $ pulumi import aws:servicecatalog/appregistryApplication:AppregistryApplication example application-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param AppregistryApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppregistryApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppregistryApplicationArgs.__new__(AppregistryApplicationArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["application_tag"] = None
            __props__.__dict__["arn"] = None
        super(AppregistryApplication, __self__).__init__(
            'aws:servicecatalog/appregistryApplication:AppregistryApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_tag: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'AppregistryApplication':
        """
        Get an existing AppregistryApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] application_tag: A map with a single tag key-value pair used to associate resources with the application. This attribute can be passed directly into the `tags` argument of another resource, or merged into a map of existing tags.
        :param pulumi.Input[str] arn: ARN (Amazon Resource Name) of the application.
        :param pulumi.Input[str] description: Description of the application.
        :param pulumi.Input[str] name: Name of the application. The name must be unique within an AWS region.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppregistryApplicationState.__new__(_AppregistryApplicationState)

        __props__.__dict__["application_tag"] = application_tag
        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        return AppregistryApplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationTag")
    def application_tag(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map with a single tag key-value pair used to associate resources with the application. This attribute can be passed directly into the `tags` argument of another resource, or merged into a map of existing tags.
        """
        return pulumi.get(self, "application_tag")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN (Amazon Resource Name) of the application.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the application.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the application. The name must be unique within an AWS region.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

