# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAliasResult',
    'AwaitableGetAliasResult',
    'get_alias',
    'get_alias_output',
]

@pulumi.output_type
class GetAliasResult:
    """
    A collection of values returned by getAlias.
    """
    def __init__(__self__, arn=None, creation_date=None, description=None, id=None, name=None, routing_configurations=None, statemachine_arn=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if creation_date and not isinstance(creation_date, str):
            raise TypeError("Expected argument 'creation_date' to be a str")
        pulumi.set(__self__, "creation_date", creation_date)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if routing_configurations and not isinstance(routing_configurations, list):
            raise TypeError("Expected argument 'routing_configurations' to be a list")
        pulumi.set(__self__, "routing_configurations", routing_configurations)
        if statemachine_arn and not isinstance(statemachine_arn, str):
            raise TypeError("Expected argument 'statemachine_arn' to be a str")
        pulumi.set(__self__, "statemachine_arn", statemachine_arn)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN identifying the State Machine alias.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> str:
        """
        Date the state machine Alias was created.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of state machine alias.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routingConfigurations")
    def routing_configurations(self) -> Sequence['outputs.GetAliasRoutingConfigurationResult']:
        """
        Routing Configuration of state machine alias
        """
        return pulumi.get(self, "routing_configurations")

    @property
    @pulumi.getter(name="statemachineArn")
    def statemachine_arn(self) -> str:
        return pulumi.get(self, "statemachine_arn")


class AwaitableGetAliasResult(GetAliasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAliasResult(
            arn=self.arn,
            creation_date=self.creation_date,
            description=self.description,
            id=self.id,
            name=self.name,
            routing_configurations=self.routing_configurations,
            statemachine_arn=self.statemachine_arn)


def get_alias(description: Optional[str] = None,
              name: Optional[str] = None,
              statemachine_arn: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAliasResult:
    """
    Data source for managing an AWS SFN (Step Functions) State Machine Alias.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.sfn.get_alias(name="my_sfn_alias",
        statemachine_arn=sfn_test["arn"])
    ```


    :param str description: Description of state machine alias.
    :param str name: Name of the State Machine alias.
    :param str statemachine_arn: ARN of the State Machine.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['name'] = name
    __args__['statemachineArn'] = statemachine_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:sfn/getAlias:getAlias', __args__, opts=opts, typ=GetAliasResult).value

    return AwaitableGetAliasResult(
        arn=pulumi.get(__ret__, 'arn'),
        creation_date=pulumi.get(__ret__, 'creation_date'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        routing_configurations=pulumi.get(__ret__, 'routing_configurations'),
        statemachine_arn=pulumi.get(__ret__, 'statemachine_arn'))
def get_alias_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                     name: Optional[pulumi.Input[str]] = None,
                     statemachine_arn: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAliasResult]:
    """
    Data source for managing an AWS SFN (Step Functions) State Machine Alias.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.sfn.get_alias(name="my_sfn_alias",
        statemachine_arn=sfn_test["arn"])
    ```


    :param str description: Description of state machine alias.
    :param str name: Name of the State Machine alias.
    :param str statemachine_arn: ARN of the State Machine.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['name'] = name
    __args__['statemachineArn'] = statemachine_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:sfn/getAlias:getAlias', __args__, opts=opts, typ=GetAliasResult)
    return __ret__.apply(lambda __response__: GetAliasResult(
        arn=pulumi.get(__response__, 'arn'),
        creation_date=pulumi.get(__response__, 'creation_date'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        routing_configurations=pulumi.get(__response__, 'routing_configurations'),
        statemachine_arn=pulumi.get(__response__, 'statemachine_arn')))
