# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AssociationArgs', 'Association']

@pulumi.input_type
class AssociationArgs:
    def __init__(__self__, *,
                 apply_only_at_cron_interval: Optional[pulumi.Input[bool]] = None,
                 association_name: Optional[pulumi.Input[str]] = None,
                 automation_target_parameter_name: Optional[pulumi.Input[str]] = None,
                 compliance_severity: Optional[pulumi.Input[str]] = None,
                 document_version: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 max_concurrency: Optional[pulumi.Input[str]] = None,
                 max_errors: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_location: Optional[pulumi.Input['AssociationOutputLocationArgs']] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 schedule_expression: Optional[pulumi.Input[str]] = None,
                 sync_compliance: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]] = None,
                 wait_for_success_timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Association resource.
        :param pulumi.Input[bool] apply_only_at_cron_interval: By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
        :param pulumi.Input[str] association_name: The descriptive name for the association.
        :param pulumi.Input[str] automation_target_parameter_name: Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
        :param pulumi.Input[str] compliance_severity: The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
        :param pulumi.Input[str] document_version: The document version you want to associate with the target(s). Can be a specific version or the default version.
        :param pulumi.Input[str] instance_id: The instance ID to apply an SSM document to. Use `targets` with key `InstanceIds` for document schema versions 2.0 and above. Use the `targets` attribute instead.
        :param pulumi.Input[str] max_concurrency: The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
        :param pulumi.Input[str] max_errors: The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
        :param pulumi.Input[str] name: The name of the SSM document to apply.
        :param pulumi.Input['AssociationOutputLocationArgs'] output_location: An output location block. Output Location is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: A block of arbitrary string parameters to pass to the SSM document.
        :param pulumi.Input[str] schedule_expression: A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
        :param pulumi.Input[str] sync_compliance: The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]] targets: A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
        :param pulumi.Input[int] wait_for_success_timeout_seconds: The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.
               
               Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
        """
        if apply_only_at_cron_interval is not None:
            pulumi.set(__self__, "apply_only_at_cron_interval", apply_only_at_cron_interval)
        if association_name is not None:
            pulumi.set(__self__, "association_name", association_name)
        if automation_target_parameter_name is not None:
            pulumi.set(__self__, "automation_target_parameter_name", automation_target_parameter_name)
        if compliance_severity is not None:
            pulumi.set(__self__, "compliance_severity", compliance_severity)
        if document_version is not None:
            pulumi.set(__self__, "document_version", document_version)
        if instance_id is not None:
            warnings.warn("""use 'targets' argument instead. https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociation.html#systemsmanager-CreateAssociation-request-InstanceId""", DeprecationWarning)
            pulumi.log.warn("""instance_id is deprecated: use 'targets' argument instead. https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociation.html#systemsmanager-CreateAssociation-request-InstanceId""")
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_errors is not None:
            pulumi.set(__self__, "max_errors", max_errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)
        if sync_compliance is not None:
            pulumi.set(__self__, "sync_compliance", sync_compliance)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if wait_for_success_timeout_seconds is not None:
            pulumi.set(__self__, "wait_for_success_timeout_seconds", wait_for_success_timeout_seconds)

    @property
    @pulumi.getter(name="applyOnlyAtCronInterval")
    def apply_only_at_cron_interval(self) -> Optional[pulumi.Input[bool]]:
        """
        By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
        """
        return pulumi.get(self, "apply_only_at_cron_interval")

    @apply_only_at_cron_interval.setter
    def apply_only_at_cron_interval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_only_at_cron_interval", value)

    @property
    @pulumi.getter(name="associationName")
    def association_name(self) -> Optional[pulumi.Input[str]]:
        """
        The descriptive name for the association.
        """
        return pulumi.get(self, "association_name")

    @association_name.setter
    def association_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "association_name", value)

    @property
    @pulumi.getter(name="automationTargetParameterName")
    def automation_target_parameter_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
        """
        return pulumi.get(self, "automation_target_parameter_name")

    @automation_target_parameter_name.setter
    def automation_target_parameter_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "automation_target_parameter_name", value)

    @property
    @pulumi.getter(name="complianceSeverity")
    def compliance_severity(self) -> Optional[pulumi.Input[str]]:
        """
        The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
        """
        return pulumi.get(self, "compliance_severity")

    @compliance_severity.setter
    def compliance_severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compliance_severity", value)

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[pulumi.Input[str]]:
        """
        The document version you want to associate with the target(s). Can be a specific version or the default version.
        """
        return pulumi.get(self, "document_version")

    @document_version.setter
    def document_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "document_version", value)

    @property
    @pulumi.getter(name="instanceId")
    @_utilities.deprecated("""use 'targets' argument instead. https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociation.html#systemsmanager-CreateAssociation-request-InstanceId""")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The instance ID to apply an SSM document to. Use `targets` with key `InstanceIds` for document schema versions 2.0 and above. Use the `targets` attribute instead.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_concurrency", value)

    @property
    @pulumi.getter(name="maxErrors")
    def max_errors(self) -> Optional[pulumi.Input[str]]:
        """
        The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
        """
        return pulumi.get(self, "max_errors")

    @max_errors.setter
    def max_errors(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_errors", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SSM document to apply.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[pulumi.Input['AssociationOutputLocationArgs']]:
        """
        An output location block. Output Location is documented below.
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: Optional[pulumi.Input['AssociationOutputLocationArgs']]):
        pulumi.set(self, "output_location", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A block of arbitrary string parameters to pass to the SSM document.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[pulumi.Input[str]]:
        """
        A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_expression", value)

    @property
    @pulumi.getter(name="syncCompliance")
    def sync_compliance(self) -> Optional[pulumi.Input[str]]:
        """
        The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
        """
        return pulumi.get(self, "sync_compliance")

    @sync_compliance.setter
    def sync_compliance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sync_compliance", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]]:
        """
        A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter(name="waitForSuccessTimeoutSeconds")
    def wait_for_success_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.

        Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
        """
        return pulumi.get(self, "wait_for_success_timeout_seconds")

    @wait_for_success_timeout_seconds.setter
    def wait_for_success_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "wait_for_success_timeout_seconds", value)


@pulumi.input_type
class _AssociationState:
    def __init__(__self__, *,
                 apply_only_at_cron_interval: Optional[pulumi.Input[bool]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 association_id: Optional[pulumi.Input[str]] = None,
                 association_name: Optional[pulumi.Input[str]] = None,
                 automation_target_parameter_name: Optional[pulumi.Input[str]] = None,
                 compliance_severity: Optional[pulumi.Input[str]] = None,
                 document_version: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 max_concurrency: Optional[pulumi.Input[str]] = None,
                 max_errors: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_location: Optional[pulumi.Input['AssociationOutputLocationArgs']] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 schedule_expression: Optional[pulumi.Input[str]] = None,
                 sync_compliance: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]] = None,
                 wait_for_success_timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Association resources.
        :param pulumi.Input[bool] apply_only_at_cron_interval: By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
        :param pulumi.Input[str] arn: The ARN of the SSM association
        :param pulumi.Input[str] association_id: The ID of the SSM association.
        :param pulumi.Input[str] association_name: The descriptive name for the association.
        :param pulumi.Input[str] automation_target_parameter_name: Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
        :param pulumi.Input[str] compliance_severity: The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
        :param pulumi.Input[str] document_version: The document version you want to associate with the target(s). Can be a specific version or the default version.
        :param pulumi.Input[str] instance_id: The instance ID to apply an SSM document to. Use `targets` with key `InstanceIds` for document schema versions 2.0 and above. Use the `targets` attribute instead.
        :param pulumi.Input[str] max_concurrency: The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
        :param pulumi.Input[str] max_errors: The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
        :param pulumi.Input[str] name: The name of the SSM document to apply.
        :param pulumi.Input['AssociationOutputLocationArgs'] output_location: An output location block. Output Location is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: A block of arbitrary string parameters to pass to the SSM document.
        :param pulumi.Input[str] schedule_expression: A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
        :param pulumi.Input[str] sync_compliance: The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]] targets: A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
        :param pulumi.Input[int] wait_for_success_timeout_seconds: The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.
               
               Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
        """
        if apply_only_at_cron_interval is not None:
            pulumi.set(__self__, "apply_only_at_cron_interval", apply_only_at_cron_interval)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if association_id is not None:
            pulumi.set(__self__, "association_id", association_id)
        if association_name is not None:
            pulumi.set(__self__, "association_name", association_name)
        if automation_target_parameter_name is not None:
            pulumi.set(__self__, "automation_target_parameter_name", automation_target_parameter_name)
        if compliance_severity is not None:
            pulumi.set(__self__, "compliance_severity", compliance_severity)
        if document_version is not None:
            pulumi.set(__self__, "document_version", document_version)
        if instance_id is not None:
            warnings.warn("""use 'targets' argument instead. https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociation.html#systemsmanager-CreateAssociation-request-InstanceId""", DeprecationWarning)
            pulumi.log.warn("""instance_id is deprecated: use 'targets' argument instead. https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociation.html#systemsmanager-CreateAssociation-request-InstanceId""")
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_errors is not None:
            pulumi.set(__self__, "max_errors", max_errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)
        if sync_compliance is not None:
            pulumi.set(__self__, "sync_compliance", sync_compliance)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if wait_for_success_timeout_seconds is not None:
            pulumi.set(__self__, "wait_for_success_timeout_seconds", wait_for_success_timeout_seconds)

    @property
    @pulumi.getter(name="applyOnlyAtCronInterval")
    def apply_only_at_cron_interval(self) -> Optional[pulumi.Input[bool]]:
        """
        By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
        """
        return pulumi.get(self, "apply_only_at_cron_interval")

    @apply_only_at_cron_interval.setter
    def apply_only_at_cron_interval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_only_at_cron_interval", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the SSM association
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the SSM association.
        """
        return pulumi.get(self, "association_id")

    @association_id.setter
    def association_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "association_id", value)

    @property
    @pulumi.getter(name="associationName")
    def association_name(self) -> Optional[pulumi.Input[str]]:
        """
        The descriptive name for the association.
        """
        return pulumi.get(self, "association_name")

    @association_name.setter
    def association_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "association_name", value)

    @property
    @pulumi.getter(name="automationTargetParameterName")
    def automation_target_parameter_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
        """
        return pulumi.get(self, "automation_target_parameter_name")

    @automation_target_parameter_name.setter
    def automation_target_parameter_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "automation_target_parameter_name", value)

    @property
    @pulumi.getter(name="complianceSeverity")
    def compliance_severity(self) -> Optional[pulumi.Input[str]]:
        """
        The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
        """
        return pulumi.get(self, "compliance_severity")

    @compliance_severity.setter
    def compliance_severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compliance_severity", value)

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[pulumi.Input[str]]:
        """
        The document version you want to associate with the target(s). Can be a specific version or the default version.
        """
        return pulumi.get(self, "document_version")

    @document_version.setter
    def document_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "document_version", value)

    @property
    @pulumi.getter(name="instanceId")
    @_utilities.deprecated("""use 'targets' argument instead. https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociation.html#systemsmanager-CreateAssociation-request-InstanceId""")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The instance ID to apply an SSM document to. Use `targets` with key `InstanceIds` for document schema versions 2.0 and above. Use the `targets` attribute instead.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_concurrency", value)

    @property
    @pulumi.getter(name="maxErrors")
    def max_errors(self) -> Optional[pulumi.Input[str]]:
        """
        The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
        """
        return pulumi.get(self, "max_errors")

    @max_errors.setter
    def max_errors(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_errors", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SSM document to apply.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[pulumi.Input['AssociationOutputLocationArgs']]:
        """
        An output location block. Output Location is documented below.
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: Optional[pulumi.Input['AssociationOutputLocationArgs']]):
        pulumi.set(self, "output_location", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A block of arbitrary string parameters to pass to the SSM document.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[pulumi.Input[str]]:
        """
        A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_expression", value)

    @property
    @pulumi.getter(name="syncCompliance")
    def sync_compliance(self) -> Optional[pulumi.Input[str]]:
        """
        The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
        """
        return pulumi.get(self, "sync_compliance")

    @sync_compliance.setter
    def sync_compliance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sync_compliance", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]]:
        """
        A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter(name="waitForSuccessTimeoutSeconds")
    def wait_for_success_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.

        Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
        """
        return pulumi.get(self, "wait_for_success_timeout_seconds")

    @wait_for_success_timeout_seconds.setter
    def wait_for_success_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "wait_for_success_timeout_seconds", value)


class Association(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_only_at_cron_interval: Optional[pulumi.Input[bool]] = None,
                 association_name: Optional[pulumi.Input[str]] = None,
                 automation_target_parameter_name: Optional[pulumi.Input[str]] = None,
                 compliance_severity: Optional[pulumi.Input[str]] = None,
                 document_version: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 max_concurrency: Optional[pulumi.Input[str]] = None,
                 max_errors: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_location: Optional[pulumi.Input[Union['AssociationOutputLocationArgs', 'AssociationOutputLocationArgsDict']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 schedule_expression: Optional[pulumi.Input[str]] = None,
                 sync_compliance: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssociationTargetArgs', 'AssociationTargetArgsDict']]]]] = None,
                 wait_for_success_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Associates an SSM Document to an instance or EC2 tag.

        ## Example Usage

        ### Create an association for a specific instance

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name=example_aws_ssm_document["name"],
            targets=[{
                "key": "InstanceIds",
                "values": [example_aws_instance["id"]],
            }])
        ```

        ### Create an association for all managed instances in an AWS account

        To target all managed instances in an AWS account, set the `key` as `"InstanceIds"` with `values` set as `["*"]`. This example also illustrates how to use an Amazon owned SSM document named `AmazonCloudWatch-ManageAgent`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name="AmazonCloudWatch-ManageAgent",
            targets=[{
                "key": "InstanceIds",
                "values": ["*"],
            }])
        ```

        ### Create an association for a specific tag

        This example shows how to target all managed instances that are assigned a tag key of `Environment` and value of `Development`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name="AmazonCloudWatch-ManageAgent",
            targets=[{
                "key": "tag:Environment",
                "values": ["Development"],
            }])
        ```

        ### Create an association with a specific schedule

        This example shows how to schedule an association in various ways.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name=example_aws_ssm_document["name"],
            schedule_expression="cron(0 2 ? * SUN *)",
            targets=[{
                "key": "InstanceIds",
                "values": [example_aws_instance["id"]],
            }])
        ```

        ## Import

        Using `pulumi import`, import SSM associations using the `association_id`. For example:

        ```sh
        $ pulumi import aws:ssm/association:Association test-association 10abcdef-0abc-1234-5678-90abcdef123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] apply_only_at_cron_interval: By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
        :param pulumi.Input[str] association_name: The descriptive name for the association.
        :param pulumi.Input[str] automation_target_parameter_name: Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
        :param pulumi.Input[str] compliance_severity: The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
        :param pulumi.Input[str] document_version: The document version you want to associate with the target(s). Can be a specific version or the default version.
        :param pulumi.Input[str] instance_id: The instance ID to apply an SSM document to. Use `targets` with key `InstanceIds` for document schema versions 2.0 and above. Use the `targets` attribute instead.
        :param pulumi.Input[str] max_concurrency: The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
        :param pulumi.Input[str] max_errors: The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
        :param pulumi.Input[str] name: The name of the SSM document to apply.
        :param pulumi.Input[Union['AssociationOutputLocationArgs', 'AssociationOutputLocationArgsDict']] output_location: An output location block. Output Location is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: A block of arbitrary string parameters to pass to the SSM document.
        :param pulumi.Input[str] schedule_expression: A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
        :param pulumi.Input[str] sync_compliance: The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AssociationTargetArgs', 'AssociationTargetArgsDict']]]] targets: A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
        :param pulumi.Input[int] wait_for_success_timeout_seconds: The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.
               
               Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AssociationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associates an SSM Document to an instance or EC2 tag.

        ## Example Usage

        ### Create an association for a specific instance

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name=example_aws_ssm_document["name"],
            targets=[{
                "key": "InstanceIds",
                "values": [example_aws_instance["id"]],
            }])
        ```

        ### Create an association for all managed instances in an AWS account

        To target all managed instances in an AWS account, set the `key` as `"InstanceIds"` with `values` set as `["*"]`. This example also illustrates how to use an Amazon owned SSM document named `AmazonCloudWatch-ManageAgent`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name="AmazonCloudWatch-ManageAgent",
            targets=[{
                "key": "InstanceIds",
                "values": ["*"],
            }])
        ```

        ### Create an association for a specific tag

        This example shows how to target all managed instances that are assigned a tag key of `Environment` and value of `Development`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name="AmazonCloudWatch-ManageAgent",
            targets=[{
                "key": "tag:Environment",
                "values": ["Development"],
            }])
        ```

        ### Create an association with a specific schedule

        This example shows how to schedule an association in various ways.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.Association("example",
            name=example_aws_ssm_document["name"],
            schedule_expression="cron(0 2 ? * SUN *)",
            targets=[{
                "key": "InstanceIds",
                "values": [example_aws_instance["id"]],
            }])
        ```

        ## Import

        Using `pulumi import`, import SSM associations using the `association_id`. For example:

        ```sh
        $ pulumi import aws:ssm/association:Association test-association 10abcdef-0abc-1234-5678-90abcdef123456
        ```

        :param str resource_name: The name of the resource.
        :param AssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_only_at_cron_interval: Optional[pulumi.Input[bool]] = None,
                 association_name: Optional[pulumi.Input[str]] = None,
                 automation_target_parameter_name: Optional[pulumi.Input[str]] = None,
                 compliance_severity: Optional[pulumi.Input[str]] = None,
                 document_version: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 max_concurrency: Optional[pulumi.Input[str]] = None,
                 max_errors: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_location: Optional[pulumi.Input[Union['AssociationOutputLocationArgs', 'AssociationOutputLocationArgsDict']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 schedule_expression: Optional[pulumi.Input[str]] = None,
                 sync_compliance: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssociationTargetArgs', 'AssociationTargetArgsDict']]]]] = None,
                 wait_for_success_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssociationArgs.__new__(AssociationArgs)

            __props__.__dict__["apply_only_at_cron_interval"] = apply_only_at_cron_interval
            __props__.__dict__["association_name"] = association_name
            __props__.__dict__["automation_target_parameter_name"] = automation_target_parameter_name
            __props__.__dict__["compliance_severity"] = compliance_severity
            __props__.__dict__["document_version"] = document_version
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["max_concurrency"] = max_concurrency
            __props__.__dict__["max_errors"] = max_errors
            __props__.__dict__["name"] = name
            __props__.__dict__["output_location"] = output_location
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["schedule_expression"] = schedule_expression
            __props__.__dict__["sync_compliance"] = sync_compliance
            __props__.__dict__["tags"] = tags
            __props__.__dict__["targets"] = targets
            __props__.__dict__["wait_for_success_timeout_seconds"] = wait_for_success_timeout_seconds
            __props__.__dict__["arn"] = None
            __props__.__dict__["association_id"] = None
            __props__.__dict__["tags_all"] = None
        super(Association, __self__).__init__(
            'aws:ssm/association:Association',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apply_only_at_cron_interval: Optional[pulumi.Input[bool]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            association_id: Optional[pulumi.Input[str]] = None,
            association_name: Optional[pulumi.Input[str]] = None,
            automation_target_parameter_name: Optional[pulumi.Input[str]] = None,
            compliance_severity: Optional[pulumi.Input[str]] = None,
            document_version: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            max_concurrency: Optional[pulumi.Input[str]] = None,
            max_errors: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            output_location: Optional[pulumi.Input[Union['AssociationOutputLocationArgs', 'AssociationOutputLocationArgsDict']]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            schedule_expression: Optional[pulumi.Input[str]] = None,
            sync_compliance: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssociationTargetArgs', 'AssociationTargetArgsDict']]]]] = None,
            wait_for_success_timeout_seconds: Optional[pulumi.Input[int]] = None) -> 'Association':
        """
        Get an existing Association resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] apply_only_at_cron_interval: By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
        :param pulumi.Input[str] arn: The ARN of the SSM association
        :param pulumi.Input[str] association_id: The ID of the SSM association.
        :param pulumi.Input[str] association_name: The descriptive name for the association.
        :param pulumi.Input[str] automation_target_parameter_name: Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
        :param pulumi.Input[str] compliance_severity: The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
        :param pulumi.Input[str] document_version: The document version you want to associate with the target(s). Can be a specific version or the default version.
        :param pulumi.Input[str] instance_id: The instance ID to apply an SSM document to. Use `targets` with key `InstanceIds` for document schema versions 2.0 and above. Use the `targets` attribute instead.
        :param pulumi.Input[str] max_concurrency: The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
        :param pulumi.Input[str] max_errors: The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
        :param pulumi.Input[str] name: The name of the SSM document to apply.
        :param pulumi.Input[Union['AssociationOutputLocationArgs', 'AssociationOutputLocationArgsDict']] output_location: An output location block. Output Location is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: A block of arbitrary string parameters to pass to the SSM document.
        :param pulumi.Input[str] schedule_expression: A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
        :param pulumi.Input[str] sync_compliance: The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AssociationTargetArgs', 'AssociationTargetArgsDict']]]] targets: A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
        :param pulumi.Input[int] wait_for_success_timeout_seconds: The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.
               
               Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssociationState.__new__(_AssociationState)

        __props__.__dict__["apply_only_at_cron_interval"] = apply_only_at_cron_interval
        __props__.__dict__["arn"] = arn
        __props__.__dict__["association_id"] = association_id
        __props__.__dict__["association_name"] = association_name
        __props__.__dict__["automation_target_parameter_name"] = automation_target_parameter_name
        __props__.__dict__["compliance_severity"] = compliance_severity
        __props__.__dict__["document_version"] = document_version
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["max_concurrency"] = max_concurrency
        __props__.__dict__["max_errors"] = max_errors
        __props__.__dict__["name"] = name
        __props__.__dict__["output_location"] = output_location
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["schedule_expression"] = schedule_expression
        __props__.__dict__["sync_compliance"] = sync_compliance
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["targets"] = targets
        __props__.__dict__["wait_for_success_timeout_seconds"] = wait_for_success_timeout_seconds
        return Association(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applyOnlyAtCronInterval")
    def apply_only_at_cron_interval(self) -> pulumi.Output[Optional[bool]]:
        """
        By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
        """
        return pulumi.get(self, "apply_only_at_cron_interval")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the SSM association
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> pulumi.Output[str]:
        """
        The ID of the SSM association.
        """
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter(name="associationName")
    def association_name(self) -> pulumi.Output[Optional[str]]:
        """
        The descriptive name for the association.
        """
        return pulumi.get(self, "association_name")

    @property
    @pulumi.getter(name="automationTargetParameterName")
    def automation_target_parameter_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
        """
        return pulumi.get(self, "automation_target_parameter_name")

    @property
    @pulumi.getter(name="complianceSeverity")
    def compliance_severity(self) -> pulumi.Output[Optional[str]]:
        """
        The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
        """
        return pulumi.get(self, "compliance_severity")

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> pulumi.Output[str]:
        """
        The document version you want to associate with the target(s). Can be a specific version or the default version.
        """
        return pulumi.get(self, "document_version")

    @property
    @pulumi.getter(name="instanceId")
    @_utilities.deprecated("""use 'targets' argument instead. https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociation.html#systemsmanager-CreateAssociation-request-InstanceId""")
    def instance_id(self) -> pulumi.Output[Optional[str]]:
        """
        The instance ID to apply an SSM document to. Use `targets` with key `InstanceIds` for document schema versions 2.0 and above. Use the `targets` attribute instead.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> pulumi.Output[Optional[str]]:
        """
        The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
        """
        return pulumi.get(self, "max_concurrency")

    @property
    @pulumi.getter(name="maxErrors")
    def max_errors(self) -> pulumi.Output[Optional[str]]:
        """
        The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
        """
        return pulumi.get(self, "max_errors")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the SSM document to apply.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> pulumi.Output[Optional['outputs.AssociationOutputLocation']]:
        """
        An output location block. Output Location is documented below.
        """
        return pulumi.get(self, "output_location")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A block of arbitrary string parameters to pass to the SSM document.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> pulumi.Output[Optional[str]]:
        """
        A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
        """
        return pulumi.get(self, "schedule_expression")

    @property
    @pulumi.getter(name="syncCompliance")
    def sync_compliance(self) -> pulumi.Output[Optional[str]]:
        """
        The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
        """
        return pulumi.get(self, "sync_compliance")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Sequence['outputs.AssociationTarget']]:
        """
        A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="waitForSuccessTimeoutSeconds")
    def wait_for_success_timeout_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.

        Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
        """
        return pulumi.get(self, "wait_for_success_timeout_seconds")

