# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ApplicationAccessScopeArgs', 'ApplicationAccessScope']

@pulumi.input_type
class ApplicationAccessScopeArgs:
    def __init__(__self__, *,
                 application_arn: pulumi.Input[str],
                 scope: pulumi.Input[str],
                 authorized_targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ApplicationAccessScope resource.
        :param pulumi.Input[str] application_arn: Specifies the ARN of the application with the access scope with the targets to add or update.
        :param pulumi.Input[str] scope: Specifies the name of the access scope to be associated with the specified targets.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorized_targets: Specifies an array list of ARNs that represent the authorized targets for this access scope.
        """
        pulumi.set(__self__, "application_arn", application_arn)
        pulumi.set(__self__, "scope", scope)
        if authorized_targets is not None:
            pulumi.set(__self__, "authorized_targets", authorized_targets)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> pulumi.Input[str]:
        """
        Specifies the ARN of the application with the access scope with the targets to add or update.
        """
        return pulumi.get(self, "application_arn")

    @application_arn.setter
    def application_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_arn", value)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[str]:
        """
        Specifies the name of the access scope to be associated with the specified targets.

        The following arguments are optional:
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[str]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="authorizedTargets")
    def authorized_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array list of ARNs that represent the authorized targets for this access scope.
        """
        return pulumi.get(self, "authorized_targets")

    @authorized_targets.setter
    def authorized_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "authorized_targets", value)


@pulumi.input_type
class _ApplicationAccessScopeState:
    def __init__(__self__, *,
                 application_arn: Optional[pulumi.Input[str]] = None,
                 authorized_targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ApplicationAccessScope resources.
        :param pulumi.Input[str] application_arn: Specifies the ARN of the application with the access scope with the targets to add or update.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorized_targets: Specifies an array list of ARNs that represent the authorized targets for this access scope.
        :param pulumi.Input[str] scope: Specifies the name of the access scope to be associated with the specified targets.
               
               The following arguments are optional:
        """
        if application_arn is not None:
            pulumi.set(__self__, "application_arn", application_arn)
        if authorized_targets is not None:
            pulumi.set(__self__, "authorized_targets", authorized_targets)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ARN of the application with the access scope with the targets to add or update.
        """
        return pulumi.get(self, "application_arn")

    @application_arn.setter
    def application_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_arn", value)

    @property
    @pulumi.getter(name="authorizedTargets")
    def authorized_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array list of ARNs that represent the authorized targets for this access scope.
        """
        return pulumi.get(self, "authorized_targets")

    @authorized_targets.setter
    def authorized_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "authorized_targets", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the access scope to be associated with the specified targets.

        The following arguments are optional:
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


class ApplicationAccessScope(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_arn: Optional[pulumi.Input[str]] = None,
                 authorized_targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS SSO Admin Application Access Scope.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssoadmin.get_instances()
        example_application = aws.ssoadmin.Application("example",
            name="example",
            application_provider_arn="arn:aws:sso::aws:applicationProvider/custom",
            instance_arn=example.arns[0])
        example_application_access_scope = aws.ssoadmin.ApplicationAccessScope("example",
            application_arn=example_application.application_arn,
            authorized_targets=["arn:aws:sso::123456789012:application/ssoins-123456789012/apl-123456789012"],
            scope="sso:account:access")
        ```

        ## Import

        Using `pulumi import`, import SSO Admin Application Access Scope using the `id`. For example:

        ```sh
        $ pulumi import aws:ssoadmin/applicationAccessScope:ApplicationAccessScope example arn:aws:sso::123456789012:application/ssoins-123456789012/apl-123456789012,sso:account:access
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_arn: Specifies the ARN of the application with the access scope with the targets to add or update.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorized_targets: Specifies an array list of ARNs that represent the authorized targets for this access scope.
        :param pulumi.Input[str] scope: Specifies the name of the access scope to be associated with the specified targets.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationAccessScopeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS SSO Admin Application Access Scope.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssoadmin.get_instances()
        example_application = aws.ssoadmin.Application("example",
            name="example",
            application_provider_arn="arn:aws:sso::aws:applicationProvider/custom",
            instance_arn=example.arns[0])
        example_application_access_scope = aws.ssoadmin.ApplicationAccessScope("example",
            application_arn=example_application.application_arn,
            authorized_targets=["arn:aws:sso::123456789012:application/ssoins-123456789012/apl-123456789012"],
            scope="sso:account:access")
        ```

        ## Import

        Using `pulumi import`, import SSO Admin Application Access Scope using the `id`. For example:

        ```sh
        $ pulumi import aws:ssoadmin/applicationAccessScope:ApplicationAccessScope example arn:aws:sso::123456789012:application/ssoins-123456789012/apl-123456789012,sso:account:access
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationAccessScopeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationAccessScopeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_arn: Optional[pulumi.Input[str]] = None,
                 authorized_targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationAccessScopeArgs.__new__(ApplicationAccessScopeArgs)

            if application_arn is None and not opts.urn:
                raise TypeError("Missing required property 'application_arn'")
            __props__.__dict__["application_arn"] = application_arn
            __props__.__dict__["authorized_targets"] = authorized_targets
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
        super(ApplicationAccessScope, __self__).__init__(
            'aws:ssoadmin/applicationAccessScope:ApplicationAccessScope',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_arn: Optional[pulumi.Input[str]] = None,
            authorized_targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            scope: Optional[pulumi.Input[str]] = None) -> 'ApplicationAccessScope':
        """
        Get an existing ApplicationAccessScope resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_arn: Specifies the ARN of the application with the access scope with the targets to add or update.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorized_targets: Specifies an array list of ARNs that represent the authorized targets for this access scope.
        :param pulumi.Input[str] scope: Specifies the name of the access scope to be associated with the specified targets.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationAccessScopeState.__new__(_ApplicationAccessScopeState)

        __props__.__dict__["application_arn"] = application_arn
        __props__.__dict__["authorized_targets"] = authorized_targets
        __props__.__dict__["scope"] = scope
        return ApplicationAccessScope(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> pulumi.Output[str]:
        """
        Specifies the ARN of the application with the access scope with the targets to add or update.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="authorizedTargets")
    def authorized_targets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies an array list of ARNs that represent the authorized targets for this access scope.
        """
        return pulumi.get(self, "authorized_targets")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[str]:
        """
        Specifies the name of the access scope to be associated with the specified targets.

        The following arguments are optional:
        """
        return pulumi.get(self, "scope")

