# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationPortalOptions',
    'ApplicationPortalOptionsSignInOptions',
    'CustomerManagedPolicyAttachmentCustomerManagedPolicyReference',
    'InstanceAccessControlAttributesAttribute',
    'InstanceAccessControlAttributesAttributeValue',
    'PermissionsBoundaryAttachmentPermissionsBoundary',
    'PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReference',
    'TrustedTokenIssuerTrustedTokenIssuerConfiguration',
    'TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfiguration',
    'GetApplicationAssignmentsApplicationAssignmentResult',
    'GetApplicationPortalOptionResult',
    'GetApplicationPortalOptionSignInOptionResult',
    'GetApplicationProvidersApplicationProviderResult',
    'GetApplicationProvidersApplicationProviderDisplayDataResult',
    'GetPrincipalApplicationAssignmentsApplicationAssignmentResult',
]

@pulumi.output_type
class ApplicationPortalOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signInOptions":
            suggest = "sign_in_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationPortalOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationPortalOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationPortalOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sign_in_options: Optional['outputs.ApplicationPortalOptionsSignInOptions'] = None,
                 visibility: Optional[str] = None):
        """
        :param 'ApplicationPortalOptionsSignInOptionsArgs' sign_in_options: Sign-in options for the access portal. See `sign_in_options` below.
        :param str visibility: Indicates whether this application is visible in the access portal. Valid values are `ENABLED` and `DISABLED`.
        """
        if sign_in_options is not None:
            pulumi.set(__self__, "sign_in_options", sign_in_options)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter(name="signInOptions")
    def sign_in_options(self) -> Optional['outputs.ApplicationPortalOptionsSignInOptions']:
        """
        Sign-in options for the access portal. See `sign_in_options` below.
        """
        return pulumi.get(self, "sign_in_options")

    @property
    @pulumi.getter
    def visibility(self) -> Optional[str]:
        """
        Indicates whether this application is visible in the access portal. Valid values are `ENABLED` and `DISABLED`.
        """
        return pulumi.get(self, "visibility")


@pulumi.output_type
class ApplicationPortalOptionsSignInOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationUrl":
            suggest = "application_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationPortalOptionsSignInOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationPortalOptionsSignInOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationPortalOptionsSignInOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 origin: str,
                 application_url: Optional[str] = None):
        """
        :param str origin: Determines how IAM Identity Center navigates the user to the target application.
               Valid values are `APPLICATION` and `IDENTITY_CENTER`.
               If `APPLICATION` is set, IAM Identity Center redirects the customer to the configured `application_url`.
               If `IDENTITY_CENTER` is set, IAM Identity Center uses SAML identity-provider initiated authentication to sign the customer directly into a SAML-based application.
        :param str application_url: URL that accepts authentication requests for an application.
        """
        pulumi.set(__self__, "origin", origin)
        if application_url is not None:
            pulumi.set(__self__, "application_url", application_url)

    @property
    @pulumi.getter
    def origin(self) -> str:
        """
        Determines how IAM Identity Center navigates the user to the target application.
        Valid values are `APPLICATION` and `IDENTITY_CENTER`.
        If `APPLICATION` is set, IAM Identity Center redirects the customer to the configured `application_url`.
        If `IDENTITY_CENTER` is set, IAM Identity Center uses SAML identity-provider initiated authentication to sign the customer directly into a SAML-based application.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="applicationUrl")
    def application_url(self) -> Optional[str]:
        """
        URL that accepts authentication requests for an application.
        """
        return pulumi.get(self, "application_url")


@pulumi.output_type
class CustomerManagedPolicyAttachmentCustomerManagedPolicyReference(dict):
    def __init__(__self__, *,
                 name: str,
                 path: Optional[str] = None):
        """
        :param str name: Name of the customer managed IAM Policy to be attached.
        :param str path: The path to the IAM policy to be attached. The default is `/`. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) for more information.
        """
        pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the customer managed IAM Policy to be attached.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to the IAM policy to be attached. The default is `/`. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) for more information.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class InstanceAccessControlAttributesAttribute(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence['outputs.InstanceAccessControlAttributesAttributeValue']):
        """
        :param str key: The name of the attribute associated with your identities in your identity source. This is used to map a specified attribute in your identity source with an attribute in AWS SSO.
        :param Sequence['InstanceAccessControlAttributesAttributeValueArgs'] values: The value used for mapping a specified attribute to an identity source. See AccessControlAttributeValue
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the attribute associated with your identities in your identity source. This is used to map a specified attribute in your identity source with an attribute in AWS SSO.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence['outputs.InstanceAccessControlAttributesAttributeValue']:
        """
        The value used for mapping a specified attribute to an identity source. See AccessControlAttributeValue
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class InstanceAccessControlAttributesAttributeValue(dict):
    def __init__(__self__, *,
                 sources: Sequence[str]):
        """
        :param Sequence[str] sources: The identity source to use when mapping a specified attribute to AWS SSO.
        """
        pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def sources(self) -> Sequence[str]:
        """
        The identity source to use when mapping a specified attribute to AWS SSO.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class PermissionsBoundaryAttachmentPermissionsBoundary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerManagedPolicyReference":
            suggest = "customer_managed_policy_reference"
        elif key == "managedPolicyArn":
            suggest = "managed_policy_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsBoundaryAttachmentPermissionsBoundary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsBoundaryAttachmentPermissionsBoundary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsBoundaryAttachmentPermissionsBoundary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_managed_policy_reference: Optional['outputs.PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReference'] = None,
                 managed_policy_arn: Optional[str] = None):
        """
        :param 'PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs' customer_managed_policy_reference: Specifies the name and path of a customer managed policy. See below.
        :param str managed_policy_arn: AWS-managed IAM policy ARN to use as the permissions boundary.
        """
        if customer_managed_policy_reference is not None:
            pulumi.set(__self__, "customer_managed_policy_reference", customer_managed_policy_reference)
        if managed_policy_arn is not None:
            pulumi.set(__self__, "managed_policy_arn", managed_policy_arn)

    @property
    @pulumi.getter(name="customerManagedPolicyReference")
    def customer_managed_policy_reference(self) -> Optional['outputs.PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReference']:
        """
        Specifies the name and path of a customer managed policy. See below.
        """
        return pulumi.get(self, "customer_managed_policy_reference")

    @property
    @pulumi.getter(name="managedPolicyArn")
    def managed_policy_arn(self) -> Optional[str]:
        """
        AWS-managed IAM policy ARN to use as the permissions boundary.
        """
        return pulumi.get(self, "managed_policy_arn")


@pulumi.output_type
class PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReference(dict):
    def __init__(__self__, *,
                 name: str,
                 path: Optional[str] = None):
        """
        :param str name: Name of the customer managed IAM Policy to be attached.
        :param str path: The path to the IAM policy to be attached. The default is `/`. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) for more information.
        """
        pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the customer managed IAM Policy to be attached.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to the IAM policy to be attached. The default is `/`. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) for more information.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class TrustedTokenIssuerTrustedTokenIssuerConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oidcJwtConfiguration":
            suggest = "oidc_jwt_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrustedTokenIssuerTrustedTokenIssuerConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrustedTokenIssuerTrustedTokenIssuerConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrustedTokenIssuerTrustedTokenIssuerConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oidc_jwt_configuration: Optional['outputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfiguration'] = None):
        """
        :param 'TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs' oidc_jwt_configuration: A block that describes the settings for a trusted token issuer that works with OpenID Connect (OIDC) by using JSON Web Tokens (JWT). See Documented below below.
        """
        if oidc_jwt_configuration is not None:
            pulumi.set(__self__, "oidc_jwt_configuration", oidc_jwt_configuration)

    @property
    @pulumi.getter(name="oidcJwtConfiguration")
    def oidc_jwt_configuration(self) -> Optional['outputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfiguration']:
        """
        A block that describes the settings for a trusted token issuer that works with OpenID Connect (OIDC) by using JSON Web Tokens (JWT). See Documented below below.
        """
        return pulumi.get(self, "oidc_jwt_configuration")


@pulumi.output_type
class TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "claimAttributePath":
            suggest = "claim_attribute_path"
        elif key == "identityStoreAttributePath":
            suggest = "identity_store_attribute_path"
        elif key == "issuerUrl":
            suggest = "issuer_url"
        elif key == "jwksRetrievalOption":
            suggest = "jwks_retrieval_option"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 claim_attribute_path: str,
                 identity_store_attribute_path: str,
                 issuer_url: str,
                 jwks_retrieval_option: str):
        """
        :param str claim_attribute_path: Specifies the path of the source attribute in the JWT from the trusted token issuer.
        :param str identity_store_attribute_path: Specifies path of the destination attribute in a JWT from IAM Identity Center. The attribute mapped by this JMESPath expression is compared against the attribute mapped by `claim_attribute_path` when a trusted token issuer token is exchanged for an IAM Identity Center token.
        :param str issuer_url: Specifies the URL that IAM Identity Center uses for OpenID Discovery. OpenID Discovery is used to obtain the information required to verify the tokens that the trusted token issuer generates.
        :param str jwks_retrieval_option: The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT. Valid values are `OPEN_ID_DISCOVERY`
        """
        pulumi.set(__self__, "claim_attribute_path", claim_attribute_path)
        pulumi.set(__self__, "identity_store_attribute_path", identity_store_attribute_path)
        pulumi.set(__self__, "issuer_url", issuer_url)
        pulumi.set(__self__, "jwks_retrieval_option", jwks_retrieval_option)

    @property
    @pulumi.getter(name="claimAttributePath")
    def claim_attribute_path(self) -> str:
        """
        Specifies the path of the source attribute in the JWT from the trusted token issuer.
        """
        return pulumi.get(self, "claim_attribute_path")

    @property
    @pulumi.getter(name="identityStoreAttributePath")
    def identity_store_attribute_path(self) -> str:
        """
        Specifies path of the destination attribute in a JWT from IAM Identity Center. The attribute mapped by this JMESPath expression is compared against the attribute mapped by `claim_attribute_path` when a trusted token issuer token is exchanged for an IAM Identity Center token.
        """
        return pulumi.get(self, "identity_store_attribute_path")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> str:
        """
        Specifies the URL that IAM Identity Center uses for OpenID Discovery. OpenID Discovery is used to obtain the information required to verify the tokens that the trusted token issuer generates.
        """
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="jwksRetrievalOption")
    def jwks_retrieval_option(self) -> str:
        """
        The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT. Valid values are `OPEN_ID_DISCOVERY`
        """
        return pulumi.get(self, "jwks_retrieval_option")


@pulumi.output_type
class GetApplicationAssignmentsApplicationAssignmentResult(dict):
    def __init__(__self__, *,
                 application_arn: str,
                 principal_id: str,
                 principal_type: str):
        """
        :param str application_arn: ARN of the application.
        :param str principal_id: An identifier for an object in IAM Identity Center, such as a user or group.
        :param str principal_type: Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
        """
        pulumi.set(__self__, "application_arn", application_arn)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> str:
        """
        ARN of the application.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        An identifier for an object in IAM Identity Center, such as a user or group.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> str:
        """
        Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
        """
        return pulumi.get(self, "principal_type")


@pulumi.output_type
class GetApplicationPortalOptionResult(dict):
    def __init__(__self__, *,
                 visibility: str,
                 sign_in_options: Optional[Sequence['outputs.GetApplicationPortalOptionSignInOptionResult']] = None):
        pulumi.set(__self__, "visibility", visibility)
        if sign_in_options is not None:
            pulumi.set(__self__, "sign_in_options", sign_in_options)

    @property
    @pulumi.getter
    def visibility(self) -> str:
        return pulumi.get(self, "visibility")

    @property
    @pulumi.getter(name="signInOptions")
    def sign_in_options(self) -> Optional[Sequence['outputs.GetApplicationPortalOptionSignInOptionResult']]:
        return pulumi.get(self, "sign_in_options")


@pulumi.output_type
class GetApplicationPortalOptionSignInOptionResult(dict):
    def __init__(__self__, *,
                 application_url: str,
                 origin: str):
        pulumi.set(__self__, "application_url", application_url)
        pulumi.set(__self__, "origin", origin)

    @property
    @pulumi.getter(name="applicationUrl")
    def application_url(self) -> str:
        return pulumi.get(self, "application_url")

    @property
    @pulumi.getter
    def origin(self) -> str:
        return pulumi.get(self, "origin")


@pulumi.output_type
class GetApplicationProvidersApplicationProviderResult(dict):
    def __init__(__self__, *,
                 application_provider_arn: str,
                 federation_protocol: str,
                 display_datas: Optional[Sequence['outputs.GetApplicationProvidersApplicationProviderDisplayDataResult']] = None):
        """
        :param str application_provider_arn: ARN of the application provider.
        :param str federation_protocol: Protocol that the application provider uses to perform federation. Valid values are `SAML` and `OAUTH`.
        :param Sequence['GetApplicationProvidersApplicationProviderDisplayDataArgs'] display_datas: An object describing how IAM Identity Center represents the application provider in the portal. See `display_data` below.
        """
        pulumi.set(__self__, "application_provider_arn", application_provider_arn)
        pulumi.set(__self__, "federation_protocol", federation_protocol)
        if display_datas is not None:
            pulumi.set(__self__, "display_datas", display_datas)

    @property
    @pulumi.getter(name="applicationProviderArn")
    def application_provider_arn(self) -> str:
        """
        ARN of the application provider.
        """
        return pulumi.get(self, "application_provider_arn")

    @property
    @pulumi.getter(name="federationProtocol")
    def federation_protocol(self) -> str:
        """
        Protocol that the application provider uses to perform federation. Valid values are `SAML` and `OAUTH`.
        """
        return pulumi.get(self, "federation_protocol")

    @property
    @pulumi.getter(name="displayDatas")
    def display_datas(self) -> Optional[Sequence['outputs.GetApplicationProvidersApplicationProviderDisplayDataResult']]:
        """
        An object describing how IAM Identity Center represents the application provider in the portal. See `display_data` below.
        """
        return pulumi.get(self, "display_datas")


@pulumi.output_type
class GetApplicationProvidersApplicationProviderDisplayDataResult(dict):
    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 icon_url: str):
        """
        :param str description: Description of the application provider.
        :param str display_name: Name of the application provider.
        :param str icon_url: URL that points to an icon that represents the application provider.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "icon_url", icon_url)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the application provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of the application provider.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> str:
        """
        URL that points to an icon that represents the application provider.
        """
        return pulumi.get(self, "icon_url")


@pulumi.output_type
class GetPrincipalApplicationAssignmentsApplicationAssignmentResult(dict):
    def __init__(__self__, *,
                 application_arn: str,
                 principal_id: str,
                 principal_type: str):
        """
        :param str application_arn: ARN of the application.
        :param str principal_id: An identifier for an object in IAM Identity Center, such as a user or group.
        :param str principal_type: Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
        """
        pulumi.set(__self__, "application_arn", application_arn)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> str:
        """
        ARN of the application.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        An identifier for an object in IAM Identity Center, such as a user or group.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> str:
        """
        Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
        """
        return pulumi.get(self, "principal_type")


