# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetConnectorResult',
    'AwaitableGetConnectorResult',
    'get_connector',
    'get_connector_output',
]

@pulumi.output_type
class GetConnectorResult:
    """
    A collection of values returned by getConnector.
    """
    def __init__(__self__, access_role=None, arn=None, as2_configs=None, id=None, logging_role=None, security_policy_name=None, service_managed_egress_ip_addresses=None, sftp_configs=None, tags=None, url=None):
        if access_role and not isinstance(access_role, str):
            raise TypeError("Expected argument 'access_role' to be a str")
        pulumi.set(__self__, "access_role", access_role)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if as2_configs and not isinstance(as2_configs, list):
            raise TypeError("Expected argument 'as2_configs' to be a list")
        pulumi.set(__self__, "as2_configs", as2_configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if logging_role and not isinstance(logging_role, str):
            raise TypeError("Expected argument 'logging_role' to be a str")
        pulumi.set(__self__, "logging_role", logging_role)
        if security_policy_name and not isinstance(security_policy_name, str):
            raise TypeError("Expected argument 'security_policy_name' to be a str")
        pulumi.set(__self__, "security_policy_name", security_policy_name)
        if service_managed_egress_ip_addresses and not isinstance(service_managed_egress_ip_addresses, list):
            raise TypeError("Expected argument 'service_managed_egress_ip_addresses' to be a list")
        pulumi.set(__self__, "service_managed_egress_ip_addresses", service_managed_egress_ip_addresses)
        if sftp_configs and not isinstance(sftp_configs, list):
            raise TypeError("Expected argument 'sftp_configs' to be a list")
        pulumi.set(__self__, "sftp_configs", sftp_configs)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="accessRole")
    def access_role(self) -> str:
        """
        ARN of the AWS Identity and Access Management role.
        """
        return pulumi.get(self, "access_role")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the Connector.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="as2Configs")
    def as2_configs(self) -> Sequence['outputs.GetConnectorAs2ConfigResult']:
        """
        Structure containing the parameters for an AS2 connector object. Contains the following attributes:
        """
        return pulumi.get(self, "as2_configs")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loggingRole")
    def logging_role(self) -> str:
        """
        ARN of the IAM role that allows a connector to turn on CLoudwatch logging for Amazon S3 events.
        """
        return pulumi.get(self, "logging_role")

    @property
    @pulumi.getter(name="securityPolicyName")
    def security_policy_name(self) -> str:
        """
        Name of security policy.
        """
        return pulumi.get(self, "security_policy_name")

    @property
    @pulumi.getter(name="serviceManagedEgressIpAddresses")
    def service_managed_egress_ip_addresses(self) -> Sequence[str]:
        """
        List of egress Ip addresses.
        """
        return pulumi.get(self, "service_managed_egress_ip_addresses")

    @property
    @pulumi.getter(name="sftpConfigs")
    def sftp_configs(self) -> Sequence['outputs.GetConnectorSftpConfigResult']:
        """
        Object containing the following attributes:
        """
        return pulumi.get(self, "sftp_configs")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Object containing the following attributes:
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL of the partner's AS2 or SFTP endpoint.
        """
        return pulumi.get(self, "url")


class AwaitableGetConnectorResult(GetConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectorResult(
            access_role=self.access_role,
            arn=self.arn,
            as2_configs=self.as2_configs,
            id=self.id,
            logging_role=self.logging_role,
            security_policy_name=self.security_policy_name,
            service_managed_egress_ip_addresses=self.service_managed_egress_ip_addresses,
            sftp_configs=self.sftp_configs,
            tags=self.tags,
            url=self.url)


def get_connector(id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectorResult:
    """
    Data source for managing an AWS Transfer Family Connector.


    :param str id: Unique identifier for connector
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:transfer/getConnector:getConnector', __args__, opts=opts, typ=GetConnectorResult).value

    return AwaitableGetConnectorResult(
        access_role=pulumi.get(__ret__, 'access_role'),
        arn=pulumi.get(__ret__, 'arn'),
        as2_configs=pulumi.get(__ret__, 'as2_configs'),
        id=pulumi.get(__ret__, 'id'),
        logging_role=pulumi.get(__ret__, 'logging_role'),
        security_policy_name=pulumi.get(__ret__, 'security_policy_name'),
        service_managed_egress_ip_addresses=pulumi.get(__ret__, 'service_managed_egress_ip_addresses'),
        sftp_configs=pulumi.get(__ret__, 'sftp_configs'),
        tags=pulumi.get(__ret__, 'tags'),
        url=pulumi.get(__ret__, 'url'))
def get_connector_output(id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectorResult]:
    """
    Data source for managing an AWS Transfer Family Connector.


    :param str id: Unique identifier for connector
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:transfer/getConnector:getConnector', __args__, opts=opts, typ=GetConnectorResult)
    return __ret__.apply(lambda __response__: GetConnectorResult(
        access_role=pulumi.get(__response__, 'access_role'),
        arn=pulumi.get(__response__, 'arn'),
        as2_configs=pulumi.get(__response__, 'as2_configs'),
        id=pulumi.get(__response__, 'id'),
        logging_role=pulumi.get(__response__, 'logging_role'),
        security_policy_name=pulumi.get(__response__, 'security_policy_name'),
        service_managed_egress_ip_addresses=pulumi.get(__response__, 'service_managed_egress_ip_addresses'),
        sftp_configs=pulumi.get(__response__, 'sftp_configs'),
        tags=pulumi.get(__response__, 'tags'),
        url=pulumi.get(__response__, 'url')))
