# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerArgs', 'Server']

@pulumi.input_type
class ServerArgs:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[str]] = None,
                 directory_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 endpoint_details: Optional[pulumi.Input['ServerEndpointDetailsArgs']] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 function: Optional[pulumi.Input[str]] = None,
                 host_key: Optional[pulumi.Input[str]] = None,
                 identity_provider_type: Optional[pulumi.Input[str]] = None,
                 invocation_role: Optional[pulumi.Input[str]] = None,
                 logging_role: Optional[pulumi.Input[str]] = None,
                 post_authentication_login_banner: Optional[pulumi.Input[str]] = None,
                 pre_authentication_login_banner: Optional[pulumi.Input[str]] = None,
                 protocol_details: Optional[pulumi.Input['ServerProtocolDetailsArgs']] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 s3_storage_options: Optional[pulumi.Input['ServerS3StorageOptionsArgs']] = None,
                 security_policy_name: Optional[pulumi.Input[str]] = None,
                 sftp_authentication_methods: Optional[pulumi.Input[str]] = None,
                 structured_log_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 workflow_details: Optional[pulumi.Input['ServerWorkflowDetailsArgs']] = None):
        """
        The set of arguments for constructing a Server resource.
        :param pulumi.Input[str] certificate: The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
        :param pulumi.Input[str] directory_id: The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
        :param pulumi.Input[str] domain: The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
        :param pulumi.Input['ServerEndpointDetailsArgs'] endpoint_details: The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. See `endpoint_details` Block below for details.
        :param pulumi.Input[str] endpoint_type: The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn't accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
        :param pulumi.Input[bool] force_destroy: A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
        :param pulumi.Input[str] function: The ARN for a lambda function to use for the Identity provider.
        :param pulumi.Input[str] host_key: RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N "" -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N "" -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N "" -f my-new-server-key` commands).
        :param pulumi.Input[str] identity_provider_type: The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
        :param pulumi.Input[str] invocation_role: Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
        :param pulumi.Input[str] logging_role: Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
        :param pulumi.Input[str] post_authentication_login_banner: Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
        :param pulumi.Input[str] pre_authentication_login_banner: Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
        :param pulumi.Input['ServerProtocolDetailsArgs'] protocol_details: The protocol settings that are configured for your server. See `protocol_details` Block below for details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This defaults to `SFTP` . The available protocols are:
               * `AS2`: File transfer over Applicability Statement 2
               * `SFTP`: File transfer over SSH
               * `FTPS`: File transfer with TLS encryption
               * `FTP`: Unencrypted file transfer
        :param pulumi.Input['ServerS3StorageOptionsArgs'] s3_storage_options: Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default. See `s3_storage_options` Block below for details.
        :param pulumi.Input[str] security_policy_name: Specifies the name of the security policy that is attached to the server. Default value is: `TransferSecurityPolicy-2018-11`. The available values are:
               * `TransferSecurityPolicy-2018-11`
               * `TransferSecurityPolicy-2020-06`
               * `TransferSecurityPolicy-2022-03`
               * `TransferSecurityPolicy-2023-05`
               * `TransferSecurityPolicy-2024-01`
               * `TransferSecurityPolicy-FIPS-2020-06`
               * `TransferSecurityPolicy-FIPS-2023-05`
               * `TransferSecurityPolicy-FIPS-2024-01`
               * `TransferSecurityPolicy-FIPS-2024-05`
               * `TransferSecurityPolicy-PQ-SSH-Experimental-2023-04`
               * `TransferSecurityPolicy-PQ-SSH-FIPS-Experimental-2023-04`
               * `TransferSecurityPolicy-Restricted-2018-11`
               * `TransferSecurityPolicy-Restricted-2020-06`
               * `TransferSecurityPolicy-Restricted-2024-06`
               
               See [Security policies for AWS Transfer Family servers](https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html) for details.
        :param pulumi.Input[str] sftp_authentication_methods: For SFTP-enabled servers, and for custom identity providers only. Valid values are `PASSWORD`, `PUBLIC_KEY`, `PUBLIC_KEY_OR_PASSWORD` and `PUBLIC_KEY_AND_PASSWORD`. Default value is: `PUBLIC_KEY_OR_PASSWORD`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] structured_log_destinations: A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] url: URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
        :param pulumi.Input['ServerWorkflowDetailsArgs'] workflow_details: Specifies the workflow details. See `workflow_details` Block below for details.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if endpoint_details is not None:
            pulumi.set(__self__, "endpoint_details", endpoint_details)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if host_key is not None:
            pulumi.set(__self__, "host_key", host_key)
        if identity_provider_type is not None:
            pulumi.set(__self__, "identity_provider_type", identity_provider_type)
        if invocation_role is not None:
            pulumi.set(__self__, "invocation_role", invocation_role)
        if logging_role is not None:
            pulumi.set(__self__, "logging_role", logging_role)
        if post_authentication_login_banner is not None:
            pulumi.set(__self__, "post_authentication_login_banner", post_authentication_login_banner)
        if pre_authentication_login_banner is not None:
            pulumi.set(__self__, "pre_authentication_login_banner", pre_authentication_login_banner)
        if protocol_details is not None:
            pulumi.set(__self__, "protocol_details", protocol_details)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if s3_storage_options is not None:
            pulumi.set(__self__, "s3_storage_options", s3_storage_options)
        if security_policy_name is not None:
            pulumi.set(__self__, "security_policy_name", security_policy_name)
        if sftp_authentication_methods is not None:
            pulumi.set(__self__, "sftp_authentication_methods", sftp_authentication_methods)
        if structured_log_destinations is not None:
            pulumi.set(__self__, "structured_log_destinations", structured_log_destinations)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if workflow_details is not None:
            pulumi.set(__self__, "workflow_details", workflow_details)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[str]]:
        """
        The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directory_id", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="endpointDetails")
    def endpoint_details(self) -> Optional[pulumi.Input['ServerEndpointDetailsArgs']]:
        """
        The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. See `endpoint_details` Block below for details.
        """
        return pulumi.get(self, "endpoint_details")

    @endpoint_details.setter
    def endpoint_details(self, value: Optional[pulumi.Input['ServerEndpointDetailsArgs']]):
        pulumi.set(self, "endpoint_details", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn't accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for a lambda function to use for the Identity provider.
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter(name="hostKey")
    def host_key(self) -> Optional[pulumi.Input[str]]:
        """
        RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N "" -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N "" -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N "" -f my-new-server-key` commands).
        """
        return pulumi.get(self, "host_key")

    @host_key.setter
    def host_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_key", value)

    @property
    @pulumi.getter(name="identityProviderType")
    def identity_provider_type(self) -> Optional[pulumi.Input[str]]:
        """
        The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
        """
        return pulumi.get(self, "identity_provider_type")

    @identity_provider_type.setter
    def identity_provider_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_provider_type", value)

    @property
    @pulumi.getter(name="invocationRole")
    def invocation_role(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
        """
        return pulumi.get(self, "invocation_role")

    @invocation_role.setter
    def invocation_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invocation_role", value)

    @property
    @pulumi.getter(name="loggingRole")
    def logging_role(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
        """
        return pulumi.get(self, "logging_role")

    @logging_role.setter
    def logging_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logging_role", value)

    @property
    @pulumi.getter(name="postAuthenticationLoginBanner")
    def post_authentication_login_banner(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
        """
        return pulumi.get(self, "post_authentication_login_banner")

    @post_authentication_login_banner.setter
    def post_authentication_login_banner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "post_authentication_login_banner", value)

    @property
    @pulumi.getter(name="preAuthenticationLoginBanner")
    def pre_authentication_login_banner(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
        """
        return pulumi.get(self, "pre_authentication_login_banner")

    @pre_authentication_login_banner.setter
    def pre_authentication_login_banner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_authentication_login_banner", value)

    @property
    @pulumi.getter(name="protocolDetails")
    def protocol_details(self) -> Optional[pulumi.Input['ServerProtocolDetailsArgs']]:
        """
        The protocol settings that are configured for your server. See `protocol_details` Block below for details.
        """
        return pulumi.get(self, "protocol_details")

    @protocol_details.setter
    def protocol_details(self, value: Optional[pulumi.Input['ServerProtocolDetailsArgs']]):
        pulumi.set(self, "protocol_details", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This defaults to `SFTP` . The available protocols are:
        * `AS2`: File transfer over Applicability Statement 2
        * `SFTP`: File transfer over SSH
        * `FTPS`: File transfer with TLS encryption
        * `FTP`: Unencrypted file transfer
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="s3StorageOptions")
    def s3_storage_options(self) -> Optional[pulumi.Input['ServerS3StorageOptionsArgs']]:
        """
        Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default. See `s3_storage_options` Block below for details.
        """
        return pulumi.get(self, "s3_storage_options")

    @s3_storage_options.setter
    def s3_storage_options(self, value: Optional[pulumi.Input['ServerS3StorageOptionsArgs']]):
        pulumi.set(self, "s3_storage_options", value)

    @property
    @pulumi.getter(name="securityPolicyName")
    def security_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the security policy that is attached to the server. Default value is: `TransferSecurityPolicy-2018-11`. The available values are:
        * `TransferSecurityPolicy-2018-11`
        * `TransferSecurityPolicy-2020-06`
        * `TransferSecurityPolicy-2022-03`
        * `TransferSecurityPolicy-2023-05`
        * `TransferSecurityPolicy-2024-01`
        * `TransferSecurityPolicy-FIPS-2020-06`
        * `TransferSecurityPolicy-FIPS-2023-05`
        * `TransferSecurityPolicy-FIPS-2024-01`
        * `TransferSecurityPolicy-FIPS-2024-05`
        * `TransferSecurityPolicy-PQ-SSH-Experimental-2023-04`
        * `TransferSecurityPolicy-PQ-SSH-FIPS-Experimental-2023-04`
        * `TransferSecurityPolicy-Restricted-2018-11`
        * `TransferSecurityPolicy-Restricted-2020-06`
        * `TransferSecurityPolicy-Restricted-2024-06`

        See [Security policies for AWS Transfer Family servers](https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html) for details.
        """
        return pulumi.get(self, "security_policy_name")

    @security_policy_name.setter
    def security_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy_name", value)

    @property
    @pulumi.getter(name="sftpAuthenticationMethods")
    def sftp_authentication_methods(self) -> Optional[pulumi.Input[str]]:
        """
        For SFTP-enabled servers, and for custom identity providers only. Valid values are `PASSWORD`, `PUBLIC_KEY`, `PUBLIC_KEY_OR_PASSWORD` and `PUBLIC_KEY_AND_PASSWORD`. Default value is: `PUBLIC_KEY_OR_PASSWORD`.
        """
        return pulumi.get(self, "sftp_authentication_methods")

    @sftp_authentication_methods.setter
    def sftp_authentication_methods(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sftp_authentication_methods", value)

    @property
    @pulumi.getter(name="structuredLogDestinations")
    def structured_log_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
        """
        return pulumi.get(self, "structured_log_destinations")

    @structured_log_destinations.setter
    def structured_log_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "structured_log_destinations", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="workflowDetails")
    def workflow_details(self) -> Optional[pulumi.Input['ServerWorkflowDetailsArgs']]:
        """
        Specifies the workflow details. See `workflow_details` Block below for details.
        """
        return pulumi.get(self, "workflow_details")

    @workflow_details.setter
    def workflow_details(self, value: Optional[pulumi.Input['ServerWorkflowDetailsArgs']]):
        pulumi.set(self, "workflow_details", value)


@pulumi.input_type
class _ServerState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 directory_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 endpoint_details: Optional[pulumi.Input['ServerEndpointDetailsArgs']] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 function: Optional[pulumi.Input[str]] = None,
                 host_key: Optional[pulumi.Input[str]] = None,
                 host_key_fingerprint: Optional[pulumi.Input[str]] = None,
                 identity_provider_type: Optional[pulumi.Input[str]] = None,
                 invocation_role: Optional[pulumi.Input[str]] = None,
                 logging_role: Optional[pulumi.Input[str]] = None,
                 post_authentication_login_banner: Optional[pulumi.Input[str]] = None,
                 pre_authentication_login_banner: Optional[pulumi.Input[str]] = None,
                 protocol_details: Optional[pulumi.Input['ServerProtocolDetailsArgs']] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 s3_storage_options: Optional[pulumi.Input['ServerS3StorageOptionsArgs']] = None,
                 security_policy_name: Optional[pulumi.Input[str]] = None,
                 sftp_authentication_methods: Optional[pulumi.Input[str]] = None,
                 structured_log_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 workflow_details: Optional[pulumi.Input['ServerWorkflowDetailsArgs']] = None):
        """
        Input properties used for looking up and filtering Server resources.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of Transfer Server
        :param pulumi.Input[str] certificate: The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
        :param pulumi.Input[str] directory_id: The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
        :param pulumi.Input[str] domain: The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
        :param pulumi.Input[str] endpoint: The endpoint of the Transfer Server (e.g., `s-12345678.server.transfer.REGION.amazonaws.com`)
        :param pulumi.Input['ServerEndpointDetailsArgs'] endpoint_details: The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. See `endpoint_details` Block below for details.
        :param pulumi.Input[str] endpoint_type: The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn't accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
        :param pulumi.Input[bool] force_destroy: A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
        :param pulumi.Input[str] function: The ARN for a lambda function to use for the Identity provider.
        :param pulumi.Input[str] host_key: RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N "" -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N "" -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N "" -f my-new-server-key` commands).
        :param pulumi.Input[str] host_key_fingerprint: This value contains the message-digest algorithm (MD5) hash of the server's host key. This value is equivalent to the output of the `ssh-keygen -l -E md5 -f my-new-server-key` command.
        :param pulumi.Input[str] identity_provider_type: The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
        :param pulumi.Input[str] invocation_role: Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
        :param pulumi.Input[str] logging_role: Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
        :param pulumi.Input[str] post_authentication_login_banner: Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
        :param pulumi.Input[str] pre_authentication_login_banner: Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
        :param pulumi.Input['ServerProtocolDetailsArgs'] protocol_details: The protocol settings that are configured for your server. See `protocol_details` Block below for details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This defaults to `SFTP` . The available protocols are:
               * `AS2`: File transfer over Applicability Statement 2
               * `SFTP`: File transfer over SSH
               * `FTPS`: File transfer with TLS encryption
               * `FTP`: Unencrypted file transfer
        :param pulumi.Input['ServerS3StorageOptionsArgs'] s3_storage_options: Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default. See `s3_storage_options` Block below for details.
        :param pulumi.Input[str] security_policy_name: Specifies the name of the security policy that is attached to the server. Default value is: `TransferSecurityPolicy-2018-11`. The available values are:
               * `TransferSecurityPolicy-2018-11`
               * `TransferSecurityPolicy-2020-06`
               * `TransferSecurityPolicy-2022-03`
               * `TransferSecurityPolicy-2023-05`
               * `TransferSecurityPolicy-2024-01`
               * `TransferSecurityPolicy-FIPS-2020-06`
               * `TransferSecurityPolicy-FIPS-2023-05`
               * `TransferSecurityPolicy-FIPS-2024-01`
               * `TransferSecurityPolicy-FIPS-2024-05`
               * `TransferSecurityPolicy-PQ-SSH-Experimental-2023-04`
               * `TransferSecurityPolicy-PQ-SSH-FIPS-Experimental-2023-04`
               * `TransferSecurityPolicy-Restricted-2018-11`
               * `TransferSecurityPolicy-Restricted-2020-06`
               * `TransferSecurityPolicy-Restricted-2024-06`
               
               See [Security policies for AWS Transfer Family servers](https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html) for details.
        :param pulumi.Input[str] sftp_authentication_methods: For SFTP-enabled servers, and for custom identity providers only. Valid values are `PASSWORD`, `PUBLIC_KEY`, `PUBLIC_KEY_OR_PASSWORD` and `PUBLIC_KEY_AND_PASSWORD`. Default value is: `PUBLIC_KEY_OR_PASSWORD`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] structured_log_destinations: A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] url: URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
        :param pulumi.Input['ServerWorkflowDetailsArgs'] workflow_details: Specifies the workflow details. See `workflow_details` Block below for details.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if endpoint_details is not None:
            pulumi.set(__self__, "endpoint_details", endpoint_details)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if host_key is not None:
            pulumi.set(__self__, "host_key", host_key)
        if host_key_fingerprint is not None:
            pulumi.set(__self__, "host_key_fingerprint", host_key_fingerprint)
        if identity_provider_type is not None:
            pulumi.set(__self__, "identity_provider_type", identity_provider_type)
        if invocation_role is not None:
            pulumi.set(__self__, "invocation_role", invocation_role)
        if logging_role is not None:
            pulumi.set(__self__, "logging_role", logging_role)
        if post_authentication_login_banner is not None:
            pulumi.set(__self__, "post_authentication_login_banner", post_authentication_login_banner)
        if pre_authentication_login_banner is not None:
            pulumi.set(__self__, "pre_authentication_login_banner", pre_authentication_login_banner)
        if protocol_details is not None:
            pulumi.set(__self__, "protocol_details", protocol_details)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if s3_storage_options is not None:
            pulumi.set(__self__, "s3_storage_options", s3_storage_options)
        if security_policy_name is not None:
            pulumi.set(__self__, "security_policy_name", security_policy_name)
        if sftp_authentication_methods is not None:
            pulumi.set(__self__, "sftp_authentication_methods", sftp_authentication_methods)
        if structured_log_destinations is not None:
            pulumi.set(__self__, "structured_log_destinations", structured_log_destinations)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if workflow_details is not None:
            pulumi.set(__self__, "workflow_details", workflow_details)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of Transfer Server
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[str]]:
        """
        The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directory_id", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint of the Transfer Server (e.g., `s-12345678.server.transfer.REGION.amazonaws.com`)
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="endpointDetails")
    def endpoint_details(self) -> Optional[pulumi.Input['ServerEndpointDetailsArgs']]:
        """
        The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. See `endpoint_details` Block below for details.
        """
        return pulumi.get(self, "endpoint_details")

    @endpoint_details.setter
    def endpoint_details(self, value: Optional[pulumi.Input['ServerEndpointDetailsArgs']]):
        pulumi.set(self, "endpoint_details", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn't accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for a lambda function to use for the Identity provider.
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter(name="hostKey")
    def host_key(self) -> Optional[pulumi.Input[str]]:
        """
        RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N "" -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N "" -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N "" -f my-new-server-key` commands).
        """
        return pulumi.get(self, "host_key")

    @host_key.setter
    def host_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_key", value)

    @property
    @pulumi.getter(name="hostKeyFingerprint")
    def host_key_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        This value contains the message-digest algorithm (MD5) hash of the server's host key. This value is equivalent to the output of the `ssh-keygen -l -E md5 -f my-new-server-key` command.
        """
        return pulumi.get(self, "host_key_fingerprint")

    @host_key_fingerprint.setter
    def host_key_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_key_fingerprint", value)

    @property
    @pulumi.getter(name="identityProviderType")
    def identity_provider_type(self) -> Optional[pulumi.Input[str]]:
        """
        The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
        """
        return pulumi.get(self, "identity_provider_type")

    @identity_provider_type.setter
    def identity_provider_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_provider_type", value)

    @property
    @pulumi.getter(name="invocationRole")
    def invocation_role(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
        """
        return pulumi.get(self, "invocation_role")

    @invocation_role.setter
    def invocation_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invocation_role", value)

    @property
    @pulumi.getter(name="loggingRole")
    def logging_role(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
        """
        return pulumi.get(self, "logging_role")

    @logging_role.setter
    def logging_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logging_role", value)

    @property
    @pulumi.getter(name="postAuthenticationLoginBanner")
    def post_authentication_login_banner(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
        """
        return pulumi.get(self, "post_authentication_login_banner")

    @post_authentication_login_banner.setter
    def post_authentication_login_banner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "post_authentication_login_banner", value)

    @property
    @pulumi.getter(name="preAuthenticationLoginBanner")
    def pre_authentication_login_banner(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
        """
        return pulumi.get(self, "pre_authentication_login_banner")

    @pre_authentication_login_banner.setter
    def pre_authentication_login_banner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_authentication_login_banner", value)

    @property
    @pulumi.getter(name="protocolDetails")
    def protocol_details(self) -> Optional[pulumi.Input['ServerProtocolDetailsArgs']]:
        """
        The protocol settings that are configured for your server. See `protocol_details` Block below for details.
        """
        return pulumi.get(self, "protocol_details")

    @protocol_details.setter
    def protocol_details(self, value: Optional[pulumi.Input['ServerProtocolDetailsArgs']]):
        pulumi.set(self, "protocol_details", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This defaults to `SFTP` . The available protocols are:
        * `AS2`: File transfer over Applicability Statement 2
        * `SFTP`: File transfer over SSH
        * `FTPS`: File transfer with TLS encryption
        * `FTP`: Unencrypted file transfer
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="s3StorageOptions")
    def s3_storage_options(self) -> Optional[pulumi.Input['ServerS3StorageOptionsArgs']]:
        """
        Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default. See `s3_storage_options` Block below for details.
        """
        return pulumi.get(self, "s3_storage_options")

    @s3_storage_options.setter
    def s3_storage_options(self, value: Optional[pulumi.Input['ServerS3StorageOptionsArgs']]):
        pulumi.set(self, "s3_storage_options", value)

    @property
    @pulumi.getter(name="securityPolicyName")
    def security_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the security policy that is attached to the server. Default value is: `TransferSecurityPolicy-2018-11`. The available values are:
        * `TransferSecurityPolicy-2018-11`
        * `TransferSecurityPolicy-2020-06`
        * `TransferSecurityPolicy-2022-03`
        * `TransferSecurityPolicy-2023-05`
        * `TransferSecurityPolicy-2024-01`
        * `TransferSecurityPolicy-FIPS-2020-06`
        * `TransferSecurityPolicy-FIPS-2023-05`
        * `TransferSecurityPolicy-FIPS-2024-01`
        * `TransferSecurityPolicy-FIPS-2024-05`
        * `TransferSecurityPolicy-PQ-SSH-Experimental-2023-04`
        * `TransferSecurityPolicy-PQ-SSH-FIPS-Experimental-2023-04`
        * `TransferSecurityPolicy-Restricted-2018-11`
        * `TransferSecurityPolicy-Restricted-2020-06`
        * `TransferSecurityPolicy-Restricted-2024-06`

        See [Security policies for AWS Transfer Family servers](https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html) for details.
        """
        return pulumi.get(self, "security_policy_name")

    @security_policy_name.setter
    def security_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy_name", value)

    @property
    @pulumi.getter(name="sftpAuthenticationMethods")
    def sftp_authentication_methods(self) -> Optional[pulumi.Input[str]]:
        """
        For SFTP-enabled servers, and for custom identity providers only. Valid values are `PASSWORD`, `PUBLIC_KEY`, `PUBLIC_KEY_OR_PASSWORD` and `PUBLIC_KEY_AND_PASSWORD`. Default value is: `PUBLIC_KEY_OR_PASSWORD`.
        """
        return pulumi.get(self, "sftp_authentication_methods")

    @sftp_authentication_methods.setter
    def sftp_authentication_methods(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sftp_authentication_methods", value)

    @property
    @pulumi.getter(name="structuredLogDestinations")
    def structured_log_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
        """
        return pulumi.get(self, "structured_log_destinations")

    @structured_log_destinations.setter
    def structured_log_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "structured_log_destinations", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="workflowDetails")
    def workflow_details(self) -> Optional[pulumi.Input['ServerWorkflowDetailsArgs']]:
        """
        Specifies the workflow details. See `workflow_details` Block below for details.
        """
        return pulumi.get(self, "workflow_details")

    @workflow_details.setter
    def workflow_details(self, value: Optional[pulumi.Input['ServerWorkflowDetailsArgs']]):
        pulumi.set(self, "workflow_details", value)


class Server(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 directory_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 endpoint_details: Optional[pulumi.Input[Union['ServerEndpointDetailsArgs', 'ServerEndpointDetailsArgsDict']]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 function: Optional[pulumi.Input[str]] = None,
                 host_key: Optional[pulumi.Input[str]] = None,
                 identity_provider_type: Optional[pulumi.Input[str]] = None,
                 invocation_role: Optional[pulumi.Input[str]] = None,
                 logging_role: Optional[pulumi.Input[str]] = None,
                 post_authentication_login_banner: Optional[pulumi.Input[str]] = None,
                 pre_authentication_login_banner: Optional[pulumi.Input[str]] = None,
                 protocol_details: Optional[pulumi.Input[Union['ServerProtocolDetailsArgs', 'ServerProtocolDetailsArgsDict']]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 s3_storage_options: Optional[pulumi.Input[Union['ServerS3StorageOptionsArgs', 'ServerS3StorageOptionsArgsDict']]] = None,
                 security_policy_name: Optional[pulumi.Input[str]] = None,
                 sftp_authentication_methods: Optional[pulumi.Input[str]] = None,
                 structured_log_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 workflow_details: Optional[pulumi.Input[Union['ServerWorkflowDetailsArgs', 'ServerWorkflowDetailsArgsDict']]] = None,
                 __props__=None):
        """
        Provides a AWS Transfer Server resource.

        > **NOTE on AWS IAM permissions:** If the `endpoint_type` is set to `VPC`, the `ec2:DescribeVpcEndpoints` and `ec2:ModifyVpcEndpoint` [actions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonec2.html#amazonec2-actions-as-permissions) are used.

        > **NOTE:** Use the `transfer.Tag` resource to manage the system tags used for [custom hostnames](https://docs.aws.amazon.com/transfer/latest/userguide/requirements-dns.html#tag-custom-hostname-cdk).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Server("example", tags={
            "Name": "Example",
        })
        ```

        ### Security Policy Name

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Server("example", security_policy_name="TransferSecurityPolicy-2020-06")
        ```

        ### VPC Endpoint

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Server("example",
            endpoint_type="VPC",
            endpoint_details={
                "address_allocation_ids": [example_aws_eip["id"]],
                "subnet_ids": [example_aws_subnet["id"]],
                "vpc_id": example_aws_vpc["id"],
            })
        ```

        ### AWS Directory authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Server("example",
            identity_provider_type="AWS_DIRECTORY_SERVICE",
            directory_id=example_aws_directory_service_directory["id"])
        ```

        ### AWS Lambda authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Server("example",
            identity_provider_type="AWS_LAMBDA",
            function=example_aws_lambda_identity_provider["arn"])
        ```

        ### Protocols

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Server("example",
            endpoint_type="VPC",
            endpoint_details={
                "subnet_ids": [example_aws_subnet["id"]],
                "vpc_id": example_aws_vpc["id"],
            },
            protocols=[
                "FTP",
                "FTPS",
            ],
            certificate=example_aws_acm_certificate["arn"],
            identity_provider_type="API_GATEWAY",
            url=f"{example_aws_api_gateway_deployment['invokeUrl']}{example_aws_api_gateway_resource['path']}")
        ```

        ### Using Structured Logging Destinations

        ```python
        import pulumi
        import pulumi_aws as aws

        transfer = aws.cloudwatch.LogGroup("transfer", name_prefix="transfer_test_")
        transfer_assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["transfer.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        iam_for_transfer = aws.iam.Role("iam_for_transfer",
            name_prefix="iam_for_transfer_",
            assume_role_policy=transfer_assume_role.json,
            managed_policy_arns=["arn:aws:iam::aws:policy/service-role/AWSTransferLoggingAccess"])
        transfer_server = aws.transfer.Server("transfer",
            endpoint_type="PUBLIC",
            logging_role=iam_for_transfer.arn,
            protocols=["SFTP"],
            structured_log_destinations=[transfer.arn.apply(lambda arn: f"{arn}:*")])
        ```

        ## Import

        In Terraform v1.5.0 and later, use an `import` Block to import Transfer Servers using the server `id`. For example:

        Using `pulumi import`, import Transfer Servers using the server `id`. For example:

        ```sh
        $ pulumi import aws:transfer/server:Server example s-12345678
        ```
        Certain resource arguments, such as `host_key`, cannot be read via the API and imported into the provider. This provider will display a difference for these arguments the first run after import if declared in the provider configuration for an imported resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate: The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
        :param pulumi.Input[str] directory_id: The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
        :param pulumi.Input[str] domain: The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
        :param pulumi.Input[Union['ServerEndpointDetailsArgs', 'ServerEndpointDetailsArgsDict']] endpoint_details: The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. See `endpoint_details` Block below for details.
        :param pulumi.Input[str] endpoint_type: The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn't accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
        :param pulumi.Input[bool] force_destroy: A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
        :param pulumi.Input[str] function: The ARN for a lambda function to use for the Identity provider.
        :param pulumi.Input[str] host_key: RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N "" -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N "" -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N "" -f my-new-server-key` commands).
        :param pulumi.Input[str] identity_provider_type: The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
        :param pulumi.Input[str] invocation_role: Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
        :param pulumi.Input[str] logging_role: Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
        :param pulumi.Input[str] post_authentication_login_banner: Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
        :param pulumi.Input[str] pre_authentication_login_banner: Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
        :param pulumi.Input[Union['ServerProtocolDetailsArgs', 'ServerProtocolDetailsArgsDict']] protocol_details: The protocol settings that are configured for your server. See `protocol_details` Block below for details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This defaults to `SFTP` . The available protocols are:
               * `AS2`: File transfer over Applicability Statement 2
               * `SFTP`: File transfer over SSH
               * `FTPS`: File transfer with TLS encryption
               * `FTP`: Unencrypted file transfer
        :param pulumi.Input[Union['ServerS3StorageOptionsArgs', 'ServerS3StorageOptionsArgsDict']] s3_storage_options: Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default. See `s3_storage_options` Block below for details.
        :param pulumi.Input[str] security_policy_name: Specifies the name of the security policy that is attached to the server. Default value is: `TransferSecurityPolicy-2018-11`. The available values are:
               * `TransferSecurityPolicy-2018-11`
               * `TransferSecurityPolicy-2020-06`
               * `TransferSecurityPolicy-2022-03`
               * `TransferSecurityPolicy-2023-05`
               * `TransferSecurityPolicy-2024-01`
               * `TransferSecurityPolicy-FIPS-2020-06`
               * `TransferSecurityPolicy-FIPS-2023-05`
               * `TransferSecurityPolicy-FIPS-2024-01`
               * `TransferSecurityPolicy-FIPS-2024-05`
               * `TransferSecurityPolicy-PQ-SSH-Experimental-2023-04`
               * `TransferSecurityPolicy-PQ-SSH-FIPS-Experimental-2023-04`
               * `TransferSecurityPolicy-Restricted-2018-11`
               * `TransferSecurityPolicy-Restricted-2020-06`
               * `TransferSecurityPolicy-Restricted-2024-06`
               
               See [Security policies for AWS Transfer Family servers](https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html) for details.
        :param pulumi.Input[str] sftp_authentication_methods: For SFTP-enabled servers, and for custom identity providers only. Valid values are `PASSWORD`, `PUBLIC_KEY`, `PUBLIC_KEY_OR_PASSWORD` and `PUBLIC_KEY_AND_PASSWORD`. Default value is: `PUBLIC_KEY_OR_PASSWORD`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] structured_log_destinations: A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] url: URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
        :param pulumi.Input[Union['ServerWorkflowDetailsArgs', 'ServerWorkflowDetailsArgsDict']] workflow_details: Specifies the workflow details. See `workflow_details` Block below for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a AWS Transfer Server resource.

        > **NOTE on AWS IAM permissions:** If the `endpoint_type` is set to `VPC`, the `ec2:DescribeVpcEndpoints` and `ec2:ModifyVpcEndpoint` [actions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonec2.html#amazonec2-actions-as-permissions) are used.

        > **NOTE:** Use the `transfer.Tag` resource to manage the system tags used for [custom hostnames](https://docs.aws.amazon.com/transfer/latest/userguide/requirements-dns.html#tag-custom-hostname-cdk).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Server("example", tags={
            "Name": "Example",
        })
        ```

        ### Security Policy Name

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Server("example", security_policy_name="TransferSecurityPolicy-2020-06")
        ```

        ### VPC Endpoint

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Server("example",
            endpoint_type="VPC",
            endpoint_details={
                "address_allocation_ids": [example_aws_eip["id"]],
                "subnet_ids": [example_aws_subnet["id"]],
                "vpc_id": example_aws_vpc["id"],
            })
        ```

        ### AWS Directory authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Server("example",
            identity_provider_type="AWS_DIRECTORY_SERVICE",
            directory_id=example_aws_directory_service_directory["id"])
        ```

        ### AWS Lambda authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Server("example",
            identity_provider_type="AWS_LAMBDA",
            function=example_aws_lambda_identity_provider["arn"])
        ```

        ### Protocols

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.transfer.Server("example",
            endpoint_type="VPC",
            endpoint_details={
                "subnet_ids": [example_aws_subnet["id"]],
                "vpc_id": example_aws_vpc["id"],
            },
            protocols=[
                "FTP",
                "FTPS",
            ],
            certificate=example_aws_acm_certificate["arn"],
            identity_provider_type="API_GATEWAY",
            url=f"{example_aws_api_gateway_deployment['invokeUrl']}{example_aws_api_gateway_resource['path']}")
        ```

        ### Using Structured Logging Destinations

        ```python
        import pulumi
        import pulumi_aws as aws

        transfer = aws.cloudwatch.LogGroup("transfer", name_prefix="transfer_test_")
        transfer_assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["transfer.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        iam_for_transfer = aws.iam.Role("iam_for_transfer",
            name_prefix="iam_for_transfer_",
            assume_role_policy=transfer_assume_role.json,
            managed_policy_arns=["arn:aws:iam::aws:policy/service-role/AWSTransferLoggingAccess"])
        transfer_server = aws.transfer.Server("transfer",
            endpoint_type="PUBLIC",
            logging_role=iam_for_transfer.arn,
            protocols=["SFTP"],
            structured_log_destinations=[transfer.arn.apply(lambda arn: f"{arn}:*")])
        ```

        ## Import

        In Terraform v1.5.0 and later, use an `import` Block to import Transfer Servers using the server `id`. For example:

        Using `pulumi import`, import Transfer Servers using the server `id`. For example:

        ```sh
        $ pulumi import aws:transfer/server:Server example s-12345678
        ```
        Certain resource arguments, such as `host_key`, cannot be read via the API and imported into the provider. This provider will display a difference for these arguments the first run after import if declared in the provider configuration for an imported resource.

        :param str resource_name: The name of the resource.
        :param ServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 directory_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 endpoint_details: Optional[pulumi.Input[Union['ServerEndpointDetailsArgs', 'ServerEndpointDetailsArgsDict']]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 function: Optional[pulumi.Input[str]] = None,
                 host_key: Optional[pulumi.Input[str]] = None,
                 identity_provider_type: Optional[pulumi.Input[str]] = None,
                 invocation_role: Optional[pulumi.Input[str]] = None,
                 logging_role: Optional[pulumi.Input[str]] = None,
                 post_authentication_login_banner: Optional[pulumi.Input[str]] = None,
                 pre_authentication_login_banner: Optional[pulumi.Input[str]] = None,
                 protocol_details: Optional[pulumi.Input[Union['ServerProtocolDetailsArgs', 'ServerProtocolDetailsArgsDict']]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 s3_storage_options: Optional[pulumi.Input[Union['ServerS3StorageOptionsArgs', 'ServerS3StorageOptionsArgsDict']]] = None,
                 security_policy_name: Optional[pulumi.Input[str]] = None,
                 sftp_authentication_methods: Optional[pulumi.Input[str]] = None,
                 structured_log_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 workflow_details: Optional[pulumi.Input[Union['ServerWorkflowDetailsArgs', 'ServerWorkflowDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerArgs.__new__(ServerArgs)

            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["directory_id"] = directory_id
            __props__.__dict__["domain"] = domain
            __props__.__dict__["endpoint_details"] = endpoint_details
            __props__.__dict__["endpoint_type"] = endpoint_type
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["function"] = function
            __props__.__dict__["host_key"] = None if host_key is None else pulumi.Output.secret(host_key)
            __props__.__dict__["identity_provider_type"] = identity_provider_type
            __props__.__dict__["invocation_role"] = invocation_role
            __props__.__dict__["logging_role"] = logging_role
            __props__.__dict__["post_authentication_login_banner"] = None if post_authentication_login_banner is None else pulumi.Output.secret(post_authentication_login_banner)
            __props__.__dict__["pre_authentication_login_banner"] = None if pre_authentication_login_banner is None else pulumi.Output.secret(pre_authentication_login_banner)
            __props__.__dict__["protocol_details"] = protocol_details
            __props__.__dict__["protocols"] = protocols
            __props__.__dict__["s3_storage_options"] = s3_storage_options
            __props__.__dict__["security_policy_name"] = security_policy_name
            __props__.__dict__["sftp_authentication_methods"] = sftp_authentication_methods
            __props__.__dict__["structured_log_destinations"] = structured_log_destinations
            __props__.__dict__["tags"] = tags
            __props__.__dict__["url"] = url
            __props__.__dict__["workflow_details"] = workflow_details
            __props__.__dict__["arn"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["host_key_fingerprint"] = None
            __props__.__dict__["tags_all"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["hostKey", "postAuthenticationLoginBanner", "preAuthenticationLoginBanner"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Server, __self__).__init__(
            'aws:transfer/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            directory_id: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            endpoint_details: Optional[pulumi.Input[Union['ServerEndpointDetailsArgs', 'ServerEndpointDetailsArgsDict']]] = None,
            endpoint_type: Optional[pulumi.Input[str]] = None,
            force_destroy: Optional[pulumi.Input[bool]] = None,
            function: Optional[pulumi.Input[str]] = None,
            host_key: Optional[pulumi.Input[str]] = None,
            host_key_fingerprint: Optional[pulumi.Input[str]] = None,
            identity_provider_type: Optional[pulumi.Input[str]] = None,
            invocation_role: Optional[pulumi.Input[str]] = None,
            logging_role: Optional[pulumi.Input[str]] = None,
            post_authentication_login_banner: Optional[pulumi.Input[str]] = None,
            pre_authentication_login_banner: Optional[pulumi.Input[str]] = None,
            protocol_details: Optional[pulumi.Input[Union['ServerProtocolDetailsArgs', 'ServerProtocolDetailsArgsDict']]] = None,
            protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            s3_storage_options: Optional[pulumi.Input[Union['ServerS3StorageOptionsArgs', 'ServerS3StorageOptionsArgsDict']]] = None,
            security_policy_name: Optional[pulumi.Input[str]] = None,
            sftp_authentication_methods: Optional[pulumi.Input[str]] = None,
            structured_log_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            url: Optional[pulumi.Input[str]] = None,
            workflow_details: Optional[pulumi.Input[Union['ServerWorkflowDetailsArgs', 'ServerWorkflowDetailsArgsDict']]] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of Transfer Server
        :param pulumi.Input[str] certificate: The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
        :param pulumi.Input[str] directory_id: The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
        :param pulumi.Input[str] domain: The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
        :param pulumi.Input[str] endpoint: The endpoint of the Transfer Server (e.g., `s-12345678.server.transfer.REGION.amazonaws.com`)
        :param pulumi.Input[Union['ServerEndpointDetailsArgs', 'ServerEndpointDetailsArgsDict']] endpoint_details: The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. See `endpoint_details` Block below for details.
        :param pulumi.Input[str] endpoint_type: The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn't accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
        :param pulumi.Input[bool] force_destroy: A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
        :param pulumi.Input[str] function: The ARN for a lambda function to use for the Identity provider.
        :param pulumi.Input[str] host_key: RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N "" -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N "" -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N "" -f my-new-server-key` commands).
        :param pulumi.Input[str] host_key_fingerprint: This value contains the message-digest algorithm (MD5) hash of the server's host key. This value is equivalent to the output of the `ssh-keygen -l -E md5 -f my-new-server-key` command.
        :param pulumi.Input[str] identity_provider_type: The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
        :param pulumi.Input[str] invocation_role: Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
        :param pulumi.Input[str] logging_role: Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
        :param pulumi.Input[str] post_authentication_login_banner: Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
        :param pulumi.Input[str] pre_authentication_login_banner: Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
        :param pulumi.Input[Union['ServerProtocolDetailsArgs', 'ServerProtocolDetailsArgsDict']] protocol_details: The protocol settings that are configured for your server. See `protocol_details` Block below for details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This defaults to `SFTP` . The available protocols are:
               * `AS2`: File transfer over Applicability Statement 2
               * `SFTP`: File transfer over SSH
               * `FTPS`: File transfer with TLS encryption
               * `FTP`: Unencrypted file transfer
        :param pulumi.Input[Union['ServerS3StorageOptionsArgs', 'ServerS3StorageOptionsArgsDict']] s3_storage_options: Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default. See `s3_storage_options` Block below for details.
        :param pulumi.Input[str] security_policy_name: Specifies the name of the security policy that is attached to the server. Default value is: `TransferSecurityPolicy-2018-11`. The available values are:
               * `TransferSecurityPolicy-2018-11`
               * `TransferSecurityPolicy-2020-06`
               * `TransferSecurityPolicy-2022-03`
               * `TransferSecurityPolicy-2023-05`
               * `TransferSecurityPolicy-2024-01`
               * `TransferSecurityPolicy-FIPS-2020-06`
               * `TransferSecurityPolicy-FIPS-2023-05`
               * `TransferSecurityPolicy-FIPS-2024-01`
               * `TransferSecurityPolicy-FIPS-2024-05`
               * `TransferSecurityPolicy-PQ-SSH-Experimental-2023-04`
               * `TransferSecurityPolicy-PQ-SSH-FIPS-Experimental-2023-04`
               * `TransferSecurityPolicy-Restricted-2018-11`
               * `TransferSecurityPolicy-Restricted-2020-06`
               * `TransferSecurityPolicy-Restricted-2024-06`
               
               See [Security policies for AWS Transfer Family servers](https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html) for details.
        :param pulumi.Input[str] sftp_authentication_methods: For SFTP-enabled servers, and for custom identity providers only. Valid values are `PASSWORD`, `PUBLIC_KEY`, `PUBLIC_KEY_OR_PASSWORD` and `PUBLIC_KEY_AND_PASSWORD`. Default value is: `PUBLIC_KEY_OR_PASSWORD`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] structured_log_destinations: A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] url: URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
        :param pulumi.Input[Union['ServerWorkflowDetailsArgs', 'ServerWorkflowDetailsArgsDict']] workflow_details: Specifies the workflow details. See `workflow_details` Block below for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerState.__new__(_ServerState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["domain"] = domain
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["endpoint_details"] = endpoint_details
        __props__.__dict__["endpoint_type"] = endpoint_type
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["function"] = function
        __props__.__dict__["host_key"] = host_key
        __props__.__dict__["host_key_fingerprint"] = host_key_fingerprint
        __props__.__dict__["identity_provider_type"] = identity_provider_type
        __props__.__dict__["invocation_role"] = invocation_role
        __props__.__dict__["logging_role"] = logging_role
        __props__.__dict__["post_authentication_login_banner"] = post_authentication_login_banner
        __props__.__dict__["pre_authentication_login_banner"] = pre_authentication_login_banner
        __props__.__dict__["protocol_details"] = protocol_details
        __props__.__dict__["protocols"] = protocols
        __props__.__dict__["s3_storage_options"] = s3_storage_options
        __props__.__dict__["security_policy_name"] = security_policy_name
        __props__.__dict__["sftp_authentication_methods"] = sftp_authentication_methods
        __props__.__dict__["structured_log_destinations"] = structured_log_destinations
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["url"] = url
        __props__.__dict__["workflow_details"] = workflow_details
        return Server(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of Transfer Server
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[Optional[str]]:
        """
        The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[str]]:
        """
        The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        The endpoint of the Transfer Server (e.g., `s-12345678.server.transfer.REGION.amazonaws.com`)
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="endpointDetails")
    def endpoint_details(self) -> pulumi.Output[Optional['outputs.ServerEndpointDetails']]:
        """
        The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. See `endpoint_details` Block below for details.
        """
        return pulumi.get(self, "endpoint_details")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn't accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter
    def function(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN for a lambda function to use for the Identity provider.
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter(name="hostKey")
    def host_key(self) -> pulumi.Output[Optional[str]]:
        """
        RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N "" -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N "" -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N "" -f my-new-server-key` commands).
        """
        return pulumi.get(self, "host_key")

    @property
    @pulumi.getter(name="hostKeyFingerprint")
    def host_key_fingerprint(self) -> pulumi.Output[str]:
        """
        This value contains the message-digest algorithm (MD5) hash of the server's host key. This value is equivalent to the output of the `ssh-keygen -l -E md5 -f my-new-server-key` command.
        """
        return pulumi.get(self, "host_key_fingerprint")

    @property
    @pulumi.getter(name="identityProviderType")
    def identity_provider_type(self) -> pulumi.Output[Optional[str]]:
        """
        The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
        """
        return pulumi.get(self, "identity_provider_type")

    @property
    @pulumi.getter(name="invocationRole")
    def invocation_role(self) -> pulumi.Output[Optional[str]]:
        """
        Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
        """
        return pulumi.get(self, "invocation_role")

    @property
    @pulumi.getter(name="loggingRole")
    def logging_role(self) -> pulumi.Output[Optional[str]]:
        """
        Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
        """
        return pulumi.get(self, "logging_role")

    @property
    @pulumi.getter(name="postAuthenticationLoginBanner")
    def post_authentication_login_banner(self) -> pulumi.Output[Optional[str]]:
        """
        Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
        """
        return pulumi.get(self, "post_authentication_login_banner")

    @property
    @pulumi.getter(name="preAuthenticationLoginBanner")
    def pre_authentication_login_banner(self) -> pulumi.Output[Optional[str]]:
        """
        Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
        """
        return pulumi.get(self, "pre_authentication_login_banner")

    @property
    @pulumi.getter(name="protocolDetails")
    def protocol_details(self) -> pulumi.Output['outputs.ServerProtocolDetails']:
        """
        The protocol settings that are configured for your server. See `protocol_details` Block below for details.
        """
        return pulumi.get(self, "protocol_details")

    @property
    @pulumi.getter
    def protocols(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This defaults to `SFTP` . The available protocols are:
        * `AS2`: File transfer over Applicability Statement 2
        * `SFTP`: File transfer over SSH
        * `FTPS`: File transfer with TLS encryption
        * `FTP`: Unencrypted file transfer
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="s3StorageOptions")
    def s3_storage_options(self) -> pulumi.Output['outputs.ServerS3StorageOptions']:
        """
        Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default. See `s3_storage_options` Block below for details.
        """
        return pulumi.get(self, "s3_storage_options")

    @property
    @pulumi.getter(name="securityPolicyName")
    def security_policy_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the name of the security policy that is attached to the server. Default value is: `TransferSecurityPolicy-2018-11`. The available values are:
        * `TransferSecurityPolicy-2018-11`
        * `TransferSecurityPolicy-2020-06`
        * `TransferSecurityPolicy-2022-03`
        * `TransferSecurityPolicy-2023-05`
        * `TransferSecurityPolicy-2024-01`
        * `TransferSecurityPolicy-FIPS-2020-06`
        * `TransferSecurityPolicy-FIPS-2023-05`
        * `TransferSecurityPolicy-FIPS-2024-01`
        * `TransferSecurityPolicy-FIPS-2024-05`
        * `TransferSecurityPolicy-PQ-SSH-Experimental-2023-04`
        * `TransferSecurityPolicy-PQ-SSH-FIPS-Experimental-2023-04`
        * `TransferSecurityPolicy-Restricted-2018-11`
        * `TransferSecurityPolicy-Restricted-2020-06`
        * `TransferSecurityPolicy-Restricted-2024-06`

        See [Security policies for AWS Transfer Family servers](https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html) for details.
        """
        return pulumi.get(self, "security_policy_name")

    @property
    @pulumi.getter(name="sftpAuthenticationMethods")
    def sftp_authentication_methods(self) -> pulumi.Output[str]:
        """
        For SFTP-enabled servers, and for custom identity providers only. Valid values are `PASSWORD`, `PUBLIC_KEY`, `PUBLIC_KEY_OR_PASSWORD` and `PUBLIC_KEY_AND_PASSWORD`. Default value is: `PUBLIC_KEY_OR_PASSWORD`.
        """
        return pulumi.get(self, "sftp_authentication_methods")

    @property
    @pulumi.getter(name="structuredLogDestinations")
    def structured_log_destinations(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
        """
        return pulumi.get(self, "structured_log_destinations")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional[str]]:
        """
        URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="workflowDetails")
    def workflow_details(self) -> pulumi.Output[Optional['outputs.ServerWorkflowDetails']]:
        """
        Specifies the workflow details. See `workflow_details` Block below for details.
        """
        return pulumi.get(self, "workflow_details")

