# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyStoreArgs', 'PolicyStore']

@pulumi.input_type
class PolicyStoreArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 validation_settings: Optional[pulumi.Input['PolicyStoreValidationSettingsArgs']] = None):
        """
        The set of arguments for constructing a PolicyStore resource.
        :param pulumi.Input[str] description: A description of the Policy Store.
        :param pulumi.Input['PolicyStoreValidationSettingsArgs'] validation_settings: Validation settings for the policy store.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if validation_settings is not None:
            pulumi.set(__self__, "validation_settings", validation_settings)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the Policy Store.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> Optional[pulumi.Input['PolicyStoreValidationSettingsArgs']]:
        """
        Validation settings for the policy store.
        """
        return pulumi.get(self, "validation_settings")

    @validation_settings.setter
    def validation_settings(self, value: Optional[pulumi.Input['PolicyStoreValidationSettingsArgs']]):
        pulumi.set(self, "validation_settings", value)


@pulumi.input_type
class _PolicyStoreState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 policy_store_id: Optional[pulumi.Input[str]] = None,
                 validation_settings: Optional[pulumi.Input['PolicyStoreValidationSettingsArgs']] = None):
        """
        Input properties used for looking up and filtering PolicyStore resources.
        :param pulumi.Input[str] arn: The ARN of the Policy Store.
        :param pulumi.Input[str] description: A description of the Policy Store.
        :param pulumi.Input[str] policy_store_id: The ID of the Policy Store.
        :param pulumi.Input['PolicyStoreValidationSettingsArgs'] validation_settings: Validation settings for the policy store.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if policy_store_id is not None:
            pulumi.set(__self__, "policy_store_id", policy_store_id)
        if validation_settings is not None:
            pulumi.set(__self__, "validation_settings", validation_settings)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the Policy Store.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the Policy Store.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="policyStoreId")
    def policy_store_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Policy Store.
        """
        return pulumi.get(self, "policy_store_id")

    @policy_store_id.setter
    def policy_store_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_store_id", value)

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> Optional[pulumi.Input['PolicyStoreValidationSettingsArgs']]:
        """
        Validation settings for the policy store.
        """
        return pulumi.get(self, "validation_settings")

    @validation_settings.setter
    def validation_settings(self, value: Optional[pulumi.Input['PolicyStoreValidationSettingsArgs']]):
        pulumi.set(self, "validation_settings", value)


class PolicyStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 validation_settings: Optional[pulumi.Input[Union['PolicyStoreValidationSettingsArgs', 'PolicyStoreValidationSettingsArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.verifiedpermissions.PolicyStore("example", validation_settings={
            "mode": "STRICT",
        })
        ```

        ## Import

        Using `pulumi import`, import Verified Permissions Policy Store using the `policy_store_id`. For example:

        console

         % pulumi import aws_verifiedpermissions_policy_store.example DxQg2j8xvXJQ1tQCYNWj9T

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the Policy Store.
        :param pulumi.Input[Union['PolicyStoreValidationSettingsArgs', 'PolicyStoreValidationSettingsArgsDict']] validation_settings: Validation settings for the policy store.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PolicyStoreArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.verifiedpermissions.PolicyStore("example", validation_settings={
            "mode": "STRICT",
        })
        ```

        ## Import

        Using `pulumi import`, import Verified Permissions Policy Store using the `policy_store_id`. For example:

        console

         % pulumi import aws_verifiedpermissions_policy_store.example DxQg2j8xvXJQ1tQCYNWj9T

        :param str resource_name: The name of the resource.
        :param PolicyStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 validation_settings: Optional[pulumi.Input[Union['PolicyStoreValidationSettingsArgs', 'PolicyStoreValidationSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyStoreArgs.__new__(PolicyStoreArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["validation_settings"] = validation_settings
            __props__.__dict__["arn"] = None
            __props__.__dict__["policy_store_id"] = None
        super(PolicyStore, __self__).__init__(
            'aws:verifiedpermissions/policyStore:PolicyStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            policy_store_id: Optional[pulumi.Input[str]] = None,
            validation_settings: Optional[pulumi.Input[Union['PolicyStoreValidationSettingsArgs', 'PolicyStoreValidationSettingsArgsDict']]] = None) -> 'PolicyStore':
        """
        Get an existing PolicyStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the Policy Store.
        :param pulumi.Input[str] description: A description of the Policy Store.
        :param pulumi.Input[str] policy_store_id: The ID of the Policy Store.
        :param pulumi.Input[Union['PolicyStoreValidationSettingsArgs', 'PolicyStoreValidationSettingsArgsDict']] validation_settings: Validation settings for the policy store.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyStoreState.__new__(_PolicyStoreState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["policy_store_id"] = policy_store_id
        __props__.__dict__["validation_settings"] = validation_settings
        return PolicyStore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the Policy Store.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the Policy Store.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="policyStoreId")
    def policy_store_id(self) -> pulumi.Output[str]:
        """
        The ID of the Policy Store.
        """
        return pulumi.get(self, "policy_store_id")

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> pulumi.Output[Optional['outputs.PolicyStoreValidationSettings']]:
        """
        Validation settings for the policy store.
        """
        return pulumi.get(self, "validation_settings")

