      SUBROUTINE MUL2M (A1, M1, K1, L1, N1,
     &                  A2, M2, K2, L2, N2,
     &                  A , M , K , L , N )
C ======================================================================
C A(K:K+N1,L:L+N) = A1(K1:K1+N1,L1:L1+N2) * 
C                   A2(K2:K2+N2,L2:L2+N3) 
C ======================================================================
C KI  I4  >0: NORMAL USAGE
C         <0: TRANSPOSE IS USED
C ======================================================================
      IMPLICIT REAL(8)(A-H,O-Z)
      IMPLICIT INTEGER(4)(I-N)
C ======================================================================
      DIMENSION A1(M1,*), A2(M2,*), A(M,*)
C ======================================================================
      DO 2000 I1 = K, K+N1-1
      DO 2100 I  = L, L+N -1
      A(I1,I) = 0D0
 2100 CONTINUE
 2000 CONTINUE
C ======================================================================
      DO 1000 I1 = 0, N1-1
C ----------------------------------------------------------------------
      DO 1100 I2 = 0, N2-1
      IF (K1 .GE. 0) THEN
         F1 = A1(I1+K1,I2+L1)
      ELSE
         F1 = A1(I2-K1,I1+L1)
      ENDIF
      IF (F1 .EQ. 0D0) GOTO 1100
C ----------------------------------------------------------------------
      DO 1200 I  = 0, N -1
      IF (K2 .GE. 0) THEN
         F2 = A2(I2+K2,I +L2)
      ELSE
         F2 = A2(I -K2,I2+L2)
      ENDIF
      IF (F2 .EQ. 0D0) GOTO 1200
      F2 = F2 * F1
      IC = I1 + K
      IR = I  + L
      A(IC,IR) = A(IC,IR) + F2
 1200 CONTINUE
C ----------------------------------------------------------------------
 1100 CONTINUE
C ----------------------------------------------------------------------
 1000 CONTINUE
C ======================================================================
      RETURN
      END
