# Version history

## 0.10.7

- Lock on collaboration room cleanup.
- Move `ASGIWebSocketTransport` to `jupyverse_api`.

## 0.10.6

- Bump `fps >=0.5.1`.
- Support stopping `fps-kernel-web-worker`.

## 0.10.5

- Add `fps-kernel-web-worker` plugin.

## 0.10.3

- Propagate `yjs` settings.

## 0.10.2

- Rework `test_kernels.py` to use ASGI transport.

## 0.10.1

- Fix optional dependencies pinning.

## 0.10.0

- Fix write permissions in RTC.
- Make `watchfiles` an optional dependency in `fps-kernels`.
- Support kernel launchers.
- Remove `websockets` dependency.

## 0.9.0

- Extract out file ID from contents to its own plugin.

## 0.8.4

- Check if `labextensions` directory exists.

## 0.8.3

- Pin `jupyverse-api` >=0.8.2.

## 0.8.2

- Move `rich-click` dependency from `jupyverse-api` to `jupyverse`.

## 0.8.1

- `jupyverse-api`: Don't wait for server to start if no server.

## 0.8.0

- Use `uv` for building and publishing.
- Update `fps` to v0.4.0.
- Depend on package `notebook-frontend` instead of `notebook`.
- Depend on package `jupyterlab-js` instead of `jupyterlab`.

## 0.7.8

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.7.7...aef97417f06bbb76e9a6b060b5f662dd555caaae))

### Merged PRs

- Use jupyter-ydoc instead of vendored version [#484](https://github.com/jupyter-server/jupyverse/pull/484) ([@davidbrochart](https://github.com/davidbrochart))
- Upgrade FPS to v0.3.0 [#482](https://github.com/jupyter-server/jupyverse/pull/482) ([@davidbrochart](https://github.com/davidbrochart))
- Fix stream outputs [#480](https://github.com/jupyter-server/jupyverse/pull/480) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2025-04-04&to=2025-04-23&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2025-04-04..2025-04-23&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2025-04-04..2025-04-23&type=Issues)

## 0.7.7

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.7.6...69a1ecaa8f61a83c441d1c8e69a02835085fceb6))

### Merged PRs

- Check if file exists before inserting it in fileids [#478](https://github.com/jupyter-server/jupyverse/pull/478) ([@davidbrochart](https://github.com/davidbrochart))
- Bump fps >=0.2.1 [#476](https://github.com/jupyter-server/jupyverse/pull/476) ([@davidbrochart](https://github.com/davidbrochart))
- Update types [#475](https://github.com/jupyter-server/jupyverse/pull/475) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2025-03-28&to=2025-04-04&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2025-03-28..2025-04-04&type=Issues)

## 0.7.6

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.7.5...510ab6902fb8701df90fb542511b7daa2f7a9537))

### Merged PRs

- Convert repo to use releaser from repo [#474](https://github.com/jupyter-server/jupyverse/pull/474) ([@davidbrochart](https://github.com/davidbrochart))
- Fix kernel shutdown [#473](https://github.com/jupyter-server/jupyverse/pull/473) ([@davidbrochart](https://github.com/davidbrochart))
- Bump FPS v0.1.5 [#467](https://github.com/jupyter-server/jupyverse/pull/467) ([@davidbrochart](https://github.com/davidbrochart))
- Use zmq-anyio [#466](https://github.com/jupyter-server/jupyverse/pull/466) ([@davidbrochart](https://github.com/davidbrochart))
- Fix connection to existing kernel [#463](https://github.com/jupyter-server/jupyverse/pull/463) ([@davidbrochart](https://github.com/davidbrochart))
- Bump FPS v0.1.3 [#462](https://github.com/jupyter-server/jupyverse/pull/462) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2025-02-26&to=2025-03-28&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2025-02-26..2025-03-28&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2025-02-26..2025-03-28&type=Issues)

## 0.7.5

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.7.4...3c652e450d8ce5e46d7ea1bb00c402d611c4f54f))

### Merged PRs

- Use AnyIO's wait_readable for terminals [#461](https://github.com/jupyter-server/jupyverse/pull/461) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2025-02-17&to=2025-02-26&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2025-02-17..2025-02-26&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2025-02-17..2025-02-26&type=Issues)

## 0.7.4

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.7.3...3dee770cdcb8ae2529874a0a73592d2744eed63e))

### Merged PRs

- Fix fps-auth-jupyterhub [#460](https://github.com/jupyter-server/jupyverse/pull/460) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2025-02-17&to=2025-02-17&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2025-02-17..2025-02-17&type=Issues)

## 0.7.3

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.7.2...2c046e8db0203c7d90476bf11ab11b89c0b0af51))

### Merged PRs

- Fix fps-auth-jupyterhub dependency [#459](https://github.com/jupyter-server/jupyverse/pull/459) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2025-02-15&to=2025-02-17&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2025-02-15..2025-02-17&type=Issues)

## 0.7.2

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.7.1...4d739c76ef3891c6fe8b6e7397e215efe348e95b))

### Merged PRs

- Bump fastapi-users v14 [#458](https://github.com/jupyter-server/jupyverse/pull/458) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2025-02-14&to=2025-02-15&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2025-02-14..2025-02-15&type=Issues)

## 0.7.1

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.7.0...96cb8831e330527089ebbf41d649cbe9c8b32053))

### Merged PRs

- Require versions >=0.7.0 [#457](https://github.com/jupyter-server/jupyverse/pull/457) ([@davidbrochart](https://github.com/davidbrochart))
- Unpin Python version in Binder [#456](https://github.com/jupyter-server/jupyverse/pull/456) ([@davidbrochart](https://github.com/davidbrochart))
- Fix fps-notebook base URL [#455](https://github.com/jupyter-server/jupyverse/pull/455) ([@davidbrochart](https://github.com/davidbrochart))
- Update README [#454](https://github.com/jupyter-server/jupyverse/pull/454) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2025-02-14&to=2025-02-14&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2025-02-14..2025-02-14&type=Issues)

## 0.7.0

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.6.4...6fe98eab9ef0cef9d77a49bed92829ae3fb3538c))

### Merged PRs

- Switch to FPS [#453](https://github.com/jupyter-server/jupyverse/pull/453) ([@davidbrochart](https://github.com/davidbrochart))
- Fixing typo in the documentation [#452](https://github.com/jupyter-server/jupyverse/pull/452) ([@ThePavolC](https://github.com/ThePavolC))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2024-10-15&to=2025-02-14&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2024-10-15..2025-02-14&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2024-10-15..2025-02-14&type=Issues) | [@ThePavolC](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3AThePavolC+updated%3A2024-10-15..2025-02-14&type=Issues)

## 0.6.4

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.6.3...69394c087d0645c784ff14e3cb71557c7a0d5cfa))

### Merged PRs

- Fix nbconvert file save mode [#446](https://github.com/jupyter-server/jupyverse/pull/446) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2024-10-02&to=2024-10-15&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2024-10-02..2024-10-15&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2024-10-02..2024-10-15&type=Issues)

## 0.6.3

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.6.2...aa6854a51665d95216340d7fda1ba111af6aef74))

### Merged PRs

- Add Yjs plugin configuration [#442](https://github.com/jupyter-server/jupyverse/pull/442) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2024-09-13&to=2024-10-02&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2024-09-13..2024-10-02&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2024-09-13..2024-10-02&type=Issues)

## 0.6.2

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.6.1...b7823731e061936842a3d2bcc6044f5134b50857))

### Merged PRs

- Bump ypywidgets, fix display_output handling [#437](https://github.com/jupyter-server/jupyverse/pull/437) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2024-09-09&to=2024-09-13&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2024-09-09..2024-09-13&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2024-09-09..2024-09-13&type=Issues)

## 0.6.1

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.6.0...74930336b6b60a75e07cb0d45b10e4cfcdb80d58))

### Merged PRs

- Bump pycrdt v0.9.0 [#434](https://github.com/jupyter-server/jupyverse/pull/434) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2024-05-22&to=2024-09-09&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2024-05-22..2024-09-09&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2024-05-22..2024-09-09&type=Issues)

## 0.6.0

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.5.4...74a20c5aba350ae2dac605ff303d4e75f72eff40))

### Merged PRs

- Fix terminals [#414](https://github.com/jupyter-server/jupyverse/pull/414) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2024-05-14&to=2024-05-22&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2024-05-14..2024-05-22&type=Issues)

## 0.5.4

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.5.3...9f208a6e2e13396f6723a80e23bef688285611e5))

### Merged PRs

- Improve terminals [#413](https://github.com/jupyter-server/jupyverse/pull/413) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2024-05-13&to=2024-05-14&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2024-05-13..2024-05-14&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2024-05-13..2024-05-14&type=Issues)

## 0.5.3

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.5.2...d5a5b178b93172a9bb8b90459d45ed20a1b734c5))

### Merged PRs

- Remove asyncio reader when quitting terminal [#411](https://github.com/jupyter-server/jupyverse/pull/411) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2024-05-02&to=2024-05-13&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2024-05-02..2024-05-13&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2024-05-02..2024-05-13&type=Issues)

## 0.5.2

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.5.1...0bd54d15a6ad7fbfe7c54f5a06ed4546de4ad90d))

### Merged PRs

- Fix typo [#407](https://github.com/jupyter-server/jupyverse/pull/407) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2024-04-29&to=2024-05-02&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2024-04-29..2024-05-02&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2024-04-29..2024-05-02&type=Issues)

## 0.5.1

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.5.0...4ddd9ab118c9ed47340d44b6eb57b68894b1bcc5))

### Merged PRs

- Check terminal websocket before removing it [#405](https://github.com/jupyter-server/jupyverse/pull/405) ([@davidbrochart](https://github.com/davidbrochart))
- Update documentation URL [#404](https://github.com/jupyter-server/jupyverse/pull/404) ([@davidbrochart](https://github.com/davidbrochart))
- Set watchfiles log level to WARNING [#403](https://github.com/jupyter-server/jupyverse/pull/403) ([@davidbrochart](https://github.com/davidbrochart))
- Update ypywidgets v0.7.0 for tests [#400](https://github.com/jupyter-server/jupyverse/pull/400) ([@davidbrochart](https://github.com/davidbrochart))
- Remove output trailing newline [#399](https://github.com/jupyter-server/jupyverse/pull/399) ([@davidbrochart](https://github.com/davidbrochart))
- Save anonymous user info in database [#397](https://github.com/jupyter-server/jupyverse/pull/397) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2024-04-12&to=2024-04-29&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2024-04-12..2024-04-29&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2024-04-12..2024-04-29&type=Issues)

## 0.5.0

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.4.2...66aac71cf07cbc14c5196cc1c144b9965fec7d2c))

### Merged PRs

- Replace RetroLab with Notebook [#396](https://github.com/jupyter-server/jupyverse/pull/396) ([@davidbrochart](https://github.com/davidbrochart))
- Update FastAPI-Users v13.0.0 [#395](https://github.com/jupyter-server/jupyverse/pull/395) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2024-01-02&to=2024-04-12&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2024-01-02..2024-04-12&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2024-01-02..2024-04-12&type=Issues)

## 0.4.2

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.4.1...2f084c7c744bb2d2865bdad223c680eca5c8a2cb))

### Merged PRs

- Update pycrdt >=0.8.2 [#379](https://github.com/jupyter-server/jupyverse/pull/379) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-12-18&to=2024-01-02&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-12-18..2024-01-02&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-12-18..2024-01-02&type=Issues)

## 0.4.1

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.4.0...8321cf2a280ebe5e4bb4b09571a5b11855db649a))

### Merged PRs

- Make ypywidgets optional [#375](https://github.com/jupyter-server/jupyverse/pull/375) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-12-16&to=2023-12-18&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-12-16..2023-12-18&type=Issues)

## 0.4.0

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.3.0...73a16c326e333838aaa8ec2321c40d5d13a96f05))

### Merged PRs

- Check types in a separate CI job [#373](https://github.com/jupyter-server/jupyverse/pull/373) ([@davidbrochart](https://github.com/davidbrochart))
- Add pytest color [#372](https://github.com/jupyter-server/jupyverse/pull/372) ([@davidbrochart](https://github.com/davidbrochart))
- Update pycrdt v0.7.2 [#371](https://github.com/jupyter-server/jupyverse/pull/371) ([@davidbrochart](https://github.com/davidbrochart))
- Implement server-side ypywidgets rendering [#364](https://github.com/jupyter-server/jupyverse/pull/364) ([@davidbrochart](https://github.com/davidbrochart))
- Improve data read [#362](https://github.com/jupyter-server/jupyverse/pull/362) ([@davidbrochart](https://github.com/davidbrochart))
- Replace black with ruff formatter [#361](https://github.com/jupyter-server/jupyverse/pull/361) ([@davidbrochart](https://github.com/davidbrochart))
- Replace Ypy with pycrdt [#359](https://github.com/jupyter-server/jupyverse/pull/359) ([@davidbrochart](https://github.com/davidbrochart))
- Set optional contents API model fields to None by default [#358](https://github.com/jupyter-server/jupyverse/pull/358) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-10-10&to=2023-12-16&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-10-10..2023-12-16&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-10-10..2023-12-16&type=Issues)

## 0.3.0

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.2.5...88f061e58d22963f7b195b5677c983a7b1056b94))

### Merged PRs

- Send notebook cell source as string when type is list [#354](https://github.com/jupyter-server/jupyverse/pull/354) ([@davidbrochart](https://github.com/davidbrochart))
- Align external kernel connections with jupyter-server [#352](https://github.com/jupyter-server/jupyverse/pull/352) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-09-06&to=2023-10-10&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-09-06..2023-10-10&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-09-06..2023-10-10&type=Issues)

## 0.2.5

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.2.4...18f312eb8b3dee262fb512af7e7ec3996674c4d4))

### Merged PRs

- Add default values to CLI callback [#349](https://github.com/jupyter-server/jupyverse/pull/349) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-08-31&to=2023-09-06&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-08-31..2023-09-06&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-08-31..2023-09-06&type=Issues)

## 0.2.4

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.2.3...5f49cddd48ea1344f21acc79b4a07ba2068ade51))

### Merged PRs

- Pin anyio\<5 [#344](https://github.com/jupyter-server/jupyverse/pull/344) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-08-30&to=2023-08-31&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-08-30..2023-08-31&type=Issues)

## 0.2.3

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.2.2...861ae2c7b123e1fca13d4ef5fd50cc3472ea744e))

### Merged PRs

- Add CLI --allow-origin (CORS) [#343](https://github.com/jupyter-server/jupyverse/pull/343) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-08-29&to=2023-08-30&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-08-29..2023-08-30&type=Issues)

## 0.2.2

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.2.1...cca0480530ca9fd6ce09d4d7901e8a3ffa0e55d2))

### Merged PRs

- Fix fps_auth_jupyterhub [#338](https://github.com/jupyter-server/jupyverse/pull/338) ([@davidbrochart](https://github.com/davidbrochart))
- Add GET /api/status [#337](https://github.com/jupyter-server/jupyverse/pull/337) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-08-02&to=2023-08-29&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-08-02..2023-08-29&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-08-02..2023-08-29&type=Issues)

## 0.2.1

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.2.0...dbd047377e6d7f16c235795da578813cf274651f))

### Merged PRs

- Add fps_auth_jupyterhub plugin [#335](https://github.com/jupyter-server/jupyverse/pull/335) ([@davidbrochart](https://github.com/davidbrochart))
- Add mount_path for mounting app at sub-path [#334](https://github.com/jupyter-server/jupyverse/pull/334) ([@davidbrochart](https://github.com/davidbrochart))
- Fix external kernels [#333](https://github.com/jupyter-server/jupyverse/pull/333) ([@davidbrochart](https://github.com/davidbrochart))
- Add documentation on deployment [#327](https://github.com/jupyter-server/jupyverse/pull/327) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-07-13&to=2023-08-02&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-07-13..2023-08-02&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-07-13..2023-08-02&type=Issues)

## 0.2.0

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.1.10...ebf0e6d40a593eccccaf3ae2753e6ad272135e3b))

### Merged PRs

- Rerun flaky tests [#331](https://github.com/jupyter-server/jupyverse/pull/331) ([@davidbrochart](https://github.com/davidbrochart))
- Use pydantic v2 [#330](https://github.com/jupyter-server/jupyverse/pull/330) ([@davidbrochart](https://github.com/davidbrochart))
- Update fastapi-users v12 [#329](https://github.com/jupyter-server/jupyverse/pull/329) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-07-05&to=2023-07-13&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-07-05..2023-07-13&type=Issues) | [@frankie567](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Afrankie567+updated%3A2023-07-05..2023-07-13&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-07-05..2023-07-13&type=Issues)

## 0.1.10

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.1.9...e15a7e4091cfa94dff41b05cf273ed92438ad299))

### Merged PRs

- Pin ypy-websocket \<0.11 [#325](https://github.com/jupyter-server/jupyverse/pull/325) ([@davidbrochart](https://github.com/davidbrochart))
- Add GitHub authentication with fps-auth-fief [#324](https://github.com/jupyter-server/jupyverse/pull/324) ([@davidbrochart](https://github.com/davidbrochart))
- Support ypy-websocket v0.12 [#320](https://github.com/jupyter-server/jupyverse/pull/320) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-06-06&to=2023-07-05&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-06-06..2023-07-05&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-06-06..2023-07-05&type=Issues)

## 0.1.9

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.1.8...ab09a2ea41fcdab226ec55541a26329c3d5b7583))

### Merged PRs

- Fix fps-webdav logging config [#317](https://github.com/jupyter-server/jupyverse/pull/317) ([@davidbrochart](https://github.com/davidbrochart))
- Fix fps-auth-fief [#316](https://github.com/jupyter-server/jupyverse/pull/316) ([@davidbrochart](https://github.com/davidbrochart))
- Handle binary (base64-encoded) files [#315](https://github.com/jupyter-server/jupyverse/pull/315) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-05-31&to=2023-06-06&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-05-31..2023-06-06&type=Issues) | [@trungleduc](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Atrungleduc+updated%3A2023-05-31..2023-06-06&type=Issues)

## 0.1.8

No merged PRs

## 0.1.7

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.1.6...d1d54a22429136b87fd45b7540d43937b2e6b695))

### Merged PRs

- Add WebDAV plugin [#312](https://github.com/jupyter-server/jupyverse/pull/312) ([@davidbrochart](https://github.com/davidbrochart))
- Fix contents for empty directory [#311](https://github.com/jupyter-server/jupyverse/pull/311) ([@davidbrochart](https://github.com/davidbrochart))
- Replace request with permissions query parameter in GET /api/me [#309](https://github.com/jupyter-server/jupyverse/pull/309) ([@davidbrochart](https://github.com/davidbrochart))
- Add notebook for user administration [#308](https://github.com/jupyter-server/jupyverse/pull/308) ([@davidbrochart](https://github.com/davidbrochart))
- Refactor fps_yjs [#307](https://github.com/jupyter-server/jupyverse/pull/307) ([@davidbrochart](https://github.com/davidbrochart))
- Fix labextensions, move fileid.db to .fileid.db, update to jupyterlab v4 [#304](https://github.com/jupyter-server/jupyverse/pull/304) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-05-05&to=2023-05-31&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-05-05..2023-05-31&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-05-05..2023-05-31&type=Issues)

## 0.1.6

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.1.5...442f12896cb390ef8346a2fc99e927fa3295421b))

### Merged PRs

- Update dependencies [#298](https://github.com/jupyter-server/jupyverse/pull/298) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-04-29&to=2023-05-05&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-04-29..2023-05-05&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-04-29..2023-05-05&type=Issues)

## 0.1.5

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.1.4...bea8fa74efe86fa59ea6054f6e332ffd3d58b23f))

### Merged PRs

- Update with FastAPI-Users v11 [#296](https://github.com/jupyter-server/jupyverse/pull/296) ([@davidbrochart](https://github.com/davidbrochart))
- Update documentation on microservices with authentication [#295](https://github.com/jupyter-server/jupyverse/pull/295) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-04-18&to=2023-04-29&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-04-18..2023-04-29&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-04-18..2023-04-29&type=Issues)

## 0.1.4

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.1.3...a42f7c4d0e951d620108afb4ca25e57da5bae2a1))

### Merged PRs

- Move routes to jupyverse_api [#293](https://github.com/jupyter-server/jupyverse/pull/293) ([@davidbrochart](https://github.com/davidbrochart))
- Add microservices doc, move CLI to jupyverse_api [#292](https://github.com/jupyter-server/jupyverse/pull/292) ([@davidbrochart](https://github.com/davidbrochart))
- Don't ignore types for fief_client [#290](https://github.com/jupyter-server/jupyverse/pull/290) ([@davidbrochart](https://github.com/davidbrochart))
- Update README [#288](https://github.com/jupyter-server/jupyverse/pull/288) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-04-06&to=2023-04-18&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-04-06..2023-04-18&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-04-06..2023-04-18&type=Issues)

## 0.1.3

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.1.2...b5faf93e3296d855c7ebeda0c25e9861400ad469))

### Merged PRs

- Add fps-lab and fps-frontend dependencies to jupyverse [#287](https://github.com/jupyter-server/jupyverse/pull/287) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-04-06&to=2023-04-06&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-04-06..2023-04-06&type=Issues)

## 0.1.2

No merged PRs

## 0.1.1

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.50...254a3dfd5f6851e2e79406fab934c8361399ffb6))

### Merged PRs

- Fix jupyverse-api -> jupyverse_api [#286](https://github.com/jupyter-server/jupyverse/pull/286) ([@davidbrochart](https://github.com/davidbrochart))
- Add jupyverse_api dependency to plugins [#285](https://github.com/jupyter-server/jupyverse/pull/285) ([@davidbrochart](https://github.com/davidbrochart))
- Update documentation, add jupyverse CLI [#283](https://github.com/jupyter-server/jupyverse/pull/283) ([@davidbrochart](https://github.com/davidbrochart))
- Update to FastAPI 0.95 [#281](https://github.com/jupyter-server/jupyverse/pull/281) ([@davidbrochart](https://github.com/davidbrochart))
- Drop FPS in favor of Asphalt [#277](https://github.com/jupyter-server/jupyverse/pull/277) ([@davidbrochart](https://github.com/davidbrochart))
- Add ruff pre-commit [#275](https://github.com/jupyter-server/jupyverse/pull/275) ([@davidbrochart](https://github.com/davidbrochart))
- Add DELETE /api/kernels/{kernel_id} (shutdown kernel) [#274](https://github.com/jupyter-server/jupyverse/pull/274) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-02-23&to=2023-04-06&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-02-23..2023-04-06&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-02-23..2023-04-06&type=Issues)

## 0.1.0

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.50...62b06f7a05b4ba536ce1ae0f40b3643dc4b4152d))

### Merged PRs

- Add jupyverse_api dependency to plugins [#285](https://github.com/jupyter-server/jupyverse/pull/285) ([@davidbrochart](https://github.com/davidbrochart))
- Update documentation, add jupyverse CLI [#283](https://github.com/jupyter-server/jupyverse/pull/283) ([@davidbrochart](https://github.com/davidbrochart))
- Update to FastAPI 0.95 [#281](https://github.com/jupyter-server/jupyverse/pull/281) ([@davidbrochart](https://github.com/davidbrochart))
- Drop FPS in favor of Asphalt [#277](https://github.com/jupyter-server/jupyverse/pull/277) ([@davidbrochart](https://github.com/davidbrochart))
- Add ruff pre-commit [#275](https://github.com/jupyter-server/jupyverse/pull/275) ([@davidbrochart](https://github.com/davidbrochart))
- Add DELETE /api/kernels/{kernel_id} (shutdown kernel) [#274](https://github.com/jupyter-server/jupyverse/pull/274) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-02-23&to=2023-04-06&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-02-23..2023-04-06&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-02-23..2023-04-06&type=Issues)

## 0.0.50

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.49...cf56682249dd5c7064d16b4a88f6f49aeb728ce1))

### Merged PRs

- Update python, jupyter-ydoc, y-py [#273](https://github.com/jupyter-server/jupyverse/pull/273) ([@davidbrochart](https://github.com/davidbrochart))
- Add support for external kernels [#265](https://github.com/jupyter-server/jupyverse/pull/265) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-01-24&to=2023-02-23&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-01-24..2023-02-23&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2023-01-24..2023-02-23&type=Issues)

## 0.0.49

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.48...c976ab4f7c7c8c416b19dc794f253ec0a2c87636))

### Merged PRs

- Revert terminals change [#266](https://github.com/jupyter-server/jupyverse/pull/266) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-01-12&to=2023-01-24&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-01-12..2023-01-24&type=Issues)

## 0.0.48

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.47...487c8557a665c78cc268c87820fab64570a6b951))

### Merged PRs

- Don't modify terminal environment [#264](https://github.com/jupyter-server/jupyverse/pull/264) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2023-01-06&to=2023-01-12&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2023-01-06..2023-01-12&type=Issues)

## 0.0.47

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.46...e39fa082add25c29ac963b1c432f5599c2666869))

### Merged PRs

- Remove duplicate favicon.ico [#263](https://github.com/jupyter-server/jupyverse/pull/263) ([@davidbrochart](https://github.com/davidbrochart))
- Pin ypy-websocket >=0.8.2 [#262](https://github.com/jupyter-server/jupyverse/pull/262) ([@davidbrochart](https://github.com/davidbrochart))
- Pass environment to terminals [#261](https://github.com/jupyter-server/jupyverse/pull/261) ([@davidbrochart](https://github.com/davidbrochart))
- Remove fps-resource-usage dependency [#257](https://github.com/jupyter-server/jupyverse/pull/257) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-12-13&to=2023-01-06&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-12-13..2023-01-06&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2022-12-13..2023-01-06&type=Issues)

## 0.0.46

No merged PRs

## 0.0.45

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.44...8652e430f192d2e6ebea712c7b38134da377e8d2))

### Merged PRs

- Update docs and project with resource_usage [#254](https://github.com/jupyter-server/jupyverse/pull/254) ([@davidbrochart](https://github.com/davidbrochart))
- Add resource_usage plugin [#253](https://github.com/jupyter-server/jupyverse/pull/253) ([@davidbrochart](https://github.com/davidbrochart))
- Lock file accesses [#252](https://github.com/jupyter-server/jupyverse/pull/252) ([@davidbrochart](https://github.com/davidbrochart))
- Fix clean room never triggered [#250](https://github.com/jupyter-server/jupyverse/pull/250) ([@Wh1isper](https://github.com/Wh1isper))
- Fix /api/me permissions parameters [#249](https://github.com/jupyter-server/jupyverse/pull/249) ([@davidbrochart](https://github.com/davidbrochart))
- Fix incomplete kernel search path [#246](https://github.com/jupyter-server/jupyverse/pull/246) ([@Wh1isper](https://github.com/Wh1isper))
- Add kernel cwd [#245](https://github.com/jupyter-server/jupyverse/pull/245) ([@davidbrochart](https://github.com/davidbrochart))
- Implement file ID service [#244](https://github.com/jupyter-server/jupyverse/pull/244) ([@davidbrochart](https://github.com/davidbrochart))
- Align path format for windows. [#243](https://github.com/jupyter-server/jupyverse/pull/243) ([@specter119](https://github.com/specter119))
- Skip test_kernel_messages on Windows [#242](https://github.com/jupyter-server/jupyverse/pull/242) ([@davidbrochart](https://github.com/davidbrochart))
- Use system prefix instead of conda prefix for kernel test [#241](https://github.com/jupyter-server/jupyverse/pull/241) ([@RobertRosca](https://github.com/RobertRosca))
- Use Hatch Environments and Scripts [#239](https://github.com/jupyter-server/jupyverse/pull/239) ([@RobertRosca](https://github.com/RobertRosca))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-09-23&to=2022-12-13&type=c))

[@blink1073](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Ablink1073+updated%3A2022-09-23..2022-12-13&type=Issues) | [@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-09-23..2022-12-13&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2022-09-23..2022-12-13&type=Issues) | [@RobertRosca](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3ARobertRosca+updated%3A2022-09-23..2022-12-13&type=Issues) | [@specter119](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Aspecter119+updated%3A2022-09-23..2022-12-13&type=Issues) | [@welcome](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Awelcome+updated%3A2022-09-23..2022-12-13&type=Issues) | [@Wh1isper](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3AWh1isper+updated%3A2022-09-23..2022-12-13&type=Issues)

## 0.0.44

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.43...ee5c523b7d110fb6ed7dc35816629fe52baa019f))

### Merged PRs

- Adds fps-noauth [#237](https://github.com/jupyter-server/jupyverse/pull/237) ([@hbcarlos](https://github.com/hbcarlos))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-09-22&to=2022-09-23&type=c))

[@hbcarlos](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Ahbcarlos+updated%3A2022-09-22..2022-09-23&type=Issues)

## 0.0.43

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.42...213cc30f642789e115c9ea0fd03e11804c68e827))

### Merged PRs

- Fix plugin pinning [#234](https://github.com/jupyter-server/jupyverse/pull/234) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-09-21&to=2022-09-22&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-09-21..2022-09-22&type=Issues)

## 0.0.42

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.41...2c1499e1b2d4b5f209174dd7445780bc610803a7))

### Merged PRs

- Create a base auth plugin to depend on instead of jupyverse [#232](https://github.com/jupyter-server/jupyverse/pull/232) ([@hbcarlos](https://github.com/hbcarlos))
- Moves the frontend generic configuration to a new plugin [#231](https://github.com/jupyter-server/jupyverse/pull/231) ([@hbcarlos](https://github.com/hbcarlos))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-09-16&to=2022-09-21&type=c))

[@hbcarlos](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Ahbcarlos+updated%3A2022-09-16..2022-09-21&type=Issues)

## 0.0.41

No merged PRs

## 0.0.40

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.38...2f4a777357a2a94346270c259ff0953c084d30c5))

### Other merged PRs

- Switch to hatch build system [#227](https://github.com/jupyter-server/jupyverse/pull/227) ([@davidbrochart](https://github.com/davidbrochart))
- Add file watcher [#225](https://github.com/jupyter-server/jupyverse/pull/225) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-09-06&to=2022-09-16&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-09-06..2022-09-16&type=Issues)

## 0.0.39

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.38...39f19ba1b0fdc0b82552a318be4f76533cb9c93a))

### Merged PRs

- Add file watcher [#225](https://github.com/jupyter-server/jupyverse/pull/225) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-09-06&to=2022-09-12&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-09-06..2022-09-12&type=Issues)

## 0.0.38

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.37...0793c799d414ae49fffd1eeaac7b7353a0e76168))

### Other merged PRs

- Pin plugins with >=0.0.37 [#223](https://github.com/jupyter-server/jupyverse/pull/223) ([@davidbrochart](https://github.com/davidbrochart))
- Move flake8 config to pyproject.toml [#222](https://github.com/jupyter-server/jupyverse/pull/222) ([@davidbrochart](https://github.com/davidbrochart))
- Make jupyverse depend on released plugins [#219](https://github.com/jupyter-server/jupyverse/pull/219) ([@davidbrochart](https://github.com/davidbrochart))
- Remove FastAPI monkey-patch [#218](https://github.com/jupyter-server/jupyverse/pull/218) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-09-01&to=2022-09-06&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-09-01..2022-09-06&type=Issues)

## 0.0.37

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.36...a0a199c29216ed1f2d52c9197b86c0dc8839dfc2))

### Merged PRs

- Add fps-auth-fief to jupyter-releaser [#216](https://github.com/jupyter-server/jupyverse/pull/216) ([@davidbrochart](https://github.com/davidbrochart))
- Fix jupyterlab and retrolab plugins name (now lower-case) [#215](https://github.com/jupyter-server/jupyverse/pull/215) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-08-31&to=2022-09-01&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-08-31..2022-09-01&type=Issues)

## 0.0.36

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.35...7577605fee6687ef74c6eba69574421dcf75781d))

### Merged PRs

- Add documentation [#213](https://github.com/jupyter-server/jupyverse/pull/213) ([@davidbrochart](https://github.com/davidbrochart))
- Open browser window with token as query parameter [#212](https://github.com/jupyter-server/jupyverse/pull/212) ([@davidbrochart](https://github.com/davidbrochart))
- Add auth_fief plugin, register auth via entry point, add WebSocket auth [#211](https://github.com/jupyter-server/jupyverse/pull/211) ([@davidbrochart](https://github.com/davidbrochart))
- Remove Podman specific `runArgs` [#208](https://github.com/jupyter-server/jupyverse/pull/208) ([@RobertRosca](https://github.com/RobertRosca))
- Add devcontainer configuration [#207](https://github.com/jupyter-server/jupyverse/pull/207) ([@RobertRosca](https://github.com/RobertRosca))
- Add authorization [#206](https://github.com/jupyter-server/jupyverse/pull/206) ([@davidbrochart](https://github.com/davidbrochart))
- [pre-commit.ci] pre-commit autoupdate [#205](https://github.com/jupyter-server/jupyverse/pull/205) ([@pre-commit-ci](https://github.com/pre-commit-ci))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-08-08&to=2022-08-31&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-08-08..2022-08-31&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2022-08-08..2022-08-31&type=Issues) | [@RobertRosca](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3ARobertRosca+updated%3A2022-08-08..2022-08-31&type=Issues) | [@welcome](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Awelcome+updated%3A2022-08-08..2022-08-31&type=Issues)

## 0.0.35

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.34...6574141ed7c0c1ab6e74ebd9a4491f712c183f02))

### Merged PRs

- Support global awareness [#202](https://github.com/jupyter-server/jupyverse/pull/202) ([@davidbrochart](https://github.com/davidbrochart))
- Disable Windows for test_rest_api [#200](https://github.com/jupyter-server/jupyverse/pull/200) ([@davidbrochart](https://github.com/davidbrochart))
- Fix GitHub workflow execution duplication [#199](https://github.com/jupyter-server/jupyverse/pull/199) ([@davidbrochart](https://github.com/davidbrochart))
- [pre-commit.ci] pre-commit autoupdate [#198](https://github.com/jupyter-server/jupyverse/pull/198) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- Update jupyter_ydoc and ypy-websocket pinning [#196](https://github.com/jupyter-server/jupyverse/pull/196) ([@davidbrochart](https://github.com/davidbrochart))
- Add POST execute cell [#191](https://github.com/jupyter-server/jupyverse/pull/191) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-07-25&to=2022-08-08&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-07-25..2022-08-08&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2022-07-25..2022-08-08&type=Issues)

## 0.0.34

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.33...d612ecaf5a96c692f9e10c53e3b5bb4db795c304))

### Merged PRs

- Pin fastapi-users >=10.1.4 [#194](https://github.com/jupyter-server/jupyverse/pull/194) ([@davidbrochart](https://github.com/davidbrochart))
- Documentation update [#193](https://github.com/jupyter-server/jupyverse/pull/193) ([@photocyte](https://github.com/photocyte))
- Store Y updates [#190](https://github.com/jupyter-server/jupyverse/pull/190) ([@davidbrochart](https://github.com/davidbrochart))
- Don't trust notebook [#188](https://github.com/jupyter-server/jupyverse/pull/188) ([@davidbrochart](https://github.com/davidbrochart))
- [pre-commit.ci] pre-commit autoupdate [#185](https://github.com/jupyter-server/jupyverse/pull/185) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- Await zmq sends [#184](https://github.com/jupyter-server/jupyverse/pull/184) ([@minrk](https://github.com/minrk))
- fix zmq Socket types [#183](https://github.com/jupyter-server/jupyverse/pull/183) ([@minrk](https://github.com/minrk))
- Increase time to receive message type warning [#182](https://github.com/jupyter-server/jupyverse/pull/182) ([@davidbrochart](https://github.com/davidbrochart))
- Load/auto-save document from the back-end using y-py [#127](https://github.com/jupyter-server/jupyverse/pull/127) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-05-17&to=2022-07-25&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-05-17..2022-07-25&type=Issues) | [@minrk](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Aminrk+updated%3A2022-05-17..2022-07-25&type=Issues) | [@photocyte](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Aphotocyte+updated%3A2022-05-17..2022-07-25&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2022-05-17..2022-07-25&type=Issues) | [@welcome](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Awelcome+updated%3A2022-05-17..2022-07-25&type=Issues)

## 0.0.33

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.32...db404f0decf2b0739613cdf17a3d925d536e7991))

### Merged PRs

- Relax timeout in tests [#180](https://github.com/jupyter-server/jupyverse/pull/180) ([@davidbrochart](https://github.com/davidbrochart))
- Update fastapi-users>=10 [#179](https://github.com/jupyter-server/jupyverse/pull/179) ([@davidbrochart](https://github.com/davidbrochart))
- [pre-commit.ci] pre-commit autoupdate [#178](https://github.com/jupyter-server/jupyverse/pull/178) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- Update install instructions for conda-forge [#177](https://github.com/jupyter-server/jupyverse/pull/177) ([@davidbrochart](https://github.com/davidbrochart))
- Run pre-commit [#176](https://github.com/jupyter-server/jupyverse/pull/176) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-03-25&to=2022-05-17&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-03-25..2022-05-17&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Apre-commit-ci+updated%3A2022-03-25..2022-05-17&type=Issues)

## 0.0.32

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.31...7cef3ccb7073e67734270e7b05e2645ace959aff))

### Merged PRs

- Include explicit package data [#173](https://github.com/jupyter-server/jupyverse/pull/173) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-03-25&to=2022-03-25&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-03-25..2022-03-25&type=Issues)

## 0.0.31

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.30...5e050741eb9bf0b36f058065edd84791f2e0a11a))

### Merged PRs

- Include static directory [#171](https://github.com/jupyter-server/jupyverse/pull/171) ([@davidbrochart](https://github.com/davidbrochart))
- Support Windows terminals [#170](https://github.com/jupyter-server/jupyverse/pull/170) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-03-22&to=2022-03-25&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-03-22..2022-03-25&type=Issues)

## 0.0.30

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.29...dd3b60678adadb77cca1f54581cde735fc91a366))

### Merged PRs

- Add license [#168](https://github.com/jupyter-server/jupyverse/pull/168) ([@davidbrochart](https://github.com/davidbrochart))
- Don't install fps-terminals on Windows [#167](https://github.com/jupyter-server/jupyverse/pull/167) ([@davidbrochart](https://github.com/davidbrochart))
- Handle symlinks [#166](https://github.com/jupyter-server/jupyverse/pull/166) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-03-21&to=2022-03-22&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-03-21..2022-03-22&type=Issues)

## 0.0.29

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.28...090205cbdaa1193f06a6d10dbea8b83ac0b46e54))

### Merged PRs

- Support python 3.7 [#163](https://github.com/jupyter-server/jupyverse/pull/163) ([@davidbrochart](https://github.com/davidbrochart))
- Support stdin channel [#160](https://github.com/jupyter-server/jupyverse/pull/160) ([@davidbrochart](https://github.com/davidbrochart))
- Fix JupyterLab dev_mode [#159](https://github.com/jupyter-server/jupyverse/pull/159) ([@davidbrochart](https://github.com/davidbrochart))
- Manually restart kernel as stop and start [#158](https://github.com/jupyter-server/jupyverse/pull/158) ([@davidbrochart](https://github.com/davidbrochart))
- Remove leftover [#155](https://github.com/jupyter-server/jupyverse/pull/155) ([@davidbrochart](https://github.com/davidbrochart))
- Protocol alignment [#154](https://github.com/jupyter-server/jupyverse/pull/154) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-01-05&to=2022-03-21&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-01-05..2022-03-21&type=Issues)

## 0.0.28

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.27...71cbcbf60156c56debdddfabcda633060a89f604))

### Enhancements made

- Add the french language pack on Binder [#74](https://github.com/jupyter-server/jupyverse/pull/74) ([@jtpio](https://github.com/jtpio))

### Other merged PRs

- Fix terminals [#152](https://github.com/jupyter-server/jupyverse/pull/152) ([@davidbrochart](https://github.com/davidbrochart))
- Fix retrolab console [#151](https://github.com/jupyter-server/jupyverse/pull/151) ([@davidbrochart](https://github.com/davidbrochart))
- Fix trailing slash redirect in translations request [#150](https://github.com/jupyter-server/jupyverse/pull/150) ([@davidbrochart](https://github.com/davidbrochart))
- Add base URL to kernelspecs file path [#149](https://github.com/jupyter-server/jupyverse/pull/149) ([@davidbrochart](https://github.com/davidbrochart))
- Fix noauth+collaborative mode [#148](https://github.com/jupyter-server/jupyverse/pull/148) ([@davidbrochart](https://github.com/davidbrochart))
- Fix binder [#147](https://github.com/jupyter-server/jupyverse/pull/147) ([@davidbrochart](https://github.com/davidbrochart))
- Fix language setting [#146](https://github.com/jupyter-server/jupyverse/pull/146) ([@davidbrochart](https://github.com/davidbrochart))
- Fix settings test [#144](https://github.com/jupyter-server/jupyverse/pull/144) ([@davidbrochart](https://github.com/davidbrochart))
- Update with fastapi-users v9 [#142](https://github.com/jupyter-server/jupyverse/pull/142) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2022-01-01&to=2022-01-05&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2022-01-01..2022-01-05&type=Issues) | [@fcollonval](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Afcollonval+updated%3A2022-01-01..2022-01-05&type=Issues) | [@jtpio](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Ajtpio+updated%3A2022-01-01..2022-01-05&type=Issues)

## 0.0.27

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.26...43f148c68605f6f47c7f2b28339382f4e920dc0c))

### Merged PRs

- Pin fastapi-users < 9 [#140](https://github.com/jupyter-server/jupyverse/pull/140) ([@davidbrochart](https://github.com/davidbrochart))
- Use anyio for file IO [#138](https://github.com/jupyter-server/jupyverse/pull/138) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2021-12-07&to=2022-01-01&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2021-12-07..2022-01-01&type=Issues)

## 0.0.26

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.25...0f2ab3e1dd6cddf6ecd8eb1a590f186df9b5552a))

### Merged PRs

- Update README [#135](https://github.com/jupyter-server/jupyverse/pull/135) ([@davidbrochart](https://github.com/davidbrochart))
- Implement rename [#134](https://github.com/jupyter-server/jupyverse/pull/134) ([@davidbrochart](https://github.com/davidbrochart))
- Implement file/folder delete [#133](https://github.com/jupyter-server/jupyverse/pull/133) ([@davidbrochart](https://github.com/davidbrochart))
- Fix opening of files and notebooks in directory [#132](https://github.com/jupyter-server/jupyverse/pull/132) ([@davidbrochart](https://github.com/davidbrochart))
- Fix file creation [#131](https://github.com/jupyter-server/jupyverse/pull/131) ([@davidbrochart](https://github.com/davidbrochart))
- Fix directory creation [#130](https://github.com/jupyter-server/jupyverse/pull/130) ([@davidbrochart](https://github.com/davidbrochart))
- Fix retro consoles [#129](https://github.com/jupyter-server/jupyverse/pull/129) ([@davidbrochart](https://github.com/davidbrochart))
- Fix retrolab extension handling [#128](https://github.com/jupyter-server/jupyverse/pull/128) ([@davidbrochart](https://github.com/davidbrochart))
- Return 404 when content not found [#126](https://github.com/jupyter-server/jupyverse/pull/126) ([@davidbrochart](https://github.com/davidbrochart))
- Pass dev_mode to JupyterLab front-end [#125](https://github.com/jupyter-server/jupyverse/pull/125) ([@davidbrochart](https://github.com/davidbrochart))
- Support JupyterLab's dev mode, improve extension system [#124](https://github.com/jupyter-server/jupyverse/pull/124) ([@davidbrochart](https://github.com/davidbrochart))
- Fix create_guest [#123](https://github.com/jupyter-server/jupyverse/pull/123) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2021-11-05&to=2021-12-07&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2021-11-05..2021-12-07&type=Issues)

## 0.0.25

No merged PRs

## 0.0.24

No merged PRs

## 0.0.23

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.22...fa401365d5e322fa6c41c66648553c820d830289))

### Merged PRs

- Update Python packages with new Jupyter Releaser [#119](https://github.com/jupyter-server/jupyverse/pull/119) ([@davidbrochart](https://github.com/davidbrochart))
- Update Python packages with new Jupyter Releaser [#118](https://github.com/jupyter-server/jupyverse/pull/118) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2021-11-05&to=2021-11-05&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2021-11-05..2021-11-05&type=Issues)

## 0.0.22

No merged PRs

## 0.0.21

No merged PRs

## 0.0.20

No merged PRs

## 0.0.19

No merged PRs

## 0.0.18

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.17...872da1507741e8be75961e8844ed9c7f92ae658d))

### Merged PRs

- Fix binary buffers [#112](https://github.com/jupyter-server/jupyverse/pull/112) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2021-11-03&to=2021-11-04&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2021-11-03..2021-11-04&type=Issues)

## 0.0.17

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.16...27c9bb97b8a71ca6f645cf2db54181340dc75b49))

### Merged PRs

- Support binary buffers [#110](https://github.com/jupyter-server/jupyverse/pull/110) ([@davidbrochart](https://github.com/davidbrochart))
- Add login plugin to Jupyter Releaser Python packages [#108](https://github.com/jupyter-server/jupyverse/pull/108) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2021-10-18&to=2021-11-03&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2021-10-18..2021-11-03&type=Issues)

## 0.0.16

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.15...b03b1423ecc31e674d2299a8bf97f6f65443ccf0))

### Merged PRs

- Login page [#75](https://github.com/jupyter-server/jupyverse/pull/75) ([@hbcarlos](https://github.com/hbcarlos))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2021-10-14&to=2021-10-18&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2021-10-14..2021-10-18&type=Issues) | [@hbcarlos](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Ahbcarlos+updated%3A2021-10-14..2021-10-18&type=Issues) | [@welcome](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Awelcome+updated%3A2021-10-14..2021-10-18&type=Issues)

## 0.0.15

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.13...e71ff9e8037e0659db8c904732dd50b9dc302fd8))

### Merged PRs

- Remove reference to my branch in check-release action [#104](https://github.com/jupyter-server/jupyverse/pull/104) ([@davidbrochart](https://github.com/davidbrochart))
- Improve server setup in tests [#98](https://github.com/jupyter-server/jupyverse/pull/98) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2021-10-11&to=2021-10-14&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2021-10-11..2021-10-14&type=Issues)

## 0.0.14

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.13...21ecbfd09cc206df8a1ba0582bcb716d71f4221d))

### Merged PRs

- Improve server setup in tests [#98](https://github.com/jupyter-server/jupyverse/pull/98) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2021-10-11&to=2021-10-14&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2021-10-11..2021-10-14&type=Issues)

## 0.0.13

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.12...8561f58f9d75d7e822646a5ac2f47af6f75befcb))

### Merged PRs

- Add aiosqlite to fps-auth dependencies [#95](https://github.com/jupyter-server/jupyverse/pull/95) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2021-10-11&to=2021-10-11&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2021-10-11..2021-10-11&type=Issues)

## 0.0.12

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/v0.0.11...c109da7a6a9b9801cfecc971893823c213d995aa))

### Merged PRs

- Fix retrolab setup.cfg [#93](https://github.com/jupyter-server/jupyverse/pull/93) ([@davidbrochart](https://github.com/davidbrochart))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2021-10-11&to=2021-10-11&type=c))

[@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2021-10-11..2021-10-11&type=Issues)

## 0.0.11

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/0.0.7...1a3dea5b7d5da42560f52cb50901c257723b78ba))

### Maintenance and upkeep improvements

- Prepare for use with Jupyter Releaser [#81](https://github.com/jupyter-server/jupyverse/pull/81) ([@davidbrochart](https://github.com/davidbrochart))

### Other merged PRs

- Skip check-manifest [#91](https://github.com/jupyter-server/jupyverse/pull/91) ([@davidbrochart](https://github.com/davidbrochart))
- Remove login plugin [#89](https://github.com/jupyter-server/jupyverse/pull/89) ([@davidbrochart](https://github.com/davidbrochart))
- Add python_packages [#87](https://github.com/jupyter-server/jupyverse/pull/87) ([@davidbrochart](https://github.com/davidbrochart))
- Support editing file [#84](https://github.com/jupyter-server/jupyverse/pull/84) ([@davidbrochart](https://github.com/davidbrochart))
- Filter out messages [#83](https://github.com/jupyter-server/jupyverse/pull/83) ([@davidbrochart](https://github.com/davidbrochart))
- Change license from MIT to BSD-3-Clause [#82](https://github.com/jupyter-server/jupyverse/pull/82) ([@davidbrochart](https://github.com/davidbrochart))
- Allow KernelServer to connect to existing kernel [#80](https://github.com/jupyter-server/jupyverse/pull/80) ([@davidbrochart](https://github.com/davidbrochart))
- Fix Binder [#79](https://github.com/jupyter-server/jupyverse/pull/79) ([@davidbrochart](https://github.com/davidbrochart))
- Create lab plugin, common to jupyterlab and retrolab [#78](https://github.com/jupyter-server/jupyverse/pull/78) ([@davidbrochart](https://github.com/davidbrochart))
- Improve Binder and launch jupyverse directly [#76](https://github.com/jupyter-server/jupyverse/pull/76) ([@davidbrochart](https://github.com/davidbrochart))
- Support RetroLab in Binder [#72](https://github.com/jupyter-server/jupyverse/pull/72) ([@davidbrochart](https://github.com/davidbrochart))
- Improve retrolab [#69](https://github.com/jupyter-server/jupyverse/pull/69) ([@davidbrochart](https://github.com/davidbrochart))
- Redirect to login page when not authorized [#68](https://github.com/jupyter-server/jupyverse/pull/68) ([@davidbrochart](https://github.com/davidbrochart))
- Use `fps_uvicorn` plugin [#67](https://github.com/jupyter-server/jupyverse/pull/67) ([@adriendelsalle](https://github.com/adriendelsalle))
- Add persistence settings test [#66](https://github.com/jupyter-server/jupyverse/pull/66) ([@davidbrochart](https://github.com/davidbrochart))
- Add settings test [#65](https://github.com/jupyter-server/jupyverse/pull/65) ([@davidbrochart](https://github.com/davidbrochart))
- Fix OpenAPI generation for NoAuthAuthentication [#64](https://github.com/jupyter-server/jupyverse/pull/64) ([@davidbrochart](https://github.com/davidbrochart))
- Rework noauth [#62](https://github.com/jupyter-server/jupyverse/pull/62) ([@davidbrochart](https://github.com/davidbrochart))
- Use get_user_db dependency [#60](https://github.com/jupyter-server/jupyverse/pull/60) ([@davidbrochart](https://github.com/davidbrochart))
- Remove unneeded dependencies [#59](https://github.com/jupyter-server/jupyverse/pull/59) ([@davidbrochart](https://github.com/davidbrochart))
- Use FastAPI-Users 8.0 [#58](https://github.com/jupyter-server/jupyverse/pull/58) ([@davidbrochart](https://github.com/davidbrochart))
- Fix some full URLs [#57](https://github.com/jupyter-server/jupyverse/pull/57) ([@davidbrochart](https://github.com/davidbrochart))
- Implement jlab translations API [#56](https://github.com/jupyter-server/jupyverse/pull/56) ([@davidbrochart](https://github.com/davidbrochart))
- Add `consoles` and `terminals` handlers for RetroLab [#54](https://github.com/jupyter-server/jupyverse/pull/54) ([@jtpio](https://github.com/jtpio))
- Replace references to adriendelsalle with jupyter-server [#52](https://github.com/jupyter-server/jupyverse/pull/52) ([@davidbrochart](https://github.com/davidbrochart))
- Replace references to davidbrochart by jupyter-server [#51](https://github.com/jupyter-server/jupyverse/pull/51) ([@davidbrochart](https://github.com/davidbrochart))
- Make clarification clearer re: experimental [#50](https://github.com/jupyter-server/jupyverse/pull/50) ([@willingc](https://github.com/willingc))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2021-09-16&to=2021-10-11&type=c))

[@adriendelsalle](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Aadriendelsalle+updated%3A2021-09-16..2021-10-11&type=Issues) | [@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2021-09-16..2021-10-11&type=Issues) | [@fcollonval](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Afcollonval+updated%3A2021-09-16..2021-10-11&type=Issues) | [@hbcarlos](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Ahbcarlos+updated%3A2021-09-16..2021-10-11&type=Issues) | [@jtpio](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Ajtpio+updated%3A2021-09-16..2021-10-11&type=Issues) | [@welcome](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Awelcome+updated%3A2021-09-16..2021-10-11&type=Issues) | [@willingc](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Awillingc+updated%3A2021-09-16..2021-10-11&type=Issues)

## 0.0.10

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/0.0.7...a6ff497a1475862353cec7d6c2645e56f1951af9))

### Maintenance and upkeep improvements

- Prepare for use with Jupyter Releaser [#81](https://github.com/jupyter-server/jupyverse/pull/81) ([@davidbrochart](https://github.com/davidbrochart))

### Other merged PRs

- Remove login plugin [#89](https://github.com/jupyter-server/jupyverse/pull/89) ([@davidbrochart](https://github.com/davidbrochart))
- Add python_packages [#87](https://github.com/jupyter-server/jupyverse/pull/87) ([@davidbrochart](https://github.com/davidbrochart))
- Support editing file [#84](https://github.com/jupyter-server/jupyverse/pull/84) ([@davidbrochart](https://github.com/davidbrochart))
- Filter out messages [#83](https://github.com/jupyter-server/jupyverse/pull/83) ([@davidbrochart](https://github.com/davidbrochart))
- Change license from MIT to BSD-3-Clause [#82](https://github.com/jupyter-server/jupyverse/pull/82) ([@davidbrochart](https://github.com/davidbrochart))
- Allow KernelServer to connect to existing kernel [#80](https://github.com/jupyter-server/jupyverse/pull/80) ([@davidbrochart](https://github.com/davidbrochart))
- Fix Binder [#79](https://github.com/jupyter-server/jupyverse/pull/79) ([@davidbrochart](https://github.com/davidbrochart))
- Create lab plugin, common to jupyterlab and retrolab [#78](https://github.com/jupyter-server/jupyverse/pull/78) ([@davidbrochart](https://github.com/davidbrochart))
- Improve Binder and launch jupyverse directly [#76](https://github.com/jupyter-server/jupyverse/pull/76) ([@davidbrochart](https://github.com/davidbrochart))
- Support RetroLab in Binder [#72](https://github.com/jupyter-server/jupyverse/pull/72) ([@davidbrochart](https://github.com/davidbrochart))
- Improve retrolab [#69](https://github.com/jupyter-server/jupyverse/pull/69) ([@davidbrochart](https://github.com/davidbrochart))
- Redirect to login page when not authorized [#68](https://github.com/jupyter-server/jupyverse/pull/68) ([@davidbrochart](https://github.com/davidbrochart))
- Use `fps_uvicorn` plugin [#67](https://github.com/jupyter-server/jupyverse/pull/67) ([@adriendelsalle](https://github.com/adriendelsalle))
- Add persistence settings test [#66](https://github.com/jupyter-server/jupyverse/pull/66) ([@davidbrochart](https://github.com/davidbrochart))
- Add settings test [#65](https://github.com/jupyter-server/jupyverse/pull/65) ([@davidbrochart](https://github.com/davidbrochart))
- Fix OpenAPI generation for NoAuthAuthentication [#64](https://github.com/jupyter-server/jupyverse/pull/64) ([@davidbrochart](https://github.com/davidbrochart))
- Rework noauth [#62](https://github.com/jupyter-server/jupyverse/pull/62) ([@davidbrochart](https://github.com/davidbrochart))
- Use get_user_db dependency [#60](https://github.com/jupyter-server/jupyverse/pull/60) ([@davidbrochart](https://github.com/davidbrochart))
- Remove unneeded dependencies [#59](https://github.com/jupyter-server/jupyverse/pull/59) ([@davidbrochart](https://github.com/davidbrochart))
- Use FastAPI-Users 8.0 [#58](https://github.com/jupyter-server/jupyverse/pull/58) ([@davidbrochart](https://github.com/davidbrochart))
- Fix some full URLs [#57](https://github.com/jupyter-server/jupyverse/pull/57) ([@davidbrochart](https://github.com/davidbrochart))
- Implement jlab translations API [#56](https://github.com/jupyter-server/jupyverse/pull/56) ([@davidbrochart](https://github.com/davidbrochart))
- Add `consoles` and `terminals` handlers for RetroLab [#54](https://github.com/jupyter-server/jupyverse/pull/54) ([@jtpio](https://github.com/jtpio))
- Replace references to adriendelsalle with jupyter-server [#52](https://github.com/jupyter-server/jupyverse/pull/52) ([@davidbrochart](https://github.com/davidbrochart))
- Replace references to davidbrochart by jupyter-server [#51](https://github.com/jupyter-server/jupyverse/pull/51) ([@davidbrochart](https://github.com/davidbrochart))
- Make clarification clearer re: experimental [#50](https://github.com/jupyter-server/jupyverse/pull/50) ([@willingc](https://github.com/willingc))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2021-09-16&to=2021-10-11&type=c))

[@adriendelsalle](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Aadriendelsalle+updated%3A2021-09-16..2021-10-11&type=Issues) | [@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2021-09-16..2021-10-11&type=Issues) | [@fcollonval](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Afcollonval+updated%3A2021-09-16..2021-10-11&type=Issues) | [@hbcarlos](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Ahbcarlos+updated%3A2021-09-16..2021-10-11&type=Issues) | [@jtpio](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Ajtpio+updated%3A2021-09-16..2021-10-11&type=Issues) | [@welcome](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Awelcome+updated%3A2021-09-16..2021-10-11&type=Issues) | [@willingc](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Awillingc+updated%3A2021-09-16..2021-10-11&type=Issues)

## 0.0.9

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/0.0.7...83dd276c6b72ef766871dc22025aa6799990e15a))

### Maintenance and upkeep improvements

- Prepare for use with Jupyter Releaser [#81](https://github.com/jupyter-server/jupyverse/pull/81) ([@davidbrochart](https://github.com/davidbrochart))

### Other merged PRs

- Add python_packages [#87](https://github.com/jupyter-server/jupyverse/pull/87) ([@davidbrochart](https://github.com/davidbrochart))
- Support editing file [#84](https://github.com/jupyter-server/jupyverse/pull/84) ([@davidbrochart](https://github.com/davidbrochart))
- Filter out messages [#83](https://github.com/jupyter-server/jupyverse/pull/83) ([@davidbrochart](https://github.com/davidbrochart))
- Change license from MIT to BSD-3-Clause [#82](https://github.com/jupyter-server/jupyverse/pull/82) ([@davidbrochart](https://github.com/davidbrochart))
- Allow KernelServer to connect to existing kernel [#80](https://github.com/jupyter-server/jupyverse/pull/80) ([@davidbrochart](https://github.com/davidbrochart))
- Fix Binder [#79](https://github.com/jupyter-server/jupyverse/pull/79) ([@davidbrochart](https://github.com/davidbrochart))
- Create lab plugin, common to jupyterlab and retrolab [#78](https://github.com/jupyter-server/jupyverse/pull/78) ([@davidbrochart](https://github.com/davidbrochart))
- Improve Binder and launch jupyverse directly [#76](https://github.com/jupyter-server/jupyverse/pull/76) ([@davidbrochart](https://github.com/davidbrochart))
- Support RetroLab in Binder [#72](https://github.com/jupyter-server/jupyverse/pull/72) ([@davidbrochart](https://github.com/davidbrochart))
- Improve retrolab [#69](https://github.com/jupyter-server/jupyverse/pull/69) ([@davidbrochart](https://github.com/davidbrochart))
- Redirect to login page when not authorized [#68](https://github.com/jupyter-server/jupyverse/pull/68) ([@davidbrochart](https://github.com/davidbrochart))
- Use `fps_uvicorn` plugin [#67](https://github.com/jupyter-server/jupyverse/pull/67) ([@adriendelsalle](https://github.com/adriendelsalle))
- Add persistence settings test [#66](https://github.com/jupyter-server/jupyverse/pull/66) ([@davidbrochart](https://github.com/davidbrochart))
- Add settings test [#65](https://github.com/jupyter-server/jupyverse/pull/65) ([@davidbrochart](https://github.com/davidbrochart))
- Fix OpenAPI generation for NoAuthAuthentication [#64](https://github.com/jupyter-server/jupyverse/pull/64) ([@davidbrochart](https://github.com/davidbrochart))
- Rework noauth [#62](https://github.com/jupyter-server/jupyverse/pull/62) ([@davidbrochart](https://github.com/davidbrochart))
- Use get_user_db dependency [#60](https://github.com/jupyter-server/jupyverse/pull/60) ([@davidbrochart](https://github.com/davidbrochart))
- Remove unneeded dependencies [#59](https://github.com/jupyter-server/jupyverse/pull/59) ([@davidbrochart](https://github.com/davidbrochart))
- Use FastAPI-Users 8.0 [#58](https://github.com/jupyter-server/jupyverse/pull/58) ([@davidbrochart](https://github.com/davidbrochart))
- Fix some full URLs [#57](https://github.com/jupyter-server/jupyverse/pull/57) ([@davidbrochart](https://github.com/davidbrochart))
- Implement jlab translations API [#56](https://github.com/jupyter-server/jupyverse/pull/56) ([@davidbrochart](https://github.com/davidbrochart))
- Add `consoles` and `terminals` handlers for RetroLab [#54](https://github.com/jupyter-server/jupyverse/pull/54) ([@jtpio](https://github.com/jtpio))
- Replace references to adriendelsalle with jupyter-server [#52](https://github.com/jupyter-server/jupyverse/pull/52) ([@davidbrochart](https://github.com/davidbrochart))
- Replace references to davidbrochart by jupyter-server [#51](https://github.com/jupyter-server/jupyverse/pull/51) ([@davidbrochart](https://github.com/davidbrochart))
- Make clarification clearer re: experimental [#50](https://github.com/jupyter-server/jupyverse/pull/50) ([@willingc](https://github.com/willingc))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2021-09-16&to=2021-10-11&type=c))

[@adriendelsalle](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Aadriendelsalle+updated%3A2021-09-16..2021-10-11&type=Issues) | [@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2021-09-16..2021-10-11&type=Issues) | [@fcollonval](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Afcollonval+updated%3A2021-09-16..2021-10-11&type=Issues) | [@hbcarlos](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Ahbcarlos+updated%3A2021-09-16..2021-10-11&type=Issues) | [@jtpio](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Ajtpio+updated%3A2021-09-16..2021-10-11&type=Issues) | [@welcome](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Awelcome+updated%3A2021-09-16..2021-10-11&type=Issues) | [@willingc](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Awillingc+updated%3A2021-09-16..2021-10-11&type=Issues)

## 0.0.8

([Full Changelog](https://github.com/jupyter-server/jupyverse/compare/0.0.7...8003fb634d36fcb9dd6bc21f861a3feb2620891a))

### Maintenance and upkeep improvements

- Prepare for use with Jupyter Releaser [#81](https://github.com/jupyter-server/jupyverse/pull/81) ([@davidbrochart](https://github.com/davidbrochart))

### Other merged PRs

- Support editing file [#84](https://github.com/jupyter-server/jupyverse/pull/84) ([@davidbrochart](https://github.com/davidbrochart))
- Filter out messages [#83](https://github.com/jupyter-server/jupyverse/pull/83) ([@davidbrochart](https://github.com/davidbrochart))
- Change license from MIT to BSD-3-Clause [#82](https://github.com/jupyter-server/jupyverse/pull/82) ([@davidbrochart](https://github.com/davidbrochart))
- Allow KernelServer to connect to existing kernel [#80](https://github.com/jupyter-server/jupyverse/pull/80) ([@davidbrochart](https://github.com/davidbrochart))
- Fix Binder [#79](https://github.com/jupyter-server/jupyverse/pull/79) ([@davidbrochart](https://github.com/davidbrochart))
- Create lab plugin, common to jupyterlab and retrolab [#78](https://github.com/jupyter-server/jupyverse/pull/78) ([@davidbrochart](https://github.com/davidbrochart))
- Improve Binder and launch jupyverse directly [#76](https://github.com/jupyter-server/jupyverse/pull/76) ([@davidbrochart](https://github.com/davidbrochart))
- Support RetroLab in Binder [#72](https://github.com/jupyter-server/jupyverse/pull/72) ([@davidbrochart](https://github.com/davidbrochart))
- Improve retrolab [#69](https://github.com/jupyter-server/jupyverse/pull/69) ([@davidbrochart](https://github.com/davidbrochart))
- Redirect to login page when not authorized [#68](https://github.com/jupyter-server/jupyverse/pull/68) ([@davidbrochart](https://github.com/davidbrochart))
- Use `fps_uvicorn` plugin [#67](https://github.com/jupyter-server/jupyverse/pull/67) ([@adriendelsalle](https://github.com/adriendelsalle))
- Add persistence settings test [#66](https://github.com/jupyter-server/jupyverse/pull/66) ([@davidbrochart](https://github.com/davidbrochart))
- Add settings test [#65](https://github.com/jupyter-server/jupyverse/pull/65) ([@davidbrochart](https://github.com/davidbrochart))
- Fix OpenAPI generation for NoAuthAuthentication [#64](https://github.com/jupyter-server/jupyverse/pull/64) ([@davidbrochart](https://github.com/davidbrochart))
- Rework noauth [#62](https://github.com/jupyter-server/jupyverse/pull/62) ([@davidbrochart](https://github.com/davidbrochart))
- Use get_user_db dependency [#60](https://github.com/jupyter-server/jupyverse/pull/60) ([@davidbrochart](https://github.com/davidbrochart))
- Remove unneeded dependencies [#59](https://github.com/jupyter-server/jupyverse/pull/59) ([@davidbrochart](https://github.com/davidbrochart))
- Use FastAPI-Users 8.0 [#58](https://github.com/jupyter-server/jupyverse/pull/58) ([@davidbrochart](https://github.com/davidbrochart))
- Fix some full URLs [#57](https://github.com/jupyter-server/jupyverse/pull/57) ([@davidbrochart](https://github.com/davidbrochart))
- Implement jlab translations API [#56](https://github.com/jupyter-server/jupyverse/pull/56) ([@davidbrochart](https://github.com/davidbrochart))
- Add `consoles` and `terminals` handlers for RetroLab [#54](https://github.com/jupyter-server/jupyverse/pull/54) ([@jtpio](https://github.com/jtpio))
- Replace references to adriendelsalle with jupyter-server [#52](https://github.com/jupyter-server/jupyverse/pull/52) ([@davidbrochart](https://github.com/davidbrochart))
- Replace references to davidbrochart by jupyter-server [#51](https://github.com/jupyter-server/jupyverse/pull/51) ([@davidbrochart](https://github.com/davidbrochart))
- Make clarification clearer re: experimental [#50](https://github.com/jupyter-server/jupyverse/pull/50) ([@willingc](https://github.com/willingc))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyverse/graphs/contributors?from=2021-09-16&to=2021-10-11&type=c))

[@adriendelsalle](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Aadriendelsalle+updated%3A2021-09-16..2021-10-11&type=Issues) | [@davidbrochart](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Adavidbrochart+updated%3A2021-09-16..2021-10-11&type=Issues) | [@fcollonval](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Afcollonval+updated%3A2021-09-16..2021-10-11&type=Issues) | [@hbcarlos](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Ahbcarlos+updated%3A2021-09-16..2021-10-11&type=Issues) | [@jtpio](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Ajtpio+updated%3A2021-09-16..2021-10-11&type=Issues) | [@welcome](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Awelcome+updated%3A2021-09-16..2021-10-11&type=Issues) | [@willingc](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyverse+involves%3Awillingc+updated%3A2021-09-16..2021-10-11&type=Issues)

## 0.0.7
