Jupyverse can be installed to run either [JupyterLab](https://jupyterlab.readthedocs.io) or [Jupyter Notebook](https://jupyter-notebook.readthedocs.io).

## With `pip`

For the JupyterLab frontend:
```bash
pip install "jupyverse[jupyterlab,auth]"
```
Or for the Jupyter Notebook frontend:
```bash
pip install "jupyverse[notebook,auth]"
```

## With `micromamba`

We recommend using `micromamba` to manage [conda-forge](https://conda-forge.org) environments
(see `micromamba`'s
[installation instructions](https://mamba.readthedocs.io/en/latest/installation.html#micromamba)).
First create an environment, here called `jupyverse`, and activate it:
```bash
micromamba create -n jupyverse
micromamba activate jupyverse
```
Then install Jupyverse and the desired plugins.

For the JupyterLab frontend:
```bash
micromamba install -c conda-forge jupyverse fps-jupyterlab fps-auth
```
Or for the Jupyter Notebook frontend:
```bash
micromamba install -c conda-forge jupyverse fps-notebook fps-auth
```

## Development install

You first need to clone the repository:
```bash
git clone https://github.com/jupyter-server/jupyverse.git
cd jupyverse
```
Jupyverse uses [Hatch](https://github.com/pypa/hatch) for project management.
Hatch can handle multiple environments in parallel, allowing for easy development
and testing of different frontends, authentication methods, and incompatible
plugins.

We recommend working in an isolated conda environment, in which hatch will manage
sub-environments:
```bash
micromamba create -n jupyverse-dev
micromamba activate jupyverse-dev
micromamba install -c conda-forge hatch
```
Entering `hatch env show` will show the available environments:
```text
                Standalone
┏━━━━━━━━━┳━━━━━━━━━┳━━━━━━━━━━┳━━━━━━━━━┓
┃ Name    ┃ Type    ┃ Features ┃ Scripts ┃
┡━━━━━━━━━╇━━━━━━━━━╇━━━━━━━━━━╇━━━━━━━━━┩
│ default │ virtual │          │         │
├─────────┼─────────┼──────────┼─────────┤
│ docs    │ virtual │ docs     │ build   │
│         │         │          │ serve   │
└─────────┴─────────┴──────────┴─────────┘
                              Matrices
┏━━━━━━┳━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━┳━━━━━━━━━━━┓
┃ Name ┃ Type    ┃ Envs                     ┃ Features ┃ Scripts   ┃
┡━━━━━━╇━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━╇━━━━━━━━━━━┩
│ dev  │ virtual │ dev.jupyterlab-noauth    │ test     │ lint      │
│      │         │ dev.jupyterlab-auth      │          │ test      │
│      │         │ dev.jupyterlab-auth_fief │          │ typecheck │
│      │         │ dev.notebook-noauth      │          │           │
│      │         │ dev.notebook-auth        │          │           │
│      │         │ dev.notebook-auth_fief   │          │           │
└──────┴─────────┴──────────────────────────┴──────────┴───────────┘
```
!!! note
    The `default` environment will install all the plugins from PyPI, **not** from
    your local repository. The `dev` environment installs all plugins in editable mode
    from your local repository. So you want to use the `dev` environment.

Currently, the `dev` environment matrix consists of all combinations of frontends
(`jupyterlab`, `notebook`) and authentication methods (`noauth`, `auth`, `auth_fief`),
which leads to six environments.

A number of scripts are available in the `dev` environments. They can be
executed using `hatch run {env}:{script}`. You can also execute anything that you would
execute in your shell. For instance, to run Jupyverse for the `jupyterlab` frontend and
without authentication, enter:
```bash
hatch run dev.jupyterlab-noauth:jupyverse
```

Tests should be executed using the `dev.jupyterlab-auth` environment:
```bash
hatch run dev.jupyterlab-auth:test
```
Sometimes it is easier to directly be in the environment, without having to prefix everything
with `hatch run {env}:`. To do so, just enter:
```bash
hatch -e dev.jupyterlab-auth shell
```
You can now directly enter shell commands, e.g. `jupyverse`.
To exit the environment, just enter `exit`.

As the plugins are all installed in editable mode, you could start an instance
of Jupyverse in each environment and see how code changes interact with plugins at
the same time.

Finally, `hatch run docs:serve` can be used to view documentation changes.

If you ever need to start from a fresh environment, you can remove them individually:
```bash
hatch env remove dev.jupyterlab-auth
```
Or globally:
```bash
hatch env prune
```
