---
title: bigtree
description: Tree Implementation and Methods for Python, integrated with list, dictionary, pandas and polars DataFrame.
hide:
  - toc
---

# 🌳 Documentation

[![pypi-python-version](https://badge.fury.io/py/bigtree.svg "pypi-python-version")](https://badge.fury.io/py/bigtree/)
[![conda-python-version](https://anaconda.org/conda-forge/bigtree/badges/version.svg "conda-python-version")](https://anaconda.org/conda-forge/bigtree)
[![documentation-status](https://readthedocs.org/projects/bigtree/badge/?version=latest "documentation-status")](https://bigtree.readthedocs.io/en/latest/?badge=latest)
[![code-coverage](https://codecov.io/github/kayjan/bigtree/branch/master/graph/badge.svg?token=O5gyTsGIiw "code-coverage")](https://codecov.io/gh/kayjan/bigtree)
[![pytest-github-workflows](https://github.com/kayjan/bigtree/actions/workflows/pytest.yml/badge.svg "pytest-github-workflows")](https://github.com/kayjan/bigtree/actions/workflows/pytest.yml)

[![python-compatibility](https://img.shields.io/pypi/pyversions/bigtree.svg "python-compatibility")](https://pypi.python.org/pypi/bigtree)
[![package-downloads](https://static.pepy.tech/badge/bigtree "package-downloads")](https://pepy.tech/project/bigtree)
[![license](https://img.shields.io/static/v1?label=license&message=MIT&color=blue "license")](#)
[![style](https://img.shields.io/static/v1?label=style&message=black&color=black "style")](#)

Tree Implementation and Methods for Python, integrated with list, dictionary, pandas and polars DataFrame.

It is pythonic, making it easy to learn and extendable to many types of workflows.

<div class="grid cards" markdown>

- :material-clock-fast:{ .lg .middle } __Set up in 2 minutes__

    ---
    Install [`bigtree`](#) and get up and running in minutes

    [:octicons-arrow-right-24: Installation](home/install.md)

- :material-map:{ .lg .middle } __Getting started__

    ---
    View demonstration on how to use [`bigtree`](#)

    [:octicons-arrow-right-24: Reference](gettingstarted/demo/tree.md)

- :material-slide:{ .lg .middle } __Playground__

    ---
    Get some hands-on with [`bigtree`](#)!

    [:octicons-arrow-right-24: Play](playground/index.md)

- :material-heart-outline:{ .lg .middle } __Support bigtree__

    ---
    Do support if you like this project!

    [:octicons-arrow-right-24: Support](https://www.buymeacoffee.com/kayjan)

</div>

-----

Related Links:

- Community: [Issues](https://github.com/kayjan/bigtree/issues) / [Discussions](https://github.com/kayjan/bigtree/discussions)
- Package: [PyPI](https://pypi.org/project/bigtree/) / [Conda](https://anaconda.org/conda-forge/bigtree)
