# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ActionsRepositoryOidcSubjectClaimCustomizationTemplateArgs', 'ActionsRepositoryOidcSubjectClaimCustomizationTemplate']

@pulumi.input_type
class ActionsRepositoryOidcSubjectClaimCustomizationTemplateArgs:
    def __init__(__self__, *,
                 repository: pulumi.Input[builtins.str],
                 use_default: pulumi.Input[builtins.bool],
                 include_claim_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ActionsRepositoryOidcSubjectClaimCustomizationTemplate resource.
        :param pulumi.Input[builtins.str] repository: The name of the repository.
        :param pulumi.Input[builtins.bool] use_default: Whether to use the default template or not. If `true`, `include_claim_keys` must not
               be set.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] include_claim_keys: A list of OpenID Connect claims.
        """
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "use_default", use_default)
        if include_claim_keys is not None:
            pulumi.set(__self__, "include_claim_keys", include_claim_keys)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[builtins.str]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> pulumi.Input[builtins.bool]:
        """
        Whether to use the default template or not. If `true`, `include_claim_keys` must not
        be set.
        """
        return pulumi.get(self, "use_default")

    @use_default.setter
    def use_default(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "use_default", value)

    @property
    @pulumi.getter(name="includeClaimKeys")
    def include_claim_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of OpenID Connect claims.
        """
        return pulumi.get(self, "include_claim_keys")

    @include_claim_keys.setter
    def include_claim_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "include_claim_keys", value)


@pulumi.input_type
class _ActionsRepositoryOidcSubjectClaimCustomizationTemplateState:
    def __init__(__self__, *,
                 include_claim_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None,
                 use_default: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ActionsRepositoryOidcSubjectClaimCustomizationTemplate resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] include_claim_keys: A list of OpenID Connect claims.
        :param pulumi.Input[builtins.str] repository: The name of the repository.
        :param pulumi.Input[builtins.bool] use_default: Whether to use the default template or not. If `true`, `include_claim_keys` must not
               be set.
        """
        if include_claim_keys is not None:
            pulumi.set(__self__, "include_claim_keys", include_claim_keys)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if use_default is not None:
            pulumi.set(__self__, "use_default", use_default)

    @property
    @pulumi.getter(name="includeClaimKeys")
    def include_claim_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of OpenID Connect claims.
        """
        return pulumi.get(self, "include_claim_keys")

    @include_claim_keys.setter
    def include_claim_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "include_claim_keys", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to use the default template or not. If `true`, `include_claim_keys` must not
        be set.
        """
        return pulumi.get(self, "use_default")

    @use_default.setter
    def use_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_default", value)


@pulumi.type_token("github:index/actionsRepositoryOidcSubjectClaimCustomizationTemplate:ActionsRepositoryOidcSubjectClaimCustomizationTemplate")
class ActionsRepositoryOidcSubjectClaimCustomizationTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 include_claim_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None,
                 use_default: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage an OpenID Connect subject claim customization template for a GitHub
        repository.

        More information on integrating GitHub with cloud providers using OpenID Connect and a list of available claims is
        available in the [Actions documentation](https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/about-security-hardening-with-openid-connect).

        The following table lists the behaviour of `use_default`:

        | `use_default` | `include_claim_keys` | Template used                                             |
        |---------------|----------------------|-----------------------------------------------------------|
        | `true`        | Unset                | GitHub's default                                          |
        | `false`       | Set                  | `include_claim_keys`                                      |
        | `false`       | Unset                | Organization's default if set, otherwise GitHub's default |

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example = github.Repository("example", name="example-repository")
        example_template = github.ActionsRepositoryOidcSubjectClaimCustomizationTemplate("example_template",
            repository=example.name,
            use_default=False,
            include_claim_keys=[
                "actor",
                "context",
                "repository_owner",
            ])
        ```

        ## Import

        This resource can be imported using the repository's name.

        ```sh
        $ pulumi import github:index/actionsRepositoryOidcSubjectClaimCustomizationTemplate:ActionsRepositoryOidcSubjectClaimCustomizationTemplate test example_repository
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] include_claim_keys: A list of OpenID Connect claims.
        :param pulumi.Input[builtins.str] repository: The name of the repository.
        :param pulumi.Input[builtins.bool] use_default: Whether to use the default template or not. If `true`, `include_claim_keys` must not
               be set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ActionsRepositoryOidcSubjectClaimCustomizationTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage an OpenID Connect subject claim customization template for a GitHub
        repository.

        More information on integrating GitHub with cloud providers using OpenID Connect and a list of available claims is
        available in the [Actions documentation](https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/about-security-hardening-with-openid-connect).

        The following table lists the behaviour of `use_default`:

        | `use_default` | `include_claim_keys` | Template used                                             |
        |---------------|----------------------|-----------------------------------------------------------|
        | `true`        | Unset                | GitHub's default                                          |
        | `false`       | Set                  | `include_claim_keys`                                      |
        | `false`       | Unset                | Organization's default if set, otherwise GitHub's default |

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example = github.Repository("example", name="example-repository")
        example_template = github.ActionsRepositoryOidcSubjectClaimCustomizationTemplate("example_template",
            repository=example.name,
            use_default=False,
            include_claim_keys=[
                "actor",
                "context",
                "repository_owner",
            ])
        ```

        ## Import

        This resource can be imported using the repository's name.

        ```sh
        $ pulumi import github:index/actionsRepositoryOidcSubjectClaimCustomizationTemplate:ActionsRepositoryOidcSubjectClaimCustomizationTemplate test example_repository
        ```

        :param str resource_name: The name of the resource.
        :param ActionsRepositoryOidcSubjectClaimCustomizationTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActionsRepositoryOidcSubjectClaimCustomizationTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 include_claim_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None,
                 use_default: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActionsRepositoryOidcSubjectClaimCustomizationTemplateArgs.__new__(ActionsRepositoryOidcSubjectClaimCustomizationTemplateArgs)

            __props__.__dict__["include_claim_keys"] = include_claim_keys
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
            if use_default is None and not opts.urn:
                raise TypeError("Missing required property 'use_default'")
            __props__.__dict__["use_default"] = use_default
        super(ActionsRepositoryOidcSubjectClaimCustomizationTemplate, __self__).__init__(
            'github:index/actionsRepositoryOidcSubjectClaimCustomizationTemplate:ActionsRepositoryOidcSubjectClaimCustomizationTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            include_claim_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            repository: Optional[pulumi.Input[builtins.str]] = None,
            use_default: Optional[pulumi.Input[builtins.bool]] = None) -> 'ActionsRepositoryOidcSubjectClaimCustomizationTemplate':
        """
        Get an existing ActionsRepositoryOidcSubjectClaimCustomizationTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] include_claim_keys: A list of OpenID Connect claims.
        :param pulumi.Input[builtins.str] repository: The name of the repository.
        :param pulumi.Input[builtins.bool] use_default: Whether to use the default template or not. If `true`, `include_claim_keys` must not
               be set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActionsRepositoryOidcSubjectClaimCustomizationTemplateState.__new__(_ActionsRepositoryOidcSubjectClaimCustomizationTemplateState)

        __props__.__dict__["include_claim_keys"] = include_claim_keys
        __props__.__dict__["repository"] = repository
        __props__.__dict__["use_default"] = use_default
        return ActionsRepositoryOidcSubjectClaimCustomizationTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="includeClaimKeys")
    def include_claim_keys(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of OpenID Connect claims.
        """
        return pulumi.get(self, "include_claim_keys")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[builtins.str]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to use the default template or not. If `true`, `include_claim_keys` must not
        be set.
        """
        return pulumi.get(self, "use_default")

