# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRepositoryBranchesResult',
    'AwaitableGetRepositoryBranchesResult',
    'get_repository_branches',
    'get_repository_branches_output',
]

@pulumi.output_type
class GetRepositoryBranchesResult:
    """
    A collection of values returned by getRepositoryBranches.
    """
    def __init__(__self__, branches=None, id=None, only_non_protected_branches=None, only_protected_branches=None, repository=None):
        if branches and not isinstance(branches, list):
            raise TypeError("Expected argument 'branches' to be a list")
        pulumi.set(__self__, "branches", branches)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if only_non_protected_branches and not isinstance(only_non_protected_branches, bool):
            raise TypeError("Expected argument 'only_non_protected_branches' to be a bool")
        pulumi.set(__self__, "only_non_protected_branches", only_non_protected_branches)
        if only_protected_branches and not isinstance(only_protected_branches, bool):
            raise TypeError("Expected argument 'only_protected_branches' to be a bool")
        pulumi.set(__self__, "only_protected_branches", only_protected_branches)
        if repository and not isinstance(repository, str):
            raise TypeError("Expected argument 'repository' to be a str")
        pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def branches(self) -> Sequence['outputs.GetRepositoryBranchesBranchResult']:
        """
        The list of this repository's branches. Each element of `branches` has the following attributes:
        """
        return pulumi.get(self, "branches")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="onlyNonProtectedBranches")
    def only_non_protected_branches(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "only_non_protected_branches")

    @property
    @pulumi.getter(name="onlyProtectedBranches")
    def only_protected_branches(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "only_protected_branches")

    @property
    @pulumi.getter
    def repository(self) -> builtins.str:
        return pulumi.get(self, "repository")


class AwaitableGetRepositoryBranchesResult(GetRepositoryBranchesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryBranchesResult(
            branches=self.branches,
            id=self.id,
            only_non_protected_branches=self.only_non_protected_branches,
            only_protected_branches=self.only_protected_branches,
            repository=self.repository)


def get_repository_branches(only_non_protected_branches: Optional[builtins.bool] = None,
                            only_protected_branches: Optional[builtins.bool] = None,
                            repository: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryBranchesResult:
    """
    Use this data source to retrieve information about branches in a repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_repository_branches(repository="example-repository")
    ```


    :param builtins.bool only_non_protected_branches: . If true, the `branches` attributes will be populated only with non protected branches. Default: `false`.
    :param builtins.bool only_protected_branches: . If true, the `branches` attributes will be populated only with protected branches. Default: `false`.
    :param builtins.str repository: Name of the repository to retrieve the branches from.
    """
    __args__ = dict()
    __args__['onlyNonProtectedBranches'] = only_non_protected_branches
    __args__['onlyProtectedBranches'] = only_protected_branches
    __args__['repository'] = repository
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('github:index/getRepositoryBranches:getRepositoryBranches', __args__, opts=opts, typ=GetRepositoryBranchesResult).value

    return AwaitableGetRepositoryBranchesResult(
        branches=pulumi.get(__ret__, 'branches'),
        id=pulumi.get(__ret__, 'id'),
        only_non_protected_branches=pulumi.get(__ret__, 'only_non_protected_branches'),
        only_protected_branches=pulumi.get(__ret__, 'only_protected_branches'),
        repository=pulumi.get(__ret__, 'repository'))
def get_repository_branches_output(only_non_protected_branches: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                   only_protected_branches: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                   repository: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryBranchesResult]:
    """
    Use this data source to retrieve information about branches in a repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_repository_branches(repository="example-repository")
    ```


    :param builtins.bool only_non_protected_branches: . If true, the `branches` attributes will be populated only with non protected branches. Default: `false`.
    :param builtins.bool only_protected_branches: . If true, the `branches` attributes will be populated only with protected branches. Default: `false`.
    :param builtins.str repository: Name of the repository to retrieve the branches from.
    """
    __args__ = dict()
    __args__['onlyNonProtectedBranches'] = only_non_protected_branches
    __args__['onlyProtectedBranches'] = only_protected_branches
    __args__['repository'] = repository
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('github:index/getRepositoryBranches:getRepositoryBranches', __args__, opts=opts, typ=GetRepositoryBranchesResult)
    return __ret__.apply(lambda __response__: GetRepositoryBranchesResult(
        branches=pulumi.get(__response__, 'branches'),
        id=pulumi.get(__response__, 'id'),
        only_non_protected_branches=pulumi.get(__response__, 'only_non_protected_branches'),
        only_protected_branches=pulumi.get(__response__, 'only_protected_branches'),
        repository=pulumi.get(__response__, 'repository')))
