# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRepositoryEnvironmentsResult',
    'AwaitableGetRepositoryEnvironmentsResult',
    'get_repository_environments',
    'get_repository_environments_output',
]

@pulumi.output_type
class GetRepositoryEnvironmentsResult:
    """
    A collection of values returned by getRepositoryEnvironments.
    """
    def __init__(__self__, environments=None, id=None, repository=None):
        if environments and not isinstance(environments, list):
            raise TypeError("Expected argument 'environments' to be a list")
        pulumi.set(__self__, "environments", environments)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if repository and not isinstance(repository, str):
            raise TypeError("Expected argument 'repository' to be a str")
        pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def environments(self) -> Sequence['outputs.GetRepositoryEnvironmentsEnvironmentResult']:
        """
        The list of this repository's environments. Each element of `environments` has the following attributes:
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def repository(self) -> builtins.str:
        return pulumi.get(self, "repository")


class AwaitableGetRepositoryEnvironmentsResult(GetRepositoryEnvironmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryEnvironmentsResult(
            environments=self.environments,
            id=self.id,
            repository=self.repository)


def get_repository_environments(repository: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryEnvironmentsResult:
    """
    Use this data source to retrieve information about environments for a repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_repository_environments(repository="example-repository")
    ```


    :param builtins.str repository: Name of the repository to retrieve the environments from.
    """
    __args__ = dict()
    __args__['repository'] = repository
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('github:index/getRepositoryEnvironments:getRepositoryEnvironments', __args__, opts=opts, typ=GetRepositoryEnvironmentsResult).value

    return AwaitableGetRepositoryEnvironmentsResult(
        environments=pulumi.get(__ret__, 'environments'),
        id=pulumi.get(__ret__, 'id'),
        repository=pulumi.get(__ret__, 'repository'))
def get_repository_environments_output(repository: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryEnvironmentsResult]:
    """
    Use this data source to retrieve information about environments for a repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_repository_environments(repository="example-repository")
    ```


    :param builtins.str repository: Name of the repository to retrieve the environments from.
    """
    __args__ = dict()
    __args__['repository'] = repository
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('github:index/getRepositoryEnvironments:getRepositoryEnvironments', __args__, opts=opts, typ=GetRepositoryEnvironmentsResult)
    return __ret__.apply(lambda __response__: GetRepositoryEnvironmentsResult(
        environments=pulumi.get(__response__, 'environments'),
        id=pulumi.get(__response__, 'id'),
        repository=pulumi.get(__response__, 'repository')))
