# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TeamMembersArgs', 'TeamMembers']

@pulumi.input_type
class TeamMembersArgs:
    def __init__(__self__, *,
                 members: pulumi.Input[Sequence[pulumi.Input['TeamMembersMemberArgs']]],
                 team_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a TeamMembers resource.
        :param pulumi.Input[Sequence[pulumi.Input['TeamMembersMemberArgs']]] members: List of team members. See Members below for details.
        :param pulumi.Input[builtins.str] team_id: The team id or the team slug
               
               > **Note** Although the team id or team slug can be used it is recommended to use the team id.  Using the team slug will cause the team members associations to the team to be destroyed and recreated if the team name is updated.
        """
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def members(self) -> pulumi.Input[Sequence[pulumi.Input['TeamMembersMemberArgs']]]:
        """
        List of team members. See Members below for details.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: pulumi.Input[Sequence[pulumi.Input['TeamMembersMemberArgs']]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Input[builtins.str]:
        """
        The team id or the team slug

        > **Note** Although the team id or team slug can be used it is recommended to use the team id.  Using the team slug will cause the team members associations to the team to be destroyed and recreated if the team name is updated.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _TeamMembersState:
    def __init__(__self__, *,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['TeamMembersMemberArgs']]]] = None,
                 team_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering TeamMembers resources.
        :param pulumi.Input[Sequence[pulumi.Input['TeamMembersMemberArgs']]] members: List of team members. See Members below for details.
        :param pulumi.Input[builtins.str] team_id: The team id or the team slug
               
               > **Note** Although the team id or team slug can be used it is recommended to use the team id.  Using the team slug will cause the team members associations to the team to be destroyed and recreated if the team name is updated.
        """
        if members is not None:
            pulumi.set(__self__, "members", members)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TeamMembersMemberArgs']]]]:
        """
        List of team members. See Members below for details.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TeamMembersMemberArgs']]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The team id or the team slug

        > **Note** Although the team id or team slug can be used it is recommended to use the team id.  Using the team slug will cause the team members associations to the team to be destroyed and recreated if the team name is updated.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "team_id", value)


@pulumi.type_token("github:index/teamMembers:TeamMembers")
class TeamMembers(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TeamMembersMemberArgs', 'TeamMembersMemberArgsDict']]]]] = None,
                 team_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        # Add a user to the organization
        membership_for_some_user = github.Membership("membership_for_some_user",
            username="SomeUser",
            role="member")
        membership_for_another_user = github.Membership("membership_for_another_user",
            username="AnotherUser",
            role="member")
        some_team = github.Team("some_team",
            name="SomeTeam",
            description="Some cool team")
        some_team_members = github.TeamMembers("some_team_members",
            team_id=some_team.id,
            members=[
                {
                    "username": "SomeUser",
                    "role": "maintainer",
                },
                {
                    "username": "AnotherUser",
                    "role": "member",
                },
            ])
        ```

        ## Import

        ~> **Note** Although the team id or team slug can be used it is recommended to use the team id.  Using the team slug will result in terraform doing conversions between the team slug and team id.  This will cause team members associations to the team to be destroyed and recreated on import.

        GitHub Team Membership can be imported using the team ID team id or team slug, e.g.

        ```sh
        $ pulumi import github:index/teamMembers:TeamMembers some_team 1234567
        ```

        ```sh
        $ pulumi import github:index/teamMembers:TeamMembers some_team Administrators
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TeamMembersMemberArgs', 'TeamMembersMemberArgsDict']]]] members: List of team members. See Members below for details.
        :param pulumi.Input[builtins.str] team_id: The team id or the team slug
               
               > **Note** Although the team id or team slug can be used it is recommended to use the team id.  Using the team slug will cause the team members associations to the team to be destroyed and recreated if the team name is updated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TeamMembersArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        # Add a user to the organization
        membership_for_some_user = github.Membership("membership_for_some_user",
            username="SomeUser",
            role="member")
        membership_for_another_user = github.Membership("membership_for_another_user",
            username="AnotherUser",
            role="member")
        some_team = github.Team("some_team",
            name="SomeTeam",
            description="Some cool team")
        some_team_members = github.TeamMembers("some_team_members",
            team_id=some_team.id,
            members=[
                {
                    "username": "SomeUser",
                    "role": "maintainer",
                },
                {
                    "username": "AnotherUser",
                    "role": "member",
                },
            ])
        ```

        ## Import

        ~> **Note** Although the team id or team slug can be used it is recommended to use the team id.  Using the team slug will result in terraform doing conversions between the team slug and team id.  This will cause team members associations to the team to be destroyed and recreated on import.

        GitHub Team Membership can be imported using the team ID team id or team slug, e.g.

        ```sh
        $ pulumi import github:index/teamMembers:TeamMembers some_team 1234567
        ```

        ```sh
        $ pulumi import github:index/teamMembers:TeamMembers some_team Administrators
        ```

        :param str resource_name: The name of the resource.
        :param TeamMembersArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TeamMembersArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TeamMembersMemberArgs', 'TeamMembersMemberArgsDict']]]]] = None,
                 team_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TeamMembersArgs.__new__(TeamMembersArgs)

            if members is None and not opts.urn:
                raise TypeError("Missing required property 'members'")
            __props__.__dict__["members"] = members
            if team_id is None and not opts.urn:
                raise TypeError("Missing required property 'team_id'")
            __props__.__dict__["team_id"] = team_id
        super(TeamMembers, __self__).__init__(
            'github:index/teamMembers:TeamMembers',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TeamMembersMemberArgs', 'TeamMembersMemberArgsDict']]]]] = None,
            team_id: Optional[pulumi.Input[builtins.str]] = None) -> 'TeamMembers':
        """
        Get an existing TeamMembers resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TeamMembersMemberArgs', 'TeamMembersMemberArgsDict']]]] members: List of team members. See Members below for details.
        :param pulumi.Input[builtins.str] team_id: The team id or the team slug
               
               > **Note** Although the team id or team slug can be used it is recommended to use the team id.  Using the team slug will cause the team members associations to the team to be destroyed and recreated if the team name is updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TeamMembersState.__new__(_TeamMembersState)

        __props__.__dict__["members"] = members
        __props__.__dict__["team_id"] = team_id
        return TeamMembers(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence['outputs.TeamMembersMember']]:
        """
        List of team members. See Members below for details.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[builtins.str]:
        """
        The team id or the team slug

        > **Note** Although the team id or team slug can be used it is recommended to use the team id.  Using the team slug will cause the team members associations to the team to be destroyed and recreated if the team name is updated.
        """
        return pulumi.get(self, "team_id")

