## 📝 Description

Clear description of the changes made in this PR.

## 🔗 Related Issues

- Closes #(issue number)
- Fixes #(issue number)
- Related to #(issue number)

## 🧪 Testing

- [ ] Unit tests added/updated
- [ ] Integration tests pass
- [ ] Manually verified on different operating systems
- [ ] Verified with different output formats

### Testing Commands

```bash
# Run tests
uv run pytest

# Check code quality
uv run ruff check --fix .
uv run ruff format .
uv run mypy .

# Test functionality manually
uv run python -m trxd --help
uv run python -m trxd /path/to/test/directory
```

## 📚 Documentation

- [ ] README updated if necessary
- [ ] Docstrings added/updated
- [ ] Code comments if necessary
- [ ] CONTRIBUTING.md updated if necessary

## 🎨 Visual Changes

If there are visual changes, include screenshots or examples:

### Before

```
# Previous output
```

### After

```
# New output
```

## 🔧 Technical Changes

### Modified Files

- `file1.py` - Description of change

- `file2.py` - Description of change

### New Dependencies

- [ ] No new dependencies added
- [ ] New dependencies added (specify which ones and why)

### Breaking Changes

- [ ] No breaking changes
- [ ] Breaking changes exist (describe which ones and how to migrate)

## 📊 Performance Impact

- [ ] No performance impact
- [ ] Improves performance (describe)
- [ ] May affect performance (describe and justify)

## 🔍 Checklist

- [ ] My code follows the project conventions
- [ ] I have performed self-review of my code
- [ ] I have commented my code, especially in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes do not generate new warnings
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing tests pass locally with my changes
- [ ] Any dependent changes have been merged and published

## 📝 Additional Notes

Any additional information that reviewers should know.

## 🎯 Type of Change

- [ ] Bug fix (change that fixes a problem)
- [ ] New feature (change that adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] Documentation (changes only in documentation)
- [ ] Refactoring (code change that neither fixes a bug nor adds functionality)
- [ ] Performance (change that improves performance)
- [ ] Test (adding tests or fixing existing tests)
- [ ] Chore (changes in build process, auxiliary tools, etc.)

## 🚀 Screenshots/Videos

If applicable, include screenshots or videos that demonstrate the changes.
