__slots__ = ['SLIM', 'SLIM_GRUM', 'WIDE', 'WIDE_GRUM']
from copy import deepcopy

class SHADE:
    FRONT = 2
    FRONT_H = 0
    SIDE = 6
    SIDE_H = 4
    TOP = 4
    TOP_H = 2


BASE = [
    # LEG LEFT
    [(20, 52, 24, 64), [( 7.9,  4.8), ( 7.9,  3.8), (10.9,  6.8), (10.9,  7.8)], SHADE.FRONT], # Front
    [( 4, 52,  8, 64), [( 7.9,  4.8), ( 7.9,  3.7), (  11,  6.8), (  11,  7.9)], SHADE.FRONT_H], # Front hat
    
    # LEG RIGHT
    [( 0, 20,  4, 32), [( 6.9,  5.8), ( 7.9,  5.8), (10.9,  8.8), ( 9.9,  8.8)], SHADE.SIDE], # Side
    [( 4, 20,  8, 32), [( 7.9,  5.8), ( 7.9,  4.8), (10.9,  7.8), (10.9,  8.8)], SHADE.FRONT], # Front
    [( 0, 36,  4, 48), [( 6.8,  5.8), ( 7.9,  5.8), (  11,  8.9), ( 9.9,  8.9)], SHADE.SIDE_H], # Side hat
    [( 4, 36,  8, 48), [( 7.9,  5.8), ( 7.9,  4.7), (  11,  7.8), (  11,  8.9)], SHADE.FRONT_H], # Front hat
    
    'ARM_LEFT',
    
    # BODY
    [(20, 20, 28, 32), [( 4.9,  2.8), ( 4.9,  0.8), ( 7.9,  3.8), ( 7.9,  5.8)], SHADE.FRONT], # Front
    
    'ARM_RIGHT',
    
    # BODY (Hat part rendered above arm)
    [(20, 36, 28, 48), [( 4.9,  2.8), ( 4.9,  0.7), (   8,  3.8), (   8,  5.9)], SHADE.FRONT_H], # Front hat
    
    # HEAD
    [( 8,  0, 16,  8), [( 1.4,  0.8), ( 1.4, -1.2), ( 3.4, -1.2), ( 3.4,  0.8)], SHADE.TOP], # Top
    [( 0,  8,  8, 16), [( 1.4,  0.8), ( 3.4,  0.8), ( 5.4,  2.8), ( 3.4,  2.8)], SHADE.SIDE], # Side
    [( 8,  8, 16, 16), [( 3.4,  0.8), ( 3.4, -1.2), ( 5.4,  0.8), ( 5.4,  2.8)], SHADE.FRONT], # Front
    [(40,  0, 48,  8), [( 1.3,  0.8), ( 1.3, -1.3), ( 3.4, -1.3), ( 3.4,  0.8)], SHADE.TOP_H], # Top hat
    [(32,  8, 40, 16), [( 1.3,  0.8), ( 3.4,  0.8), ( 5.5,  2.9), ( 3.4,  2.9)], SHADE.SIDE_H], # Side hat
    [(40,  8, 48, 16), [( 3.4,  0.8), ( 3.4, -1.3), ( 5.5,  0.8), ( 5.5,  2.9)], SHADE.FRONT_H], # Front hat
]

BASE_GRUM = [
    # HEAD
    [(16,  0, 24,  8), [( 9.15, 4.55), ( 7.15, 4.55), ( 7.15, 6.55), ( 9.15, 6.55)], SHADE.TOP], # Top
    [( 0,  8,  8, 16), [(11.15, 6.55), (11.15, 8.55), ( 9.15, 6.55), ( 9.15, 4.55)], SHADE.SIDE], # Side
    [( 8,  8, 16, 16), [(11.15, 8.55), ( 9.15, 8.55), ( 7.15, 6.55), ( 9.15, 6.55)], SHADE.FRONT], # Front
    [(48,  0, 56,  8), [( 9.15, 4.45), ( 7.05, 4.45), ( 7.05, 6.55), ( 9.15, 6.55)], SHADE.TOP_H], # Top hat
    [(32,  8, 40, 16), [(11.25, 6.55), (11.25, 8.65), ( 9.15, 6.55), ( 9.15, 4.45)], SHADE.SIDE_H], # Side hat
    [(40,  8, 48, 16), [(11.25, 8.65), ( 9.15, 8.65), ( 7.05, 6.55), ( 9.15, 6.55)], SHADE.FRONT_H], # Front hat
    
    'ARM_LEFT',
    
    # BODY
    [(20, 20, 28, 32), [(9.15, 6.05), (7.15, 6.05), (4.15, 3.05), (6.15, 3.05)], SHADE.FRONT], # Front
    
    'ARM_RIGHT',
    
    # LEG LEFT
    [(24, 48, 28, 52), [(2.15, 0.05), (1.15, 0.05), (1.15, -0.95), (2.15, -0.95)], SHADE.TOP], # Top
    [(20, 52, 24, 64), [(5.15, 3.05), (4.15, 3.05), (1.15,  0.05), (2.15,  0.05)], SHADE.FRONT], # Front
    [( 8, 48, 12, 52), [(2.15, 0.05), (1.05, 0.05), (1.05, -1.05), (2.15, -1.05)], SHADE.TOP_H], # Top hat
    [( 4, 52,  8, 64), [(5.25, 3.15), (4.15, 3.15), (1.05,  0.05), (2.15,  0.05)], SHADE.FRONT_H], # Front hat
    
    # LEG RIGHT
    [( 8, 16, 12, 20), [(3.15, 0.05), (2.15, 0.05), (2.15, -0.95), (3.15, -0.95)], SHADE.TOP], # Top
    [( 0, 20,  4, 32), [(6.15, 2.05), (6.15, 3.05), (3.15,  0.05), (3.15, -0.95)], SHADE.SIDE], # Side
    [( 4, 20,  8, 32), [(6.15, 3.05), (5.15, 3.05), (2.15,  0.05), (3.15,  0.05)], SHADE.FRONT], # Front
    [( 8, 32, 12, 36), [(3.15, 0.05), (2.05, 0.05), (2.05, -1.05), (3.15, -1.05)], SHADE.TOP_H], # Top hat
    [( 0, 36,  4, 48), [(6.25, 2.05), (6.25, 3.15), (3.15,  0.05), (3.15, -1.05)], SHADE.SIDE_H], # Side hat
    [( 4, 36,  8, 48), [(6.25, 3.15), (5.15, 3.15), (2.05,  0.05), (3.15,  0.05)], SHADE.FRONT_H], # Front hat
    
    # BODY (Hat part rendered above arm/leg)
    [(20, 36, 28, 48), [(9.25, 6.15), (7.15, 6.15), (4.05, 3.05), (6.15, 3.05)], SHADE.FRONT_H], # Front hat
]


# Not the weirdest function name I have ever thought of...
def insert_arms(replacements: dict[str, list], base: list = BASE) -> list[list[tuple, list[tuple], int]]: # Why did I do it this specific?
    """Simple function to replace ARM_LEFT and ARM_RIGHT
    with the character specific parts."""
    char = deepcopy(base)
    
    for key, parts in replacements.items():
        index = char.index(key)
        char.remove(key)
        
        for part in reversed(parts): char.insert(index, part)
    
    return char


SLIM = insert_arms({
    'ARM_LEFT': [
        [(36, 48, 39, 52), [( 3.9,  0.8), ( 3.9,  0.05), ( 4.9,  0.05), ( 4.9,  0.8)], SHADE.TOP], # Top
        [(36, 52, 39, 64), [( 4.9,  0.8), ( 4.9,  0.05), ( 7.9,  3.05), ( 7.9,  3.8)], SHADE.FRONT], # Front
        [(52, 48, 55, 52), [( 3.8,  0.8), ( 3.8, -0.05), ( 4.9, -0.05), ( 4.9,  0.8)], SHADE.TOP_H], # Top hat
        [(52, 52, 55, 64), [( 4.9,  0.8), ( 4.9, -0.05), (   8,  3.05), (   8,  3.9)], SHADE.FRONT_H], # Front hat
    ],
    'ARM_RIGHT': [
        [(44, 16, 47, 20), [( 3.9, 3.55), ( 3.9,  2.8), ( 4.9,  2.8), ( 4.9, 3.55)], SHADE.TOP], # Top
        [(40, 20, 44, 32), [( 3.9, 3.55), ( 4.9, 3.55), ( 7.9, 6.55), ( 6.9, 6.55)], SHADE.SIDE], # Side
        [(44, 20, 47, 32), [( 4.9, 3.55), ( 4.9,  2.8), ( 7.9,  5.8), ( 7.9, 6.55)], SHADE.FRONT], # Front
        [(44, 32, 47, 36), [( 3.8, 3.55), ( 3.8,  2.7), ( 4.9,  2.7), ( 4.9, 3.55)], SHADE.TOP_H], # Top hat
        [(40, 36, 44, 48), [( 3.8, 3.55), ( 4.9, 3.55), (   8, 6.65), ( 6.9, 6.65)], SHADE.SIDE_H], # Side hat
        [(44, 36, 47, 48), [( 4.9, 3.55), ( 4.9,  2.7), (   8,  5.8), (   8, 6.65)], SHADE.FRONT_H], # Front hat
    ]
})

WIDE = insert_arms({
    'ARM_LEFT': [
        [(36, 48, 40, 52), [( 3.9,  0.8), ( 3.9, -0.2), ( 4.9, -0.2), ( 4.9,  0.8)], SHADE.TOP], # Top
        [(36, 52, 40, 64), [( 4.9,  0.8), ( 4.9, -0.2), ( 7.9,  2.8), ( 7.9,  3.8)], SHADE.FRONT], # Front
        [(52, 48, 56, 52), [( 3.8,  0.8), ( 3.8, -0.3), ( 4.9, -0.3), ( 4.9,  0.8)], SHADE.TOP_H], # Top hat
        [(52, 52, 56, 64), [( 4.9,  0.8), ( 4.9, -0.3), (   8,  2.8), (   8,  3.9)], SHADE.FRONT_H], # Front hat
    ],
    'ARM_RIGHT': [
        [(44, 16, 48, 20), [( 3.9,  3.8), ( 3.9,  2.8), ( 4.9,  2.8), ( 4.9,  3.8)], SHADE.TOP], # Top
        [(40, 20, 44, 32), [( 3.9,  3.8), ( 4.9,  3.8), ( 7.9,  6.8), ( 6.9,  6.8)], SHADE.SIDE], # Side
        [(44, 20, 48, 32), [( 4.9,  3.8), ( 4.9,  2.8), ( 7.9,  5.8), ( 7.9,  6.8)], SHADE.FRONT], # Front
        [(44, 32, 48, 36), [( 3.8,  3.8), ( 3.8,  2.7), ( 4.9,  2.7), ( 4.9,  3.8)], SHADE.TOP_H], # Top hat
        [(40, 36, 44, 48), [( 3.8,  3.8), ( 4.9,  3.8), (   8,  6.9), ( 6.9,  6.9)], SHADE.SIDE_H], # Side hat
        [(44, 36, 48, 48), [( 4.9,  3.8), ( 4.9,  2.7), (   8,  5.8), (   8,  6.9)], SHADE.FRONT_H], # Front hat
    ]
})

SLIM_GRUM = insert_arms({
    'ARM_LEFT': [
        [(39, 48, 42, 52), [(4.15, 2.05), ( 3.4, 2.05), ( 3.4, 3.05), (4.15, 3.05)], SHADE.TOP], # Top
        [(36, 52, 39, 64), [(7.15, 6.05), ( 6.4, 6.05), ( 3.4, 3.05), (4.15, 3.05)], SHADE.FRONT], # Front
        [(55, 48, 58, 52), [(4.15, 1.95), ( 3.3, 1.95), ( 3.3, 3.05), (4.15, 3.05)], SHADE.TOP_H], # Top hat
        [(52, 52, 55, 64), [(7.25, 6.15), ( 6.4, 6.15), ( 3.3, 3.05), (4.15, 3.05)], SHADE.FRONT_H], # Front hat
    ],
    'ARM_RIGHT': [
        [(47, 16, 50, 20), [( 6.9, 2.05), (6.15, 2.05), (6.15, 3.05), ( 6.9, 3.05)], SHADE.TOP], # Top
        [(40, 20, 44, 32), [( 9.9, 5.05), ( 9.9, 6.05), ( 6.9, 3.05), ( 6.9, 2.05)], SHADE.SIDE], # Side
        [(44, 20, 47, 32), [( 9.9, 6.05), (9.15, 6.05), (6.15, 3.05), ( 6.9, 3.05)], SHADE.FRONT], # Front
        [(47, 32, 50, 36), [( 6.9, 1.95), (6.05, 1.95), (6.05, 3.05), ( 6.9, 3.05)], SHADE.TOP_H], # Top hat
        [(40, 36, 44, 48), [(  10, 5.05), (  10, 6.15), ( 6.9, 3.05), ( 6.9, 1.95)], SHADE.SIDE_H], # Side hat
        [(44, 36, 47, 48), [(  10, 6.15), (9.15, 6.15), (6.05, 3.05), ( 6.9, 3.05)], SHADE.FRONT_H], # Front hat
    ]
}, BASE_GRUM)

WIDE_GRUM = insert_arms({
    'ARM_LEFT': [
        [(40, 48, 44, 52), [(4.15, 2.05), (3.15, 2.05), (3.15, 3.05), (4.15, 3.05)], SHADE.TOP], # Top
        [(36, 52, 40, 64), [(7.15, 6.05), (6.15, 6.05), (3.15, 3.05), (4.15, 3.05)], SHADE.FRONT], # Front
        [(56, 48, 60, 52), [(4.15, 1.95), (3.05, 1.95), (3.05, 3.05), (4.15, 3.05)], SHADE.TOP_H], # Top hat
        [(52, 52, 56, 64), [(7.25, 6.15), (6.15, 6.15), (3.05, 3.05), (4.15, 3.05)], SHADE.FRONT_H], # Front hat
    ],
    'ARM_RIGHT': [
        [(48, 16, 52, 20), [( 7.15, 2.05), ( 6.15, 2.05), (6.15, 3.05), (7.15, 3.05)], SHADE.TOP], # Top
        [(40, 20, 44, 32), [(10.15, 5.05), (10.15, 6.05), (7.15, 3.05), (7.15, 2.05)], SHADE.SIDE], # Side
        [(44, 20, 48, 32), [(10.15, 6.05), ( 9.15, 6.05), (6.15, 3.05), (7.15, 3.05)], SHADE.FRONT], # Front
        [(48, 32, 52, 36), [( 7.15, 1.95), ( 6.05, 1.95), (6.05, 3.05), (7.15, 3.05)], SHADE.TOP_H], # Top hat
        [(40, 36, 44, 48), [(10.25, 5.05), (10.25, 6.15), (7.15, 3.05), (7.15, 1.95)], SHADE.SIDE_H], # Side hat
        [(44, 36, 48, 48), [(10.25, 6.15), ( 9.15, 6.15), (6.05, 3.05), (7.15, 3.05)], SHADE.FRONT_H], # Front hat
    ]
}, BASE_GRUM)
