# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/classes/50_DomoInstanceConfig_UserAttributes.ipynb.

# %% auto 0
__all__ = ['UserAttribute', 'UserAttributes']

# %% ../../nbs/classes/50_DomoInstanceConfig_UserAttributes.ipynb 2
from domolibrary.routes.user_attributes import (
    UserAttributes_GET_Error,
    UserAttributes_CRUD_Error,
    UserAttributes_IssuerType,
)

# %% ../../nbs/classes/50_DomoInstanceConfig_UserAttributes.ipynb 3
from dataclasses import dataclass, field

import httpx
from nbdev.showdoc import patch_to
from typing import List, Any

import domolibrary.client.DomoAuth as dmda
import domolibrary.routes.user_attributes as user_attribute_routes

import datetime as dt


# %% ../../nbs/classes/50_DomoInstanceConfig_UserAttributes.ipynb 5
@dataclass
class UserAttribute:
    """utility class that absorbs many of the domo instance configuration methods"""

    auth: dmda.DomoAuth = field(repr=False)
    id: str
    name: str
    description: str

    issuer_type: UserAttributes_IssuerType
    customer_id: str
    value_type: str

    validator: str
    validator_configuration: None

    security_voter: str
    custom: bool

    def __eq__(self, other):
        return self.id == other.id

    @classmethod
    def _from_json(cls, obj, auth):
        return cls(
            auth=auth,
            id=obj["key"],
            name=obj["title"],
            description=obj["description"],
            issuer_type=UserAttributes_IssuerType(obj["keyspace"]),
            customer_id=obj["context"],
            value_type=obj["valueType"],
            validator=obj["validator"],
            validator_configuration=obj["validatorConfiguration"],
            security_voter=obj["securityVoter"],
            custom=obj["custom"],
        )

# %% ../../nbs/classes/50_DomoInstanceConfig_UserAttributes.ipynb 6
@patch_to(UserAttribute, cls_method=True)
async def get_by_id(
    cls: UserAttribute,
    auth: dmda.DomoAuth,
    attribute_id: str,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    debug_num_stacks_to_drop=2,
    return_raw: bool = False,
):
    res = await user_attribute_routes.get_user_attribute_by_id(
        auth=auth,
        attribute_id=attribute_id,
        session=session,
        debug_api=debug_api,
        parent_class=cls.__name__,
        debug_num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if return_raw:
        return res
    return cls._from_json(obj=res.response, auth=auth)

# %% ../../nbs/classes/50_DomoInstanceConfig_UserAttributes.ipynb 9
@patch_to(UserAttribute)
async def update(
    self: UserAttribute,
    name=None,
    description=None,
    issuer_type: UserAttributes_IssuerType = None,
    data_type: str = None,
    security_voter=None,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    debug_num_stacks_to_drop=2,
):
    await user_attribute_routes.update_user_attribute(
        auth=self.auth,
        attribute_id=self.id,
        name=name,
        description=description,
        issuer_type=issuer_type,
        data_type=data_type,
        security_voter=security_voter,
        session=session,
        debug_api=debug_api,
        parent_class=self.__class__.__name__,
        debug_num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    new = await UserAttribute.get_by_id(attribute_id=self.id, auth=self.auth)

    [setattr(self, key, value) for key, value in new.__dict__.items()]

    return self

# %% ../../nbs/classes/50_DomoInstanceConfig_UserAttributes.ipynb 12
@dataclass
class UserAttributes:
    auth: dmda.DomoAuth = field(repr=False)

    attributes: List[UserAttribute] = field(default=None)

# %% ../../nbs/classes/50_DomoInstanceConfig_UserAttributes.ipynb 13
@patch_to(UserAttributes)
async def get(
    self: UserAttributes,
    
    issuer_type_ls: List[
        UserAttributes_IssuerType
    ] = None,  # use `UserAttributes_IssuerType` enum
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    debug_num_stacks_to_drop=2,
):
    auth = self.auth

    res = await user_attribute_routes.get_user_attributes(
        auth=auth,
        session=session,
        issuer_type_ls=issuer_type_ls,
        debug_api=debug_api,
        parent_class=self.__class__.__name__,
        debug_num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    self.attributes = [
        UserAttribute._from_json(obj=obj, auth=auth) for obj in res.response
    ]
    return self.attributes

# %% ../../nbs/classes/50_DomoInstanceConfig_UserAttributes.ipynb 16
@patch_to(UserAttributes)
async def create(
    self: UserAttributes,
    attribute_id: str,
    name=None,
    description=f"updated via domolibrary {dt.datetime.now().strftime('%Y-%m-%d - %H:%M')}",
    data_type: str = "ANY_VALUE",
    security_voter="FULL_VIS_ADMIN_IDP",
    issuer_type: UserAttributes_IssuerType = UserAttributes_IssuerType.CUSTOM,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    debug_num_stacks_to_drop=2,
    return_raw: bool = False,
):

    auth = self.auth
    attribute_id = user_attribute_routes.clean_attribute_id(attribute_id)

    res = await user_attribute_routes.create_user_attribute(
        auth=auth,
        session=session,
        issuer_type=issuer_type,
        name=name,
        attribute_id=attribute_id,
        description=description,
        data_type=data_type,
        security_voter=security_voter,
        debug_api=debug_api,
        parent_class=self.__class__.__name__,
        debug_num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    await self.get()

    if return_raw:
        return res

    return await UserAttribute.get_by_id(auth=auth, attribute_id=attribute_id)

# %% ../../nbs/classes/50_DomoInstanceConfig_UserAttributes.ipynb 19
@patch_to(UserAttributes)
async def upsert(
    self: UserAttributes,
    attribute_id,
    name=None,
    description=None,
    issuer_type: UserAttributes_IssuerType = None,
    data_type: str = None,
    security_voter=None,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    debug_num_stacks_to_drop=2,
    debug_prn: bool = False,
):

    auth = self.auth
    attribute_id = user_attribute_routes.clean_attribute_id(attribute_id)

    user_attribute = None

    try:
        user_attribute = await UserAttribute.get_by_id(
            attribute_id=attribute_id,
            auth=auth,
            session=session,
            debug_num_stacks_to_drop=debug_num_stacks_to_drop,
            debug_api=debug_api,
        )

        if user_attribute:
            if debug_prn:
                print(f"upserting {attribute_id} in {auth.domo_instance}")

            await user_attribute.update(
                name=name,
                description=description,
                issuer_type=issuer_type,
                data_type=data_type,
                security_voter=security_voter,
                session=session,
                debug_api=debug_api,
                debug_num_stacks_to_drop=debug_num_stacks_to_drop,
            )

        return user_attribute

    except (UserAttributes_CRUD_Error, UserAttributes_GET_Error) as e:
        if debug_prn:
            print(f"creating {attribute_id} in {auth.domo_instance}")

        return await self.create(
            attribute_id=attribute_id,
            name=name,
            description=description,
            issuer_type=issuer_type or UserAttributes_IssuerType.CUSTOM,
            data_type=data_type,
            security_voter=security_voter,
            session=session,
            debug_api=debug_api,
            debug_num_stacks_to_drop=debug_num_stacks_to_drop + 1,
        )

    finally:
        await self.get()

# %% ../../nbs/classes/50_DomoInstanceConfig_UserAttributes.ipynb 21
@patch_to(UserAttributes)
async def delete(
    self: UserAttributes,
    attribute_id: str,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    debug_num_stacks_to_drop=2,
    return_raw: bool = False,
):

    auth = self.auth

    res = await user_attribute_routes.delete_user_attribute(
        auth=auth,
        session=session,
        debug_api=debug_api,
        parent_class=self.__class__.__name__,
        debug_num_stacks_to_drop=debug_num_stacks_to_drop,
        attribute_id=attribute_id,
    )

    await self.get()

    return res
