# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/classes/50_DomoJupyter_DataSource.ipynb.

# %% ../../nbs/classes/50_DomoJupyter_DataSource.ipynb 2
from __future__ import annotations

# %% auto 0
__all__ = ['DomoJupyter_DataSource']

# %% ../../nbs/classes/50_DomoJupyter_DataSource.ipynb 3
from ..routes.jupyter import get_workspace_auth_token_params, JupyterAPI_Error, JupyterAPI_WorkspaceStarted

# %% ../../nbs/classes/50_DomoJupyter_DataSource.ipynb 4
import os
from dataclasses import dataclass, field
from typing import Any

import domolibrary.client.DomoAuth as dmda
import domolibrary.classes.DomoDataset as dmds



# %% ../../nbs/classes/50_DomoJupyter_DataSource.ipynb 9
@dataclass
class DomoJupyter_DataSource:
    dj_workspace: Any = field(repr=False)

    dataset_id: str
    alias: str

    is_exists: bool = False
    domo_dataset: dmds.DomoDataset = None

    def __eq__(self, other):
        if self.__class__.__name__ != other.__class__.__name__:
            return False
        
        return self.dataset_id == other.dataset_id
    
    def __lt__(self, other):
        if self.__class__.__name__ != other.__class__.__name__:
            return False

        return self.alias < other.alias

    async def get_dataset(self):
        try:
            self.domo_dataset = await dmds.DomoDataset.get_by_id(
                auth=self.dj_workspace.auth, dataset_id=self.dataset_id
            )
            self.is_exists = True

            return self.domo_dataset

        except dmds.DatasetNotFoundError as e:
            self.is_exists = False

    @classmethod
    async def _from_json(cls, obj, dj_workspace):

        dataset_id = obj["dataSourceId"]

        ds = cls(
            dataset_id=dataset_id,
            alias=obj["alias"],
            dj_workspace=dj_workspace,
        )

        await ds.get_dataset()
        return ds

    def to_json(self):
        return {"dataSourceId": self.dataset_id, "alias": self.alias}

    async def share_with_workspace_as_input_datasource(
        self,
        dj_workspace: Any = None,
        is_update_config: bool = True,
        debug_api: bool = False,
    ):
        dj_workspace = dj_workspace or self.dj_workspace

        await self.dj_workspace.add_config_input_datasource(
            dja_input_datasource=self,
            is_update_config=is_update_config,
            debug_api=debug_api,
        )

    async def share_with_workspace_as_output_datasource(
        self,
        dj_workspace: Any = None,
        is_update_config: bool = True,
        debug_api: bool = False,
    ):
        dj_workspace = dj_workspace or self.dj_workspace

        await self.dj_workspace.add_config_output_datasource(
            dja_datasource=self,
            is_update_config=is_update_config,
            debug_api=debug_api,
        )

    


