"""preferred response class for all API requests"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/client/99_DomoEntity.ipynb.

# %% auto 0
__all__ = ['NotImplemented', 'DomoEntity', 'DomoEntity_w_Lineage', 'DomoSubEntity', 'Entity_Relation']

# %% ../../nbs/client/99_DomoEntity.ipynb 2
from enum import Enum as DomoEnum


# %% ../../nbs/client/99_DomoEntity.ipynb 3
import domolibrary.client.DomoAuth as dmda

import abc
from dataclasses import dataclass, field

import httpx
from typing import Any

from nbdev.showdoc import patch_to


# %% ../../nbs/client/99_DomoEntity.ipynb 5
@patch_to(DomoEnum, cls_method = True)
def get(cls, value):
    
    for member in cls:
        if member.name.lower() == value.lower():
            return member
    
    return cls.default

@patch_to(DomoEnum, cls_method = True)
def _mising_(cls, value):
    for member in cls:
        if member.name.lower() == value.lower():
            return member
    
    return cls.default

# %% ../../nbs/client/99_DomoEntity.ipynb 9
class NotImplemented:
    
    @classmethod
    def _from_parent(cls, parent):
        return cls()


    async def get():
        raise NotImplementedError("This method should be implemented by subclasses.")

# %% ../../nbs/client/99_DomoEntity.ipynb 10
@dataclass
class DomoEntity(abc.ABC):
    auth: dmda.DomoAuth = field(repr=False)
    raw : dict = field(repr=False)

    id: str


    def __eq__(self, other):
        if isinstance(other, DomoEntity):
            return self.id == other.id
        
        return False
    

    @classmethod
    @abc.abstractmethod
    async def get_by_id(cls, auth: dmda.DomoAuth, entity_id: str):
        """
        Fetches an entity by its ID.
        """
        raise NotImplementedError("This method should be implemented by subclasses.")
    
    @abc.abstractmethod
    def display_url(self) -> str:
        """
        Returns the URL to display the entity in Domo.
        """
        raise NotImplementedError("This method should be implemented by subclasses.")


@dataclass
class DomoEntity_w_Lineage(DomoEntity):

    Lineage: Any = field(repr=False)

    def __post_init__(self):
        
        import domolibrary.classes.DomoLineage as dmdl
        
        self.Lineage = dmdl.DomoLineage._from_parent(auth = self.auth, 
                                                         parent = self)

    @classmethod
    @abc.abstractmethod
    async def _get_entity_by_id(cls, auth: dmda.DomoAuth, entity_id: str):
        """
        Fetches an entity by its ID.
        This method should be implemented by subclasses to fetch the specific entity type.
        """
        raise NotImplementedError("This method should be implemented by subclasses.")

# %% ../../nbs/client/99_DomoEntity.ipynb 11
@dataclass
class DomoSubEntity(abc.ABC):
    auth: dmda.DomoAuth = field(repr=False)
    parent : Any
    parent_id : str

    def __post_init__(self):
        if self.parent: 
            self.auth = self.parent.auth
            self.parent_id = self.parent.id

    @classmethod
    def _from_parent(cls, parent: DomoEntity):
        return cls(
            auth = parent.auth,
            parent = parent,
            parent_id = parent.id
        )
        
        

# %% ../../nbs/client/99_DomoEntity.ipynb 12
@dataclass
class Entity_Relation:
    auth: dmda.DomoAuth = field(repr=False)
    entity: Any
    relation_type: str

    def __eq__(self, other):
        if self.__class__.__name__ != other.__class__.__name__:
            return False

        return (
            self.entity.id == other.entity.id
            and self.relation_type == other.relation_type
        )

    @classmethod
    async def from_user_id(
        cls,
        user_id,
        relation_type: str,
        auth: dmda.DomoAuth,
        session: httpx.AsyncClient = None,
        debug_api: bool = False,
        debug_num_stacks_to_drop=2,
    ):

        # if entity_type == "USER":
        import domolibrary.classes.DomoUser as dmdu

        domo_user = await dmdu.DomoUser.get_by_id(
            user_id=user_id,
            auth=auth,
            session=session,
            debug_api=debug_api,
            debug_num_stacks_to_drop=debug_num_stacks_to_drop + 1,
        )

        return cls(entity=domo_user, relation_type=relation_type, auth=auth)

    @classmethod
    async def from_group_id(
        cls,
        group_id,
        relation_type,
        auth: dmda.DomoAuth,
        session: httpx.AsyncClient = None,
        debug_api: bool = False,
        debug_num_stacks_to_drop=2,
    ):

        import domolibrary.classes.DomoGroup as dmdg

        domo_group = await dmdg.DomoGroup.get_by_id(
            group_id=group_id,
            auth=auth,
            session=session,
            debug_api=debug_api,
            debug_num_stacks_to_drop=debug_num_stacks_to_drop + 1,
        )

        return cls(entity=domo_group, relation_type=relation_type, auth=auth)
