# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/routes/ai.ipynb.

# %% auto 0
__all__ = ['DataDictionary_ColumnsDict', 'ColumnsDict', 'generate_chat_body', 'llm_generate_text', 'OutputStyleEnum',
           'generate_summarize_body', 'llm_summarize_text', 'get_dataset_ai_readiness', 'create_dataset_ai_readiness',
           'update_dataset_ai_readiness']

# %% ../../nbs/routes/ai.ipynb 1
import httpx
from domolibrary.client.DomoEntity import DomoEnum
from typing import List, TypedDict

import domolibrary.client.get_data as gd
import domolibrary.client.ResponseGetData as rgd
import domolibrary.client.DomoAuth as dmda
import domolibrary.client.DomoError as dmde

# %% ../../nbs/routes/ai.ipynb 4
def generate_chat_body(
    text_input: str, model="domo.domo_ai.domogpt-chat-medium-v1.1:anthropic"
):

    return {
        "input": text_input,
        "promptTemplate": {"template": "${input}"},
        "model": model,
    }

@gd.route_function
async def llm_generate_text(
    text_input,
    auth: dmda.DomoAuth,
    chat_body: dict = None,
    debug_api: bool = False,
    parent_class: str = None,
    debug_num_stacks_to_drop=1,
    return_raw: bool = False,
    session : httpx.AsyncClient = None
) -> rgd.ResponseGetData:

    url = f"https://{auth.domo_instance}.domo.com/api/ai/v1/text/generation"

    body = chat_body or generate_chat_body(text_input=text_input)

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="POST",
        body=body,
        debug_api=debug_api,
        num_stacks_to_drop = debug_num_stacks_to_drop,
        parent_class = parent_class,
        session = session
    )

    if return_raw:
        return res

    if not res.is_success:
        raise dmde.RouteError(res = res)

    res.response["output"] = res.response["choices"][0]["output"]

    return res

# %% ../../nbs/routes/ai.ipynb 7
class OutputStyleEnum(DomoEnum):
    BULLETED = "BULLETED"
    NUMBERED = "Numbered"
    PARAGRAPH = "PARAGRAPH"


def generate_summarize_body(
    text_input: str,
    summary_length: int = 100,
    output_style: str = "BULLETED",
    system_prompt: str = "You are a helpful assistant that writes concise summaries",
    model="domo.domo_ai.domogpt-summarize-v1:anthropic",
):
    text_input = text_input if isinstance(text_input, str) else json.dumps(text_input)

    return {
        "input": text_input,
        "system": system_prompt,
        "promptTemplate": {
            "template": f"Write a {summary_length} summary of the following text. With {output_style} output.  Do not include a preamble. \nTEXT_TO_SUMMARIZE: {text_input} \nCONCISE SUMMARY:",
        },
        "model": model,
        "outputStyle": output_style,
        "outputWordLength": {"max": summary_length},
    }


@gd.route_function
async def llm_summarize_text(
    text_input: str,
    auth: dmda.DomoAuth,
    system_prompt: str = None,
    summary_length: int = 100,
    output_style: OutputStyleEnum = OutputStyleEnum.BULLETED,
    summary_body: dict = None,
    return_raw: bool = False,
    debug_api: bool = False,
    debug_num_stacks_to_drop=1,
    session: httpx.AsyncClient = None,
    parent_class: str = None 
):
    output_style = (
        output_style.value
        if isinstance(output_style, OutputStyleEnum)
        else output_style
    )

    url = f"https://{auth.domo_instance}.domo.com/api/ai/v1/text/summarize"

    body = summary_body or generate_summarize_body(
        text_input=text_input,
        system_prompt=system_prompt,
        output_style=output_style,
        summary_length=summary_length,
    )

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="POST",
        body=body,
        debug_api=debug_api,
        session=session,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class = parent_class,
    )

    if return_raw:
        return res

    if not res.is_success:
        raise dmde.RouteError(res = res)

    res.response["ouptput"] = res.response["choices"][0]["output"]

    return res

# %% ../../nbs/routes/ai.ipynb 10
@gd.route_function
async def get_dataset_ai_readiness(
    auth: dmda.DomoAuth,
    dataset_id: str,
    debug_api: bool = False,
    debug_num_stacks_to_drop=1,
    session: httpx.AsyncClient = None,
    parent_class: str = None 
):

    url = f'https://{auth.domo_instance}.domo.com/api/ai/readiness/v1/data-dictionary/dataset/{dataset_id}'

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        debug_api=debug_api,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        session=session,
        parent_class = parent_class
    )

    if not res.is_success:
        raise dmde.RouteError(res = res)
    
    return res

# %% ../../nbs/routes/ai.ipynb 12
DataDictionary_ColumnsDict = TypedDict('ColumnsDict', {
    "name": str,
    "description": str,
    "synonyms": List[str],
    "subType": str,
    "agentEnabled": bool,
    "beastmodeId": str
})

@gd.route_function
async def create_dataset_ai_readiness(
    auth: dmda.DomoAuth,
    dataset_id: str,
    dictionary_name: str,
    description : str = None,
    columns: List[DataDictionary_ColumnsDict] = None,
    debug_api: bool = False,
    debug_num_stacks_to_drop=1,
    session: httpx.AsyncClient = None,
    parent_class: str = None 
):
    body = {
        "datasetId": dataset_id,
        "name": dictionary_name,
        "description": description,
        "unitOfAnalysis": "",
        "columns":columns or []
    }

    url = f'https://{auth.domo_instance}.domo.com/api/ai/readiness/v1/data-dictionary/dataset/{dataset_id}'

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="POST",
        body = body,
        debug_api=debug_api,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        session=session,
        parent_class = parent_class
    )

    if not res.is_success:
        raise dmde.RouteError(res = res)
    
    return res


ColumnsDict = TypedDict('ColumnsDict', {
    "name": str,
    "description": str,
    "synonyms": List[str],
    "subType": str,
    "agentEnabled": bool,
    "beastmodeId": str
})

@gd.route_function
async def update_dataset_ai_readiness(
    auth: dmda.DomoAuth,
    dataset_id: str,
    dictionary_id: str = None,
    dictionary_name: str = None,
    columns: List[ColumnsDict] = None,
    description : str = None,
    body = None,
    debug_api: bool = False,
    debug_num_stacks_to_drop=1,
    session: httpx.AsyncClient = None,
    parent_class: str = None 
):
    body = body or {
        "id": dictionary_id,
        "name": dictionary_name,
        "description": description,
        "columns":columns
    }

    body.update({"datasetId": dataset_id})

    url = f'https://{auth.domo_instance}.domo.com/api/ai/readiness/v1/data-dictionary/dataset/{dataset_id}'

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="PUT",
        body = body,
        debug_api=debug_api,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        session=session,
        parent_class = parent_class
    )

    if not res.is_success:
        raise dmde.RouteError(res = res)
    
    return res
