# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/routes/bootstrap.ipynb.

# %% auto 0
__all__ = ['Bootstrap_RetrievalError', 'get_bootstrap', 'get_bootstrap_customerid', 'get_bootstrap_features',
           'get_bootstrap_features_is_accountsv2_enabled', 'get_bootstrap_pages']

# %% ../../nbs/routes/bootstrap.ipynb 3
import httpx

import domolibrary.client.DomoError as dmde
import domolibrary.client.get_data as gd
import domolibrary.client.ResponseGetData as rgd
import domolibrary.client.DomoAuth as dmda

# %% ../../nbs/routes/bootstrap.ipynb 4
from ..client.DomoAuth import InvalidAuthTypeError

# %% ../../nbs/routes/bootstrap.ipynb 7
class Bootstrap_RetrievalError(dmde.RouteError):
    def __init__(self, res, response: str = None):
        super().__init__(res=res, message=response)

# %% ../../nbs/routes/bootstrap.ipynb 9
@gd.route_function
async def get_bootstrap(
    auth: dmda.DomoFullAuth,  ## only works with DomoFullAuth authentication, do not use TokenAuth
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    parent_class=None,
    debug_num_stacks_to_drop=1,
) -> rgd.ResponseGetData:
    """get bootstrap data"""

    dmda.test_is_full_auth(auth, num_stacks_to_drop=2)

    # url = f"https://{auth.domo_instance}.domo.com/api/domoweb/bootstrap?v2Navigation=false"
    url = (
        f"https://{auth.domo_instance}.domo.com/api/domoweb/bootstrap?v2Navigation=true"
    )

    res = await gd.get_data(
        url=url,
        method="GET",
        auth=auth,
        debug_api=debug_api,
        session=session,
        is_follow_redirects=True,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
    )

    if not res.is_success:
        raise Bootstrap_RetrievalError(
            res = res
        )

    if res.response == "":
        raise Bootstrap_RetrievalError(
            response="BSR_Features:  no features returned - is there a VPN?",
            res = res
        )

    return res

# %% ../../nbs/routes/bootstrap.ipynb 14
@gd.route_function
async def get_bootstrap_customerid(
    auth: dmda.DomoFullAuth,  # this function requires the DomoFullAuth object to authenticate the bootstrap
    session: httpx.AsyncClient = None,  # optional parameter to improve same instance query performance
    debug_api: bool = False,  # pass True to see the parameters sent to the Domo API
    return_raw: bool = False,  # pass True to return the raw API response
    debug_num_stacks_to_drop=2,  # number frames to drop off the stacktrace.  retrieved from `res.traceback_details`
    parent_class: str = None,  # Optional parent class that calls the route function
) -> (
    rgd.ResponseGetData
):  # the response contains the string representation of the customer_id
    """retrieves the domo_instance customer id"""

    res = await get_bootstrap(
        auth=auth,
        session=session,
        debug_api=debug_api,
        debug_num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
    )

    if return_raw:
        return res

    res.response = res.response.get("currentUser").get("USER_GROUP")
    return res

# %% ../../nbs/routes/bootstrap.ipynb 19
@gd.route_function
async def get_bootstrap_features(
    auth: dmda.DomoFullAuth,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    return_raw: bool = False,
    debug_num_stacks_to_drop=2,
    parent_class=None,
) -> rgd.ResponseGetData:

    res = await get_bootstrap(
        auth=auth,
        session=session,
        debug_api=debug_api,
        debug_num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
    )

    if return_raw:
        return res

    res.response = res.response.get("data").get("features")
    return res

# %% ../../nbs/routes/bootstrap.ipynb 23
@gd.route_function
async def get_bootstrap_features_is_accountsv2_enabled(
    auth: dmda.DomoAuth,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    return_raw: bool = False,
    debug_num_stacks_to_drop=2,
    parent_class=None,
) -> rgd.ResponseGetData:

    res = await get_bootstrap_features(
        auth=auth,
        session=session,
        debug_api=debug_api,
        debug_num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
        return_raw=False,
    )

    if return_raw:
        return res

    match_accounts_v2 = next(
        (
            domo_feature
            for domo_feature in res.response
            if domo_feature.get("name") == "accounts-v2"
        ),
        None,
    )

    res.response = True if match_accounts_v2 else False
    return res

# %% ../../nbs/routes/bootstrap.ipynb 27
@gd.route_function
async def get_bootstrap_pages(
    auth: dmda.DomoFullAuth,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    return_raw: bool = False,
    debug_num_stacks_to_drop=2,
    parent_class=None,
) -> rgd.ResponseGetData:
    """this API will return the downstream (children) hierarchy of a page"""
    res = await get_bootstrap(
        auth=auth,
        session=session,
        debug_api=debug_api,
        debug_num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
    )

    if return_raw:
        return res

    res.response = res.response.get("data").get("pages")
    return res
