# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/routes/codeengine_GET.ipynb.

# %% auto 0
__all__ = ['CodeEngine_API_Error', 'get_packages', 'CodeEngine_Package_Parts', 'CodeEngine_FunctionCallError',
           'get_codeengine_package_by_id', 'get_package_versions', 'get_codeengine_package_by_id_and_version']

# %% ../../nbs/routes/codeengine_GET.ipynb 2
import httpx

from domolibrary.client.DomoEntity import DomoEnum

import domolibrary.client.get_data as gd
import domolibrary.client.DomoError as dmde
import domolibrary.client.ResponseGetData as rgd
import domolibrary.client.DomoAuth as dmda



# %% ../../nbs/routes/codeengine_GET.ipynb 5
class CodeEngine_API_Error(dmde.RouteError):
    def __init__(self, res : rgd.ResponseGetData ):
        super().__init__(res = res)

@gd.route_function
async def get_packages(
    auth: dmda.DomoAuth,
    debug_api: bool = False,
    debug_num_stacks_to_drop=1,
    session: httpx.AsyncClient = None,
    parent_class: str = None,
):
    url = f"http://{auth.domo_instance}.domo.com/api/codeengine/v2/packages"

    res = await gd.get_data(
        url=url,
        auth=auth,
        method="get",
        debug_api=debug_api,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        session=session,
        parent_class=parent_class,
        is_follow_redirects=True
    )

    if not res.is_success:
        raise CodeEngine_API_Error(res = res)

    return res

# %% ../../nbs/routes/codeengine_GET.ipynb 7
class CodeEngine_Package_Parts(DomoEnum):
    VERSIONS = 'versions'
    FUNCTIONS = 'functions'
    CODE = 'code'

    

# %% ../../nbs/routes/codeengine_GET.ipynb 8
class CodeEngine_FunctionCallError(dmde.DomoError):
    def __init__(self, message: str, auth: dmda.DomoAuth):
        super().__init__(message=message, domo_instance=auth.domo_instance)

@gd.route_function
async def get_codeengine_package_by_id(
    package_id,
    auth: dmda.DomoAuth,
    debug_api: bool = False,
    params: dict = None,
    session: httpx.AsyncClient = None,
    parent_class: str = None,
    debug_num_stacks_to_drop=1,
) -> rgd.ResponseGetData:
    url = (
        f"https://{auth.domo_instance}.domo.com/api/codeengine/v2/packages/{package_id}"
    )

    if not package_id:
        raise CodeEngine_FunctionCallError(
            message="Package ID must be provided.",
            auth=auth,
        )
    
    params = params or {"parts": "versions"}

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        debug_api=debug_api,
        params=params,
        session=session,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise CodeEngine_API_Error(res=res)

    return res

# %% ../../nbs/routes/codeengine_GET.ipynb 10
@gd.route_function
async def get_package_versions(
    auth: dmda.DomoAuth,
    package_id,
    debug_api: bool = False,
    parent_class: str = None,
    debug_num_stacks_to_drop=1,
    session : httpx.AsyncClient = None
):
    """each package can have one or many version"""

    if not package_id:
        raise CodeEngine_FunctionCallError(
            message="Package ID must be provided.",
            auth=auth,
        )

    url = f"https://{auth.domo_instance}.domo.com/api/codeengine/v2/packages/{package_id}/versions/"

    params = {"parts": "functions,code"}

    res = await gd.get_data(
        url = url,
        method ="get",
        auth=auth,
        params=params,
        debug_api=debug_api,
        num_stacks_to_drop = debug_num_stacks_to_drop,
        parent_class = parent_class,
        session = session
    )

    if not res.is_success:
        raise CodeEngine_API_Error(res = res)
    
    return res

# %% ../../nbs/routes/codeengine_GET.ipynb 12
@gd.route_function
async def get_codeengine_package_by_id_and_version(
    package_id,
    version,
    auth: dmda.DomoAuth,
    debug_api: bool = False,
    params: dict = None,
    session: httpx.AsyncClient = None,
    parent_class: str = None,
    debug_num_stacks_to_drop=1,
) -> rgd.ResponseGetData:
    
    if not package_id or not version:
        raise CodeEngine_FunctionCallError(
            message= f"Package ID {package_id or 'not provided '} and version {version or ' not provided  '} must be provided.",
            auth=auth,
        )
    
    url = f"https://{auth.domo_instance}.domo.com/api/codeengine/v2/packages/{package_id}/versions/{version}"

    params = params or {"parts": "functions,code"}

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        debug_api=debug_api,
        params=params,
        session=session,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise CodeEngine_API_Error(res=res)
    
    return res
