# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/routes/filesets.ipynb.

# %% auto 0
__all__ = ['EmbedData_Type', 'create_filesets_index', 'embed_image', 'get_fileset_by_id', 'search_fileset_files',
           'get_data_file_by_id']

# %% ../../nbs/routes/filesets.ipynb 1
import domolibrary.client.get_data as gd
import domolibrary.client.DomoError as dmde
import domolibrary.client.DomoAuth as dmda
import domolibrary.client.ResponseGetData as rgd
from typing import Optional, Literal, get_args

import httpx

# %% ../../nbs/routes/filesets.ipynb 5
@gd.route_function
async def create_filesets_index(
    auth: dmda.DomoAuth,
    index_id,
    embedding_model: str = "domo.domo_ai.domo-embed-text-multilingual-v1:cohere",
    debug_api: bool = False,
    debug_num_stacks_to_drop: int = 1,
    session: httpx.AsyncClient = None,
    parent_class: str = None,
):
    """Creates a new vectorDB index."""

    url = f"{auth.domo_instance}.domo.com/api/recall/v1/indexes"

    payload = {
        "indexId": index_id,
        "embeddingModel": embedding_model,
    }
    res = await gd.get_data(
        url,
        method="POST",
        body=payload,
        auth=auth,
        session=session,
        debug_api=debug_api,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
    )

    if not res.is_success:
        raise dmde.RouteError(res=res)

    return res

# %% ../../nbs/routes/filesets.ipynb 6
EmbedData_Type = Literal["base64"]
    
@gd.route_function
async def embed_image(
    auth: dmda.DomoAuth,
    body : dict = None,
    image_data: str = None,
    media_type: str=None,
    data_type : EmbedData_Type = "base64",
    model: str = "domo.domo_ai",
    debug_api: bool = False,
    debug_num_stacks_to_drop: int = 1,
    parent_class: str = None,
    session: Optional[httpx.AsyncClient] = None,
) -> rgd.ResponseGetData:
    """
    Create an embedding for a base64 encoded image using Domo's AI services.
    """
    # Utility function is_valid_base64_image should be called by the orchestrator before this.
    # This route function assumes valid base64 data.

    api_url = f"https://{auth.domo_instance}.domo.com/api/ai/v1/embedding/image"
    
    body = body or{
        "input": [
            {"type": "", "mediaType": "", "data": ""}
        ],
        "model": "",
    }
    if image_data:
        body['input'][0].update({"data": image_data})

    if media_type:
        body['input'][0].update({"mediaType": media_type})
    
    if data_type:
        body['input'][0].update({"type": data_type})
    
    if model:
        body.update({'model': model})

    res = await gd.get_data(
        auth=auth,
        url=api_url,
        method="POST",
        body=body,
        debug_api=debug_api,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        session=session,
        parent_class=parent_class,
    )
    if not res.is_success:
        raise dmde.RouteError(res=res)
    
    return res


# %% ../../nbs/routes/filesets.ipynb 10
@gd.route_function
async def get_fileset_by_id(
    auth: dmda.DomoAuth,
    fileset_id: str,
    debug_api: bool = False,
    debug_num_stacks_to_drop=1,
    parent_class: str = None,
    session: httpx.AsyncClient = None,
):
    url = f"https://{auth.domo_instance}.domo.com/api/files/v1/filesets/{fileset_id}"
    res = await gd.get_data(
        auth=auth,
        method="GET",
        url=url,
        debug_api=debug_api,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
        session=session,
    )

    if not res.is_success:
        raise dmde.RouteError(res=res, debug_api=debug_api)

    return res

# %% ../../nbs/routes/filesets.ipynb 13
@gd.route_function
async def search_fileset_files(
    auth: dmda.DomoAuth,
    domo_fileset_id: str,
    body: dict = None,
    debug_api: bool = False,
    debug_num_stacks_to_drop=1,
    parent_class: str = None,
    session: httpx.AsyncClient = None,
):
    url = f"https://{auth.domo_instance}.domo.com/api/files/v1/filesets/{domo_fileset_id}/files/search?directoryPath=&immediateChildren=true"

    if not body:
        # default body will pull all files within the given fileset_id
        body = {
            "fieldSort": [{"field": "created", "order": "DESC"}],
            "filters": [],
            "dateFilters": [],
        }

    res = await gd.get_data(
        auth=auth,
        method="POST",
        url=url,
        body=body,
        debug_api=debug_api,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
        session=session,
    )
    if not res.is_success:
        raise dmde.RouteError(res=res)

    return res

# %% ../../nbs/routes/filesets.ipynb 15
@gd.route_function
async def get_data_file_by_id(
    auth: dmda.DomoAuth,
    file_id: str,
    debug_api: bool = False,
    debug_num_stacks_to_drop: int = 1,
    parent_class: str = None,
    session: Optional[httpx.AsyncClient] = None,
) -> rgd.ResponseGetData:
    """
    Retrieves the content of a data file from Domo.
    """
    url = f"https://{auth.domo_instance}.domo.com/data/v1/data-files/{file_id}"
    res = gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        debug_api=debug_api,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        session=session,
        parent_class=parent_class,
    )
    if not res.is_success:
        raise dmde.RouteError(res=res)
    return res
