# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/routes/grant.ipynb.

# %% auto 0
__all__ = ['GetGrants_Error', 'get_grants']

# %% ../../nbs/routes/grant.ipynb 3
import httpx

import domolibrary.client.get_data as gd
import domolibrary.client.ResponseGetData as rgd
import domolibrary.client.DomoAuth as dmda
import domolibrary.client.DomoError as de

# %% ../../nbs/routes/grant.ipynb 4
class GetGrants_Error(de.RouteError):
    def __init__(self, **kwargs):
        super().__init__(
            **kwargs
        )

# %% ../../nbs/routes/grant.ipynb 6
async def get_grants(
    auth: dmda.DomoAuth, debug_api: bool = False, session: httpx.AsyncClient = None
) -> rgd.ResponseGetData:

    url = f"https://{auth.domo_instance}.domo.com/api/authorization/v1/authorities"

    res = await gd.get_data(
        auth=auth, url=url, method="GET", debug_api=debug_api, session=session
    )

    if not res.is_success:
        raise GetGrants_Error(
            res = res
        )

    if len(res.response) == 0:
        raise GetGrants_Error(
            res = res,
            message=f"{len(res.response)} grants returned",
        )

    return res
