# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/routes/instance_config_instance_switcher.ipynb.

# %% auto 0
__all__ = ['InstanceSwitcherMapping_GET_Error', 'get_instance_switcher_mapping', 'InstanceSwitcherMapping_CRUD_Error',
           'set_instance_switcher_mapping']

# %% ../../nbs/routes/instance_config_instance_switcher.ipynb 2
import httpx

from typing import List

import domolibrary.client.get_data as gd
import domolibrary.client.ResponseGetData as rgd
import domolibrary.client.DomoAuth as dmda
import domolibrary.client.DomoError as de


# %% ../../nbs/routes/instance_config_instance_switcher.ipynb 6
class InstanceSwitcherMapping_GET_Error(de.RouteError):
    def __init__(
        self,
        res: rgd.ResponseGetData,
        message=None,
    ):

        super().__init__(
            res=res,
            message=message or res.response,
        )


# gets existing instance switcher mapping, response = list[dict]
@gd.route_function
async def get_instance_switcher_mapping(
    auth: dmda.DomoAuth,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    parent_class: str = None,
    debug_num_stacks_to_drop: int = 1,
    timeout: int = 20
) -> rgd.ResponseGetData:

    url = f"https://{auth.domo_instance}.domo.com/api/content/v1/everywhere/admin/userattributeinstances"

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        debug_api=debug_api,
        session=session,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        timeout=timeout
    )

    if not res.is_success:
        raise InstanceSwitcherMapping_GET_Error(
            res=res,
            message= f"failed to retrieve instance switcher mapping - {res.response}",
        )

    return res

# %% ../../nbs/routes/instance_config_instance_switcher.ipynb 9
class InstanceSwitcherMapping_CRUD_Error(de.RouteError):
    def __init__(
        self,
        res,
        message=None,
    ):
        super().__init__(
            res=res,
            message=message or res.response,
        )


# update the instance switcher mappings
@gd.route_function
async def set_instance_switcher_mapping(
    auth: dmda.DomoAuth,
    mapping_payloads: List[dict],
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    parent_class: str = None,
    debug_num_stacks_to_drop: int = 1,
    timeout: int = 60
) -> rgd.ResponseGetData:
    """
    accepts a list of instance_switcher_mappings format:
    mapping_payloads = [ {'userAttribute': 'test1','instance': 'test.domo.com'}]

    """

    url = f"https://{auth.domo_instance}.domo.com/api/content/v1/everywhere/admin/userattributeinstances"

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="POST",
        debug_api=debug_api,
        session=session,
        body=mapping_payloads,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        timeout=timeout
    )

    if not res.is_success:
        raise InstanceSwitcherMapping_CRUD_Error(
            res=res,
            message=f"failed to update instance switcher mappings - {res.response}",
        )

    res.response = f"success: updated instance switcher mappings"
    return res
