# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/routes/workflows.ipynb.

# %% auto 0
__all__ = ['get_workflow', 'generate_trigger_workflow_body', 'trigger_workflow', 'get_workflow_trigger_history',
           'get_workflow_executions']

# %% ../../nbs/routes/workflows.ipynb 1
import domolibrary.client.get_data as gd
import domolibrary.client.DomoError as dmde
import domolibrary.client.DomoAuth as dmda
import httpx

# %% ../../nbs/routes/workflows.ipynb 5
@gd.route_function
async def get_workflow(
    auth: dmda.DomoAuth,
    model_id: str,
    version_id: str,
    debug_api: bool = False,
    debug_num_stacks_to_drop=1,
    parent_class: str = None,
    session: httpx.AsyncClient = None,
):

    url = f"https://{auth.domo_instance}.domo.com/api/workflow/v1/models/{model_id}/versions/{version_id}"
    res = await gd.get_data(
        auth=auth,
        method="GET",
        url=url,
        debug_api=debug_api,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
        session=session,
    )

    if not res.is_success:
        raise dmde.RouteError(res=res)

    return res

# %% ../../nbs/routes/workflows.ipynb 8
def generate_trigger_workflow_body(
    starting_tile, model_id, version_id, execution_params: dict
):
    return {
        "messageName": starting_tile,
        "version": version_id,
        "modelId": model_id,
        "data": execution_params,
    }


@gd.route_function
async def trigger_workflow(
    auth: dmda.DomoAuth,
    starting_tile: str,
    model_id: str,
    version_id: str,
    execution_parameters: dict = None,
    debug_api: bool = False,
    debug_num_stacks_to_drop=1,
    parent_class: str = None,
    session: httpx.AsyncClient = None,
):
    body = generate_trigger_workflow_body(
        starting_tile=starting_tile,
        model_id=model_id,
        execution_params=execution_parameters,
        version_id=version_id,
    )

    url = f"https://{auth.domo_instance}.domo.com/api/workflow/v1/instances/message"

    res = await gd.get_data(
        method="POST",
        url=url,
        body=body,
        auth=auth,
        debug_api=debug_api,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
        session=session,
    )

    if not res.is_success:
        raise dmde.RouteError(res=res)

    return res

# %% ../../nbs/routes/workflows.ipynb 12
@gd.route_function
async def get_workflow_trigger_history(
    auth: dmda.DomoAuth,
    model_id: str,
    debug_api: bool = False,
    debug_num_stacks_to_drop=1,
    parent_class: str = None,
    session: httpx.AsyncClient = None,
):

    url = f"https://{auth.domo_instance}.domo.com/api/workflow/v2/executions/{model_id}"

    res = await gd.get_data(
        auth=auth,
        method="GET",
        url=url,
        debug_api=debug_api,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
        session=session,
    )

    if not res.is_success:
        raise dmde.RouteError(res=res)

    return res

# %% ../../nbs/routes/workflows.ipynb 14
@gd.route_function
async def get_workflow_executions(
    auth: dmda.DomoAuth,
    model_id: str,
    version_id: str,
    debug_api: bool = False,
    debug_num_stacks_to_drop=1,
    parent_class: str = None,
    session: httpx.AsyncClient = None,
    return_raw: bool = False
):
    params = {
        "modelId": model_id,
        #   "triggerTypes" : "ALERT,API,APP_STUDIO,CUSTOM_APP,MANUAL,TIMER,WORKFLOW"
        "version": version_id,
        # "status"  : "IN_PROGRESS"
    }

    url = f"https://{auth.domo_instance}.domo.com/api/workflow/v2/executions"

    res = await gd.get_data(
        auth=auth,
        method="GET",
        url=url,
        debug_api=debug_api,
        params=params,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
        session=session,
    )

    if not res.is_success:
        raise dmde.RouteError(res=res)
    
    if return_raw:
        return res

    res.response = res.response.get("executions", [])

    return res
