# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/utils/compare.ipynb.

# %% auto 0
__all__ = ['compare_dicts']

# %% ../../nbs/utils/compare.ipynb 3
def compare_dicts(dict1, dict2, path=""):
    """
    Recursively compare two dictionaries (and lists) and print differences.
    """

    diff_ls = []
    if isinstance(dict1, dict) and isinstance(dict2, dict):
        for key in dict1.keys():
            if key not in dict2:
                if dict1[key] is not None:
                    diff_ls.append({"key" : path + str(key), "message": 'found in first dict but not in second.'})
            else:
                compare_dicts(dict1[key], dict2[key], path + f"{key}.")
        for key in dict2.keys():
            if key not in dict1:
                if dict2[key] is not None:
                    diff_ls.append({"key" : path + str(key), "message": 'found in second dict but not in first.'})
    elif isinstance(dict1, list) and isinstance(dict2, list):
        min_len = min(len(dict1), len(dict2))
        for i in range(min_len):
            compare_dicts(dict1[i], dict2[i], path + f"[{i}].")
        if len(dict1) > len(dict2):
            for i in range(min_len, len(dict1)):
                diff_ls.append({"key" : f"{path}[{i}]", "message": f'Extra item in first list at \'{path}[{i}]\': {dict1[i]}'})
        elif len(dict2) > len(dict1):
            for i in range(min_len, len(dict2)):
                diff_ls.append({"key" : f"{path}[{i}]", "message": f'Extra item in second list at \'{path}[{i}]\': {dict2[i]}'})
    else:
        if dict1 != dict2:
            diff_ls.append(f"Value mismatch at '{path[:-1]}': {dict1} != {dict2}")

    return diff_ls
