# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/utils/files.ipynb.

# %% auto 0
__all__ = ['upsert_folder', 'upsert_file', 'change_extension', 'UTIL_UpsertFolder_Error', 'export_zip_binary_contents',
           'download_zip']

# %% ../../nbs/utils/files.ipynb 2
import domolibrary.client.DomoError as dmde

import os
import pathlib
import zipfile
import io
import shutil
from typing import Callable, Any

# %% ../../nbs/utils/files.ipynb 4
def upsert_folder(folder_path: str, debug_prn: bool = False, replace_folder=False):

    folder_path = os.path.dirname(folder_path)

    if replace_folder and os.path.exists(folder_path) and os.path.isdir(folder_path):
        folder_path = os.path.join(folder_path, '')
        shutil.rmtree(folder_path)

    if debug_prn:
        print(
            {
                "upsert_folder": os.path.abspath(folder_path),
                "is_exist": os.path.exists(folder_path),
            }
        )

    if not os.path.exists(folder_path):
        os.makedirs(folder_path)

# %% ../../nbs/utils/files.ipynb 5
def upsert_file(
    file_path: str,
    content: Any = None,
    write_fn: Callable = None,
    file_update_method="w",
    encoding="utf-8",
    debug_prn: bool = False,
    replace_folder : bool = False
) -> bool:

    upsert_folder(folder_path=file_path, debug_prn=debug_prn,replace_folder=replace_folder)

    with open(file_path, file_update_method, encoding=encoding) as file:
        if not write_fn:
            file.write(content or '')
            return True

        return write_fn(file=file, content=content)

# %% ../../nbs/utils/files.ipynb 7
def change_extension(file_path, new_extension):
    path = pathlib.PurePath(file_path)

    new_extension = new_extension if new_extension[0] == "." else "." + new_extension

    new_file_path = path.with_suffix( new_extension)
    return str(new_file_path)

# %% ../../nbs/utils/files.ipynb 9
class UTIL_UpsertFolder_Error(dmde.DomoError):
    def __init__(self, message):
        super().__init__(message)

def export_zip_binary_contents(output_folder, zip_bytes_content):
    output_folder = change_extension(output_folder, ".zip")
    
    upsert_folder(output_folder)

    with open(output_folder, 'wb+') as f:
        f.write(zip_bytes_content)

    return f"successfully downloaded to {output_folder}"

def download_zip(
    output_folder,
    zip_bytes_content: bytes = None, # bytes or bytearray
    existing_zip_file_path: str = None, # location of an existing zip file
    is_unpack_archive: bool = True
):
    """save bytes content to a zip file then convert html to markdown"""

    output_folder = output_folder if output_folder.endswith("/") else output_folder +'/'


    if not is_unpack_archive:
        if zip_bytes_content:
            return export_zip_binary_contents(output_folder=output_folder, zip_bytes_content=zip_bytes_content)
        
        if os.path.exists(existing_zip_file_path):
            output_zip = os.path.join(output_folder,'archive.zip')
            shutil.copy(output_zip)

            return f"zip available at {existing_zip_file_path}"
    
    zip = None
    upsert_folder(output_folder)

    if zip_bytes_content:
        zip = zipfile.ZipFile(io.BytesIO(zip_bytes_content), "r")

    if existing_zip_file_path:
        zip = zipfile.ZipFile(existing_zip_file_path)

    if not zip:
        raise UTIL_UpsertFolder_Error(
            "unable to generate zip file pass zip_bytes_content or zip_file_path"
        )
    
    zip.extractall(output_folder)
    zip.close()

    return os.listdir(output_folder)
