"""Utilities for creating reports"""

from flow360.plugins.report.report import ReportTemplate
from flow360.plugins.report.report_items import (
    Chart2D,
    Chart3D,
    FixedRangeLimit,
    Inputs,
    ManualLimit,
    NonlinearResiduals,
    PatternCaption,
    Settings,
    SubsetLimit,
    Summary,
    Table,
)
from flow360.plugins.report.utils import (
    Average,
    DataItem,
    Delta,
    Expression,
    GetAttribute,
    Grouper,
    Variable,
)
from flow360.plugins.report.uvf_shutter import (
    BottomCamera,
    Camera,
    FrontCamera,
    FrontLeftBottomCamera,
    FrontLeftTopCamera,
    LeftCamera,
    RearCamera,
    RearLeftTopCamera,
    RearRightBottomCamera,
    TopCamera,
)

__all__ = [
    "Average",
    "BottomCamera",
    "Camera",
    "Chart2D",
    "Chart3D",
    "DataItem",
    "Delta",
    "Expression",
    "FixedRangeLimit",
    "FrontCamera",
    "FrontLeftBottomCamera",
    "FrontLeftTopCamera",
    "GetAttribute",
    "Grouper",
    "Inputs",
    "LeftCamera",
    "ManualLimit",
    "NonlinearResiduals",
    "PatternCaption",
    "RearCamera",
    "RearLeftTopCamera",
    "RearRightBottomCamera",
    "ReportTemplate",
    "Settings",
    "SubsetLimit",
    "Summary",
    "Table",
    "TopCamera",
    "Variable",
]
