# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ActionConnectionArgs', 'ActionConnection']

@pulumi.input_type
class ActionConnectionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 aws: Optional[pulumi.Input['ActionConnectionAwsArgs']] = None,
                 http: Optional[pulumi.Input['ActionConnectionHttpArgs']] = None):
        """
        The set of arguments for constructing a ActionConnection resource.
        :param pulumi.Input[_builtins.str] name: Name of the connection
        :param pulumi.Input['ActionConnectionAwsArgs'] aws: Configuration for an AWS connection
        :param pulumi.Input['ActionConnectionHttpArgs'] http: Configuration for an HTTP connection
        """
        pulumi.set(__self__, "name", name)
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if http is not None:
            pulumi.set(__self__, "http", http)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['ActionConnectionAwsArgs']]:
        """
        Configuration for an AWS connection
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['ActionConnectionAwsArgs']]):
        pulumi.set(self, "aws", value)

    @_builtins.property
    @pulumi.getter
    def http(self) -> Optional[pulumi.Input['ActionConnectionHttpArgs']]:
        """
        Configuration for an HTTP connection
        """
        return pulumi.get(self, "http")

    @http.setter
    def http(self, value: Optional[pulumi.Input['ActionConnectionHttpArgs']]):
        pulumi.set(self, "http", value)


@pulumi.input_type
class _ActionConnectionState:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input['ActionConnectionAwsArgs']] = None,
                 http: Optional[pulumi.Input['ActionConnectionHttpArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ActionConnection resources.
        :param pulumi.Input['ActionConnectionAwsArgs'] aws: Configuration for an AWS connection
        :param pulumi.Input['ActionConnectionHttpArgs'] http: Configuration for an HTTP connection
        :param pulumi.Input[_builtins.str] name: Name of the connection
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['ActionConnectionAwsArgs']]:
        """
        Configuration for an AWS connection
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['ActionConnectionAwsArgs']]):
        pulumi.set(self, "aws", value)

    @_builtins.property
    @pulumi.getter
    def http(self) -> Optional[pulumi.Input['ActionConnectionHttpArgs']]:
        """
        Configuration for an HTTP connection
        """
        return pulumi.get(self, "http")

    @http.setter
    def http(self, value: Optional[pulumi.Input['ActionConnectionHttpArgs']]):
        pulumi.set(self, "http", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("datadog:index/actionConnection:ActionConnection")
class ActionConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[Union['ActionConnectionAwsArgs', 'ActionConnectionAwsArgsDict']]] = None,
                 http: Optional[pulumi.Input[Union['ActionConnectionHttpArgs', 'ActionConnectionHttpArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A connection that can be used in Actions, including in the Workflow Automation and App Builder products. This resource requires a registered application key.

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/actionConnection:ActionConnection my_connection 11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ActionConnectionAwsArgs', 'ActionConnectionAwsArgsDict']] aws: Configuration for an AWS connection
        :param pulumi.Input[Union['ActionConnectionHttpArgs', 'ActionConnectionHttpArgsDict']] http: Configuration for an HTTP connection
        :param pulumi.Input[_builtins.str] name: Name of the connection
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ActionConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A connection that can be used in Actions, including in the Workflow Automation and App Builder products. This resource requires a registered application key.

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/actionConnection:ActionConnection my_connection 11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param ActionConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActionConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[Union['ActionConnectionAwsArgs', 'ActionConnectionAwsArgsDict']]] = None,
                 http: Optional[pulumi.Input[Union['ActionConnectionHttpArgs', 'ActionConnectionHttpArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActionConnectionArgs.__new__(ActionConnectionArgs)

            __props__.__dict__["aws"] = aws
            __props__.__dict__["http"] = http
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
        super(ActionConnection, __self__).__init__(
            'datadog:index/actionConnection:ActionConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws: Optional[pulumi.Input[Union['ActionConnectionAwsArgs', 'ActionConnectionAwsArgsDict']]] = None,
            http: Optional[pulumi.Input[Union['ActionConnectionHttpArgs', 'ActionConnectionHttpArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ActionConnection':
        """
        Get an existing ActionConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ActionConnectionAwsArgs', 'ActionConnectionAwsArgsDict']] aws: Configuration for an AWS connection
        :param pulumi.Input[Union['ActionConnectionHttpArgs', 'ActionConnectionHttpArgsDict']] http: Configuration for an HTTP connection
        :param pulumi.Input[_builtins.str] name: Name of the connection
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActionConnectionState.__new__(_ActionConnectionState)

        __props__.__dict__["aws"] = aws
        __props__.__dict__["http"] = http
        __props__.__dict__["name"] = name
        return ActionConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def aws(self) -> pulumi.Output[Optional['outputs.ActionConnectionAws']]:
        """
        Configuration for an AWS connection
        """
        return pulumi.get(self, "aws")

    @_builtins.property
    @pulumi.getter
    def http(self) -> pulumi.Output[Optional['outputs.ActionConnectionHttp']]:
        """
        Configuration for an HTTP connection
        """
        return pulumi.get(self, "http")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the connection
        """
        return pulumi.get(self, "name")

