# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudConfigurationRuleArgs', 'CloudConfigurationRule']

@pulumi.input_type
class CloudConfigurationRuleArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 message: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 policy: pulumi.Input[_builtins.str],
                 resource_type: pulumi.Input[_builtins.str],
                 severity: pulumi.Input[_builtins.str],
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['CloudConfigurationRuleFilterArgs']]]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 related_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a CloudConfigurationRule resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the cloud configuration rule is enabled.
        :param pulumi.Input[_builtins.str] message: The message associated to the rule that will be shown in findings and signals.
        :param pulumi.Input[_builtins.str] name: The name of the cloud configuration rule.
        :param pulumi.Input[_builtins.str] policy: Policy written in Rego format.
        :param pulumi.Input[_builtins.str] resource_type: Main resource type to be checked by the rule.
        :param pulumi.Input[_builtins.str] severity: Severity of the rule and associated signals. Valid values are `info`, `low`, `medium`, `high`, `critical`.
        :param pulumi.Input[Sequence[pulumi.Input['CloudConfigurationRuleFilterArgs']]] filters: Additional queries to filter matched events before they are processed. Defaults to empty list
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_bies: Defaults to empty list. This function will be deprecated soon. Use the notification rules function instead. Fields to group by when generating signals, e.g. @resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notifications: This function will be deprecated soon. Use the notification rules function instead. Notification targets for signals. Defaults to empty list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] related_resource_types: Related resource types to be checked by the rule. Defaults to empty list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags of the rule, propagated to findings and signals. Defaults to empty list.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "severity", severity)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if related_resource_types is not None:
            pulumi.set(__self__, "related_resource_types", related_resource_types)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the cloud configuration rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> pulumi.Input[_builtins.str]:
        """
        The message associated to the rule that will be shown in findings and signals.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the cloud configuration rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Input[_builtins.str]:
        """
        Policy written in Rego format.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        Main resource type to be checked by the rule.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Input[_builtins.str]:
        """
        Severity of the rule and associated signals. Valid values are `info`, `low`, `medium`, `high`, `critical`.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudConfigurationRuleFilterArgs']]]]:
        """
        Additional queries to filter matched events before they are processed. Defaults to empty list
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudConfigurationRuleFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defaults to empty list. This function will be deprecated soon. Use the notification rules function instead. Fields to group by when generating signals, e.g. @resource.
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_bies", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        This function will be deprecated soon. Use the notification rules function instead. Notification targets for signals. Defaults to empty list.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter(name="relatedResourceTypes")
    def related_resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Related resource types to be checked by the rule. Defaults to empty list.
        """
        return pulumi.get(self, "related_resource_types")

    @related_resource_types.setter
    def related_resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "related_resource_types", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags of the rule, propagated to findings and signals. Defaults to empty list.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CloudConfigurationRuleState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['CloudConfigurationRuleFilterArgs']]]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 related_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering CloudConfigurationRule resources.
        :param pulumi.Input[_builtins.bool] enabled: Whether the cloud configuration rule is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['CloudConfigurationRuleFilterArgs']]] filters: Additional queries to filter matched events before they are processed. Defaults to empty list
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_bies: Defaults to empty list. This function will be deprecated soon. Use the notification rules function instead. Fields to group by when generating signals, e.g. @resource.
        :param pulumi.Input[_builtins.str] message: The message associated to the rule that will be shown in findings and signals.
        :param pulumi.Input[_builtins.str] name: The name of the cloud configuration rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notifications: This function will be deprecated soon. Use the notification rules function instead. Notification targets for signals. Defaults to empty list.
        :param pulumi.Input[_builtins.str] policy: Policy written in Rego format.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] related_resource_types: Related resource types to be checked by the rule. Defaults to empty list.
        :param pulumi.Input[_builtins.str] resource_type: Main resource type to be checked by the rule.
        :param pulumi.Input[_builtins.str] severity: Severity of the rule and associated signals. Valid values are `info`, `low`, `medium`, `high`, `critical`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags of the rule, propagated to findings and signals. Defaults to empty list.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if related_resource_types is not None:
            pulumi.set(__self__, "related_resource_types", related_resource_types)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the cloud configuration rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudConfigurationRuleFilterArgs']]]]:
        """
        Additional queries to filter matched events before they are processed. Defaults to empty list
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudConfigurationRuleFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defaults to empty list. This function will be deprecated soon. Use the notification rules function instead. Fields to group by when generating signals, e.g. @resource.
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_bies", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The message associated to the rule that will be shown in findings and signals.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the cloud configuration rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        This function will be deprecated soon. Use the notification rules function instead. Notification targets for signals. Defaults to empty list.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy written in Rego format.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="relatedResourceTypes")
    def related_resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Related resource types to be checked by the rule. Defaults to empty list.
        """
        return pulumi.get(self, "related_resource_types")

    @related_resource_types.setter
    def related_resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "related_resource_types", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Main resource type to be checked by the rule.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Severity of the rule and associated signals. Valid values are `info`, `low`, `medium`, `high`, `critical`.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags of the rule, propagated to findings and signals. Defaults to empty list.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("datadog:index/cloudConfigurationRule:CloudConfigurationRule")
class CloudConfigurationRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudConfigurationRuleFilterArgs', 'CloudConfigurationRuleFilterArgsDict']]]]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 related_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog Cloud Configuration Rule resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        myrule = datadog.CloudConfigurationRule("myrule",
            name="My cloud configuration rule",
            message="Rule has triggered",
            enabled=True,
            policy=\"\"\"package datadog

        import data.datadog.output as dd_output

        import future.keywords.contains
        import future.keywords.if
        import future.keywords.in

        eval(resource) = "skip" if {
            # Logic that evaluates to true if the resource should be skipped
            true
        } else = "pass" {
            # Logic that evaluates to true if the resource is compliant
            true
        } else = "fail" {
            # Logic that evaluates to true if the resource is not compliant
            true
        }

        # This part remains unchanged for all rules
        results contains result if {
            some resource in input.resources[input.main_resource_type]
            result := dd_output.format(resource, eval(resource))
        }
        \"\"\",
            resource_type="aws_s3_bucket",
            related_resource_types=[],
            severity="high",
            group_bies=["@resource"],
            notifications=["@channel"],
            tags=["some:tag"])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Security monitoring rules can be imported using ID, e.g.

        ```sh
        $ pulumi import datadog:index/cloudConfigurationRule:CloudConfigurationRule my_rule m0o-hto-lkb
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the cloud configuration rule is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudConfigurationRuleFilterArgs', 'CloudConfigurationRuleFilterArgsDict']]]] filters: Additional queries to filter matched events before they are processed. Defaults to empty list
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_bies: Defaults to empty list. This function will be deprecated soon. Use the notification rules function instead. Fields to group by when generating signals, e.g. @resource.
        :param pulumi.Input[_builtins.str] message: The message associated to the rule that will be shown in findings and signals.
        :param pulumi.Input[_builtins.str] name: The name of the cloud configuration rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notifications: This function will be deprecated soon. Use the notification rules function instead. Notification targets for signals. Defaults to empty list.
        :param pulumi.Input[_builtins.str] policy: Policy written in Rego format.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] related_resource_types: Related resource types to be checked by the rule. Defaults to empty list.
        :param pulumi.Input[_builtins.str] resource_type: Main resource type to be checked by the rule.
        :param pulumi.Input[_builtins.str] severity: Severity of the rule and associated signals. Valid values are `info`, `low`, `medium`, `high`, `critical`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags of the rule, propagated to findings and signals. Defaults to empty list.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudConfigurationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Cloud Configuration Rule resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        myrule = datadog.CloudConfigurationRule("myrule",
            name="My cloud configuration rule",
            message="Rule has triggered",
            enabled=True,
            policy=\"\"\"package datadog

        import data.datadog.output as dd_output

        import future.keywords.contains
        import future.keywords.if
        import future.keywords.in

        eval(resource) = "skip" if {
            # Logic that evaluates to true if the resource should be skipped
            true
        } else = "pass" {
            # Logic that evaluates to true if the resource is compliant
            true
        } else = "fail" {
            # Logic that evaluates to true if the resource is not compliant
            true
        }

        # This part remains unchanged for all rules
        results contains result if {
            some resource in input.resources[input.main_resource_type]
            result := dd_output.format(resource, eval(resource))
        }
        \"\"\",
            resource_type="aws_s3_bucket",
            related_resource_types=[],
            severity="high",
            group_bies=["@resource"],
            notifications=["@channel"],
            tags=["some:tag"])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Security monitoring rules can be imported using ID, e.g.

        ```sh
        $ pulumi import datadog:index/cloudConfigurationRule:CloudConfigurationRule my_rule m0o-hto-lkb
        ```

        :param str resource_name: The name of the resource.
        :param CloudConfigurationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudConfigurationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudConfigurationRuleFilterArgs', 'CloudConfigurationRuleFilterArgsDict']]]]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 related_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudConfigurationRuleArgs.__new__(CloudConfigurationRuleArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["filters"] = filters
            __props__.__dict__["group_bies"] = group_bies
            if message is None and not opts.urn:
                raise TypeError("Missing required property 'message'")
            __props__.__dict__["message"] = message
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["notifications"] = notifications
            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            __props__.__dict__["related_resource_types"] = related_resource_types
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            if severity is None and not opts.urn:
                raise TypeError("Missing required property 'severity'")
            __props__.__dict__["severity"] = severity
            __props__.__dict__["tags"] = tags
        super(CloudConfigurationRule, __self__).__init__(
            'datadog:index/cloudConfigurationRule:CloudConfigurationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudConfigurationRuleFilterArgs', 'CloudConfigurationRuleFilterArgsDict']]]]] = None,
            group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            message: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notifications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            policy: Optional[pulumi.Input[_builtins.str]] = None,
            related_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            severity: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'CloudConfigurationRule':
        """
        Get an existing CloudConfigurationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the cloud configuration rule is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudConfigurationRuleFilterArgs', 'CloudConfigurationRuleFilterArgsDict']]]] filters: Additional queries to filter matched events before they are processed. Defaults to empty list
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_bies: Defaults to empty list. This function will be deprecated soon. Use the notification rules function instead. Fields to group by when generating signals, e.g. @resource.
        :param pulumi.Input[_builtins.str] message: The message associated to the rule that will be shown in findings and signals.
        :param pulumi.Input[_builtins.str] name: The name of the cloud configuration rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notifications: This function will be deprecated soon. Use the notification rules function instead. Notification targets for signals. Defaults to empty list.
        :param pulumi.Input[_builtins.str] policy: Policy written in Rego format.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] related_resource_types: Related resource types to be checked by the rule. Defaults to empty list.
        :param pulumi.Input[_builtins.str] resource_type: Main resource type to be checked by the rule.
        :param pulumi.Input[_builtins.str] severity: Severity of the rule and associated signals. Valid values are `info`, `low`, `medium`, `high`, `critical`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags of the rule, propagated to findings and signals. Defaults to empty list.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudConfigurationRuleState.__new__(_CloudConfigurationRuleState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["filters"] = filters
        __props__.__dict__["group_bies"] = group_bies
        __props__.__dict__["message"] = message
        __props__.__dict__["name"] = name
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["policy"] = policy
        __props__.__dict__["related_resource_types"] = related_resource_types
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["severity"] = severity
        __props__.__dict__["tags"] = tags
        return CloudConfigurationRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the cloud configuration rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional[Sequence['outputs.CloudConfigurationRuleFilter']]]:
        """
        Additional queries to filter matched events before they are processed. Defaults to empty list
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Defaults to empty list. This function will be deprecated soon. Use the notification rules function instead. Fields to group by when generating signals, e.g. @resource.
        """
        return pulumi.get(self, "group_bies")

    @_builtins.property
    @pulumi.getter
    def message(self) -> pulumi.Output[_builtins.str]:
        """
        The message associated to the rule that will be shown in findings and signals.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the cloud configuration rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        This function will be deprecated soon. Use the notification rules function instead. Notification targets for signals. Defaults to empty list.
        """
        return pulumi.get(self, "notifications")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Output[_builtins.str]:
        """
        Policy written in Rego format.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="relatedResourceTypes")
    def related_resource_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Related resource types to be checked by the rule. Defaults to empty list.
        """
        return pulumi.get(self, "related_resource_types")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        Main resource type to be checked by the rule.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Output[_builtins.str]:
        """
        Severity of the rule and associated signals. Valid values are `info`, `low`, `medium`, `high`, `critical`.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags of the rule, propagated to findings and signals. Defaults to empty list.
        """
        return pulumi.get(self, "tags")

