# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComplianceCustomFrameworkArgs', 'ComplianceCustomFramework']

@pulumi.input_type
class ComplianceCustomFrameworkArgs:
    def __init__(__self__, *,
                 handle: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 icon_url: Optional[pulumi.Input[_builtins.str]] = None,
                 requirements: Optional[pulumi.Input[Sequence[pulumi.Input['ComplianceCustomFrameworkRequirementArgs']]]] = None):
        """
        The set of arguments for constructing a ComplianceCustomFramework resource.
        :param pulumi.Input[_builtins.str] handle: The framework handle. String length must be at least 1. This field is immutable.
        :param pulumi.Input[_builtins.str] name: The framework name. String length must be at least 1.
        :param pulumi.Input[_builtins.str] version: The framework version. String length must be at least 1. This field is immutable.
        :param pulumi.Input[_builtins.str] icon_url: The URL of the icon representing the framework
        :param pulumi.Input[Sequence[pulumi.Input['ComplianceCustomFrameworkRequirementArgs']]] requirements: The requirements of the framework. Length must be at least 1.
        """
        pulumi.set(__self__, "handle", handle)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if requirements is not None:
            pulumi.set(__self__, "requirements", requirements)

    @_builtins.property
    @pulumi.getter
    def handle(self) -> pulumi.Input[_builtins.str]:
        """
        The framework handle. String length must be at least 1. This field is immutable.
        """
        return pulumi.get(self, "handle")

    @handle.setter
    def handle(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "handle", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The framework name. String length must be at least 1.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The framework version. String length must be at least 1. This field is immutable.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the icon representing the framework
        """
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "icon_url", value)

    @_builtins.property
    @pulumi.getter
    def requirements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComplianceCustomFrameworkRequirementArgs']]]]:
        """
        The requirements of the framework. Length must be at least 1.
        """
        return pulumi.get(self, "requirements")

    @requirements.setter
    def requirements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComplianceCustomFrameworkRequirementArgs']]]]):
        pulumi.set(self, "requirements", value)


@pulumi.input_type
class _ComplianceCustomFrameworkState:
    def __init__(__self__, *,
                 handle: Optional[pulumi.Input[_builtins.str]] = None,
                 icon_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 requirements: Optional[pulumi.Input[Sequence[pulumi.Input['ComplianceCustomFrameworkRequirementArgs']]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ComplianceCustomFramework resources.
        :param pulumi.Input[_builtins.str] handle: The framework handle. String length must be at least 1. This field is immutable.
        :param pulumi.Input[_builtins.str] icon_url: The URL of the icon representing the framework
        :param pulumi.Input[_builtins.str] name: The framework name. String length must be at least 1.
        :param pulumi.Input[Sequence[pulumi.Input['ComplianceCustomFrameworkRequirementArgs']]] requirements: The requirements of the framework. Length must be at least 1.
        :param pulumi.Input[_builtins.str] version: The framework version. String length must be at least 1. This field is immutable.
        """
        if handle is not None:
            pulumi.set(__self__, "handle", handle)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if requirements is not None:
            pulumi.set(__self__, "requirements", requirements)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def handle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The framework handle. String length must be at least 1. This field is immutable.
        """
        return pulumi.get(self, "handle")

    @handle.setter
    def handle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "handle", value)

    @_builtins.property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the icon representing the framework
        """
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "icon_url", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The framework name. String length must be at least 1.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def requirements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComplianceCustomFrameworkRequirementArgs']]]]:
        """
        The requirements of the framework. Length must be at least 1.
        """
        return pulumi.get(self, "requirements")

    @requirements.setter
    def requirements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComplianceCustomFrameworkRequirementArgs']]]]):
        pulumi.set(self, "requirements", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The framework version. String length must be at least 1. This field is immutable.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("datadog:index/complianceCustomFramework:ComplianceCustomFramework")
class ComplianceCustomFramework(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 handle: Optional[pulumi.Input[_builtins.str]] = None,
                 icon_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 requirements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComplianceCustomFrameworkRequirementArgs', 'ComplianceCustomFrameworkRequirementArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog Compliance Custom Framework resource, which is used to create and manage compliance custom frameworks.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        framework = datadog.ComplianceCustomFramework("framework",
            name="my-custom-framework-terraform-2",
            version="2.0.0",
            handle="my-custom-framework-terraform-2",
            requirements=[
                {
                    "name": "requirement2",
                    "controls": [
                        {
                            "name": "control2",
                            "rules_ids": [
                                "def-000-h9o",
                                "def-000-b6i",
                                "def-000-yed",
                                "def-000-h5a",
                                "def-000-aw5",
                            ],
                        },
                        {
                            "name": "control1",
                            "rules_ids": [
                                "def-000-j9v",
                                "def-000-465",
                                "def-000-vq1",
                                "def-000-4hf",
                                "def-000-s2d",
                                "def-000-vnl",
                            ],
                        },
                    ],
                },
                {
                    "name": "requirement1",
                    "controls": [
                        {
                            "name": "control2",
                            "rules_ids": [
                                "def-000-wuf",
                                "def-000-7og",
                            ],
                        },
                        {
                            "name": "control5",
                            "rules_ids": [
                                "def-000-mdt",
                                "def-000-zrx",
                                "def-000-z6k",
                            ],
                        },
                    ],
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] handle: The framework handle. String length must be at least 1. This field is immutable.
        :param pulumi.Input[_builtins.str] icon_url: The URL of the icon representing the framework
        :param pulumi.Input[_builtins.str] name: The framework name. String length must be at least 1.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComplianceCustomFrameworkRequirementArgs', 'ComplianceCustomFrameworkRequirementArgsDict']]]] requirements: The requirements of the framework. Length must be at least 1.
        :param pulumi.Input[_builtins.str] version: The framework version. String length must be at least 1. This field is immutable.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComplianceCustomFrameworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Compliance Custom Framework resource, which is used to create and manage compliance custom frameworks.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        framework = datadog.ComplianceCustomFramework("framework",
            name="my-custom-framework-terraform-2",
            version="2.0.0",
            handle="my-custom-framework-terraform-2",
            requirements=[
                {
                    "name": "requirement2",
                    "controls": [
                        {
                            "name": "control2",
                            "rules_ids": [
                                "def-000-h9o",
                                "def-000-b6i",
                                "def-000-yed",
                                "def-000-h5a",
                                "def-000-aw5",
                            ],
                        },
                        {
                            "name": "control1",
                            "rules_ids": [
                                "def-000-j9v",
                                "def-000-465",
                                "def-000-vq1",
                                "def-000-4hf",
                                "def-000-s2d",
                                "def-000-vnl",
                            ],
                        },
                    ],
                },
                {
                    "name": "requirement1",
                    "controls": [
                        {
                            "name": "control2",
                            "rules_ids": [
                                "def-000-wuf",
                                "def-000-7og",
                            ],
                        },
                        {
                            "name": "control5",
                            "rules_ids": [
                                "def-000-mdt",
                                "def-000-zrx",
                                "def-000-z6k",
                            ],
                        },
                    ],
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param ComplianceCustomFrameworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComplianceCustomFrameworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 handle: Optional[pulumi.Input[_builtins.str]] = None,
                 icon_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 requirements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComplianceCustomFrameworkRequirementArgs', 'ComplianceCustomFrameworkRequirementArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComplianceCustomFrameworkArgs.__new__(ComplianceCustomFrameworkArgs)

            if handle is None and not opts.urn:
                raise TypeError("Missing required property 'handle'")
            __props__.__dict__["handle"] = handle
            __props__.__dict__["icon_url"] = icon_url
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["requirements"] = requirements
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
        super(ComplianceCustomFramework, __self__).__init__(
            'datadog:index/complianceCustomFramework:ComplianceCustomFramework',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            handle: Optional[pulumi.Input[_builtins.str]] = None,
            icon_url: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            requirements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ComplianceCustomFrameworkRequirementArgs', 'ComplianceCustomFrameworkRequirementArgsDict']]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'ComplianceCustomFramework':
        """
        Get an existing ComplianceCustomFramework resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] handle: The framework handle. String length must be at least 1. This field is immutable.
        :param pulumi.Input[_builtins.str] icon_url: The URL of the icon representing the framework
        :param pulumi.Input[_builtins.str] name: The framework name. String length must be at least 1.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ComplianceCustomFrameworkRequirementArgs', 'ComplianceCustomFrameworkRequirementArgsDict']]]] requirements: The requirements of the framework. Length must be at least 1.
        :param pulumi.Input[_builtins.str] version: The framework version. String length must be at least 1. This field is immutable.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComplianceCustomFrameworkState.__new__(_ComplianceCustomFrameworkState)

        __props__.__dict__["handle"] = handle
        __props__.__dict__["icon_url"] = icon_url
        __props__.__dict__["name"] = name
        __props__.__dict__["requirements"] = requirements
        __props__.__dict__["version"] = version
        return ComplianceCustomFramework(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def handle(self) -> pulumi.Output[_builtins.str]:
        """
        The framework handle. String length must be at least 1. This field is immutable.
        """
        return pulumi.get(self, "handle")

    @_builtins.property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URL of the icon representing the framework
        """
        return pulumi.get(self, "icon_url")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The framework name. String length must be at least 1.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def requirements(self) -> pulumi.Output[Optional[Sequence['outputs.ComplianceCustomFrameworkRequirement']]]:
        """
        The requirements of the framework. Length must be at least 1.
        """
        return pulumi.get(self, "requirements")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The framework version. String length must be at least 1. This field is immutable.
        """
        return pulumi.get(self, "version")

