# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationStsArgs', 'IntegrationSts']

@pulumi.input_type
class IntegrationStsArgs:
    def __init__(__self__, *,
                 client_email: pulumi.Input[_builtins.str],
                 account_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 automute: Optional[pulumi.Input[_builtins.bool]] = None,
                 cloud_run_revision_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_cspm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_per_project_quota_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_resource_change_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_security_command_center_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_namespace_configs: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationStsMetricNamespaceConfigArgs']]]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a IntegrationSts resource.
        :param pulumi.Input[_builtins.str] client_email: Your service account email address.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_tags: Tags to be associated with GCP metrics and service checks from your account.
        :param pulumi.Input[_builtins.bool] automute: Silence monitors for expected GCE instance shutdowns.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cloud_run_revision_filters: Tags to filter which Cloud Run revisions are imported into Datadog. Only revisions that meet specified criteria are monitored.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_filters: Your Host Filters.
        :param pulumi.Input[_builtins.bool] is_cspm_enabled: Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled.
        :param pulumi.Input[_builtins.bool] is_per_project_quota_enabled: When enabled, Datadog includes the `X-Goog-User-Project` header to attribute Google Cloud billing and quota usage to the monitored project instead of the default service account project.
        :param pulumi.Input[_builtins.bool] is_resource_change_collection_enabled: When enabled, Datadog scans for all resource change data in your Google Cloud environment.
        :param pulumi.Input[_builtins.bool] is_security_command_center_enabled: When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationStsMetricNamespaceConfigArgs']]] metric_namespace_configs: Configuration for a GCP metric namespace.
        :param pulumi.Input[_builtins.bool] resource_collection_enabled: When enabled, Datadog scans for all resources in your GCP environment.
        """
        pulumi.set(__self__, "client_email", client_email)
        if account_tags is not None:
            pulumi.set(__self__, "account_tags", account_tags)
        if automute is not None:
            pulumi.set(__self__, "automute", automute)
        if cloud_run_revision_filters is not None:
            pulumi.set(__self__, "cloud_run_revision_filters", cloud_run_revision_filters)
        if host_filters is not None:
            pulumi.set(__self__, "host_filters", host_filters)
        if is_cspm_enabled is not None:
            pulumi.set(__self__, "is_cspm_enabled", is_cspm_enabled)
        if is_per_project_quota_enabled is not None:
            pulumi.set(__self__, "is_per_project_quota_enabled", is_per_project_quota_enabled)
        if is_resource_change_collection_enabled is not None:
            pulumi.set(__self__, "is_resource_change_collection_enabled", is_resource_change_collection_enabled)
        if is_security_command_center_enabled is not None:
            pulumi.set(__self__, "is_security_command_center_enabled", is_security_command_center_enabled)
        if metric_namespace_configs is not None:
            pulumi.set(__self__, "metric_namespace_configs", metric_namespace_configs)
        if resource_collection_enabled is not None:
            pulumi.set(__self__, "resource_collection_enabled", resource_collection_enabled)

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Input[_builtins.str]:
        """
        Your service account email address.
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_email", value)

    @_builtins.property
    @pulumi.getter(name="accountTags")
    def account_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to be associated with GCP metrics and service checks from your account.
        """
        return pulumi.get(self, "account_tags")

    @account_tags.setter
    def account_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "account_tags", value)

    @_builtins.property
    @pulumi.getter
    def automute(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Silence monitors for expected GCE instance shutdowns.
        """
        return pulumi.get(self, "automute")

    @automute.setter
    def automute(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automute", value)

    @_builtins.property
    @pulumi.getter(name="cloudRunRevisionFilters")
    def cloud_run_revision_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to filter which Cloud Run revisions are imported into Datadog. Only revisions that meet specified criteria are monitored.
        """
        return pulumi.get(self, "cloud_run_revision_filters")

    @cloud_run_revision_filters.setter
    def cloud_run_revision_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cloud_run_revision_filters", value)

    @_builtins.property
    @pulumi.getter(name="hostFilters")
    def host_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Your Host Filters.
        """
        return pulumi.get(self, "host_filters")

    @host_filters.setter
    def host_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_filters", value)

    @_builtins.property
    @pulumi.getter(name="isCspmEnabled")
    def is_cspm_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled.
        """
        return pulumi.get(self, "is_cspm_enabled")

    @is_cspm_enabled.setter
    def is_cspm_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_cspm_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isPerProjectQuotaEnabled")
    def is_per_project_quota_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, Datadog includes the `X-Goog-User-Project` header to attribute Google Cloud billing and quota usage to the monitored project instead of the default service account project.
        """
        return pulumi.get(self, "is_per_project_quota_enabled")

    @is_per_project_quota_enabled.setter
    def is_per_project_quota_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_per_project_quota_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isResourceChangeCollectionEnabled")
    def is_resource_change_collection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, Datadog scans for all resource change data in your Google Cloud environment.
        """
        return pulumi.get(self, "is_resource_change_collection_enabled")

    @is_resource_change_collection_enabled.setter
    def is_resource_change_collection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_resource_change_collection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isSecurityCommandCenterEnabled")
    def is_security_command_center_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        """
        return pulumi.get(self, "is_security_command_center_enabled")

    @is_security_command_center_enabled.setter
    def is_security_command_center_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_security_command_center_enabled", value)

    @_builtins.property
    @pulumi.getter(name="metricNamespaceConfigs")
    def metric_namespace_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationStsMetricNamespaceConfigArgs']]]]:
        """
        Configuration for a GCP metric namespace.
        """
        return pulumi.get(self, "metric_namespace_configs")

    @metric_namespace_configs.setter
    def metric_namespace_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationStsMetricNamespaceConfigArgs']]]]):
        pulumi.set(self, "metric_namespace_configs", value)

    @_builtins.property
    @pulumi.getter(name="resourceCollectionEnabled")
    def resource_collection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, Datadog scans for all resources in your GCP environment.
        """
        return pulumi.get(self, "resource_collection_enabled")

    @resource_collection_enabled.setter
    def resource_collection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resource_collection_enabled", value)


@pulumi.input_type
class _IntegrationStsState:
    def __init__(__self__, *,
                 account_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 automute: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_run_revision_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 delegate_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 host_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_cspm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_per_project_quota_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_resource_change_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_security_command_center_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_namespace_configs: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationStsMetricNamespaceConfigArgs']]]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering IntegrationSts resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_tags: Tags to be associated with GCP metrics and service checks from your account.
        :param pulumi.Input[_builtins.bool] automute: Silence monitors for expected GCE instance shutdowns.
        :param pulumi.Input[_builtins.str] client_email: Your service account email address.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cloud_run_revision_filters: Tags to filter which Cloud Run revisions are imported into Datadog. Only revisions that meet specified criteria are monitored.
        :param pulumi.Input[_builtins.str] delegate_account_email: Datadog's STS Delegate Email.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_filters: Your Host Filters.
        :param pulumi.Input[_builtins.bool] is_cspm_enabled: Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled.
        :param pulumi.Input[_builtins.bool] is_per_project_quota_enabled: When enabled, Datadog includes the `X-Goog-User-Project` header to attribute Google Cloud billing and quota usage to the monitored project instead of the default service account project.
        :param pulumi.Input[_builtins.bool] is_resource_change_collection_enabled: When enabled, Datadog scans for all resource change data in your Google Cloud environment.
        :param pulumi.Input[_builtins.bool] is_security_command_center_enabled: When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationStsMetricNamespaceConfigArgs']]] metric_namespace_configs: Configuration for a GCP metric namespace.
        :param pulumi.Input[_builtins.bool] resource_collection_enabled: When enabled, Datadog scans for all resources in your GCP environment.
        """
        if account_tags is not None:
            pulumi.set(__self__, "account_tags", account_tags)
        if automute is not None:
            pulumi.set(__self__, "automute", automute)
        if client_email is not None:
            pulumi.set(__self__, "client_email", client_email)
        if cloud_run_revision_filters is not None:
            pulumi.set(__self__, "cloud_run_revision_filters", cloud_run_revision_filters)
        if delegate_account_email is not None:
            pulumi.set(__self__, "delegate_account_email", delegate_account_email)
        if host_filters is not None:
            pulumi.set(__self__, "host_filters", host_filters)
        if is_cspm_enabled is not None:
            pulumi.set(__self__, "is_cspm_enabled", is_cspm_enabled)
        if is_per_project_quota_enabled is not None:
            pulumi.set(__self__, "is_per_project_quota_enabled", is_per_project_quota_enabled)
        if is_resource_change_collection_enabled is not None:
            pulumi.set(__self__, "is_resource_change_collection_enabled", is_resource_change_collection_enabled)
        if is_security_command_center_enabled is not None:
            pulumi.set(__self__, "is_security_command_center_enabled", is_security_command_center_enabled)
        if metric_namespace_configs is not None:
            pulumi.set(__self__, "metric_namespace_configs", metric_namespace_configs)
        if resource_collection_enabled is not None:
            pulumi.set(__self__, "resource_collection_enabled", resource_collection_enabled)

    @_builtins.property
    @pulumi.getter(name="accountTags")
    def account_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to be associated with GCP metrics and service checks from your account.
        """
        return pulumi.get(self, "account_tags")

    @account_tags.setter
    def account_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "account_tags", value)

    @_builtins.property
    @pulumi.getter
    def automute(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Silence monitors for expected GCE instance shutdowns.
        """
        return pulumi.get(self, "automute")

    @automute.setter
    def automute(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automute", value)

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your service account email address.
        """
        return pulumi.get(self, "client_email")

    @client_email.setter
    def client_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_email", value)

    @_builtins.property
    @pulumi.getter(name="cloudRunRevisionFilters")
    def cloud_run_revision_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to filter which Cloud Run revisions are imported into Datadog. Only revisions that meet specified criteria are monitored.
        """
        return pulumi.get(self, "cloud_run_revision_filters")

    @cloud_run_revision_filters.setter
    def cloud_run_revision_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cloud_run_revision_filters", value)

    @_builtins.property
    @pulumi.getter(name="delegateAccountEmail")
    def delegate_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Datadog's STS Delegate Email.
        """
        return pulumi.get(self, "delegate_account_email")

    @delegate_account_email.setter
    def delegate_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delegate_account_email", value)

    @_builtins.property
    @pulumi.getter(name="hostFilters")
    def host_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Your Host Filters.
        """
        return pulumi.get(self, "host_filters")

    @host_filters.setter
    def host_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_filters", value)

    @_builtins.property
    @pulumi.getter(name="isCspmEnabled")
    def is_cspm_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled.
        """
        return pulumi.get(self, "is_cspm_enabled")

    @is_cspm_enabled.setter
    def is_cspm_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_cspm_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isPerProjectQuotaEnabled")
    def is_per_project_quota_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, Datadog includes the `X-Goog-User-Project` header to attribute Google Cloud billing and quota usage to the monitored project instead of the default service account project.
        """
        return pulumi.get(self, "is_per_project_quota_enabled")

    @is_per_project_quota_enabled.setter
    def is_per_project_quota_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_per_project_quota_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isResourceChangeCollectionEnabled")
    def is_resource_change_collection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, Datadog scans for all resource change data in your Google Cloud environment.
        """
        return pulumi.get(self, "is_resource_change_collection_enabled")

    @is_resource_change_collection_enabled.setter
    def is_resource_change_collection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_resource_change_collection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isSecurityCommandCenterEnabled")
    def is_security_command_center_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        """
        return pulumi.get(self, "is_security_command_center_enabled")

    @is_security_command_center_enabled.setter
    def is_security_command_center_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_security_command_center_enabled", value)

    @_builtins.property
    @pulumi.getter(name="metricNamespaceConfigs")
    def metric_namespace_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationStsMetricNamespaceConfigArgs']]]]:
        """
        Configuration for a GCP metric namespace.
        """
        return pulumi.get(self, "metric_namespace_configs")

    @metric_namespace_configs.setter
    def metric_namespace_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationStsMetricNamespaceConfigArgs']]]]):
        pulumi.set(self, "metric_namespace_configs", value)

    @_builtins.property
    @pulumi.getter(name="resourceCollectionEnabled")
    def resource_collection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When enabled, Datadog scans for all resources in your GCP environment.
        """
        return pulumi.get(self, "resource_collection_enabled")

    @resource_collection_enabled.setter
    def resource_collection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resource_collection_enabled", value)


@pulumi.type_token("datadog:gcp/integrationSts:IntegrationSts")
class IntegrationSts(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 automute: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_run_revision_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_cspm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_per_project_quota_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_resource_change_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_security_command_center_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_namespace_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationStsMetricNamespaceConfigArgs', 'IntegrationStsMetricNamespaceConfigArgsDict']]]]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a Datadog Integration GCP Sts resource. This can be used to create and manage Datadog - Google Cloud Platform integration.

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:gcp/integrationSts:IntegrationSts foo "9c303af3-b963-45e0-8c8f-469b9e1a213f"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_tags: Tags to be associated with GCP metrics and service checks from your account.
        :param pulumi.Input[_builtins.bool] automute: Silence monitors for expected GCE instance shutdowns.
        :param pulumi.Input[_builtins.str] client_email: Your service account email address.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cloud_run_revision_filters: Tags to filter which Cloud Run revisions are imported into Datadog. Only revisions that meet specified criteria are monitored.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_filters: Your Host Filters.
        :param pulumi.Input[_builtins.bool] is_cspm_enabled: Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled.
        :param pulumi.Input[_builtins.bool] is_per_project_quota_enabled: When enabled, Datadog includes the `X-Goog-User-Project` header to attribute Google Cloud billing and quota usage to the monitored project instead of the default service account project.
        :param pulumi.Input[_builtins.bool] is_resource_change_collection_enabled: When enabled, Datadog scans for all resource change data in your Google Cloud environment.
        :param pulumi.Input[_builtins.bool] is_security_command_center_enabled: When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationStsMetricNamespaceConfigArgs', 'IntegrationStsMetricNamespaceConfigArgsDict']]]] metric_namespace_configs: Configuration for a GCP metric namespace.
        :param pulumi.Input[_builtins.bool] resource_collection_enabled: When enabled, Datadog scans for all resources in your GCP environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationStsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Integration GCP Sts resource. This can be used to create and manage Datadog - Google Cloud Platform integration.

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:gcp/integrationSts:IntegrationSts foo "9c303af3-b963-45e0-8c8f-469b9e1a213f"
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationStsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationStsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 automute: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_email: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_run_revision_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_cspm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_per_project_quota_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_resource_change_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_security_command_center_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_namespace_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationStsMetricNamespaceConfigArgs', 'IntegrationStsMetricNamespaceConfigArgsDict']]]]] = None,
                 resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationStsArgs.__new__(IntegrationStsArgs)

            __props__.__dict__["account_tags"] = account_tags
            __props__.__dict__["automute"] = automute
            if client_email is None and not opts.urn:
                raise TypeError("Missing required property 'client_email'")
            __props__.__dict__["client_email"] = client_email
            __props__.__dict__["cloud_run_revision_filters"] = cloud_run_revision_filters
            __props__.__dict__["host_filters"] = host_filters
            __props__.__dict__["is_cspm_enabled"] = is_cspm_enabled
            __props__.__dict__["is_per_project_quota_enabled"] = is_per_project_quota_enabled
            __props__.__dict__["is_resource_change_collection_enabled"] = is_resource_change_collection_enabled
            __props__.__dict__["is_security_command_center_enabled"] = is_security_command_center_enabled
            __props__.__dict__["metric_namespace_configs"] = metric_namespace_configs
            __props__.__dict__["resource_collection_enabled"] = resource_collection_enabled
            __props__.__dict__["delegate_account_email"] = None
        super(IntegrationSts, __self__).__init__(
            'datadog:gcp/integrationSts:IntegrationSts',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            automute: Optional[pulumi.Input[_builtins.bool]] = None,
            client_email: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_run_revision_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            delegate_account_email: Optional[pulumi.Input[_builtins.str]] = None,
            host_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            is_cspm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_per_project_quota_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_resource_change_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_security_command_center_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            metric_namespace_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationStsMetricNamespaceConfigArgs', 'IntegrationStsMetricNamespaceConfigArgsDict']]]]] = None,
            resource_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'IntegrationSts':
        """
        Get an existing IntegrationSts resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_tags: Tags to be associated with GCP metrics and service checks from your account.
        :param pulumi.Input[_builtins.bool] automute: Silence monitors for expected GCE instance shutdowns.
        :param pulumi.Input[_builtins.str] client_email: Your service account email address.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cloud_run_revision_filters: Tags to filter which Cloud Run revisions are imported into Datadog. Only revisions that meet specified criteria are monitored.
        :param pulumi.Input[_builtins.str] delegate_account_email: Datadog's STS Delegate Email.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_filters: Your Host Filters.
        :param pulumi.Input[_builtins.bool] is_cspm_enabled: Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled.
        :param pulumi.Input[_builtins.bool] is_per_project_quota_enabled: When enabled, Datadog includes the `X-Goog-User-Project` header to attribute Google Cloud billing and quota usage to the monitored project instead of the default service account project.
        :param pulumi.Input[_builtins.bool] is_resource_change_collection_enabled: When enabled, Datadog scans for all resource change data in your Google Cloud environment.
        :param pulumi.Input[_builtins.bool] is_security_command_center_enabled: When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationStsMetricNamespaceConfigArgs', 'IntegrationStsMetricNamespaceConfigArgsDict']]]] metric_namespace_configs: Configuration for a GCP metric namespace.
        :param pulumi.Input[_builtins.bool] resource_collection_enabled: When enabled, Datadog scans for all resources in your GCP environment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationStsState.__new__(_IntegrationStsState)

        __props__.__dict__["account_tags"] = account_tags
        __props__.__dict__["automute"] = automute
        __props__.__dict__["client_email"] = client_email
        __props__.__dict__["cloud_run_revision_filters"] = cloud_run_revision_filters
        __props__.__dict__["delegate_account_email"] = delegate_account_email
        __props__.__dict__["host_filters"] = host_filters
        __props__.__dict__["is_cspm_enabled"] = is_cspm_enabled
        __props__.__dict__["is_per_project_quota_enabled"] = is_per_project_quota_enabled
        __props__.__dict__["is_resource_change_collection_enabled"] = is_resource_change_collection_enabled
        __props__.__dict__["is_security_command_center_enabled"] = is_security_command_center_enabled
        __props__.__dict__["metric_namespace_configs"] = metric_namespace_configs
        __props__.__dict__["resource_collection_enabled"] = resource_collection_enabled
        return IntegrationSts(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountTags")
    def account_tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to be associated with GCP metrics and service checks from your account.
        """
        return pulumi.get(self, "account_tags")

    @_builtins.property
    @pulumi.getter
    def automute(self) -> pulumi.Output[_builtins.bool]:
        """
        Silence monitors for expected GCE instance shutdowns.
        """
        return pulumi.get(self, "automute")

    @_builtins.property
    @pulumi.getter(name="clientEmail")
    def client_email(self) -> pulumi.Output[_builtins.str]:
        """
        Your service account email address.
        """
        return pulumi.get(self, "client_email")

    @_builtins.property
    @pulumi.getter(name="cloudRunRevisionFilters")
    def cloud_run_revision_filters(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to filter which Cloud Run revisions are imported into Datadog. Only revisions that meet specified criteria are monitored.
        """
        return pulumi.get(self, "cloud_run_revision_filters")

    @_builtins.property
    @pulumi.getter(name="delegateAccountEmail")
    def delegate_account_email(self) -> pulumi.Output[_builtins.str]:
        """
        Datadog's STS Delegate Email.
        """
        return pulumi.get(self, "delegate_account_email")

    @_builtins.property
    @pulumi.getter(name="hostFilters")
    def host_filters(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Your Host Filters.
        """
        return pulumi.get(self, "host_filters")

    @_builtins.property
    @pulumi.getter(name="isCspmEnabled")
    def is_cspm_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether Datadog collects cloud security posture management resources from your GCP project. If enabled, requires `resource_collection_enabled` to also be enabled.
        """
        return pulumi.get(self, "is_cspm_enabled")

    @_builtins.property
    @pulumi.getter(name="isPerProjectQuotaEnabled")
    def is_per_project_quota_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        When enabled, Datadog includes the `X-Goog-User-Project` header to attribute Google Cloud billing and quota usage to the monitored project instead of the default service account project.
        """
        return pulumi.get(self, "is_per_project_quota_enabled")

    @_builtins.property
    @pulumi.getter(name="isResourceChangeCollectionEnabled")
    def is_resource_change_collection_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        When enabled, Datadog scans for all resource change data in your Google Cloud environment.
        """
        return pulumi.get(self, "is_resource_change_collection_enabled")

    @_builtins.property
    @pulumi.getter(name="isSecurityCommandCenterEnabled")
    def is_security_command_center_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        When enabled, Datadog will attempt to collect Security Command Center Findings. Note: This requires additional permissions on the service account. Defaults to `false`.
        """
        return pulumi.get(self, "is_security_command_center_enabled")

    @_builtins.property
    @pulumi.getter(name="metricNamespaceConfigs")
    def metric_namespace_configs(self) -> pulumi.Output[Optional[Sequence['outputs.IntegrationStsMetricNamespaceConfig']]]:
        """
        Configuration for a GCP metric namespace.
        """
        return pulumi.get(self, "metric_namespace_configs")

    @_builtins.property
    @pulumi.getter(name="resourceCollectionEnabled")
    def resource_collection_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        When enabled, Datadog scans for all resources in your GCP environment.
        """
        return pulumi.get(self, "resource_collection_enabled")

